/*
 * Decompiled with CFR 0.152.
 */
package prefuse.action.layout.graph;

import java.awt.geom.Rectangle2D;
import java.util.Iterator;
import java.util.Random;
import prefuse.action.layout.Layout;
import prefuse.data.Graph;
import prefuse.data.Schema;
import prefuse.data.tuple.TupleSet;
import prefuse.util.PrefuseLib;
import prefuse.visual.EdgeItem;
import prefuse.visual.NodeItem;
import prefuse.visual.VisualItem;

public class FruchtermanReingoldLayout
extends Layout {
    private double forceConstant;
    private double temp;
    private int maxIter = 700;
    protected String m_nodeGroup;
    protected String m_edgeGroup;
    protected int m_fidx;
    private static final double EPSILON = 1.0E-6;
    private static final double ALPHA = 0.1;
    public static final String PARAMS = "_fruchtermanReingoldParams";
    public static final Schema PARAMS_SCHEMA = new Schema();

    public FruchtermanReingoldLayout(String graph) {
        this(graph, 700);
    }

    public FruchtermanReingoldLayout(String graph, int maxIter) {
        super(graph);
        this.m_nodeGroup = PrefuseLib.getGroupName(graph, Graph.NODES);
        this.m_edgeGroup = PrefuseLib.getGroupName(graph, Graph.EDGES);
        this.maxIter = maxIter;
    }

    public int getMaxIterations() {
        return this.maxIter;
    }

    public void setMaxIterations(int maxIter) {
        this.maxIter = maxIter;
    }

    public void run(double frac) {
        Graph g = (Graph)this.m_vis.getGroup(this.m_group);
        Rectangle2D bounds = super.getLayoutBounds();
        this.init(g, bounds);
        for (int curIter = 0; curIter < this.maxIter; ++curIter) {
            NodeItem n;
            Iterator iter = g.nodes();
            while (iter.hasNext()) {
                n = (NodeItem)iter.next();
                if (n.isFixed()) continue;
                this.calcRepulsion(g, n);
            }
            iter = g.edges();
            while (iter.hasNext()) {
                EdgeItem e = (EdgeItem)iter.next();
                this.calcAttraction(e);
            }
            iter = g.nodes();
            while (iter.hasNext()) {
                n = (NodeItem)iter.next();
                if (n.isFixed()) continue;
                this.calcPositions(n, bounds);
            }
            this.cool(curIter);
        }
        this.finish(g);
    }

    private void init(Graph g, Rectangle2D b) {
        this.initSchema(g.getNodes());
        this.temp = b.getWidth() / 10.0;
        this.forceConstant = 0.75 * Math.sqrt(b.getHeight() * b.getWidth() / (double)g.getNodeCount());
        Iterator nodeIter = g.nodes();
        Random rand = new Random(42L);
        double scaleW = 0.1 * b.getWidth() / 2.0;
        double scaleH = 0.1 * b.getHeight() / 2.0;
        while (nodeIter.hasNext()) {
            NodeItem n = (NodeItem)nodeIter.next();
            Params np = this.getParams(n);
            np.loc[0] = b.getCenterX() + rand.nextDouble() * scaleW;
            np.loc[1] = b.getCenterY() + rand.nextDouble() * scaleH;
        }
    }

    private void finish(Graph g) {
        Iterator nodeIter = g.nodes();
        while (nodeIter.hasNext()) {
            NodeItem n = (NodeItem)nodeIter.next();
            Params np = this.getParams(n);
            this.setX(n, null, np.loc[0]);
            this.setY(n, null, np.loc[1]);
        }
    }

    public void calcPositions(NodeItem n, Rectangle2D b) {
        Params np = this.getParams(n);
        double deltaLength = Math.max(1.0E-6, Math.sqrt(np.disp[0] * np.disp[0] + np.disp[1] * np.disp[1]));
        double xDisp = np.disp[0] / deltaLength * Math.min(deltaLength, this.temp);
        if (Double.isNaN(xDisp)) {
            System.err.println("Mathematical error... (calcPositions:xDisp)");
        }
        double yDisp = np.disp[1] / deltaLength * Math.min(deltaLength, this.temp);
        np.loc[0] = np.loc[0] + xDisp;
        np.loc[1] = np.loc[1] + yDisp;
        double borderWidth = b.getWidth() / 50.0;
        double x = np.loc[0];
        if (x < b.getMinX() + borderWidth) {
            x = b.getMinX() + borderWidth + Math.random() * borderWidth * 2.0;
        } else if (x > b.getMaxX() - borderWidth) {
            x = b.getMaxX() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        double y = np.loc[1];
        if (y < b.getMinY() + borderWidth) {
            y = b.getMinY() + borderWidth + Math.random() * borderWidth * 2.0;
        } else if (y > b.getMaxY() - borderWidth) {
            y = b.getMaxY() - borderWidth - Math.random() * borderWidth * 2.0;
        }
        np.loc[0] = x;
        np.loc[1] = y;
    }

    public void calcAttraction(EdgeItem e) {
        NodeItem n1 = e.getSourceItem();
        Params n1p = this.getParams(n1);
        NodeItem n2 = e.getTargetItem();
        Params n2p = this.getParams(n2);
        double xDelta = n1p.loc[0] - n2p.loc[0];
        double yDelta = n1p.loc[1] - n2p.loc[1];
        double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
        double force = deltaLength * deltaLength / this.forceConstant;
        if (Double.isNaN(force)) {
            System.err.println("Mathematical error...");
        }
        double xDisp = xDelta / deltaLength * force;
        double yDisp = yDelta / deltaLength * force;
        n1p.disp[0] = n1p.disp[0] - xDisp;
        n1p.disp[1] = n1p.disp[1] - yDisp;
        n2p.disp[0] = n2p.disp[0] + xDisp;
        n2p.disp[1] = n2p.disp[1] + yDisp;
    }

    public void calcRepulsion(Graph g, NodeItem n1) {
        Params np = this.getParams(n1);
        np.disp[0] = 0.0;
        np.disp[1] = 0.0;
        Iterator iter2 = g.nodes();
        while (iter2.hasNext()) {
            NodeItem n2 = (NodeItem)iter2.next();
            Params n2p = this.getParams(n2);
            if (n2.isFixed() || n1 == n2) continue;
            double xDelta = np.loc[0] - n2p.loc[0];
            double yDelta = np.loc[1] - n2p.loc[1];
            double deltaLength = Math.max(1.0E-6, Math.sqrt(xDelta * xDelta + yDelta * yDelta));
            double force = this.forceConstant * this.forceConstant / deltaLength;
            if (Double.isNaN(force)) {
                System.err.println("Mathematical error...");
            }
            np.disp[0] = np.disp[0] + xDelta / deltaLength * force;
            np.disp[1] = np.disp[1] + yDelta / deltaLength * force;
        }
    }

    private void cool(int curIter) {
        this.temp *= 1.0 - (double)curIter / (double)this.maxIter;
    }

    protected void initSchema(TupleSet ts) {
        try {
            ts.addColumns(PARAMS_SCHEMA);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    private Params getParams(VisualItem item) {
        Params rp = (Params)item.get(PARAMS);
        if (rp == null) {
            rp = new Params();
            item.set(PARAMS, rp);
        }
        return rp;
    }

    static {
        PARAMS_SCHEMA.addColumn(PARAMS, Params.class);
    }

    public static class Params
    implements Cloneable {
        double[] loc = new double[2];
        double[] disp = new double[2];
    }
}

