/*
 * Decompiled with CFR 0.152.
 */
package proguard.obfuscate;

import proguard.classfile.ClassCpInfo;
import proguard.classfile.ClassFile;
import proguard.classfile.DoubleCpInfo;
import proguard.classfile.FieldrefCpInfo;
import proguard.classfile.FloatCpInfo;
import proguard.classfile.IntegerCpInfo;
import proguard.classfile.InterfaceMethodrefCpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.LibraryFieldInfo;
import proguard.classfile.LibraryMemberInfo;
import proguard.classfile.LibraryMethodInfo;
import proguard.classfile.LongCpInfo;
import proguard.classfile.MethodrefCpInfo;
import proguard.classfile.NameAndTypeCpInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.ProgramFieldInfo;
import proguard.classfile.ProgramMemberInfo;
import proguard.classfile.ProgramMethodInfo;
import proguard.classfile.StringCpInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.editor.ConstantPoolEditor;
import proguard.classfile.visitor.ClassFileVisitor;
import proguard.classfile.visitor.CpInfoVisitor;
import proguard.classfile.visitor.MemberInfoVisitor;
import proguard.obfuscate.ClassFileObfuscator;
import proguard.obfuscate.MemberInfoObfuscator;

public class ClassFileRenamer
implements ClassFileVisitor,
MemberInfoVisitor,
CpInfoVisitor {
    private ConstantPoolEditor constantPoolEditor = new ConstantPoolEditor();

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        programClassFile.constantPoolEntryAccept(programClassFile.u2thisClass, this);
        programClassFile.fieldsAccept(this);
        programClassFile.methodsAccept(this);
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        libraryClassFile.thisClassName = ClassFileObfuscator.newClassName(libraryClassFile);
        libraryClassFile.fieldsAccept(this);
        libraryClassFile.methodsAccept(this);
    }

    public void visitProgramFieldInfo(ProgramClassFile programClassFile, ProgramFieldInfo programFieldInfo) {
        this.renameProgramMemberInfo(programClassFile, programFieldInfo);
    }

    public void visitProgramMethodInfo(ProgramClassFile programClassFile, ProgramMethodInfo programMethodInfo) {
        this.renameProgramMemberInfo(programClassFile, programMethodInfo);
    }

    public void visitLibraryFieldInfo(LibraryClassFile libraryClassFile, LibraryFieldInfo libraryFieldInfo) {
        this.renameLibraryMemberInfo(libraryClassFile, libraryFieldInfo);
    }

    public void visitLibraryMethodInfo(LibraryClassFile libraryClassFile, LibraryMethodInfo libraryMethodInfo) {
        this.renameLibraryMemberInfo(libraryClassFile, libraryMethodInfo);
    }

    private void renameProgramMemberInfo(ProgramClassFile programClassFile, ProgramMemberInfo programMemberInfo) {
        String string = programMemberInfo.getName(programClassFile);
        String string2 = MemberInfoObfuscator.newMemberName(programMemberInfo);
        if (string2 != null && !string2.equals(string)) {
            programMemberInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo(programClassFile, string2);
        }
    }

    private void renameLibraryMemberInfo(LibraryClassFile libraryClassFile, LibraryMemberInfo libraryMemberInfo) {
        String string = MemberInfoObfuscator.newMemberName(libraryMemberInfo);
        if (string != null) {
            libraryMemberInfo.name = string;
        }
    }

    public void visitIntegerCpInfo(ClassFile classFile, IntegerCpInfo integerCpInfo) {
    }

    public void visitLongCpInfo(ClassFile classFile, LongCpInfo longCpInfo) {
    }

    public void visitFloatCpInfo(ClassFile classFile, FloatCpInfo floatCpInfo) {
    }

    public void visitDoubleCpInfo(ClassFile classFile, DoubleCpInfo doubleCpInfo) {
    }

    public void visitStringCpInfo(ClassFile classFile, StringCpInfo stringCpInfo) {
    }

    public void visitFieldrefCpInfo(ClassFile classFile, FieldrefCpInfo fieldrefCpInfo) {
    }

    public void visitInterfaceMethodrefCpInfo(ClassFile classFile, InterfaceMethodrefCpInfo interfaceMethodrefCpInfo) {
    }

    public void visitMethodrefCpInfo(ClassFile classFile, MethodrefCpInfo methodrefCpInfo) {
    }

    public void visitNameAndTypeCpInfo(ClassFile classFile, NameAndTypeCpInfo nameAndTypeCpInfo) {
    }

    public void visitUtf8CpInfo(ClassFile classFile, Utf8CpInfo utf8CpInfo) {
    }

    public void visitClassCpInfo(ClassFile classFile, ClassCpInfo classCpInfo) {
        String string = ClassFileObfuscator.newClassName(classFile);
        if (string != null) {
            classCpInfo.u2nameIndex = this.constantPoolEditor.addUtf8CpInfo((ProgramClassFile)classFile, string);
        }
    }
}

