/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.instruction;

import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.attribute.CodeAttrInfo;
import proguard.classfile.instruction.Instruction;
import proguard.classfile.instruction.InstructionVisitor;

public class LookUpSwitchInstruction
extends Instruction {
    public int defaultOffset;
    public int jumpOffsetCount;
    public int[] cases;
    public int[] jumpOffsets;

    public LookUpSwitchInstruction copy(LookUpSwitchInstruction lookUpSwitchInstruction) {
        this.opcode = lookUpSwitchInstruction.opcode;
        this.defaultOffset = lookUpSwitchInstruction.defaultOffset;
        this.jumpOffsetCount = lookUpSwitchInstruction.jumpOffsetCount;
        this.cases = lookUpSwitchInstruction.cases;
        this.jumpOffsets = lookUpSwitchInstruction.jumpOffsets;
        return this;
    }

    public Instruction shrink() {
        return this;
    }

    protected void readInfo(byte[] byArray, int n) {
        n += -n & 3;
        this.defaultOffset = LookUpSwitchInstruction.readInt(byArray, n);
        this.jumpOffsetCount = LookUpSwitchInstruction.readInt(byArray, n += 4);
        n += 4;
        if (this.jumpOffsets == null || this.jumpOffsets.length < this.jumpOffsetCount) {
            this.cases = new int[this.jumpOffsetCount];
            this.jumpOffsets = new int[this.jumpOffsetCount];
        }
        for (int i = 0; i < this.jumpOffsetCount; ++i) {
            this.cases[i] = LookUpSwitchInstruction.readInt(byArray, n);
            this.jumpOffsets[i] = LookUpSwitchInstruction.readInt(byArray, n += 4);
            n += 4;
        }
    }

    protected void writeInfo(byte[] byArray, int n) {
        while ((n & 3) != 0) {
            LookUpSwitchInstruction.writeByte(byArray, n++, 0);
        }
        LookUpSwitchInstruction.writeInt(byArray, n, this.defaultOffset);
        LookUpSwitchInstruction.writeInt(byArray, n += 4, this.jumpOffsetCount);
        n += 4;
        for (int i = 0; i < this.jumpOffsetCount; ++i) {
            LookUpSwitchInstruction.writeInt(byArray, n, this.cases[i]);
            LookUpSwitchInstruction.writeInt(byArray, n += 4, this.jumpOffsets[i]);
            n += 4;
        }
    }

    public int length(int n) {
        return 1 + (-(n + 1) & 3) + 8 + this.jumpOffsetCount * 8;
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, CodeAttrInfo codeAttrInfo, int n, InstructionVisitor instructionVisitor) {
        instructionVisitor.visitLookUpSwitchInstruction(classFile, methodInfo, codeAttrInfo, n, this);
    }

    public String toString(int n) {
        return "[" + n + "] " + this.getName() + " (switchCaseCount=" + this.jumpOffsetCount + ")";
    }

    public String toString() {
        return this.getName() + " (switchCaseCount=" + this.jumpOffsetCount + ")";
    }
}

