/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile;

import java.io.DataInput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.CpInfo;
import proguard.classfile.LibraryClassFile;
import proguard.classfile.MemberInfo;
import proguard.classfile.Utf8CpInfo;
import proguard.classfile.attribute.LibraryAttrInfo;
import proguard.classfile.visitor.MemberInfoVisitor;

public abstract class LibraryMemberInfo
implements MemberInfo {
    private static final int ACC_VISIBLE = 5;
    public int u2accessFlags;
    public String name;
    public String descriptor;
    public Object visitorInfo;

    protected LibraryMemberInfo() {
    }

    public abstract void accept(LibraryClassFile var1, MemberInfoVisitor var2);

    protected void read(DataInput dataInput, CpInfo[] cpInfoArray) throws IOException {
        this.u2accessFlags = dataInput.readUnsignedShort();
        int n = dataInput.readUnsignedShort();
        int n2 = dataInput.readUnsignedShort();
        this.name = ((Utf8CpInfo)cpInfoArray[n]).getString();
        this.descriptor = ((Utf8CpInfo)cpInfoArray[n2]).getString();
        int n3 = dataInput.readUnsignedShort();
        for (int i = 0; i < n3; ++i) {
            LibraryAttrInfo.skip(dataInput);
        }
    }

    boolean isVisible() {
        return (this.u2accessFlags & 5) != 0;
    }

    public int getAccessFlags() {
        return this.u2accessFlags;
    }

    public String getName(ClassFile classFile) {
        return this.name;
    }

    public String getDescriptor(ClassFile classFile) {
        return this.descriptor;
    }

    public void accept(ClassFile classFile, MemberInfoVisitor memberInfoVisitor) {
        this.accept((LibraryClassFile)classFile, memberInfoVisitor);
    }

    public Object getVisitorInfo() {
        return this.visitorInfo;
    }

    public void setVisitorInfo(Object object) {
        this.visitorInfo = object;
    }
}

