/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.universe;

import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.universe.AbstractEntry;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.modules.Dependency;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class BinaryEntry
extends AbstractEntry {
    private final String cnb;
    private final File jar;
    private final String cpext;
    private final File nbdestdir;
    private final File clusterDir;
    private final String releaseVersion;
    private final String specVersion;
    private final String[] providedTokens;
    private LocalizedBundleInfo bundleInfo;
    private final ManifestManager.PackageExport[] publicPackages;
    private final String[] friends;
    private final boolean deprecated;
    private final String[] runDependencies;
    private Set<String> allPackageNames;

    public BinaryEntry(String string, File file, File[] fileArray, File file2, File file3, String string2, String string3, String[] stringArray, ManifestManager.PackageExport[] packageExportArray, String[] stringArray2, boolean bl, Set<Dependency> set) {
        this.cnb = string;
        this.jar = file;
        this.nbdestdir = file2;
        this.clusterDir = file3;
        StringBuffer stringBuffer = new StringBuffer();
        for (int i = 0; i < fileArray.length; ++i) {
            stringBuffer.append(':');
            stringBuffer.append(fileArray[i].getAbsolutePath());
        }
        this.cpext = stringBuffer.toString();
        this.releaseVersion = string2;
        this.specVersion = string3;
        this.providedTokens = stringArray;
        this.publicPackages = packageExportArray;
        this.friends = stringArray2;
        this.deprecated = bl;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (Dependency dependency : set) {
            String string4 = dependency.getName();
            int n = string4.lastIndexOf(47);
            if (n == -1) {
                treeSet.add(string4);
                continue;
            }
            treeSet.add(string4.substring(0, n));
        }
        this.runDependencies = treeSet.toArray(new String[treeSet.size()]);
    }

    @Override
    public File getSourceLocation() {
        NbPlatform nbPlatform = NbPlatform.getPlatformByDestDir(this.getDestDir());
        return nbPlatform.getSourceLocationOfModule(this.getJarLocation());
    }

    @Override
    public String getNetBeansOrgPath() {
        return null;
    }

    @Override
    public File getJarLocation() {
        return this.jar;
    }

    @Override
    public File getDestDir() {
        return this.nbdestdir;
    }

    @Override
    public String getCodeNameBase() {
        return this.cnb;
    }

    @Override
    public File getClusterDirectory() {
        return this.clusterDir;
    }

    @Override
    public String getClassPathExtensions() {
        return this.cpext;
    }

    @Override
    public String getReleaseVersion() {
        return this.releaseVersion;
    }

    @Override
    public String getSpecificationVersion() {
        return this.specVersion;
    }

    @Override
    public String[] getProvidedTokens() {
        return this.providedTokens;
    }

    @Override
    protected LocalizedBundleInfo getBundleInfo() {
        if (this.bundleInfo == null) {
            this.bundleInfo = Util.findLocalizedBundleInfoFromJAR(this.getJarLocation());
            if (this.bundleInfo == null) {
                this.bundleInfo = LocalizedBundleInfo.EMPTY;
            }
        }
        return this.bundleInfo;
    }

    @Override
    public ManifestManager.PackageExport[] getPublicPackages() {
        return this.publicPackages;
    }

    @Override
    public synchronized Set<String> getAllPackageNames() {
        if (this.allPackageNames == null) {
            this.allPackageNames = new TreeSet<String>();
            Util.scanJarForPackageNames(this.allPackageNames, this.getJarLocation());
        }
        return this.allPackageNames;
    }

    @Override
    public boolean isDeclaredAsFriend(String string) {
        return BinaryEntry.isDeclaredAsFriend(this.friends, string);
    }

    @Override
    public boolean isDeprecated() {
        return this.deprecated;
    }

    public String toString() {
        File file = this.getSourceLocation();
        return "BinaryEntry[" + this.getJarLocation() + (file != null ? "," + file : "") + "]";
    }

    @Override
    protected Set<String> computePublicClassNamesInMainModule() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        this.scanJarForPublicClassNames(hashSet, this.jar);
        return hashSet;
    }

    @Override
    public String[] getRunDependencies() {
        return this.runDependencies;
    }
}

