/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.project;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Set;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.SharabilityQuery;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.project.NameAndLocationPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.project.SelectProjectPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
final class NewProjectIterator
extends BasicWizardIterator {
    private DataModel data;
    public static final String[] MODULES = new String[]{"org.openide.filesystems", "org.openide.loaders", "org.openide.dialogs", "org.openide.util", "org.netbeans.modules.projectuiapi", "org.netbeans.modules.projectapi", "org.openide.awt", "org.jdesktop.layout"};

    private NewProjectIterator() {
    }

    public static NewProjectIterator createIterator() {
        return new NewProjectIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return NewProjectIterator.getCreatedFiles(createdModifiedFiles, this.data.getProject());
    }

    @Override
    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        this.data = new DataModel(wizardDescriptor);
        return new BasicWizardIterator.Panel[]{new SelectProjectPanel(wizardDescriptor, this.data), new NameAndLocationPanel(wizardDescriptor, this.data)};
    }

    @Override
    public void uninitialize(WizardDescriptor wizardDescriptor) {
        super.uninitialize(wizardDescriptor);
        this.data = null;
    }

    public static void generateFileChanges(DataModel dataModel) {
        CreatedModifiedFiles createdModifiedFiles = new CreatedModifiedFiles(dataModel.getProject());
        Project project = dataModel.getProject();
        NbModuleProvider nbModuleProvider = dataModel.getModuleInfo();
        String string = dataModel.getCategory();
        String string2 = dataModel.getDisplayName();
        String string3 = dataModel.getName();
        String string4 = dataModel.getPackageName();
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("CATEGORY", string);
        hashMap.put("DISPLAYNAME", string2);
        hashMap.put("TEMPLATENAME", string3);
        hashMap.put("PACKAGENAME", string4);
        String string5 = NewProjectIterator.getRelativePath(nbModuleProvider.getResourceDirectoryPath(false), string4, string3, "Description.html");
        FileObject fileObject = CreatedModifiedFiles.getTemplate("templateDescription.html");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string5, fileObject, hashMap));
        for (int i = 0; i < MODULES.length; ++i) {
            createdModifiedFiles.add(createdModifiedFiles.addModuleDependency(MODULES[i]));
        }
        createdModifiedFiles.add(createdModifiedFiles.bundleKeyDefaultBundle(string + "/" + string3 + "Project.zip", string2));
        String string6 = NewProjectIterator.getRelativePath(nbModuleProvider.getResourceDirectoryPath(false), string4, "", "Bundle.properties");
        createdModifiedFiles.add(createdModifiedFiles.bundleKey(string6, "LBL_CreateProjectStep", "Name and Location"));
        FileObject fileObject2 = LayerUtils.layerForProject(project).getLayerFile();
        FileObject fileObject3 = fileObject2 != null ? fileObject2.getParent() : null;
        Set<String> set = Collections.singleton(LayerUtils.findGeneratedName(fileObject3, string3 + "Project.zip"));
        createdModifiedFiles.add(createdModifiedFiles.layerModifications(new CreateProjectZipOperation(dataModel.getTemplate(), string3, string4, string, ManifestManager.getInstance(Util.getManifest(nbModuleProvider.getManifestFile()), false)), set));
        String string7 = NewProjectIterator.getRelativePath(nbModuleProvider.getSourceDirectoryPath(), string4, string3, "WizardIterator.java");
        fileObject = CreatedModifiedFiles.getTemplate("templateWizardIterator.java");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string7, fileObject, hashMap));
        String string8 = NewProjectIterator.getRelativePath(nbModuleProvider.getSourceDirectoryPath(), string4, string3, "WizardPanel.java");
        fileObject = CreatedModifiedFiles.getTemplate("templateWizardPanel.java");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string8, fileObject, hashMap));
        String string9 = NewProjectIterator.getRelativePath(nbModuleProvider.getSourceDirectoryPath(), string4, string3, "PanelVisual.form");
        fileObject = CreatedModifiedFiles.getTemplate("templatePanelVisual.form");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string9, fileObject, hashMap));
        String string10 = NewProjectIterator.getRelativePath(nbModuleProvider.getSourceDirectoryPath(), string4, string3, "PanelVisual.java");
        fileObject = CreatedModifiedFiles.getTemplate("templatePanelVisual.java");
        createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string10, fileObject, hashMap));
        dataModel.setCreatedModifiedFiles(createdModifiedFiles);
    }

    private static String getRelativePath(String string, String string2, String string3, String string4) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(string).append('/').append(string2.replace('.', '/')).append('/').append(string3).append(string4);
        return stringBuffer.toString();
    }

    private static void createProjectZip(OutputStream outputStream, Project project) throws IOException {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
        SourceGroup sourceGroup = sourceGroupArray[0];
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        NewProjectIterator.collectFiles(sourceGroup.getRootFolder(), arrayList, SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)sourceGroup.getRootFolder())));
        NewProjectIterator.createZipFile(outputStream, sourceGroup.getRootFolder(), arrayList);
    }

    private static void collectFiles(FileObject fileObject, Collection<FileObject> collection, int n) {
        for (FileObject fileObject2 : fileObject.getChildren()) {
            int n2;
            if (!VisibilityQuery.getDefault().isVisible(fileObject2) || (n2 = n == 0 || n == 3 ? SharabilityQuery.getSharability((File)FileUtil.toFile((FileObject)fileObject2)) : n) == 2) continue;
            if (fileObject2.isData() && !fileObject2.isVirtual()) {
                collection.add(fileObject2);
                continue;
            }
            if (!fileObject2.isFolder()) continue;
            collection.add(fileObject2);
            NewProjectIterator.collectFiles(fileObject2, collection, n2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void createZipFile(OutputStream outputStream, FileObject fileObject, Collection collection) throws IOException {
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(outputStream);
            for (FileObject fileObject2 : collection) {
                String string = FileUtil.getRelativePath((FileObject)fileObject, (FileObject)fileObject2);
                if (fileObject2.isFolder() && !string.endsWith("/")) {
                    string = string + "/";
                }
                ZipEntry zipEntry = new ZipEntry(string);
                zipOutputStream.putNextEntry(zipEntry);
                if (fileObject2.isData()) {
                    InputStream inputStream = null;
                    try {
                        inputStream = fileObject2.getInputStream();
                        FileUtil.copy((InputStream)inputStream, (OutputStream)zipOutputStream);
                    }
                    finally {
                        if (inputStream != null) {
                            inputStream.close();
                        }
                    }
                }
                zipOutputStream.closeEntry();
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.close();
            }
        }
    }

    static class CreateProjectZipOperation
    implements CreatedModifiedFiles.LayerOperation {
        private final String name;
        private final String packageName;
        private final Project templateProject;
        private final String category;
        private final ManifestManager manifestManager;

        public CreateProjectZipOperation(Project project, String string, String string2, String string3, ManifestManager manifestManager) {
            this.packageName = string2;
            this.name = string;
            this.category = string3;
            this.manifestManager = manifestManager;
            this.templateProject = project;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run(FileSystem fileSystem) throws IOException {
            FileObject fileObject = fileSystem.getRoot().getFileObject(this.category);
            if (fileObject == null) {
                fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)this.category);
            }
            FileObject fileObject2 = fileObject.createData(this.name + "Project", "zip");
            FileLock fileLock = fileObject2.lock();
            try {
                NewProjectIterator.createProjectZip(fileObject2.getOutputStream(fileLock), this.templateProject);
            }
            finally {
                fileLock.releaseLock();
            }
            String string = this.manifestManager.getLocalizingBundle();
            String string2 = ".properties";
            if (string != null && string.endsWith(string2)) {
                string = string.substring(0, string.length() - string2.length()).replace('/', '.');
                fileObject2.setAttribute("SystemFileSystem.localizingBundle", (Object)string);
            }
            fileObject2.setAttribute("template", (Object)Boolean.TRUE);
            URL uRL = new URL("nbresloc:/" + this.packageName.replace('.', '/') + "/" + this.name + "Description.html");
            fileObject2.setAttribute("instantiatingWizardURL", (Object)uRL);
            fileObject2.setAttribute("instantiatingIterator", (Object)("methodvalue:" + this.packageName + "." + this.name + "WizardIterator.createIterator"));
        }
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private Project template;
        private String name;
        private String displayName;
        private String category;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.getFiles();
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles createdModifiedFiles) {
            this.setFiles(createdModifiedFiles);
        }

        public Project getTemplate() {
            return this.template;
        }

        public void setTemplate(Project project) {
            this.template = project;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String string) {
            this.name = string;
        }

        public String getDisplayName() {
            return this.displayName;
        }

        public void setDisplayName(String string) {
            this.displayName = string;
        }

        public String getCategory() {
            return this.category;
        }

        public void setCategory(String string) {
            this.category = string;
        }

        public CreatedModifiedFiles getFiles() {
            return this.files;
        }

        public void setFiles(CreatedModifiedFiles createdModifiedFiles) {
            this.files = createdModifiedFiles;
        }
    }
}

