/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.options;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.UIUtil;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.options.OptionsPanel0;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

final class NewOptionsIterator
extends BasicWizardIterator {
    private DataModel data;

    private NewOptionsIterator() {
    }

    public static NewOptionsIterator createIterator() {
        return new NewOptionsIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return NewOptionsIterator.getCreatedFiles(createdModifiedFiles, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        this.data = new DataModel(wizardDescriptor);
        return new BasicWizardIterator.Panel[]{new OptionsPanel0(wizardDescriptor, this.data), new OptionsPanel(wizardDescriptor, this.data)};
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        super.uninitialize(wizardDescriptor);
        this.data = null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private static final int ERR_BLANK_DISPLAYNAME = 1;
        private static final int ERR_BLANK_TOOLTIP = 2;
        private static final int ERR_BLANK_TITLE = 4;
        private static final int ERR_BLANK_CATEGORY_NAME = 5;
        private static final int ERR_BLANK_ICONPATH = 6;
        private static final int ERR_BLANK_PACKAGE_NAME = 7;
        private static final int ERR_BLANK_CLASSNAME_PREFIX = 8;
        private static final int ERR_INVALID_CLASSNAME_PREFIX = 9;
        private static final int WARNING_INCORRECT_ICON_SIZE = -1;
        private static final String[] CATEGORY_BUNDLE_KEYS = new String[]{"OptionsCategory_Title", "OptionsCategory_Name"};
        private static final String[] ADVANCED_BUNDLE_KEYS = new String[]{"AdvancedOption_DisplayName", "AdvancedOption_Tooltip"};
        private static final String[] TOKENS = new String[]{"PACKAGE_NAME", "AdvancedOption_CLASS_NAME", "OptionsCategory_CLASS_NAME", "Panel_CLASS_NAME", "OptionsPanelController_CLASS_NAME", "ICON_PATH", ADVANCED_BUNDLE_KEYS[0], ADVANCED_BUNDLE_KEYS[1], CATEGORY_BUNDLE_KEYS[0], CATEGORY_BUNDLE_KEYS[1]};
        private static final String[] FORM_TEMPLATE_SUFFIXES = new String[]{"Panel"};
        private static final String[] JAVA_TEMPLATE_SUFFIXES = new String[]{"AdvancedOption", "OptionsCategory", "Panel", "OptionsPanelController"};
        private static final String JAVA_TEMPLATE_PREFIX = "template_myplugin";
        private static final String FORM_TEMPLATE_PREFIX = "template_myplugin_form";
        private CreatedModifiedFiles files;
        private String codeNameBase;
        private boolean advanced;
        private String displayName;
        private String tooltip;
        private String title;
        private String categoryName;
        private String iconPath;
        private String classNamePrefix;

        DataModel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        int setDataForAdvanced(String string, String string2) {
            this.advanced = true;
            this.displayName = string;
            this.tooltip = string2;
            return this.checkFirstPanel();
        }

        int setDataForOptionCategory(String string, String string2, String string3) {
            this.advanced = false;
            this.title = string;
            this.categoryName = string2;
            this.iconPath = string3;
            return this.checkFirstPanel();
        }

        @Override
        public String getPackageName() {
            String string = super.getPackageName();
            if (string == null) {
                string = this.getCodeNameBase();
                super.setPackageName(string);
            }
            return string;
        }

        public int setPackageAndPrefix(String string, String string2) {
            this.setPackageName(string);
            this.classNamePrefix = string2;
            int n = this.checkFinalPanel();
            if (DataModel.isSuccessCode(n)) {
                this.generateCreatedModifiedFiles();
            }
            return n;
        }

        private Map<String, String> getTokenMap() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (int i = 0; i < TOKENS.length; ++i) {
                if (this.isAdvanced() && "ICON_PATH".equals(TOKENS[i])) continue;
                hashMap.put(TOKENS[i], this.getReplacement(TOKENS[i]));
            }
            return hashMap;
        }

        private String getReplacement(String string) {
            if ("PACKAGE_NAME".equals(string)) {
                return this.getPackageName();
            }
            if ("AdvancedOption_CLASS_NAME".equals(string)) {
                return this.getAdvancedOptionClassName();
            }
            if ("OptionsCategory_CLASS_NAME".equals(string)) {
                return this.getOptionsCategoryClassName();
            }
            if ("Panel_CLASS_NAME".equals(string)) {
                return this.getPanelClassName();
            }
            if ("OptionsPanelController_CLASS_NAME".equals(string)) {
                return this.getOptionsPanelControllerClassName();
            }
            if ("ICON_PATH".equals(string)) {
                return this.addCreateIconOperation(new CreatedModifiedFiles(this.getProject()), this.getIconPath());
            }
            return string + "_" + this.getClassNamePrefix();
        }

        private String getBundleValue(String string) {
            if (string.startsWith("OptionsCategory_Title")) {
                return this.getTitle();
            }
            if (string.startsWith("OptionsCategory_Name")) {
                return this.getCategoryName();
            }
            if (string.startsWith("AdvancedOption_DisplayName")) {
                return this.getDisplayName();
            }
            if (string.startsWith("AdvancedOption_Tooltip")) {
                return this.getTooltip();
            }
            throw new AssertionError((Object)string);
        }

        String getErrorMessage(int n) {
            assert (n > 0);
            String string = null;
            switch (n) {
                case 1: {
                    string = "FIELD_DisplayName";
                    break;
                }
                case 2: {
                    string = "FIELD_Tooltip";
                    break;
                }
                case 4: {
                    string = "FIELD_Title";
                    break;
                }
                case 5: {
                    string = "FIELD_CategoryName";
                    break;
                }
                case 6: {
                    string = "FIELD_IconPath";
                    break;
                }
                case 7: {
                    string = "FIELD_PackageName";
                    break;
                }
                case 8: {
                    string = "FIELD_ClassNamePrefix";
                    break;
                }
                case 9: {
                    return NbBundle.getMessage(NewOptionsIterator.class, (String)"ERR_Name_Prefix_Invalid");
                }
                default: {
                    assert (false) : "Unknown errCode: " + n;
                    break;
                }
            }
            string = NbBundle.getMessage(NewOptionsIterator.class, (String)string);
            return n > 0 ? NbBundle.getMessage(NewOptionsIterator.class, (String)"ERR_FieldInvalid", (Object)string) : "";
        }

        String getWarningMessage(int n) {
            String string;
            assert (n < 0);
            switch (n) {
                case -1: {
                    File file = new File(this.getIconPath());
                    assert (file.exists());
                    string = UIUtil.getIconDimensionWarning(file, 32, 32);
                    break;
                }
                default: {
                    assert (false) : "Unknown warningCode: " + n;
                    string = "";
                }
            }
            return string;
        }

        static boolean isSuccessCode(int n) {
            return n == 0;
        }

        static boolean isErrorCode(int n) {
            return n > 0;
        }

        static boolean isWarningCode(int n) {
            return n < 0;
        }

        private int checkFirstPanel() {
            if (this.advanced) {
                if (this.getDisplayName().length() == 0) {
                    return 1;
                }
                if (this.getTooltip().length() == 0) {
                    return 2;
                }
            } else {
                if (this.getTitle().length() == 0) {
                    return 4;
                }
                if (this.getCategoryName().length() == 0) {
                    return 5;
                }
                if (this.getIconPath().length() == 0) {
                    return 6;
                }
                if (this.getTitle().length() == 0) {
                    return 4;
                }
                File file = new File(this.getIconPath());
                if (!file.exists()) {
                    return 6;
                }
                file = new File(this.getIconPath());
                assert (file.exists());
                if (!UIUtil.isValidIcon(file, 32, 32)) {
                    return -1;
                }
            }
            return 0;
        }

        private int checkFinalPanel() {
            if (this.getPackageName().length() == 0) {
                return 7;
            }
            if (this.getClassNamePrefix().length() == 0) {
                return 8;
            }
            if (!Utilities.isJavaIdentifier((String)this.getClassNamePrefix())) {
                return 9;
            }
            return 0;
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            if (this.files == null) {
                this.files = this.generateCreatedModifiedFiles();
            }
            return this.files;
        }

        private CreatedModifiedFiles generateCreatedModifiedFiles() {
            assert (DataModel.isSuccessCode(this.checkFirstPanel()) || DataModel.isWarningCode(this.checkFirstPanel()));
            assert (DataModel.isSuccessCode(this.checkFinalPanel()));
            this.files = new CreatedModifiedFiles(this.getProject());
            this.generateFiles();
            this.generateBundleKeys();
            this.generateDependencies();
            this.generateLayerEntry();
            if (!this.isAdvanced()) {
                this.addCreateIconOperation(this.files, this.getIconPath());
            }
            return this.files;
        }

        private void generateFiles() {
            List<String> list = Arrays.asList(FORM_TEMPLATE_SUFFIXES);
            for (int i = 0; i < JAVA_TEMPLATE_SUFFIXES.length; ++i) {
                boolean bl;
                boolean bl2 = bl = this.isAdvanced() ? "OptionsCategory".equals(JAVA_TEMPLATE_SUFFIXES[i]) : "AdvancedOption".equals(JAVA_TEMPLATE_SUFFIXES[i]);
                if (bl) continue;
                this.files.add(this.createJavaFileCopyOperation(JAVA_TEMPLATE_SUFFIXES[i]));
                if (!list.contains(JAVA_TEMPLATE_SUFFIXES[i])) continue;
                this.files.add(this.createFormFileCopyOperation(JAVA_TEMPLATE_SUFFIXES[i]));
            }
        }

        private void generateBundleKeys() {
            String[] stringArray = this.isAdvanced() ? ADVANCED_BUNDLE_KEYS : CATEGORY_BUNDLE_KEYS;
            for (int i = 0; i < stringArray.length; ++i) {
                String string = this.getReplacement(stringArray[i]);
                String string2 = this.getBundleValue(string);
                this.files.add(this.files.bundleKey(this.getDefaultPackagePath("Bundle.properties", true), string, string2));
            }
        }

        private void generateDependencies() {
            this.files.add(this.files.addModuleDependency("org.openide.util"));
            this.files.add(this.files.addModuleDependency("org.netbeans.modules.options.api", "0-1", null, true));
            this.files.add(this.files.addModuleDependency("org.openide.awt"));
            this.files.add(this.files.addModuleDependency("org.jdesktop.layout"));
        }

        private void generateLayerEntry() {
            String string = this.isAdvanced() ? "OptionsDialog/Advanced/" : "OptionsDialog/";
            String string2 = this.isAdvanced() ? this.getAdvancedOptionClassName() : this.getOptionsCategoryClassName();
            String string3 = string + this.getPackageName().replace('.', '-') + "-" + string2 + ".instance";
            this.files.add(this.files.createLayerEntry(string3, null, null, null, null));
        }

        private CreatedModifiedFiles.Operation createJavaFileCopyOperation(String string) {
            FileObject fileObject = CreatedModifiedFiles.getTemplate(JAVA_TEMPLATE_PREFIX + string + ".java");
            assert (fileObject != null) : "template_myplugin" + string;
            return this.files.createFileWithSubstitutions(this.getFilePath(string), fileObject, this.getTokenMap());
        }

        private String getFilePath(String string) {
            String string2 = this.getClassNamePrefix() + string + ".java";
            return this.getDefaultPackagePath(string2, false);
        }

        private CreatedModifiedFiles.Operation createFormFileCopyOperation(String string) {
            FileObject fileObject = CreatedModifiedFiles.getTemplate(FORM_TEMPLATE_PREFIX + string + ".form");
            assert (fileObject != null) : "template_myplugin" + string;
            String string2 = this.getClassNamePrefix() + string + ".form";
            String string3 = this.getDefaultPackagePath(string2, false);
            return this.files.createFile(string3, fileObject);
        }

        private String getCodeNameBase() {
            if (this.codeNameBase == null) {
                NbModuleProvider nbModuleProvider = (NbModuleProvider)this.getProject().getLookup().lookup(NbModuleProvider.class);
                this.codeNameBase = nbModuleProvider.getCodeNameBase();
            }
            return this.codeNameBase;
        }

        private String getDisplayName() {
            assert (!this.isAdvanced() || this.displayName != null);
            return this.displayName;
        }

        private String getTooltip() {
            assert (!this.isAdvanced() || this.tooltip != null);
            return this.tooltip;
        }

        private String getTitle() {
            assert (this.isAdvanced() || this.title != null);
            return this.title;
        }

        private String getCategoryName() {
            assert (this.isAdvanced() || this.categoryName != null);
            return this.categoryName;
        }

        private String getIconPath() {
            assert (this.isAdvanced() || this.iconPath != null);
            return this.iconPath;
        }

        String getClassNamePrefix() {
            if (this.classNamePrefix == null) {
                this.classNamePrefix = this.getCodeNameBase();
                this.classNamePrefix = this.classNamePrefix.substring(this.classNamePrefix.lastIndexOf(".") + 1);
                this.classNamePrefix = this.classNamePrefix.substring(0, 1).toUpperCase(Locale.ENGLISH) + this.classNamePrefix.substring(1);
            }
            return this.classNamePrefix;
        }

        private boolean isAdvanced() {
            return this.advanced;
        }

        private String getAdvancedOptionClassName() {
            return this.getClassName(JAVA_TEMPLATE_SUFFIXES[0]);
        }

        private String getOptionsCategoryClassName() {
            return this.getClassName(JAVA_TEMPLATE_SUFFIXES[1]);
        }

        private String getPanelClassName() {
            return this.getClassName(JAVA_TEMPLATE_SUFFIXES[2]);
        }

        private String getOptionsPanelControllerClassName() {
            return this.getClassName(JAVA_TEMPLATE_SUFFIXES[3]);
        }

        private String getClassName(String string) {
            return this.getClassNamePrefix() + string;
        }
    }
}

