/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.wizard.loader;

import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import org.netbeans.modules.apisupport.project.CreatedModifiedFiles;
import org.netbeans.modules.apisupport.project.ui.wizard.BasicWizardIterator;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.FileRecognitionPanel;
import org.netbeans.modules.apisupport.project.ui.wizard.loader.NameAndLocationPanel;
import org.openide.WizardDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.modules.SpecificationVersion;
import org.openide.util.NbBundle;
import org.openide.xml.XMLUtil;

final class NewLoaderIterator
extends BasicWizardIterator {
    private DataModel data;

    private NewLoaderIterator() {
    }

    public static NewLoaderIterator createIterator() {
        return new NewLoaderIterator();
    }

    public Set instantiate() throws IOException {
        CreatedModifiedFiles createdModifiedFiles = this.data.getCreatedModifiedFiles();
        createdModifiedFiles.run();
        return NewLoaderIterator.getCreatedFiles(createdModifiedFiles, this.data.getProject());
    }

    protected BasicWizardIterator.Panel[] createPanels(WizardDescriptor wizardDescriptor) {
        this.data = new DataModel(wizardDescriptor);
        return new BasicWizardIterator.Panel[]{new FileRecognitionPanel(wizardDescriptor, this.data), new NameAndLocationPanel(wizardDescriptor, this.data)};
    }

    public void uninitialize(WizardDescriptor wizardDescriptor) {
        super.uninitialize(wizardDescriptor);
        this.data = null;
    }

    public static void generateFileChanges(DataModel dataModel) {
        String string;
        FileObject fileObject;
        HashMap<String, String> hashMap;
        String string2;
        CreatedModifiedFiles createdModifiedFiles;
        block15: {
            Object object;
            Object object2;
            CharSequence charSequence;
            String string3;
            createdModifiedFiles = new CreatedModifiedFiles(dataModel.getProject());
            string2 = dataModel.getPrefix();
            String string4 = dataModel.getPackageName();
            final String string5 = dataModel.getMimeType();
            hashMap = new HashMap<String, String>();
            hashMap.put("PREFIX", string2);
            hashMap.put("PACKAGENAME", string4);
            hashMap.put("MIMETYPE", string5);
            hashMap.put("EXTENSIONS", NewLoaderIterator.formatExtensions(dataModel.isExtensionBased(), dataModel.getExtension(), string5));
            hashMap.put("NAMESPACES", NewLoaderIterator.formatNameSpace(dataModel.isExtensionBased(), dataModel.getNamespace(), string5));
            String string6 = dataModel.getIconPath();
            if (string6 != null && new File(string6).exists()) {
                string3 = dataModel.addCreateIconOperation(createdModifiedFiles, string6);
                hashMap.put("IMAGESNIPPET", NewLoaderIterator.formatImageSnippet(string3));
                hashMap.put("ICONPATH", string3);
                hashMap.put("COMMENTICON", "");
            } else {
                hashMap.put("IMAGESNIPPET", NewLoaderIterator.formatImageSnippet(null));
                hashMap.put("ICONPATH", "SET/PATH/TO/ICON/HERE");
                hashMap.put("COMMENTICON", "//");
            }
            string3 = dataModel.getDefaultPackagePath(string2 + "DataLoader.java", false);
            fileObject = CreatedModifiedFiles.getTemplate("templateDataLoader.java");
            createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string3, fileObject, hashMap));
            String string7 = dataModel.getDefaultPackagePath(string2 + "DataLoaderBeanInfo.java", false);
            fileObject = CreatedModifiedFiles.getTemplate("templateDataLoaderBeanInfo.java");
            createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions(string7, fileObject, hashMap));
            final boolean bl = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.+-])*)", string5);
            if (bl) {
                charSequence = new StringBuffer();
                charSequence.append("        CookieSet cookies = getCookieSet();\n");
                charSequence.append("        cookies.add((Node.Cookie) DataEditorSupport.create(this, getPrimaryEntry(), cookies));");
                hashMap.put("EDITOR_SUPPORT_SNIPPET", charSequence.toString());
                hashMap.put("EDITOR_SUPPORT_IMPORT", "import org.openide.text.DataEditorSupport;");
            } else {
                hashMap.put("EDITOR_SUPPORT_SNIPPET", "");
                hashMap.put("EDITOR_SUPPORT_IMPORT", "");
            }
            charSequence = dataModel.getDefaultPackagePath(string2 + "DataObject.java", false);
            fileObject = null;
            try {
                object2 = dataModel.getModuleInfo().getDependencyVersion("org.openide.loaders");
                object = new SpecificationVersion("6.0");
                if (object2.compareTo(object) >= 0) {
                    fileObject = CreatedModifiedFiles.getTemplate("templateDataObjectWithLookup.java");
                }
            }
            catch (IOException iOException) {
                Logger.getLogger(NewLoaderIterator.class.getName()).log(Level.INFO, null, iOException);
            }
            if (fileObject == null) {
                fileObject = CreatedModifiedFiles.getTemplate("templateDataObject.java");
            }
            createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions((String)charSequence, fileObject, hashMap));
            object2 = dataModel.getDefaultPackagePath(string2 + "DataNode.java", false);
            fileObject = CreatedModifiedFiles.getTemplate("templateDataNode.java");
            createdModifiedFiles.add(createdModifiedFiles.createFileWithSubstitutions((String)object2, fileObject, hashMap));
            fileObject = CreatedModifiedFiles.getTemplate("templateresolver.xml");
            createdModifiedFiles.add(createdModifiedFiles.createLayerEntry("Services/MIMEResolver/" + string2 + "Resolver.xml", fileObject, hashMap, NbBundle.getMessage(NewLoaderIterator.class, (String)"LBL_LoaderName", (Object)string2), null));
            createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.filesystems"));
            createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.loaders"));
            createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.nodes"));
            createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.util"));
            if (bl) {
                createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.text"));
            }
            if (bl) {
                createdModifiedFiles.add(createdModifiedFiles.addModuleDependency("org.openide.windows"));
            }
            object = dataModel.getDefaultPackagePath("Bundle.properties", true);
            createdModifiedFiles.add(createdModifiedFiles.bundleKey((String)object, "LBL_" + string2 + "_loader_name", NbBundle.getMessage(NewLoaderIterator.class, (String)"LBL_LoaderName", (Object)string2)));
            boolean bl2 = Pattern.matches("(application/([a-zA-Z0-9_.-])*\\+xml|text/([a-zA-Z0-9_.-])*\\+xml)", string5);
            String string8 = null;
            if (bl2) {
                string8 = "org.openide.loaders.XMLDataObject, org.netbeans.modules.xml.XMLDataObject";
            }
            createdModifiedFiles.add(createdModifiedFiles.addLoaderSection(string4.replace('.', '/') + "/" + string2 + "DataLoader", string8));
            createdModifiedFiles.add(createdModifiedFiles.addLookupRegistration("org.openide.loaders.DataLoader", string4 + '.' + string2 + "DataLoader", true));
            createdModifiedFiles.add(createdModifiedFiles.layerModifications(new CreatedModifiedFiles.LayerOperation(){

                public void run(FileSystem fileSystem) throws IOException {
                    ArrayList<String> arrayList = new ArrayList<String>();
                    if (bl) {
                        arrayList.add("org.openide.actions.OpenAction");
                    }
                    arrayList.addAll(Arrays.asList("org.openide.actions.FileSystemAction", null, "org.openide.actions.CutAction", "org.openide.actions.CopyAction", null, "org.openide.actions.DeleteAction", "org.openide.actions.RenameAction", null, "org.openide.actions.SaveAsTemplateAction", null, "org.openide.actions.ToolsAction", "org.openide.actions.PropertiesAction"));
                    FileObject fileObject = FileUtil.createFolder((FileObject)fileSystem.getRoot(), (String)("Loaders/" + string5 + "/Actions"));
                    ArrayList<DataObject> arrayList2 = new ArrayList<DataObject>();
                    Iterator iterator = arrayList.iterator();
                    int n = 0;
                    while (iterator.hasNext()) {
                        FileObject fileObject2;
                        String string = (String)iterator.next();
                        if (string != null) {
                            fileObject2 = fileObject.createData(string.replace('.', '-') + ".instance");
                        } else {
                            fileObject2 = fileObject.createData("sep-" + ++n + ".instance");
                            fileObject2.setAttribute("instanceClass", (Object)"javax.swing.JSeparator");
                        }
                        arrayList2.add(DataObject.find((FileObject)fileObject2));
                    }
                    DataFolder.findFolder((FileObject)fileObject).setOrder(arrayList2.toArray(new DataObject[arrayList2.size()]));
                }
            }, Collections.<String>emptySet()));
            string = null;
            if (dataModel.isExtensionBased()) {
                string = "Template." + NewLoaderIterator.getFirstExtension(dataModel.getExtension());
                fileObject = CreatedModifiedFiles.getTemplate("templateNew1");
            } else {
                fileObject = CreatedModifiedFiles.getTemplate("templateNew2");
                string = "Template.xml";
                try {
                    hashMap.put("NAMESPACE", XMLUtil.toElementContent((String)dataModel.getNamespace()));
                }
                catch (CharConversionException charConversionException) {
                    if ($assertionsDisabled) break block15;
                    throw new AssertionError((Object)charConversionException);
                }
            }
        }
        HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
        hashMap2.put("template", true);
        createdModifiedFiles.add(createdModifiedFiles.createLayerEntry("Templates/Other/" + string2 + string, fileObject, hashMap, NbBundle.getMessage(NewLoaderIterator.class, (String)"LBL_fileTemplateName", (Object)string2), hashMap2));
        dataModel.setCreatedModifiedFiles(createdModifiedFiles);
    }

    private static String formatExtensions(boolean bl, String string, String string2) {
        if (!bl) {
            return "";
        }
        StringBuffer stringBuffer = new StringBuffer();
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        while (stringTokenizer.hasMoreTokens()) {
            String string3 = stringTokenizer.nextToken().trim();
            if (string3.startsWith(".")) {
                string3 = string3.substring(1);
            }
            stringBuffer.append("        <ext name=\"").append(string3).append("\"/>\n");
        }
        stringBuffer.append("        <resolver mime=\"").append(string2).append("\"/>");
        return stringBuffer.toString();
    }

    private static String getFirstExtension(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, " ,");
        String string2 = "someextension";
        if (stringTokenizer.hasMoreTokens() && (string2 = stringTokenizer.nextToken().trim()).startsWith(".")) {
            string2 = string2.substring(1);
        }
        return string2;
    }

    private static String formatNameSpace(boolean bl, String string, String string2) {
        StringBuffer stringBuffer;
        block3: {
            if (bl) {
                return "";
            }
            stringBuffer = new StringBuffer();
            stringBuffer.append("        <ext name=\"xml\"/>\n");
            stringBuffer.append("        <resolver mime=\"").append(string2).append("\">\n");
            stringBuffer.append("            <xml-rule>\n");
            try {
                stringBuffer.append("                <element ns=\"").append(XMLUtil.toElementContent((String)string)).append("\"/>\n");
            }
            catch (CharConversionException charConversionException) {
                if ($assertionsDisabled) break block3;
                throw new AssertionError((Object)charConversionException);
            }
        }
        stringBuffer.append("            </xml-rule>\n");
        stringBuffer.append("        </resolver>");
        return stringBuffer.toString();
    }

    private static String formatImageSnippet(String string) {
        if (string == null) {
            return "return super.getIcon(type); // TODO add a custom icon here: Utilities.loadImage(..., true)\n";
        }
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("        if (type == BeanInfo.ICON_COLOR_16x16 || type == BeanInfo.ICON_MONO_16x16) {\n");
        stringBuffer.append("            return Utilities.loadImage(\"");
        stringBuffer.append(string).append("\");\n");
        stringBuffer.append("        } else {\n");
        stringBuffer.append("            return null;\n        }\n");
        return stringBuffer.toString();
    }

    static final class DataModel
    extends BasicWizardIterator.BasicDataModel {
        private String prefix;
        private String iconPath;
        private String mimeType;
        private boolean extensionBased = true;
        private String extension;
        private String namespace;
        private CreatedModifiedFiles files;

        DataModel(WizardDescriptor wizardDescriptor) {
            super(wizardDescriptor);
        }

        public CreatedModifiedFiles getCreatedModifiedFiles() {
            return this.files;
        }

        public void setCreatedModifiedFiles(CreatedModifiedFiles createdModifiedFiles) {
            this.files = createdModifiedFiles;
        }

        public String getPrefix() {
            return this.prefix;
        }

        public void setPrefix(String string) {
            this.prefix = string;
        }

        public String getIconPath() {
            return this.iconPath;
        }

        public void setIconPath(String string) {
            this.iconPath = string;
        }

        public String getMimeType() {
            return this.mimeType;
        }

        public void setMimeType(String string) {
            this.mimeType = string;
        }

        public boolean isExtensionBased() {
            return this.extensionBased;
        }

        public void setExtensionBased(boolean bl) {
            this.extensionBased = bl;
        }

        public String getExtension() {
            return this.extension;
        }

        public void setExtension(String string) {
            this.extension = string;
        }

        public String getNamespace() {
            return this.namespace;
        }

        public void setNamespace(String string) {
            this.namespace = string;
        }
    }
}

