/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.platform;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Locale;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.filechooser.FileFilter;
import org.netbeans.modules.apisupport.project.queries.GlobalSourceForBinaryImpl;
import org.netbeans.modules.apisupport.project.ui.ModuleUISettings;
import org.netbeans.modules.apisupport.project.ui.platform.PlatformComponentFactory;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

final class NbPlatformCustomizerSources
extends JPanel {
    private NbPlatform plaf;
    private PlatformComponentFactory.NbPlatformSourceRootsModel model;
    private final ListListener listListener;
    private JButton addFolderButton;
    private JPanel buttonPanel;
    private JButton moveDownButton;
    private JButton moveUpButton;
    private JButton removeButton;
    private JLabel sourceLabel;
    private JList sourceList;
    private JScrollPane sourceSP;

    NbPlatformCustomizerSources() {
        this.initComponents();
        this.initAccessibility();
        this.listListener = new ListListener(){

            void listChanged() {
                NbPlatformCustomizerSources.this.updateEnabled();
            }
        };
        this.updateEnabled();
    }

    public void addNotify() {
        super.addNotify();
        this.sourceList.addListSelectionListener(this.listListener);
        this.sourceList.getModel().addListDataListener(this.listListener);
    }

    public void removeNotify() {
        this.sourceList.removeListSelectionListener(this.listListener);
        this.sourceList.getModel().removeListDataListener(this.listListener);
        super.removeNotify();
    }

    void setPlatform(NbPlatform nbPlatform) {
        this.plaf = nbPlatform;
        this.model = new PlatformComponentFactory.NbPlatformSourceRootsModel(nbPlatform);
        this.sourceList.setModel(this.model);
    }

    private void updateEnabled() {
        this.removeButton.setEnabled(this.sourceList.getModel().getSize() > 0 && this.sourceList.getSelectedIndex() != -1);
        this.moveUpButton.setEnabled(this.sourceList.getSelectionModel().getMinSelectionIndex() > 0);
        this.moveDownButton.setEnabled(this.plaf != null && this.sourceList.getSelectionModel().getMaxSelectionIndex() < this.plaf.getSourceRoots().length - 1);
    }

    private void initComponents() {
        this.sourceLabel = new JLabel();
        this.sourceSP = new JScrollPane();
        this.sourceList = new JList();
        this.buttonPanel = new JPanel();
        this.addFolderButton = new JButton();
        this.removeButton = new JButton();
        this.moveUpButton = new JButton();
        this.moveDownButton = new JButton();
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(12, 12, 12, 12));
        this.sourceLabel.setLabelFor(this.sourceList);
        Mnemonics.setLocalizedText((JLabel)this.sourceLabel, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"LBL_PlatformSources"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        this.add((Component)this.sourceLabel, gridBagConstraints);
        this.sourceList.setCellRenderer(PlatformComponentFactory.getURLListRenderer());
        this.sourceSP.setViewportView(this.sourceList);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)this.sourceSP, gridBagConstraints);
        this.buttonPanel.setLayout(new GridBagLayout());
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 12, 0, 0));
        Mnemonics.setLocalizedText((AbstractButton)this.addFolderButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_AddZipOrFolder"));
        this.addFolderButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerSources.this.addZipOrFolder(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        this.buttonPanel.add((Component)this.addFolderButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.removeButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_Remove"));
        this.removeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerSources.this.removeFolder(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(12, 0, 12, 0);
        this.buttonPanel.add((Component)this.removeButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveUpButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_MoveUp"));
        this.moveUpButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerSources.this.moveUp(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        this.buttonPanel.add((Component)this.moveUpButton, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.moveDownButton, (String)NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)"CTL_MoveDown"));
        this.moveDownButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                NbPlatformCustomizerSources.this.moveDown(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.weighty = 1.0;
        this.buttonPanel.add((Component)this.moveDownButton, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        this.add((Component)this.buttonPanel, gridBagConstraints);
    }

    private void moveDown(ActionEvent actionEvent) {
        int[] nArray = this.sourceList.getSelectedIndices();
        this.model.moveSourceRootsDown(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            int n2 = nArray[n] + 1;
            nArray[n] = n2;
            nArray[i] = n2;
        }
        this.sourceList.setSelectedIndices(nArray);
    }

    private void moveUp(ActionEvent actionEvent) {
        int[] nArray = this.sourceList.getSelectedIndices();
        this.model.moveSourceRootsUp(nArray);
        for (int i = 0; i < nArray.length; ++i) {
            int n = i;
            int n2 = nArray[n] - 1;
            nArray[n] = n2;
            nArray[i] = n2;
        }
        this.sourceList.setSelectedIndices(nArray);
    }

    private void removeFolder(ActionEvent actionEvent) {
        Object[] objectArray = this.sourceList.getSelectedValues();
        int n = this.sourceList.getSelectedIndex() - 1;
        URL[] uRLArray = new URL[objectArray.length];
        System.arraycopy(objectArray, 0, uRLArray, 0, objectArray.length);
        this.model.removeSourceRoot(uRLArray);
        this.sourceList.setSelectedIndex(n);
    }

    private void addZipOrFolder(ActionEvent actionEvent) {
        JFileChooser jFileChooser = new JFileChooser(ModuleUISettings.getDefault().getLastUsedNbPlatformLocation());
        jFileChooser.setAcceptAllFileFilterUsed(false);
        jFileChooser.setFileSelectionMode(2);
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                return file.isDirectory() || NbPlatformCustomizerSources.isValidNbSourceRoot(file);
            }

            public String getDescription() {
                return NbPlatformCustomizerSources.this.getMessage("CTL_SourcesTab");
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = FileUtil.normalizeFile((File)jFileChooser.getSelectedFile());
            if (!file.exists() || file.isFile() && !NbPlatformCustomizerSources.isValidNbSourceRoot(file)) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)this.getMessage("MSG_NotValidNBSrcZIP")));
            } else {
                ModuleUISettings.getDefault().setLastUsedNbPlatformLocation(file.getParentFile().getAbsolutePath());
                URL uRL = FileUtil.urlForArchiveOrDir((File)file);
                this.model.addSourceRoot(uRL);
                this.sourceList.setSelectedValue(uRL, true);
            }
        }
    }

    private static boolean isValidNbSourceRoot(File file) {
        boolean bl = false;
        String string = file.getName().toLowerCase(Locale.US);
        if (string.endsWith(".jar") || string.endsWith(".zip")) {
            try {
                bl = GlobalSourceForBinaryImpl.NetBeansSourcesParser.getInstance(file) != null;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return bl;
    }

    private void initAccessibility() {
        this.addFolderButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_addFolderButton"));
        this.sourceList.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_sourceList"));
        this.moveDownButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveDownButton"));
        this.moveUpButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_moveUpButton"));
        this.removeButton.getAccessibleContext().setAccessibleDescription(this.getMessage("ACS_CTL_removeButton"));
    }

    private String getMessage(String string) {
        return NbBundle.getMessage(NbPlatformCustomizerSources.class, (String)string);
    }

    static abstract class ListListener
    implements ListDataListener,
    ListSelectionListener {
        ListListener() {
        }

        public void intervalAdded(ListDataEvent listDataEvent) {
            this.listChanged();
        }

        public void intervalRemoved(ListDataEvent listDataEvent) {
            this.listChanged();
        }

        public void contentsChanged(ListDataEvent listDataEvent) {
            this.listChanged();
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                this.listChanged();
            }
        }

        abstract void listChanged();
    }
}

