/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.NbModuleProjectGenerator;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.SuiteProvider;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;
import org.openide.util.NbCollections;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class SuiteUtils {
    private static final String ANT_PURE_PROPERTY_REFERENCE_REGEXP = "\\$\\{\\p{Graph}+\\}";
    private static final String PRIVATE_PLATFORM_PROPERTIES = "nbproject/private/platform-private.properties";
    static final String MODULES_PROPERTY = "modules";
    private final SuiteProperties suiteProps;

    private SuiteUtils(SuiteProperties suiteProperties) {
        this.suiteProps = suiteProperties;
    }

    public static NbModuleProject[] getDependentModules(final NbModuleProject nbModuleProject) throws IOException {
        final String string = nbModuleProject.getCodeNameBase();
        try {
            return (NbModuleProject[])ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<NbModuleProject[]>(){

                public NbModuleProject[] run() throws Exception {
                    HashSet<NbModuleProject> hashSet = new HashSet<NbModuleProject>();
                    SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                    if (suiteProject == null) {
                        Util.err.log(16, "Cannot find suite for the given suitecomponent (" + nbModuleProject + ')');
                    } else {
                        block0: for (NbModuleProject nbModuleProject2 : SuiteUtils.getSubProjects(suiteProject)) {
                            for (ModuleDependency moduleDependency : new ProjectXMLManager(nbModuleProject2).getDirectDependencies()) {
                                if (!moduleDependency.getModuleEntry().getCodeNameBase().equals(string)) continue;
                                hashSet.add(nbModuleProject2);
                                continue block0;
                            }
                        }
                    }
                    return hashSet.toArray(new NbModuleProject[hashSet.size()]);
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void replaceSubModules(final SuiteProperties suiteProperties) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                    Set<NbModuleProject> set = suiteProperties.getSubModules();
                    Set<NbModuleProject> set2 = suiteProperties.getOrigSubModules();
                    for (NbModuleProject nbModuleProject : set2) {
                        if (set.contains(nbModuleProject)) continue;
                        Util.err.log("Removing module: " + nbModuleProject);
                        SuiteUtils.removeModule(nbModuleProject, suiteProperties);
                    }
                    for (NbModuleProject nbModuleProject : set) {
                        if (SuiteUtils.contains(suiteProperties.getProject(), nbModuleProject)) {
                            Util.err.log("Module \"" + nbModuleProject + "\" or a module with the same CNB is already contained in the suite.");
                            continue;
                        }
                        suiteUtils.addModule(nbModuleProject);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void addModule(final SuiteProject suiteProject, final NbModuleProject nbModuleProject) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteProperties suiteProperties = new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), SuiteUtils.getSubProjects(suiteProject));
                    if (!SuiteUtils.contains(suiteProject, nbModuleProject)) {
                        SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                        suiteUtils.addModule(nbModuleProject);
                        suiteProperties.storeProperties();
                    } else {
                        Util.err.log("Module \"" + nbModuleProject + "\" or a module with the same CNB is already contained in the suite.");
                    }
                    ProjectManager.getDefault().saveProject((Project)suiteProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void removeModuleFromSuiteWithDependencies(final NbModuleProject nbModuleProject) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    NbModuleProject[] nbModuleProjectArray = SuiteUtils.getDependentModules(nbModuleProject);
                    String string = nbModuleProject.getCodeNameBase();
                    for (int i = 0; i < nbModuleProjectArray.length; ++i) {
                        ProjectXMLManager projectXMLManager = new ProjectXMLManager(nbModuleProjectArray[i]);
                        projectXMLManager.removeDependency(string);
                        ProjectManager.getDefault().saveProject((Project)nbModuleProjectArray[i]);
                    }
                    SuiteUtils.removeModuleFromSuite(nbModuleProject);
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static void removeModuleFromSuite(final NbModuleProject nbModuleProject) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws Exception {
                    SuiteProject suiteProject = SuiteUtils.findSuite(nbModuleProject);
                    if (suiteProject != null) {
                        SuiteProperties suiteProperties = new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), SuiteUtils.getSubProjects(suiteProject));
                        SuiteUtils suiteUtils = new SuiteUtils(suiteProperties);
                        SuiteUtils.removeModule(nbModuleProject, suiteProperties);
                        suiteProperties.storeProperties();
                        ProjectManager.getDefault().saveProject((Project)suiteProject);
                    } else if (Util.getModuleType(nbModuleProject) == NbModuleProvider.SUITE_COMPONENT) {
                        SuiteUtils.removeModule(nbModuleProject, null);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private void addModule(NbModuleProject nbModuleProject) throws IOException, IllegalArgumentException {
        SuiteUtils.removeModuleFromSuite(nbModuleProject);
        this.attachSubModuleToSuite(nbModuleProject);
    }

    private static void removeModule(final NbModuleProject nbModuleProject, final SuiteProperties suiteProperties) {
        NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(nbModuleProject);
        assert (nbModuleType == NbModuleProvider.SUITE_COMPONENT) : "Not a suite component: " + nbModuleProject;
        try {
            nbModuleProject.getProjectDirectory().getFileSystem().runAtomicAction(new FileSystem.AtomicAction(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                public void run() throws IOException {
                    nbModuleProject.setRunInAtomicAction(true);
                    try {
                        Object object;
                        EditableProperties editableProperties;
                        FileObject fileObject = nbModuleProject.getProjectDirectory();
                        FileObject fileObject2 = fileObject.getFileObject("nbproject/suite.properties");
                        if (fileObject2 != null) {
                            fileObject2.delete();
                        }
                        if ((fileObject2 = fileObject.getFileObject("nbproject/private/suite-private.properties")) != null) {
                            fileObject2.delete();
                        }
                        if (suiteProperties != null) {
                            editableProperties = suiteProperties.getProject().getProjectDirectory().getFileObject("nbproject/platform.properties");
                            object = fileObject.getFileObject("nbproject");
                            if (object.getFileObject("platform.properties") == null) {
                                FileUtil.copyFile((FileObject)editableProperties, (FileObject)object, (String)"platform");
                            }
                        }
                        if ((editableProperties = nbModuleProject.getHelper().getProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES)).getProperty("user.properties.file") == null) {
                            object = System.getProperty("netbeans.user");
                            if (object != null) {
                                editableProperties.setProperty("user.properties.file", new File((String)object, "build.properties").getAbsolutePath());
                                nbModuleProject.getHelper().putProperties(SuiteUtils.PRIVATE_PLATFORM_PROPERTIES, editableProperties);
                            } else {
                                Util.err.log("netbeans.user system property is not defined. Skipping nbproject/private/platform-private.properties creation.");
                            }
                        }
                        SuiteUtils.setNbModuleType(nbModuleProject, NbModuleProvider.STANDALONE);
                        ProjectManager.getDefault().saveProject((Project)nbModuleProject);
                    }
                    finally {
                        nbModuleProject.setRunInAtomicAction(false);
                    }
                }
            });
            if (suiteProperties != null) {
                SuiteUtils.removeFromProperties(nbModuleProject, suiteProperties);
            }
        }
        catch (IOException iOException) {
            ErrorManager.getDefault().notify((Throwable)iOException);
        }
    }

    private static boolean removeFromProperties(NbModuleProject nbModuleProject, SuiteProperties suiteProperties) {
        String string = suiteProperties.getProperty(MODULES_PROPERTY);
        boolean bl = false;
        if (string != null) {
            ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(PropertyUtils.tokenizePath((String)string)));
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                String string2 = (String)iterator.next();
                String string3 = suiteProperties.getEvaluator().evaluate(string2);
                if (string3 == null) {
                    Util.err.log("Cannot evaluate " + string2 + " property.");
                    continue;
                }
                if (nbModuleProject.getProjectDirectory() != suiteProperties.getHelper().resolveFileObject(string3)) continue;
                iterator.remove();
                String[] stringArray = SuiteUtils.getAntProperty(arrayList);
                suiteProperties.setProperty(MODULES_PROPERTY, stringArray);
                bl = true;
                if (!string2.matches(ANT_PURE_PROPERTY_REFERENCE_REGEXP)) break;
                String string4 = string2.substring(2, string2.length() - 1);
                suiteProperties.removeProperty(string4);
                suiteProperties.removePrivateProperty(string4);
                break;
            }
        }
        if (!bl) {
            Util.err.log("Removing of " + nbModuleProject + " was unsuccessful.");
        }
        return bl;
    }

    private void attachSubModuleToSuite(Project project) throws IOException {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        File file2 = this.suiteProps.getProjectDirectoryFile();
        String string = this.generatePropertyKey(project);
        String string2 = PropertyUtils.relativizeFile((File)file2, (File)file);
        if (string2 != null) {
            this.suiteProps.setProperty(string, string2);
        } else {
            this.suiteProps.setPrivateProperty(string, file.getAbsolutePath());
        }
        String string3 = this.suiteProps.getProperty(MODULES_PROPERTY);
        StringBuffer stringBuffer = new StringBuffer(string3 == null ? "" : string3);
        if (stringBuffer.length() > 0) {
            stringBuffer.append(':');
        }
        stringBuffer.append("${").append(string).append('}');
        this.suiteProps.setProperty(MODULES_PROPERTY, stringBuffer.toString().split("(?<=:)", -1));
        NbModuleProjectGenerator.createSuiteProperties(project.getProjectDirectory(), file2);
        SuiteUtils.setNbModuleType(project, NbModuleProvider.SUITE_COMPONENT);
        ProjectManager.getDefault().saveProject(project);
    }

    private String generatePropertyKey(Project project) {
        String string = "project." + ProjectUtils.getInformation((Project)project).getName();
        Object[] objectArray = this.suiteProps.getProperty(MODULES_PROPERTY).split("(?<=:)", -1);
        int n = 0;
        while (Arrays.binarySearch(objectArray, "${" + string + "}") >= 0) {
            string = string + "_" + ++n;
        }
        return string;
    }

    private static void setNbModuleType(Project project, NbModuleProvider.NbModuleType nbModuleType) throws IOException {
        ProjectXMLManager projectXMLManager = new ProjectXMLManager((NbModuleProject)project);
        projectXMLManager.setModuleType(nbModuleType);
    }

    private static String[] getAntProperty(Collection<String> collection) {
        ArrayList<String> arrayList = new ArrayList<String>();
        Iterator<String> iterator = collection.iterator();
        while (iterator.hasNext()) {
            String string = iterator.next() + (iterator.hasNext() ? ":" : "");
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    public static boolean isSuite(File file) {
        boolean bl = false;
        try {
            Project project;
            FileObject fileObject = FileUtil.toFileObject((File)file);
            if (fileObject != null && (project = ProjectManager.getDefault().findProject(fileObject)) != null) {
                bl = file.equals(SuiteUtils.getSuiteDirectory(project));
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bl;
    }

    public static SuiteProject findSuite(final Project project) throws IOException {
        try {
            return (SuiteProject)ProjectManager.mutex().readAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<SuiteProject>(){

                public SuiteProject run() throws Exception {
                    Project project2 = null;
                    File file = SuiteUtils.getSuiteDirectory(project);
                    if (file != null) {
                        FileObject fileObject = FileUtil.toFileObject((File)file);
                        if (fileObject == null) {
                            Util.err.log(16, "Module in the \"" + FileUtil.toFile((FileObject)project.getProjectDirectory()).getAbsolutePath() + "\" directory claims to be a subcomponent of a suite in the \"" + file.getAbsolutePath() + "\" which does not exist however.");
                        } else {
                            project2 = ProjectManager.getDefault().findProject(fileObject);
                        }
                    }
                    return project2 instanceof SuiteProject ? (SuiteProject)project2 : null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    public static boolean contains(SuiteProject suiteProject, NbModuleProject nbModuleProject) {
        Set<NbModuleProject> set = SuiteUtils.getSubProjects(suiteProject);
        if (set.contains(nbModuleProject)) {
            return true;
        }
        for (NbModuleProject nbModuleProject2 : set) {
            if (!nbModuleProject2.getCodeNameBase().equals(nbModuleProject.getCodeNameBase())) continue;
            return true;
        }
        return false;
    }

    public static Set<NbModuleProject> getSubProjects(Project project) {
        assert (project != null);
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        return NbCollections.checkedSetByFilter((Set)subprojectProvider.getSubprojects(), NbModuleProject.class, (boolean)true);
    }

    public static File getSuiteDirectory(Project project) {
        File file = null;
        SuiteProvider suiteProvider = (SuiteProvider)project.getLookup().lookup(SuiteProvider.class);
        if (suiteProvider != null) {
            file = suiteProvider.getSuiteDirectory();
        }
        return file;
    }

    public static String getSuiteDirectoryPath(Project project) {
        File file = SuiteUtils.getSuiteDirectory(project);
        return file != null ? file.getAbsolutePath() : null;
    }
}

