/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.net.URL;
import java.util.StringTokenizer;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.SwingUtilities;
import org.netbeans.modules.apisupport.project.ui.customizer.DragManager;

class SplashComponentPreview
extends JLabel {
    private FontMetrics fm;
    private Rectangle view;
    private Color color_text;
    private Color color_bar;
    private Color color_edge;
    private Color color_corner;
    private boolean draw_bar;
    protected Image image;
    private Rectangle dirty = new Rectangle();
    private String text;
    private Rectangle rect = new Rectangle();
    private Rectangle bar = new Rectangle();
    private Rectangle bar_inc = new Rectangle();
    private int progress = 0;
    private int maxSteps = 0;
    private int tmpSteps = 0;
    private int barStart = 0;
    private int barLength = 0;
    private DragManager dragManager = new DragManager(this);
    private DragManager.DragItem textDragItem = this.dragManager.createNewItem();
    private DragManager.DragItem progressDragItem = this.dragManager.createNewItem();

    void setFontSize(String string) throws NumberFormatException {
        String string2 = string;
        int n = Integer.parseInt(string2);
        Font font = new Font("Dialog", 0, n);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
    }

    void setSplashImageIcon(URL uRL) {
        ImageIcon imageIcon = new ImageIcon(uRL);
        this.image = imageIcon.getImage();
    }

    void setDropHandletForProgress(DragManager.DropHandler dropHandler) {
        this.progressDragItem.setDropHandler(dropHandler);
    }

    void setDropHandletForText(DragManager.DropHandler dropHandler) {
        this.textDragItem.setDropHandler(dropHandler);
    }

    void setFontSize(int n) throws NumberFormatException {
        Font font = new Font("Dialog", 0, n);
        this.setFont(font);
        this.fm = this.getFontMetrics(font);
    }

    void setRunningTextBounds(Rectangle rectangle) throws NumberFormatException {
        this.view = rectangle;
    }

    void setProgressBarEnabled(boolean bl) {
        this.draw_bar = bl;
        this.progressDragItem.setEnabled(bl);
    }

    void setProgressBarBounds(Rectangle rectangle) throws NumberFormatException {
        this.bar = rectangle;
        this.progressDragItem.setRectangle(this.bar);
    }

    void setColorCorner(Color color) throws NumberFormatException {
        this.color_corner = color;
    }

    void setColorEdge(Color color) throws NumberFormatException {
        this.color_edge = color;
    }

    void setTextColor(Color color) throws NumberFormatException {
        this.color_text = color;
    }

    void setColorBar(Color color) throws NumberFormatException {
        this.color_bar = color;
    }

    public void setText(final String string) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (string == null) {
                    SplashComponentPreview.this.repaint(SplashComponentPreview.this.dirty);
                    return;
                }
                if (SplashComponentPreview.this.fm == null) {
                    return;
                }
                SplashComponentPreview.this.adjustText(string);
                SwingUtilities.layoutCompoundLabel(SplashComponentPreview.this.fm, string, null, 3, 2, 3, 2, SplashComponentPreview.this.view, new Rectangle(), SplashComponentPreview.this.rect, 0);
                SplashComponentPreview.this.textDragItem.setRectangle(SplashComponentPreview.this.view);
                SplashComponentPreview.this.dirty = SplashComponentPreview.this.dirty.union(SplashComponentPreview.this.rect);
                SplashComponentPreview.this.repaint();
                SplashComponentPreview.this.dirty = new Rectangle(SplashComponentPreview.this.rect);
            }
        });
    }

    public void setMaxSteps(int n) {
        this.maxSteps = n;
    }

    public void addToMaxSteps(int n) {
        this.tmpSteps += n;
    }

    public void addAndSetMaxSteps(int n) {
        this.tmpSteps += n;
        this.maxSteps = this.tmpSteps;
    }

    public void increment(int n) {
        if (this.draw_bar) {
            int n2;
            this.progress += n;
            if (this.progress > this.maxSteps) {
                this.progress = this.maxSteps;
            } else if (this.maxSteps > 0 && ((n2 = this.bar.width * this.progress / this.maxSteps - this.barStart) > 1 || this.barStart % 2 == 0)) {
                this.barLength = n2;
                this.bar_inc = new Rectangle(this.bar.x + this.barStart, this.bar.y, this.barLength + 1, this.bar.height);
                this.repaint(this.bar_inc);
            }
        }
    }

    public void resetSteps() {
        this.progress = 0;
        this.barStart = 0;
        this.barLength = 0;
        this.increment(this.maxSteps);
    }

    private void adjustText(String string) {
        String string2 = null;
        if (string == null) {
            return;
        }
        if (this.fm == null) {
            return;
        }
        int n = this.fm.stringWidth(string);
        if (n > this.view.width) {
            StringTokenizer stringTokenizer = new StringTokenizer(string);
            while (stringTokenizer.hasMoreTokens()) {
                String string3 = stringTokenizer.nextToken();
                String string4 = string2 == null ? string3 : string2 + " " + string3;
                if (this.fm.stringWidth(string4 + "...") > this.view.width) {
                    this.text = string2 + "...";
                    break;
                }
                string2 = string4;
            }
        } else {
            this.text = string;
        }
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        super.paint(graphics);
        this.dragManager.setTranslate(0, 0);
        this.originalPaint(graphics);
        this.dragManager.paint(graphics);
    }

    public void originalPaint(Graphics graphics) {
        Graphics2D graphics2D = (Graphics2D)graphics;
        if (!this.isEnabled()) {
            graphics2D.setComposite(AlphaComposite.getInstance(3, 0.3f));
        }
        graphics.setColor(this.color_text);
        graphics.drawImage(this.image, 0, 0, null);
        if (this.text == null) {
            return;
        }
        if (this.fm == null) {
            return;
        }
        SwingUtilities.layoutCompoundLabel(this.fm, this.text, null, 3, 2, 3, 2, this.view, new Rectangle(), this.rect, 0);
        graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        graphics.drawString(this.text, this.rect.x, this.rect.y + this.fm.getAscent());
        if (this.draw_bar && !Boolean.getBoolean("netbeans.splash.nobar") && this.maxSteps > 0) {
            graphics.setColor(this.color_bar);
            graphics.fillRect(this.bar.x, this.bar.y, this.barStart + this.barLength, this.bar.height);
            graphics.setColor(this.color_corner);
            graphics.drawLine(this.bar.x, this.bar.y, this.bar.x, this.bar.y + this.bar.height);
            graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height);
            graphics.setColor(this.color_edge);
            graphics.drawLine(this.bar.x, this.bar.y + this.bar.height / 2, this.bar.x, this.bar.y + this.bar.height / 2);
            graphics.drawLine(this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2, this.bar.x + this.barStart + this.barLength, this.bar.y + this.bar.height / 2);
            this.barStart += this.barLength;
            this.barLength = 0;
        }
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.image.getWidth(null), this.image.getHeight(null));
    }

    public Rectangle getView() {
        return this.view;
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.textDragItem.setEnabled(bl);
        this.progressDragItem.setEnabled(bl & this.draw_bar);
    }
}

