/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui.customizer;

import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.ComboBoxModel;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.UIResource;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleProperties;
import org.openide.util.WeakListeners;

public class JavaPlatformComponentFactory {
    private JavaPlatformComponentFactory() {
    }

    public static ComboBoxModel javaPlatformListModel() {
        return new Model();
    }

    public static ListCellRenderer javaPlatformListCellRenderer() {
        return new Renderer();
    }

    private static final class Renderer
    extends JLabel
    implements ListCellRenderer,
    UIResource {
        public Renderer() {
            this.setOpaque(true);
        }

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            this.setName("ComboBox.listRenderer");
            String string = object != null ? ((JavaPlatform)object).getDisplayName() : null;
            this.setText(string);
            if (bl) {
                this.setBackground(jList.getSelectionBackground());
                this.setForeground(jList.getSelectionForeground());
            } else {
                this.setBackground(jList.getBackground());
                this.setForeground(jList.getForeground());
            }
            return this;
        }

        public String getName() {
            String string = super.getName();
            return string == null ? "ComboBox.renderer" : string;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class Model
    implements ComboBoxModel,
    PropertyChangeListener,
    Comparator<JavaPlatform> {
        private static final Collator COLL = Collator.getInstance();
        private static final JavaPlatformManager mgr = JavaPlatformManager.getDefault();
        private final SortedSet<JavaPlatform> platforms = new TreeSet<JavaPlatform>(this);
        private final List<ListDataListener> listeners = new ArrayList<ListDataListener>();
        private JavaPlatform selected;

        public Model() {
            this.refresh();
            mgr.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)mgr));
        }

        private void refresh() {
            this.platforms.clear();
            for (JavaPlatform javaPlatform : mgr.getInstalledPlatforms()) {
                if (!javaPlatform.getSpecification().getName().equals("j2se")) continue;
                this.platforms.add(javaPlatform);
            }
        }

        @Override
        public int getSize() {
            return this.platforms.size();
        }

        @Override
        public Object getElementAt(int n) {
            return new ArrayList<JavaPlatform>(this.platforms).get(n);
        }

        @Override
        public void addListDataListener(ListDataListener listDataListener) {
            this.listeners.add(listDataListener);
        }

        @Override
        public void removeListDataListener(ListDataListener listDataListener) {
            this.listeners.remove(listDataListener);
        }

        @Override
        public void setSelectedItem(Object object) {
            if (object != this.selected) {
                this.selected = (JavaPlatform)object;
                this.fireChange();
            }
        }

        @Override
        public Object getSelectedItem() {
            return this.selected;
        }

        private void fireChange() {
            ListDataEvent listDataEvent = new ListDataEvent(this, 0, 0, 0);
            for (ListDataListener listDataListener : new ArrayList<ListDataListener>(this.listeners)) {
                listDataListener.contentsChanged(listDataEvent);
            }
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            this.refresh();
            this.fireChange();
        }

        @Override
        public int compare(JavaPlatform javaPlatform, JavaPlatform javaPlatform2) {
            int n = COLL.compare(javaPlatform.getDisplayName(), javaPlatform2.getDisplayName());
            if (n != 0) {
                return n;
            }
            String string = ModuleProperties.getPlatformID(javaPlatform);
            String string2 = ModuleProperties.getPlatformID(javaPlatform2);
            if (string != null && string2 != null) {
                return string.compareTo(string2);
            }
            return System.identityHashCode(javaPlatform) - System.identityHashCode(javaPlatform2);
        }
    }
}

