/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.spi.project.CopyOperationImplementation;
import org.netbeans.spi.project.DeleteOperationImplementation;
import org.netbeans.spi.project.MoveOperationImplementation;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class ModuleOperations
implements DeleteOperationImplementation,
MoveOperationImplementation,
CopyOperationImplementation {
    private static final Map<String, SuiteProject> TEMPORARY_CACHE = new HashMap<String, SuiteProject>();
    private final NbModuleProject project;
    private final FileObject projectDir;

    public ModuleOperations(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
        this.projectDir = nbModuleProject.getProjectDirectory();
    }

    public void notifyDeleting() throws IOException {
        this.notifyDeleting(false);
    }

    private void notifyDeleting(boolean bl) throws IOException {
        FileObject fileObject = this.projectDir.getFileObject("build.xml");
        ActionUtils.runTarget((FileObject)fileObject, (String[])new String[]{"clean"}, null).waitFinished();
        SuiteProject suiteProject = SuiteUtils.findSuite(this.project);
        if (suiteProject != null) {
            if (bl) {
                SuiteUtils.removeModuleFromSuite(this.project);
            } else {
                SuiteUtils.removeModuleFromSuiteWithDependencies(this.project);
            }
        }
        this.project.notifyDeleting();
    }

    public void notifyDeleted() throws IOException {
        this.project.getHelper().notifyDeleted();
    }

    public void notifyMoving() throws IOException {
        SuiteProject suiteProject = SuiteUtils.findSuite(this.project);
        if (suiteProject != null) {
            TEMPORARY_CACHE.put(this.project.getCodeNameBase(), suiteProject);
        }
        this.notifyDeleting(true);
    }

    public void notifyMoved(Project project, File file, String string) throws IOException {
        if (project == null) {
            this.project.getHelper().notifyDeleted();
        } else {
            boolean bl;
            SuiteProject suiteProject = TEMPORARY_CACHE.remove(this.project.getCodeNameBase());
            if (suiteProject != null) {
                SuiteUtils.addModule(suiteProject, this.project);
            }
            if (bl = project.getProjectDirectory().getParent().equals(this.project.getProjectDirectory().getParent())) {
                this.setDisplayName(string);
            }
        }
    }

    public void notifyCopying() throws IOException {
        SuiteProject suiteProject = SuiteUtils.findSuite(this.project);
        if (suiteProject != null) {
            TEMPORARY_CACHE.put(this.project.getCodeNameBase(), suiteProject);
            SuiteUtils.removeModuleFromSuite(this.project);
        }
    }

    public void notifyCopied(Project project, File file, String string) throws IOException {
        if (project == null) {
            SuiteProject suiteProject = TEMPORARY_CACHE.remove(this.project.getCodeNameBase());
            if (suiteProject != null) {
                SuiteUtils.addModule(suiteProject, this.project);
            }
        } else {
            this.adjustDisplayName();
        }
    }

    public List<FileObject> getMetadataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        this.addFile("build.xml", arrayList);
        this.addFile("manifest.mf", arrayList);
        this.addFile("nbproject", arrayList);
        return arrayList;
    }

    public List<FileObject> getDataFiles() {
        ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
        Sources sources = ProjectUtils.getSources((Project)this.project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("java");
        for (int i = 0; i < sourceGroupArray.length; ++i) {
            FileObject fileObject = sourceGroupArray[i].getRootFolder();
            if (fileObject.getPath().endsWith("test/unit/src")) {
                this.addFile("test", arrayList);
                continue;
            }
            arrayList.add(fileObject);
        }
        return arrayList;
    }

    private void addFile(String string, List<FileObject> list) {
        FileObject fileObject = this.projectDir.getFileObject(string);
        if (fileObject != null) {
            list.add(fileObject);
        }
    }

    private void adjustDisplayName() throws IOException {
        this.setDisplayName(ProjectUtils.getInformation((Project)this.project).getDisplayName() + " (0)");
    }

    private void setDisplayName(String string) throws IOException {
        LocalizedBundleInfo localizedBundleInfo;
        LocalizedBundleInfo.Provider provider = (LocalizedBundleInfo.Provider)this.project.getLookup().lookup(LocalizedBundleInfo.Provider.class);
        if (provider != null && (localizedBundleInfo = provider.getLocalizedBundleInfo()) != null) {
            localizedBundleInfo.setDisplayName(string);
            localizedBundleInfo.store();
        }
    }

    static boolean canRun(NbModuleProject nbModuleProject, boolean bl) {
        FileObject fileObject;
        boolean bl2 = true;
        String string = nbModuleProject.evaluator().getProperty("test.user.dir");
        FileObject fileObject2 = nbModuleProject.getHelper().resolveFileObject(string);
        if (fileObject2 != null && fileObject2.isFolder() && (fileObject = fileObject2.getFileObject("lock")) != null && fileObject.isData()) {
            if (bl) {
                DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)NbBundle.getMessage(ModuleOperations.class, (String)"ERR_ModuleIsBeingRun")));
            }
            bl2 = false;
        }
        return bl2;
    }
}

