/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.ui;

import java.awt.Image;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Action;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ui.AnnotatedNode;
import org.netbeans.modules.apisupport.project.ui.ModuleActions;
import org.netbeans.spi.java.project.support.ui.PackageView;
import org.netbeans.spi.project.ui.LogicalViewProvider;
import org.netbeans.spi.project.ui.support.DefaultProjectOperations;
import org.netbeans.spi.project.ui.support.NodeFactorySupport;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;
import org.openide.util.lookup.Lookups;

public final class ModuleLogicalView
implements LogicalViewProvider {
    private final NbModuleProject project;

    public ModuleLogicalView(NbModuleProject nbModuleProject) {
        this.project = nbModuleProject;
    }

    public Node createLogicalView() {
        return new RootNode(this.project);
    }

    public Node findPath(Node node, Object object) {
        DataObject dataObject;
        if (node.getLookup().lookup(NbModuleProject.class) != this.project) {
            return null;
        }
        Node[] nodeArray = node.getChildren().getNodes(true);
        if (object instanceof FileObject) {
            try {
                dataObject = DataObject.find((FileObject)((FileObject)object));
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                throw new AssertionError((Object)dataObjectNotFoundException);
            }
        } else if (object instanceof DataObject) {
            dataObject = (DataObject)object;
        } else {
            return null;
        }
        for (int i = 0; i < nodeArray.length; ++i) {
            Node node2 = PackageView.findPath((Node)nodeArray[i], (Object)object);
            if (node2 != null) {
                return node2;
            }
            if (!nodeArray[i].getName().equals("important.files")) continue;
            Node[] nodeArray2 = nodeArray[i].getChildren().getNodes(true);
            for (int j = 0; j < nodeArray2.length; ++j) {
                if (nodeArray2[j].getCookie(DataObject.class) != dataObject) continue;
                return nodeArray2[j];
            }
        }
        return null;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class RootNode
    extends AnnotatedNode {
        private final NbModuleProject project;

        public RootNode(NbModuleProject nbModuleProject) {
            super(NodeFactorySupport.createCompositeChildren((Project)nbModuleProject, (String)"Projects/org-netbeans-modules-apisupport-project/Nodes"), Lookups.fixed((Object[])new Object[]{nbModuleProject}));
            this.project = nbModuleProject;
            this.setForceAnnotation(true);
            this.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/resources/module.png");
            ProjectInformation projectInformation = ProjectUtils.getInformation((Project)nbModuleProject);
            this.setDisplayName(projectInformation.getDisplayName());
            this.setShortDescription(NbBundle.getMessage(ModuleLogicalView.class, (String)"HINT_project_root_node", (Object)FileUtil.getFileDisplayName((FileObject)nbModuleProject.getProjectDirectory())));
            this.setFiles(this.getProjectFiles());
            projectInformation.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                    if (propertyChangeEvent.getPropertyName() == "displayName") {
                        RootNode.this.setDisplayName((String)propertyChangeEvent.getNewValue());
                    } else if (propertyChangeEvent.getPropertyName() == "name") {
                        RootNode.this.setName((String)propertyChangeEvent.getNewValue());
                    }
                }
            });
        }

        private Set<FileObject> getProjectFiles() {
            HashSet<FileObject> hashSet = new HashSet<FileObject>();
            Sources sources = ProjectUtils.getSources((Project)this.project);
            SourceGroup[] sourceGroupArray = sources.getSourceGroups("generic");
            for (int i = 0; i < sourceGroupArray.length; ++i) {
                SourceGroup sourceGroup = sourceGroupArray[i];
                FileObject fileObject = sourceGroup.getRootFolder();
                if (fileObject == null) continue;
                FileObject[] fileObjectArray = fileObject.getChildren();
                for (int j = 0; j < fileObjectArray.length; ++j) {
                    FileObject fileObject2 = fileObjectArray[j];
                    if (!sourceGroup.contains(fileObject2)) continue;
                    hashSet.add(fileObject2);
                }
            }
            return hashSet;
        }

        public Action[] getActions(boolean bl) {
            return ModuleActions.getProjectActions(this.project);
        }

        public Image getIcon(int n) {
            return this.annotateIcon(super.getIcon(n), n);
        }

        public Image getOpenedIcon(int n) {
            return this.getIcon(n);
        }

        public boolean canRename() {
            return true;
        }

        public String getName() {
            return ProjectUtils.getInformation((Project)this.project).getDisplayName();
        }

        public void setName(String string) {
            DefaultProjectOperations.performDefaultRenameOperation((Project)this.project, (String)string);
        }
    }
}

