/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.suite;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.BasicBrandingModel;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteCustomizerLibraries;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteProperties;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.ModuleList;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Mutex;
import org.openide.util.MutexException;

public class SuiteProjectGenerator {
    private static final String PLATFORM_PROPERTIES_PATH = "nbproject/platform.properties";
    public static final String PROJECT_PROPERTIES_PATH = "nbproject/project.properties";
    public static final String PRIVATE_PROPERTIES_PATH = "nbproject/private/private.properties";

    private SuiteProjectGenerator() {
    }

    public static void createSuiteProject(final File file, final String string, final boolean bl) throws IOException {
        try {
            ProjectManager.mutex().writeAccess((Mutex.ExceptionAction)new Mutex.ExceptionAction<Void>(){

                public Void run() throws IOException {
                    FileObject fileObject = FileUtil.createFolder((File)file);
                    if (ProjectManager.getDefault().findProject(fileObject) != null) {
                        throw new IllegalArgumentException("Already a project in " + fileObject);
                    }
                    SuiteProjectGenerator.createSuiteProjectXML(fileObject);
                    SuiteProjectGenerator.createPlatformProperties(fileObject, string);
                    SuiteProjectGenerator.createProjectProperties(fileObject);
                    ModuleList.refresh();
                    ProjectManager.getDefault().clearNonProjectCache();
                    if (bl) {
                        SuiteProjectGenerator.initApplication(fileObject, string);
                    }
                    return null;
                }
            });
        }
        catch (MutexException mutexException) {
            throw (IOException)mutexException.getException();
        }
    }

    private static void createSuiteProjectXML(FileObject fileObject) throws IOException {
        ProjectXMLManager.generateEmptySuiteTemplate(SuiteProjectGenerator.createFileObject(fileObject, "nbproject/project.xml"), fileObject.getNameExt());
    }

    private static void createPlatformProperties(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = SuiteProjectGenerator.createFileObject(fileObject, PLATFORM_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("nbplatform.active", string);
        SuiteProjectGenerator.storeProperties(fileObject2, editableProperties);
    }

    private static void createProjectProperties(FileObject fileObject) throws IOException {
        FileObject fileObject2 = SuiteProjectGenerator.createFileObject(fileObject, PROJECT_PROPERTIES_PATH);
        EditableProperties editableProperties = new EditableProperties(true);
        editableProperties.setProperty("modules", "");
        SuiteProjectGenerator.storeProperties(fileObject2, editableProperties);
    }

    private static void initApplication(FileObject fileObject, String string) throws IOException {
        ModuleEntry moduleEntry;
        SuiteProject suiteProject = (SuiteProject)ProjectManager.getDefault().findProject(fileObject);
        SuiteProperties suiteProperties = new SuiteProperties(suiteProject, suiteProject.getHelper(), suiteProject.getEvaluator(), Collections.<NbModuleProject>emptySet());
        BasicBrandingModel basicBrandingModel = suiteProperties.getBrandingModel();
        basicBrandingModel.setBrandingEnabled(true);
        basicBrandingModel.setName(basicBrandingModel.getName());
        basicBrandingModel.setTitle(basicBrandingModel.getTitle());
        basicBrandingModel.store();
        NbPlatform nbPlatform = NbPlatform.getPlatformByID(string);
        if (nbPlatform != null && (moduleEntry = nbPlatform.getModule("org.netbeans.bootstrap")) != null) {
            suiteProperties.setEnabledClusters(new String[]{moduleEntry.getClusterDirectory().getName()});
        }
        suiteProperties.setDisabledModules(SuiteCustomizerLibraries.DISABLED_PLATFORM_MODULES.toArray(new String[0]));
        suiteProperties.storeProperties();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(FileObject fileObject, EditableProperties editableProperties) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableProperties.store(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    private static FileObject createFileObject(FileObject fileObject, String string) throws IOException {
        FileObject fileObject2 = fileObject.getFileObject(string);
        if (fileObject2 != null) {
            throw new IllegalArgumentException("File " + fileObject2 + " already exists.");
        }
        fileObject2 = FileUtil.createData((FileObject)fileObject, (String)string);
        return fileObject2;
    }
}

