/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.io.IOException;
import java.net.URI;
import java.net.URL;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.actions.CookieAction;

public class PickNameAction
extends CookieAction {
    private static FileObject findFile(Node[] nodeArray) {
        return ((DataObject)nodeArray[0].getCookie(DataObject.class)).getPrimaryFile();
    }

    private static NbModuleProvider findProject(FileObject fileObject) {
        URL uRL = (URL)fileObject.getAttribute("WritableXMLFileSystem.location");
        if (uRL == null) {
            return null;
        }
        Project project = FileOwnerQuery.getOwner((URI)URI.create(uRL.toExternalForm()));
        assert (project != null) : uRL;
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        assert (nbModuleProvider != null) : uRL;
        return nbModuleProvider;
    }

    private static String findBundlePath(NbModuleProvider nbModuleProvider) {
        FileObject fileObject = nbModuleProvider.getSourceDirectory();
        ManifestManager manifestManager = ManifestManager.getInstance(Util.getManifest(nbModuleProvider.getManifestFile()), false);
        String string = manifestManager.getLocalizingBundle();
        if (string != null && string.endsWith(".properties") && fileObject.getFileObject(string) != null) {
            return string;
        }
        return null;
    }

    protected void performAction(Node[] nodeArray) {
        NotifyDescriptor.InputLine inputLine = new NotifyDescriptor.InputLine(NbBundle.getMessage(PickNameAction.class, (String)"PickNameAction_dialog_label"), NbBundle.getMessage(PickNameAction.class, (String)"PickNameAction_dialog_title"));
        if (DialogDisplayer.getDefault().notify((NotifyDescriptor)inputLine) != NotifyDescriptor.OK_OPTION) {
            return;
        }
        String string = inputLine.getInputText();
        FileObject fileObject = PickNameAction.findFile(nodeArray);
        NbModuleProvider nbModuleProvider = PickNameAction.findProject(fileObject);
        String string2 = PickNameAction.findBundlePath(nbModuleProvider);
        try {
            FileObject fileObject2 = nbModuleProvider.getSourceDirectory().getFileObject(string2);
            EditableProperties editableProperties = Util.loadProperties(fileObject2);
            editableProperties.setProperty(fileObject.getPath(), string);
            Util.storeProperties(fileObject2, editableProperties);
            fileObject.setAttribute("SystemFileSystem.localizingBundle", (Object)string2.substring(0, string2.length() - ".properties".length()).replace('/', '.'));
        }
        catch (IOException iOException) {
            Util.err.notify(1, (Throwable)iOException);
        }
    }

    protected boolean enable(Node[] nodeArray) {
        if (!super.enable(nodeArray)) {
            return false;
        }
        FileObject fileObject = PickNameAction.findFile(nodeArray);
        if (fileObject == null) {
            return false;
        }
        NbModuleProvider nbModuleProvider = PickNameAction.findProject(fileObject);
        if (nbModuleProvider == null) {
            return false;
        }
        return PickNameAction.findBundlePath(nbModuleProvider) != null;
    }

    public String getName() {
        return NbBundle.getMessage(PickIconAction.class, (String)"LBL_pick_name");
    }

    protected Class[] cookieClasses() {
        return new Class[]{DataObject.class};
    }

    protected int mode() {
        return 8;
    }

    public HelpCtx getHelpCtx() {
        return null;
    }

    protected boolean asynchronous() {
        return false;
    }
}

