/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project.layers;

import java.awt.Image;
import java.io.CharConversionException;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.Util;
import org.netbeans.modules.apisupport.project.layers.BadgingSupport;
import org.netbeans.modules.apisupport.project.layers.LayerUtils;
import org.netbeans.modules.apisupport.project.layers.OpenLayerFilesAction;
import org.netbeans.modules.apisupport.project.layers.PickIconAction;
import org.netbeans.modules.apisupport.project.layers.PickNameAction;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.suite.SuiteProject;
import org.netbeans.modules.apisupport.project.ui.customizer.SuiteUtils;
import org.openide.filesystems.FileAttributeEvent;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileRenameEvent;
import org.openide.filesystems.FileStatusEvent;
import org.openide.filesystems.FileStatusListener;
import org.openide.filesystems.FileSystem;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.MultiFileSystem;
import org.openide.loaders.DataNode;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.loaders.Environment;
import org.openide.nodes.AbstractNode;
import org.openide.nodes.Children;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.util.actions.SystemAction;
import org.openide.util.lookup.Lookups;
import org.openide.xml.XMLUtil;

public final class LayerNode
extends FilterNode
implements Node.Cookie {
    private final boolean specialDisplayName;

    public LayerNode(LayerUtils.LayerHandle layerHandle) {
        this(LayerNode.getDataNode(layerHandle), layerHandle, true);
    }

    private LayerNode(Node node, LayerUtils.LayerHandle layerHandle, boolean bl) {
        super(node, (Children)new LayerChildren(layerHandle));
        this.specialDisplayName = bl;
    }

    private static Node getDataNode(LayerUtils.LayerHandle layerHandle) {
        FileObject fileObject = layerHandle.getLayerFile();
        try {
            return DataObject.find((FileObject)fileObject).getNodeDelegate();
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            assert (false) : dataObjectNotFoundException;
            return Node.EMPTY;
        }
    }

    public static Environment.Provider createProvider() {
        class EP
        implements Environment.Provider {
            EP() {
            }

            public Lookup getEnvironment(DataObject dataObject) {
                DataNode dataNode = new DataNode(dataObject, FilterNode.Children.LEAF);
                dataNode.setIconBaseWithExtension("org/netbeans/modules/apisupport/project/ui/resources/layerObject.gif");
                LayerNode layerNode = new LayerNode((Node)dataNode, new LayerUtils.LayerHandle(null, dataObject.getPrimaryFile()), false);
                return Lookups.singleton((Object)((Object)layerNode));
            }
        }
        return new EP();
    }

    private static FileSystem badge(final FileSystem fileSystem, final ClassPath classPath, final FileObject fileObject, final String string, final FileSystem fileSystem2) {
        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        class BadgingMergedFileSystem
        extends MultiFileSystem {
            private final BadgingSupport status;

            public BadgingMergedFileSystem() {
                super(new FileSystem[]{fileSystem3});
                this.status = new BadgingSupport((FileSystem)this);
                this.status.addFileStatusListener(new FileStatusListener(){

                    public void annotationChanged(FileStatusEvent fileStatusEvent) {
                        this.fireFileStatusChanged(fileStatusEvent);
                    }
                });
                this.status.setClasspath(classPath);
                this.addFileChangeListener(new FileChangeListener(){

                    private void fire() {
                        this.fireFileStatusChanged(new FileStatusEvent((FileSystem)this, true, true));
                    }

                    public void fileAttributeChanged(FileAttributeEvent fileAttributeEvent) {
                        this.fire();
                    }

                    public void fileChanged(FileEvent fileEvent) {
                        this.fire();
                    }

                    public void fileDataCreated(FileEvent fileEvent) {
                        this.fire();
                    }

                    public void fileDeleted(FileEvent fileEvent) {
                        this.fire();
                    }

                    public void fileFolderCreated(FileEvent fileEvent) {
                        this.fire();
                    }

                    public void fileRenamed(FileRenameEvent fileRenameEvent) {
                        this.fire();
                    }
                });
            }

            public FileSystem.Status getStatus() {
                return new FileSystem.HtmlStatus(){

                    public String annotateNameHtml(String string, Set set) {
                        String string2;
                        String string3 = status.annotateName(string, set);
                        if (set.size() == 1 && ((FileObject)set.iterator().next()).isRoot()) {
                            string3 = string;
                        }
                        try {
                            string2 = XMLUtil.toElementContent((String)string3);
                        }
                        catch (CharConversionException charConversionException) {
                            Util.err.notify(1, (Throwable)charConversionException);
                            string2 = string3;
                        }
                        if (fileSystem2 != null) {
                            boolean bl = false;
                            for (FileObject fileObject : set) {
                                if (fileObject.isRoot() || fileSystem2.findResource(fileObject.getPath()) == null) continue;
                                bl = true;
                                break;
                            }
                            if (bl) {
                                string2 = "<b>" + string2 + "</b>";
                            }
                        }
                        return string2;
                    }

                    public String annotateName(String string, Set set) {
                        return string;
                    }

                    public Image annotateIcon(Image image, int n, Set set) {
                        return status.annotateIcon(image, n, set);
                    }
                };
            }

            public String getDisplayName() {
                return FileUtil.getFileDisplayName((FileObject)fileObject);
            }

            public SystemAction[] getActions(Set<FileObject> set) {
                return new SystemAction[]{SystemAction.get(PickNameAction.class), SystemAction.get(PickIconAction.class), SystemAction.get(OpenLayerFilesAction.class)};
            }
        }
        return new BadgingMergedFileSystem();
    }

    public String getDisplayName() {
        if (this.specialDisplayName) {
            return NbBundle.getMessage(LayerNode.class, (String)"LayerNode_label");
        }
        return super.getDisplayName();
    }

    private static ClassPath createClasspath(Project project) throws IOException {
        NbModuleProvider.NbModuleType nbModuleType = Util.getModuleType(project);
        if (nbModuleType == NbModuleProvider.STANDALONE) {
            return LayerUtils.createLayerClasspath(Collections.singleton(project), LayerUtils.getPlatformJarsForStandaloneProject(project));
        }
        if (nbModuleType == NbModuleProvider.SUITE_COMPONENT) {
            SuiteProject suiteProject = SuiteUtils.findSuite(project);
            if (suiteProject == null) {
                throw new IOException("Could not load suite for " + project);
            }
            Set<NbModuleProject> set = SuiteUtils.getSubProjects(suiteProject);
            return LayerUtils.createLayerClasspath(set, LayerUtils.getPlatformJarsForSuiteComponentProject(project, suiteProject));
        }
        if (nbModuleType == NbModuleProvider.NETBEANS_ORG) {
            return LayerUtils.createLayerClasspath(LayerUtils.getProjectsForNetBeansOrgProject((NbModuleProject)project), Collections.<File>emptySet());
        }
        throw new AssertionError((Object)nbModuleType);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class LayerChildren
    extends Children.Keys<KeyType> {
        private final LayerUtils.LayerHandle handle;
        private ClassPath cp;
        private Project p;
        private FileSystem layerfs;
        private FileSystem sfs;

        public LayerChildren(LayerUtils.LayerHandle layerHandle) {
            this.handle = layerHandle;
        }

        protected void addNotify() {
            super.addNotify();
            this.handle.setAutosave(true);
            this.setKeys(Collections.singleton(KeyType.WAIT));
            RequestProcessor.getDefault().post(new Runnable(){

                public void run() {
                    try {
                        LayerUtils.LayerHandle layerHandle;
                        FileObject fileObject = LayerChildren.this.handle.getLayerFile();
                        LayerChildren.this.p = FileOwnerQuery.getOwner((FileObject)fileObject);
                        assert (LayerChildren.this.p != null) : fileObject;
                        try {
                            LayerChildren.this.cp = LayerNode.createClasspath(LayerChildren.this.p);
                        }
                        catch (IOException iOException) {
                            Util.err.notify(1, (Throwable)iOException);
                        }
                        LayerChildren.this.layerfs = LayerChildren.this.handle.layer(false);
                        LayerChildren.this.setKeys(Arrays.asList(KeyType.RAW, KeyType.WAIT));
                        Project project = FileOwnerQuery.getOwner((FileObject)LayerChildren.this.handle.getLayerFile());
                        boolean bl = false;
                        if (project != null && (layerHandle = LayerUtils.layerForProject(project)) != null && fileObject.equals(layerHandle.getLayerFile())) {
                            FileSystem fileSystem = LayerUtils.getEffectiveSystemFilesystem(project);
                            if (LayerChildren.this.cp != null) {
                                LayerChildren.this.sfs = fileSystem;
                                LayerChildren.this.setKeys(Arrays.asList(KeyType.RAW, KeyType.CONTEXTUALIZED));
                                bl = true;
                            }
                        }
                        if (!bl) {
                            LayerChildren.this.setKeys(Collections.singleton(KeyType.RAW));
                        }
                    }
                    catch (IOException iOException) {
                        Util.err.notify(1, (Throwable)iOException);
                    }
                }
            });
        }

        protected void removeNotify() {
            this.setKeys(Collections.emptySet());
            this.cp = null;
            this.p = null;
            this.layerfs = null;
            this.sfs = null;
            super.removeNotify();
        }

        protected Node[] createNodes(KeyType keyType) {
            try {
                switch (keyType) {
                    case RAW: {
                        FileSystem fileSystem = LayerNode.badge(this.layerfs, this.cp, this.handle.getLayerFile(), NbBundle.getMessage(LayerNode.class, (String)"LBL_this_layer"), null);
                        return new Node[]{DataObject.find((FileObject)fileSystem.getRoot()).getNodeDelegate()};
                    }
                    case CONTEXTUALIZED: {
                        FileSystem fileSystem = LayerNode.badge(this.sfs, this.cp, this.handle.getLayerFile(), NbBundle.getMessage(LayerNode.class, (String)"LBL_this_layer_in_context"), this.handle.layer(false));
                        return new Node[]{DataObject.find((FileObject)fileSystem.getRoot()).getNodeDelegate()};
                    }
                    case WAIT: {
                        return new Node[]{new AbstractNode(FilterNode.Children.LEAF){

                            public String getDisplayName() {
                                return NbBundle.getMessage(LayerNode.class, (String)"LayerNode_please_wait");
                            }
                        }};
                    }
                }
                throw new AssertionError((Object)keyType);
            }
            catch (IOException iOException) {
                Util.err.notify(1, (Throwable)iOException);
                return new Node[0];
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum KeyType {
            WAIT,
            RAW,
            CONTEXTUALIZED;

        }
    }
}

