/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.apisupport.project;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeSet;
import java.util.jar.JarFile;
import java.util.jar.Manifest;
import java.util.zip.ZipEntry;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.project.Sources;
import org.netbeans.api.queries.VisibilityQuery;
import org.netbeans.modules.apisupport.project.EditableManifest;
import org.netbeans.modules.apisupport.project.ManifestManager;
import org.netbeans.modules.apisupport.project.NbModuleProject;
import org.netbeans.modules.apisupport.project.ProjectXMLManager;
import org.netbeans.modules.apisupport.project.spi.NbModuleProvider;
import org.netbeans.modules.apisupport.project.ui.customizer.ModuleDependency;
import org.netbeans.modules.apisupport.project.universe.LocalizedBundleInfo;
import org.netbeans.modules.apisupport.project.universe.ModuleEntry;
import org.netbeans.modules.apisupport.project.universe.NbPlatform;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.PropertyProvider;
import org.netbeans.spi.project.support.ant.PropertyUtils;
import org.openide.ErrorManager;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.modules.SpecificationVersion;
import org.openide.util.ChangeSupport;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Util {
    public static final ErrorManager err = ErrorManager.getDefault().getInstance("org.netbeans.modules.apisupport.project");
    private static final String SFS_VALID_PATH_RE = "(\\p{Alnum}|\\/|_)+";

    private Util() {
    }

    public static Element findElement(Element element, String string, String string2) {
        Element element2 = null;
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 1) continue;
            Element element3 = (Element)nodeList.item(i);
            if ((string2 != null || !string.equals(element3.getTagName())) && (string2 == null || !string.equals(element3.getLocalName()) || !string2.equals(element3.getNamespaceURI()))) continue;
            if (element2 == null) {
                element2 = element3;
                continue;
            }
            return null;
        }
        return element2;
    }

    public static String findText(Element element) {
        NodeList nodeList = element.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            if (nodeList.item(i).getNodeType() != 3) continue;
            Text text = (Text)nodeList.item(i);
            return text.getNodeValue();
        }
        return null;
    }

    public static List<Element> findSubElements(Element element) throws IllegalArgumentException {
        NodeList nodeList = element.getChildNodes();
        ArrayList<Element> arrayList = new ArrayList<Element>(nodeList.getLength());
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                arrayList.add((Element)node);
                continue;
            }
            if (node.getNodeType() == 3) {
                String string = ((Text)node).getNodeValue();
                if (string.trim().length() <= 0) continue;
                throw new IllegalArgumentException("non-ws text encountered in " + element + ": " + string);
            }
            if (node.getNodeType() == 8) continue;
            throw new IllegalArgumentException("unexpected non-element child of " + element + ": " + node);
        }
        return arrayList;
    }

    public static Element translateXML(Element element, String string) {
        Node node;
        Element element2 = element.getOwnerDocument().createElementNS(string, element.getLocalName());
        NodeList nodeList = element.getChildNodes();
        int n = nodeList.getLength();
        for (int i = 0; i < n; ++i) {
            Node node2 = nodeList.item(i);
            node = node2.getNodeType() == 1 ? Util.translateXML((Element)node2, string) : node2.cloneNode(true);
            element2.appendChild(node);
        }
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            node = namedNodeMap.item(i);
            element2.setAttribute(node.getNodeName(), node.getNodeValue());
        }
        return element2;
    }

    public static String getDisplayName(FileObject fileObject) {
        if (fileObject.isFolder()) {
            try {
                Project project = ProjectManager.getDefault().findProject(fileObject);
                if (project != null) {
                    return ProjectUtils.getInformation((Project)project).getDisplayName();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return FileUtil.getFileDisplayName((FileObject)fileObject);
    }

    public static String normalizeCNB(String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string.toLowerCase(Locale.ENGLISH), ".", true);
        StringBuffer stringBuffer = new StringBuffer();
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (!bl) {
                if (string2.equals(".")) continue;
                for (int i = 0; i < string2.length(); ++i) {
                    char c = string2.charAt(i);
                    if (i == 0 ? !Character.isJavaIdentifierStart(c) : !Character.isJavaIdentifierPart(c)) continue;
                    stringBuffer.append(c);
                }
            } else if (string2.equals(".")) {
                stringBuffer.append(string2);
            }
            bl = !bl;
        }
        return stringBuffer.toString().replaceAll("\\.$", "");
    }

    public static boolean isValidJavaFQN(String string) {
        if (string.length() == 0) {
            return false;
        }
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".", true);
        boolean bl = false;
        while (stringTokenizer.hasMoreTokens()) {
            String string2 = stringTokenizer.nextToken();
            if (bl ^ string2.equals(".")) {
                return false;
            }
            if (!bl && !Utilities.isJavaIdentifier((String)string2)) {
                return false;
            }
            bl = !bl;
        }
        return bl;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(FileObject fileObject, Manifest manifest) {
        String string = ManifestManager.getInstance(manifest, false).getLocalizingBundle();
        try {
            if (string != null) {
                ArrayList<FileObject> arrayList = new ArrayList<FileObject>();
                Iterator iterator = Util.getPossibleResources(string);
                while (iterator.hasNext()) {
                    String string2 = (String)iterator.next();
                    FileObject fileObject2 = fileObject.getFileObject(string2);
                    if (fileObject2 == null) continue;
                    arrayList.add(fileObject2);
                }
                if (!arrayList.isEmpty()) {
                    Collections.reverse(arrayList);
                    return LocalizedBundleInfo.load(arrayList.toArray(new FileObject[arrayList.size()]));
                }
            }
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
        }
        return null;
    }

    public static LocalizedBundleInfo findLocalizedBundleInfo(File file) {
        NbModuleProject nbModuleProject;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return null;
        }
        try {
            nbModuleProject = (NbModuleProject)ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IOException iOException) {
            return null;
        }
        if (nbModuleProject == null) {
            return null;
        }
        String string = nbModuleProject.evaluator().getProperty("src.dir");
        assert (string != null) : "Cannot evaluate src.dir property for " + nbModuleProject;
        File file2 = FileUtil.normalizeFile((File)new File(file, string));
        FileObject fileObject2 = FileUtil.toFileObject((File)file2);
        FileObject fileObject3 = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(file, "manifest.mf")));
        LocalizedBundleInfo localizedBundleInfo = null;
        Manifest manifest = Util.getManifest(fileObject3);
        if (fileObject2 != null && manifest != null) {
            localizedBundleInfo = Util.findLocalizedBundleInfo(fileObject2, manifest);
        }
        return localizedBundleInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static LocalizedBundleInfo findLocalizedBundleInfoFromJAR(File file) {
        try {
            JarFile jarFile = new JarFile(file);
            try {
                Manifest manifest = jarFile.getManifest();
                String string = ManifestManager.getInstance(manifest, false).getLocalizingBundle();
                if (string == null) return null;
                ArrayList<InputStream> arrayList = new ArrayList<InputStream>();
                ArrayList<JarFile> arrayList2 = new ArrayList<JarFile>();
                try {
                    Object object;
                    int n;
                    Iterator iterator = file.getName();
                    int n2 = ((String)((Object)iterator)).lastIndexOf(46);
                    if (n2 == -1) {
                        n = ((String)((Object)iterator)).length();
                    }
                    String string2 = ((String)((Object)iterator)).substring(0, n);
                    String string3 = ((String)((Object)iterator)).substring(n);
                    Iterator iterator2 = NbBundle.getLocalizingSuffixes();
                    while (iterator2.hasNext()) {
                        object = (String)iterator2.next();
                        File file2 = new File(file.getParentFile(), "locale" + File.separatorChar + string2 + (String)object + string3);
                        if (!file2.isFile()) continue;
                        JarFile jarFile2 = new JarFile(file2);
                        arrayList2.add(jarFile2);
                        Util.addBundlesFromJar(jarFile2, arrayList, string);
                    }
                    Util.addBundlesFromJar(jarFile, arrayList, string);
                    if (!arrayList.isEmpty()) {
                        Collections.reverse(arrayList);
                        object = LocalizedBundleInfo.load(arrayList.toArray(new InputStream[arrayList.size()]));
                        return object;
                    }
                }
                finally {
                    for (InputStream inputStream : arrayList) {
                        inputStream.close();
                    }
                    for (JarFile jarFile3 : arrayList2) {
                        jarFile3.close();
                    }
                }
            }
            finally {
                jarFile.close();
            }
        }
        catch (IOException iOException) {
            err.notify(1, (Throwable)iOException);
        }
        return null;
    }

    private static void addBundlesFromJar(JarFile jarFile, List<InputStream> list, String string) throws IOException {
        Iterator iterator = Util.getPossibleResources(string);
        while (iterator.hasNext()) {
            String string2 = (String)iterator.next();
            ZipEntry zipEntry = jarFile.getEntry(string2);
            if (zipEntry == null) continue;
            InputStream inputStream = jarFile.getInputStream(zipEntry);
            list.add(inputStream);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableProperties loadProperties(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        EditableProperties editableProperties = new EditableProperties(true);
        try {
            editableProperties.load(inputStream);
        }
        finally {
            inputStream.close();
        }
        return editableProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeProperties(FileObject fileObject, EditableProperties editableProperties) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableProperties.store(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static EditableManifest loadManifest(FileObject fileObject) throws IOException {
        InputStream inputStream = fileObject.getInputStream();
        try {
            EditableManifest editableManifest = new EditableManifest(inputStream);
            return editableManifest;
        }
        finally {
            inputStream.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void storeManifest(FileObject fileObject, EditableManifest editableManifest) throws IOException {
        FileLock fileLock = fileObject.lock();
        try {
            OutputStream outputStream = fileObject.getOutputStream(fileLock);
            try {
                editableManifest.write(outputStream);
            }
            finally {
                outputStream.close();
            }
        }
        finally {
            fileLock.releaseLock();
        }
    }

    public static URL findJavadocForNetBeansOrgModules(ModuleDependency moduleDependency) {
        ModuleEntry moduleEntry = moduleDependency.getModuleEntry();
        File file = moduleEntry.getDestDir();
        File file2 = null;
        if (file.getParent() != null) {
            file2 = file.getParentFile().getParentFile();
        }
        if (file2 == null) {
            throw new IllegalArgumentException("ModuleDependency " + moduleDependency + " doesn't represent nb.org module");
        }
        File file3 = new File(file2, "nbbuild/build/javadoc");
        URL[] uRLArray = null;
        if (file3.exists()) {
            File[] fileArray = file3.listFiles();
            uRLArray = new URL[fileArray.length];
            for (int i = 0; i < fileArray.length; ++i) {
                uRLArray[i] = FileUtil.urlForArchiveOrDir((File)fileArray[i]);
            }
        }
        return uRLArray == null ? null : Util.findJavadocURL(moduleDependency.getModuleEntry().getCodeNameBase().replace('.', '-'), uRLArray);
    }

    public static URL findJavadoc(ModuleDependency moduleDependency, NbPlatform nbPlatform) {
        String string = moduleDependency.getModuleEntry().getCodeNameBase().replace('.', '-');
        URL[] uRLArray = nbPlatform.getJavadocRoots();
        return uRLArray == null ? null : Util.findJavadocURL(string, uRLArray);
    }

    public static boolean isValidSFSPath(String string) {
        return string.matches(SFS_VALID_PATH_RE);
    }

    public static boolean addDependency(NbModuleProject nbModuleProject, NbModuleProject nbModuleProject2) throws IOException {
        return Util.addDependency(nbModuleProject, nbModuleProject2.getCodeNameBase());
    }

    public static boolean addDependency(NbModuleProject nbModuleProject, String string) throws IOException {
        return Util.addDependency(nbModuleProject, string, null, null, true);
    }

    public static boolean addDependency(NbModuleProject nbModuleProject, String string, String string2, SpecificationVersion specificationVersion, boolean bl) throws IOException {
        ModuleEntry moduleEntry = nbModuleProject.getModuleList().getEntry(string);
        if (moduleEntry == null) {
            err.log(1, "Trying to add " + string + " which cannot be found in the module's universe.");
            return false;
        }
        ProjectXMLManager projectXMLManager = new ProjectXMLManager(nbModuleProject);
        SortedSet<ModuleDependency> sortedSet = projectXMLManager.getDirectDependencies();
        for (ModuleDependency moduleDependency : sortedSet) {
            if (!string.equals(moduleDependency.getModuleEntry().getCodeNameBase())) continue;
            err.log(1, string + " already added");
            return false;
        }
        ModuleDependency moduleDependency = new ModuleDependency(moduleEntry, string2 == null ? moduleEntry.getReleaseVersion() : string2, specificationVersion == null ? moduleEntry.getSpecificationVersion() : specificationVersion.toString(), bl, false);
        projectXMLManager.addDependency(moduleDependency);
        return true;
    }

    private static URL findJavadocURL(String string, URL[] uRLArray) {
        URL uRL = null;
        for (int i = 0; i < uRLArray.length; ++i) {
            URL uRL2 = uRLArray[i];
            try {
                uRL = Util.normalizeURL(new URL(uRL2, string + "/index.html"));
                if (uRL == null && uRL2.toExternalForm().indexOf(string) != -1) {
                    uRL = Util.normalizeURL(new URL(uRL2, "index.html"));
                }
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
            if (uRL != null) break;
        }
        return uRL;
    }

    private static URL normalizeURL(URL uRL) {
        return URLMapper.findFileObject((URL)uRL) == null ? null : uRL;
    }

    private static Iterator getPossibleResources(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(46);
        if (n != -1 && n > string.lastIndexOf(47)) {
            string3 = string.substring(0, n);
            string2 = string.substring(n);
        } else {
            string3 = string;
            string2 = "";
        }
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        Iterator iterator = NbBundle.getLocalizingSuffixes();
        while (iterator.hasNext()) {
            String string4 = (String)iterator.next();
            String string5 = string3 + string4 + string2;
            linkedHashSet.add(string5);
            linkedHashSet.add(string5);
        }
        return linkedHashSet.iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Manifest getManifest(FileObject fileObject) {
        if (fileObject != null) {
            Manifest manifest;
            InputStream inputStream = fileObject.getInputStream();
            try {
                manifest = new Manifest(inputStream);
            }
            catch (Throwable throwable) {
                try {
                    inputStream.close();
                    throw throwable;
                }
                catch (IOException iOException) {
                    err.notify(1, (Throwable)iOException);
                }
            }
            inputStream.close();
            return manifest;
        }
        return null;
    }

    public static Comparator<Project> projectDisplayNameComparator() {
        return new Comparator<Project>(){
            private final Collator LOC_COLLATOR = Collator.getInstance();

            @Override
            public int compare(Project project, Project project2) {
                ProjectInformation projectInformation = ProjectUtils.getInformation((Project)project);
                ProjectInformation projectInformation2 = ProjectUtils.getInformation((Project)project2);
                int n = this.LOC_COLLATOR.compare(projectInformation.getDisplayName(), projectInformation2.getDisplayName());
                if (n != 0) {
                    return n;
                }
                n = projectInformation.getName().compareTo(projectInformation2.getName());
                if (n != 0) {
                    return n;
                }
                return System.identityHashCode(project) - System.identityHashCode(project2);
            }
        };
    }

    public static NbModuleProvider.NbModuleType getModuleType(Project project) {
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        assert (nbModuleProvider != null) : "has NbModuleProvider in the lookup";
        return nbModuleProvider.getModuleType();
    }

    public static SortedSet<String> scanProjectForPackageNames(File file) {
        String string;
        NbModuleProject nbModuleProject = null;
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject != null) {
            try {
                nbModuleProject = (NbModuleProject)ProjectManager.getDefault().findProject(fileObject);
            }
            catch (IOException iOException) {
                err.notify(1, (Throwable)iOException);
            }
        }
        if (nbModuleProject == null) {
            return new TreeSet<String>(Collections.emptySet());
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        FileObject fileObject2 = nbModuleProject.getSourceDirectory();
        Util.scanForPackages(hashSet, fileObject2, "java");
        for (FileObject fileObject3 : hashSet) {
            if (fileObject2.equals(fileObject3)) continue;
            string = PropertyUtils.relativizeFile((File)FileUtil.toFile((FileObject)fileObject2), (File)FileUtil.toFile((FileObject)fileObject3));
            treeSet.add(string.replace('/', '.'));
        }
        String[] stringArray = new ProjectXMLManager(nbModuleProject).getBinaryOrigins();
        for (int i = 0; i < stringArray.length; ++i) {
            Util.scanJarForPackageNames(treeSet, nbModuleProject.getHelper().resolveFile(stringArray[i]));
        }
        Iterator iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            string = (String)iterator.next();
            if (Util.isValidJavaFQN(string)) continue;
            iterator.remove();
        }
        return treeSet;
    }

    public static void scanJarForPackageNames(Set<String> set, File file) {
        FileObject fileObject = FileUtil.toFileObject((File)file);
        if (fileObject == null) {
            return;
        }
        FileObject fileObject2 = FileUtil.getArchiveRoot((FileObject)fileObject);
        if (fileObject2 == null) {
            return;
        }
        HashSet<FileObject> hashSet = new HashSet<FileObject>();
        Util.scanForPackages(hashSet, fileObject2, "class");
        for (FileObject fileObject3 : hashSet) {
            if (fileObject2.equals(fileObject3)) continue;
            String string = fileObject3.getPath();
            set.add(string.replace('/', '.'));
        }
    }

    private static void scanForPackages(Set<FileObject> set, FileObject fileObject, String string) {
        FileObject fileObject2;
        if (fileObject == null) {
            return;
        }
        Enumeration enumeration = fileObject.getFolders(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!VisibilityQuery.getDefault().isVisible(fileObject2)) continue;
            Util.scanForPackages(set, fileObject2, string);
        }
        enumeration = fileObject.getData(false);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!fileObject2.hasExt(string) || !Utilities.isJavaIdentifier((String)fileObject2.getName())) continue;
            set.add(fileObject);
            break;
        }
    }

    public static FileObject getResourceDirectory(Project project) {
        Sources sources = ProjectUtils.getSources((Project)project);
        SourceGroup[] sourceGroupArray = sources.getSourceGroups("resources");
        if (sourceGroupArray != null && sourceGroupArray.length > 0) {
            return sourceGroupArray[0].getRootFolder();
        }
        NbModuleProvider nbModuleProvider = (NbModuleProvider)project.getLookup().lookup(NbModuleProvider.class);
        assert (nbModuleProvider != null);
        return nbModuleProvider.getSourceDirectory();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class UserPropertiesFileProvider
    implements PropertyProvider,
    PropertyChangeListener,
    ChangeListener {
        private final PropertyEvaluator eval;
        private final File basedir;
        private final ChangeSupport changeSupport = new ChangeSupport((Object)this);
        private final ChangeListener listener = WeakListeners.change((ChangeListener)this, null);
        private PropertyProvider delegate;

        public UserPropertiesFileProvider(PropertyEvaluator propertyEvaluator, File file) {
            this.eval = propertyEvaluator;
            this.basedir = file;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
            this.computeDelegate();
        }

        private void computeDelegate() {
            String string;
            if (this.delegate != null) {
                this.delegate.removeChangeListener(this.listener);
            }
            this.delegate = (string = this.eval.getProperty("user.properties.file")) != null ? PropertyUtils.propertiesFilePropertyProvider((File)PropertyUtils.resolveFile((File)this.basedir, (String)string)) : PropertyUtils.globalPropertyProvider();
            this.delegate.addChangeListener(this.listener);
        }

        public Map<String, String> getProperties() {
            if (this.delegate != null) {
                return this.delegate.getProperties();
            }
            return Collections.emptyMap();
        }

        public void addChangeListener(ChangeListener changeListener) {
            this.changeSupport.addChangeListener(changeListener);
        }

        public void removeChangeListener(ChangeListener changeListener) {
            this.changeSupport.removeChangeListener(changeListener);
        }

        @Override
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string == null || string.equals("user.properties.file")) {
                this.computeDelegate();
                this.changeSupport.fireChange();
            }
        }

        @Override
        public void stateChanged(ChangeEvent changeEvent) {
            this.changeSupport.fireChange();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class ComputedPropertyProvider
    implements PropertyProvider,
    PropertyChangeListener {
        private final PropertyEvaluator eval;
        private final ChangeSupport cs = new ChangeSupport((Object)this);

        protected ComputedPropertyProvider(PropertyEvaluator propertyEvaluator) {
            this.eval = propertyEvaluator;
            propertyEvaluator.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)propertyEvaluator));
        }

        protected abstract Map<String, String> getProperties(Map<String, String> var1);

        protected abstract Set<String> inputProperties();

        public final Map<String, String> getProperties() {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            for (String string : this.inputProperties()) {
                hashMap.put(string, this.eval.getProperty(string));
            }
            return this.getProperties(hashMap);
        }

        public final void addChangeListener(ChangeListener changeListener) {
            this.cs.addChangeListener(changeListener);
        }

        public final void removeChangeListener(ChangeListener changeListener) {
            this.cs.removeChangeListener(changeListener);
        }

        @Override
        public final void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string != null && !this.inputProperties().contains(string)) {
                return;
            }
            this.cs.fireChange();
        }
    }
}

