/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.io.File;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.Map;
import java.util.Vector;
import javax.enterprise.deploy.shared.ActionType;
import javax.enterprise.deploy.shared.CommandType;
import javax.enterprise.deploy.shared.StateType;
import javax.enterprise.deploy.spi.TargetModuleID;
import javax.enterprise.deploy.spi.status.ClientConfiguration;
import javax.enterprise.deploy.spi.status.DeploymentStatus;
import javax.enterprise.deploy.spi.status.ProgressEvent;
import javax.enterprise.deploy.spi.status.ProgressListener;
import javax.enterprise.deploy.spi.status.ProgressObject;
import javax.swing.SwingUtilities;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.common.AttachSettings;
import org.netbeans.lib.profiler.common.Profiler;
import org.netbeans.lib.profiler.common.ProfilingSettings;
import org.netbeans.lib.profiler.common.SessionSettings;
import org.netbeans.lib.profiler.common.event.ProfilingStateEvent;
import org.netbeans.lib.profiler.common.event.ProfilingStateListener;
import org.netbeans.lib.profiler.common.integration.IntegrationUtils;
import org.netbeans.modules.j2ee.deployment.plugins.api.InstanceProperties;
import org.netbeans.modules.j2ee.deployment.profiler.api.ProfilerServerSettings;
import org.netbeans.modules.profiler.NetBeansProfiler;
import org.netbeans.modules.profiler.j2ee.J2EEProjectTypeProfiler;
import org.netbeans.modules.profiler.ui.ProfilerDialogs;
import org.netbeans.modules.profiler.utils.IDEUtils;
import org.netbeans.modules.profiler.utils.ProjectUtilities;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public class J2EEProfilerSPI
implements org.netbeans.modules.j2ee.deployment.profiler.spi.Profiler,
ProgressObject,
ProfilingStateListener {
    private static final String FAILED_DETERMINE_PLATFORM_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_FailedDeterminePlatformMsg");
    private static final String FAILED_LOAD_SETTINGS_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_FailedLoadSettingsMsg");
    private static final String DIRECT_ATTACH_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_DirectAttachMsg");
    private static final String STOPPING_SERVER_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppingServerMsg");
    private static final String STOPPED_SERVER_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppedServerMsg");
    private static final String STOPPING_SERVER_FAILED_MSG = NbBundle.getMessage(J2EEProfilerSPI.class, (String)"J2EEProfilerSPI_StoppingServerFailedMsg");
    private DeploymentStatus stopAgentStatus;
    private InstanceProperties lastServerInstanceProperties = null;
    private Vector listeners;
    private boolean profilerAgentShutdownProgress = false;
    private boolean profilerAgentStarting = false;
    private boolean refreshServerInstance = false;
    private boolean serverStartedFromIDE = false;
    private int STARTING_STATE_TIMEOUT = 20000;
    private int profilerAgentID = -111;
    private int profilerAgentPort = 0;
    private long profilerAgentStartingTime = -1L;

    public J2EEProfilerSPI() {
        String string;
        String string2 = System.getProperty("profiler.agent.startup.timeout");
        if (string2 != null && !"".equals(string2)) {
            try {
                int n;
                this.STARTING_STATE_TIMEOUT = n = new Integer(string2).intValue();
                ProfilerLogger.log((String)(">>> Profiler agent startup timeout redefined to " + this.STARTING_STATE_TIMEOUT + " ms"));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if ((string = System.getProperty("profiler.serverstate.refresh")) != null && "true".equals(string)) {
            this.refreshServerInstance = true;
            ProfilerLogger.log((String)">>> Profiler will update server instance after attaching to it and after stopping it.");
        }
        this.fireShutdownStartedEvent();
        if (this.refreshServerInstance) {
            Profiler.getDefault().addProfilingStateListener((ProfilingStateListener)this);
        }
    }

    public boolean isCancelSupported() {
        return false;
    }

    public ClientConfiguration getClientConfiguration(TargetModuleID targetModuleID) {
        return null;
    }

    public DeploymentStatus getDeploymentStatus() {
        return this.stopAgentStatus;
    }

    public boolean isProfiledServerStartedFromIDE() {
        return this.serverStartedFromIDE;
    }

    public TargetModuleID[] getResultTargetModuleIDs() {
        return null;
    }

    public ProfilerServerSettings getSettings(String string) {
        int n = J2EEProjectTypeProfiler.generateAgentID();
        int n2 = J2EEProjectTypeProfiler.generateAgentPort();
        JavaPlatform javaPlatform = J2EEProjectTypeProfiler.generateAgentJavaPlatform(string);
        if (javaPlatform == null) {
            this.lastServerInstanceProperties = null;
            return null;
        }
        String string2 = IDEUtils.getPlatformJDKVersion((JavaPlatform)javaPlatform);
        if (string2 == null) {
            Profiler.getDefault().displayError(MessageFormat.format(FAILED_DETERMINE_PLATFORM_MSG, javaPlatform.getDisplayName()));
            this.lastServerInstanceProperties = null;
            return null;
        }
        String string3 = IntegrationUtils.getLocalPlatform((int)IDEUtils.getPlatformArchitecture((JavaPlatform)javaPlatform));
        String[] stringArray = new String[2];
        String[] stringArray2 = new String[]{};
        stringArray[1] = "-Dnbprofiler.agentid=" + n;
        stringArray[0] = string2.equals("jdk15") ? IntegrationUtils.getProfilerAgentCommandLineArgs((String)string3, (String)IntegrationUtils.PLATFORM_JAVA_50, (boolean)false, (int)n2) : IntegrationUtils.getProfilerAgentCommandLineArgs((String)string3, (String)IntegrationUtils.PLATFORM_JAVA_60, (boolean)false, (int)n2);
        ProfilerServerSettings profilerServerSettings = new ProfilerServerSettings(javaPlatform, stringArray, stringArray2);
        if (ProfilerDialogs.notify((NotifyDescriptor)new NotifyDescriptor.Confirmation((Object)MessageFormat.format(DIRECT_ATTACH_MSG, javaPlatform.getDisplayName(), "" + n2), 2, 1)) != NotifyDescriptor.OK_OPTION) {
            this.lastServerInstanceProperties = null;
            return null;
        }
        Project project = ProjectUtilities.getMainProject();
        if (ProjectUtilities.isJavaProject((Project)project)) {
            AttachSettings attachSettings = null;
            try {
                NetBeansProfiler.getDefaultNB();
                attachSettings = NetBeansProfiler.loadAttachSettings((Project)project);
            }
            catch (IOException iOException) {
                Profiler.getDefault().displayWarning(MessageFormat.format(FAILED_LOAD_SETTINGS_MSG, iOException.getMessage()));
                ProfilerLogger.log((Exception)iOException);
            }
            if (attachSettings == null) {
                attachSettings = new AttachSettings();
                attachSettings.setRemote(false);
                attachSettings.setDirect(true);
                NetBeansProfiler.saveAttachSettings((Project)project, (AttachSettings)attachSettings);
            }
        }
        ProfilerLogger.log((String)">>> Generated settings for server startup - direct attach (blocking):");
        ProfilerLogger.log((String)profilerServerSettings.toString());
        this.lastServerInstanceProperties = InstanceProperties.getInstanceProperties((String)string);
        return profilerServerSettings;
    }

    public synchronized int getState() {
        int n = this.checkState();
        ProfilerLogger.log((String)(">>> Profiler agent [port=" + this.profilerAgentPort + ", id=" + this.profilerAgentID + "]: " + this.getPublicAgentStateString(n)));
        return n;
    }

    public boolean isStopSupported() {
        return false;
    }

    public synchronized void addProgressListener(ProgressListener progressListener) {
        boolean bl = false;
        if (this.listeners == null) {
            this.listeners = new Vector();
        }
        this.listeners.addElement(progressListener);
        if (this.stopAgentStatus != null && !this.stopAgentStatus.isRunning()) {
            bl = true;
        }
        if (bl) {
            IDEUtils.runInProfilerRequestProcessor((Runnable)new Runnable(){

                public void run() {
                    J2EEProfilerSPI.this.fireHandleProgressEvent(J2EEProfilerSPI.this.stopAgentStatus);
                }
            });
        }
    }

    public boolean attachProfiler(Map map) {
        return this.performProfilerAttach(map);
    }

    public void cancel() {
    }

    public void fireShutdownCompletedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPED_SERVER_MSG, StateType.COMPLETED));
    }

    public void fireShutdownFailedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPING_SERVER_FAILED_MSG, StateType.FAILED));
    }

    public void fireShutdownStartedEvent() {
        this.fireHandleProgressEvent(new StopAgentStatus(STOPPING_SERVER_MSG, StateType.RUNNING));
    }

    public void instrumentationChanged(int n, int n2) {
    }

    public void notifyStarting() {
        this.profilerAgentID = J2EEProjectTypeProfiler.getLastAgentID();
        this.profilerAgentPort = J2EEProjectTypeProfiler.getLastAgentPort();
        NetBeansProfiler.getDefaultNB().cleanForProfilingOnPort(this.profilerAgentPort);
        this.profilerAgentStartingTime = System.currentTimeMillis();
        this.profilerAgentStarting = true;
    }

    public void profilingStateChanged(ProfilingStateEvent profilingStateEvent) {
        if (profilingStateEvent.getNewState() == 4 && this.getState() == 4) {
            if (this.refreshServerInstance && this.lastServerInstanceProperties != null && Profiler.getDefault().getProfilingMode() == 0) {
                this.lastServerInstanceProperties.refreshServerInstance();
            }
            this.serverStartedFromIDE = true;
        }
        if (profilingStateEvent.getNewState() == 1) {
            if (this.refreshServerInstance && this.serverStartedFromIDE && this.lastServerInstanceProperties != null) {
                this.lastServerInstanceProperties.refreshServerInstance();
            }
            this.lastServerInstanceProperties = null;
            this.serverStartedFromIDE = false;
        }
    }

    public synchronized void removeProgressListener(ProgressListener progressListener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.removeElement(progressListener);
    }

    public ProgressObject shutdown() {
        if (this.profilerAgentShutdownProgress) {
            return this;
        }
        this.profilerAgentShutdownProgress = true;
        Runnable runnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                try {
                    J2EEProfilerSPI.this.fireShutdownStartedEvent();
                    if (J2EEProfilerSPI.this.getState() == 1) {
                        while (J2EEProfilerSPI.this.getState() == 1) {
                            try {
                                Thread.sleep(500L);
                            }
                            catch (Exception exception) {}
                        }
                    }
                    if (J2EEProfilerSPI.this.getState() == 2) {
                        Profiler.getDefault().shutdownBlockedAgent("localhost", J2EEProfilerSPI.this.profilerAgentPort, J2EEProfilerSPI.this.profilerAgentID);
                        for (int i = 0; i < 60; ++i) {
                            if (J2EEProfilerSPI.this.getState() == 0) {
                                J2EEProfilerSPI.this.fireShutdownCompletedEvent();
                                return;
                            }
                            try {
                                Thread.sleep(500L);
                                continue;
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        J2EEProfilerSPI.this.fireShutdownFailedEvent();
                    } else {
                        J2EEProfilerSPI.this.fireShutdownCompletedEvent();
                    }
                }
                finally {
                    J2EEProfilerSPI.this.profilerAgentShutdownProgress = false;
                }
            }
        };
        IDEUtils.runInProfilerRequestProcessor((Runnable)runnable);
        return this;
    }

    public void stop() {
    }

    public void threadsMonitoringChanged() {
    }

    private String getInternalAgentStateString(int n) {
        if (n == 0) {
            return "AGENT_STATE_NOT_RUNNING";
        }
        if (n == 1) {
            return "AGENT_STATE_READY_DYNAMIC";
        }
        if (n == 2) {
            return "AGENT_STATE_READY_DIRECT";
        }
        if (n == 3) {
            return "AGENT_STATE_CONNECTED";
        }
        if (n == 4) {
            return "AGENT_STATE_DIFFERENT_ID";
        }
        if (n == 5) {
            return "AGENT_STATE_OTHER_SESSION_IN_PROGRESS";
        }
        return "UNKNOWN AGENT STATE";
    }

    private String getProfilingStateString(int n) {
        if (n == 1) {
            return "PROFILING_INACTIVE";
        }
        if (n == 2) {
            return "PROFILING_STARTED";
        }
        if (n == 4) {
            return "PROFILING_RUNNING";
        }
        if (n == 8) {
            return "PROFILING_PAUSED";
        }
        if (n == 16) {
            return "PROFILING_STOPPED";
        }
        return "UNKNOWN PROFILER STATE";
    }

    private String getPublicAgentStateString(int n) {
        if (n == 0) {
            return "STATE_INACTIVE";
        }
        if (n == 1) {
            return "STATE_STARTING";
        }
        if (n == 2) {
            return "STATE_BLOCKING";
        }
        if (n == 3) {
            return "STATE_RUNNING";
        }
        if (n == 4) {
            return "STATE_PROFILING";
        }
        return "UNKNOWN AGENT STATE";
    }

    private int checkState() {
        int n = NetBeansProfiler.getDefault().getAgentState("localhost", this.profilerAgentPort, this.profilerAgentID);
        if (n == 5) {
            this.profilerAgentStarting = false;
            return 0;
        }
        if (n == 4) {
            this.profilerAgentStarting = false;
            return 0;
        }
        if (n == 0) {
            if (this.profilerAgentStarting) {
                if (System.currentTimeMillis() > this.profilerAgentStartingTime + (long)this.STARTING_STATE_TIMEOUT) {
                    this.profilerAgentStarting = false;
                    return 0;
                }
                return 1;
            }
            return 0;
        }
        if (n == 2) {
            this.profilerAgentStarting = false;
            return 2;
        }
        if (n == 1) {
            this.profilerAgentStarting = false;
            return 3;
        }
        if (n == 3) {
            this.profilerAgentStarting = false;
            return 4;
        }
        return 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireHandleProgressEvent(DeploymentStatus deploymentStatus) {
        ProgressEvent progressEvent = new ProgressEvent((Object)this, null, deploymentStatus);
        this.stopAgentStatus = deploymentStatus;
        Vector vector = null;
        J2EEProfilerSPI j2EEProfilerSPI = this;
        synchronized (j2EEProfilerSPI) {
            if (this.listeners != null) {
                vector = (Vector)this.listeners.clone();
            }
        }
        if (vector != null) {
            for (int i = 0; i < vector.size(); ++i) {
                ProgressListener progressListener = (ProgressListener)vector.elementAt(i);
                progressListener.handleProgressEvent(progressEvent);
            }
        }
    }

    private boolean performProfilerAttach(Map map) {
        FileObject fileObject;
        FileObject fileObject2 = null;
        String string = (String)map.get("profiler.info.project.dir");
        if (string != null && (fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)new File(string)))) != null) {
            try {
                fileObject2 = ProjectManager.getDefault().findProject(fileObject);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
                this.lastServerInstanceProperties = null;
                return false;
            }
        }
        fileObject = fileObject2;
        ProfilingSettings profilingSettings = new ProfilingSettings();
        SessionSettings sessionSettings = new SessionSettings();
        profilingSettings.load(map);
        sessionSettings.load(map);
        if (!J2EEProjectTypeProfiler.isSupportedProject((Project)fileObject)) {
            this.lastServerInstanceProperties = null;
            return false;
        }
        this.lastServerInstanceProperties = InstanceProperties.getInstanceProperties((String)J2EEProjectTypeProfiler.getServerInstanceID((Project)fileObject));
        SwingUtilities.invokeLater(new Runnable((Project)fileObject, profilingSettings, sessionSettings){
            final /* synthetic */ Project val$projectToUse;
            final /* synthetic */ ProfilingSettings val$ps;
            final /* synthetic */ SessionSettings val$ss;
            {
                this.val$projectToUse = project;
                this.val$ps = profilingSettings;
                this.val$ss = sessionSettings;
            }

            public void run() {
                ((NetBeansProfiler)Profiler.getDefault()).setProfiledProject(this.val$projectToUse, null);
                if (!Profiler.getDefault().connectToStartedApp(this.val$ps, this.val$ss)) {
                    ProfilerLogger.severe((String)"Error connecting to started app");
                }
            }
        });
        return true;
    }

    private class StopAgentStatus
    implements DeploymentStatus {
        private StateType state;
        private String message;

        public StopAgentStatus(String string, StateType stateType) {
            int n = string.lastIndexOf("Exception:");
            this.message = n > 0 ? string.substring(n + "Exception:".length()) : string;
            this.state = stateType;
        }

        public ActionType getAction() {
            return ActionType.EXECUTE;
        }

        public CommandType getCommand() {
            return CommandType.STOP;
        }

        public boolean isCompleted() {
            return this.state == StateType.COMPLETED;
        }

        public boolean isFailed() {
            return this.state == StateType.FAILED;
        }

        public String getMessage() {
            return this.message;
        }

        public boolean isRunning() {
            return this.state == StateType.RUNNING;
        }

        public StateType getState() {
            return this.state;
        }
    }
}

