/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.j2ee;

import java.awt.Component;
import java.awt.Container;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Set;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JSeparator;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.filechooser.FileFilter;
import org.jdesktop.layout.GroupLayout;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DirectorySelectorCombo
extends JPanel {
    private static final String SELECT_ACTION_STRING = NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo_SelectActionString");
    private static final String NONE_STRING = NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo_NoneString");
    private static final String ACTION_STRING = NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo_ActionString");
    private static final String DIALOG_CAPTION = NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo_DialogCaption");
    private static final String DIALOG_FILTER = NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo_DialogFilter");
    public static final String PROPERTY_SELECTEDPATH = "selectedPath";
    private Object lastSelectedObject = null;
    private Object propertyChangeTracker = null;
    private int lastKeypress = 0;
    private String actionText;
    private String welcomeText;
    private String noneText;
    private int itemCountLimit;
    private boolean showWelcome;
    private boolean validSelection;
    private String lastSelectedPath;
    private Set<String> supportedExtensions;
    private JComboBox fileMRU;

    public DirectorySelectorCombo() {
        this.initComponents();
        this.initCustom();
    }

    private void initComponents() {
        this.fileMRU = new JComboBox();
        this.fileMRU.setModel(new DefaultComboBoxModel<String>(new String[]{"Item 1", "Item 2", "Item 3", "Item 4"}));
        this.fileMRU.setRenderer(new SeparatedListCellRenderer());
        this.fileMRU.addPopupMenuListener(new PopupMenuListener(){

            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
            }

            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                DirectorySelectorCombo.this.fileMRUPopupMenuWillBecomeInvisible(popupMenuEvent);
            }

            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
                DirectorySelectorCombo.this.fileMRUPopupMenuWillBecomeVisible(popupMenuEvent);
            }
        });
        this.fileMRU.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DirectorySelectorCombo.this.fileMRUActionPerformed(actionEvent);
            }
        });
        this.fileMRU.addKeyListener(new KeyAdapter(){

            public void keyPressed(KeyEvent keyEvent) {
                DirectorySelectorCombo.this.fileMRUKeyPressed(keyEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout((Container)this);
        this.setLayout((LayoutManager)groupLayout);
        groupLayout.setHorizontalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileMRU, 0, 207, Short.MAX_VALUE));
        groupLayout.setVerticalGroup((GroupLayout.Group)groupLayout.createParallelGroup(1).add((Component)this.fileMRU, -2, -1, -2));
        this.fileMRU.getAccessibleContext().setAccessibleName(NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo.fileMRU.AccessibleContext.accessibleName"));
        this.fileMRU.getAccessibleContext().setAccessibleDescription(NbBundle.getMessage(DirectorySelectorCombo.class, (String)"DirectorySelectorCombo.fileMRU.AccessibleContext.accessibleDescription"));
    }

    private void fileMRUPopupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.fileMRU.getModel();
        LinkedList linkedList = new LinkedList();
        for (int i = 0; i < defaultComboBoxModel.getSize(); ++i) {
            if (!(defaultComboBoxModel.getElementAt(i) instanceof ComboListElement) || !((ComboListElement)defaultComboBoxModel.getElementAt(i)).isVolatile()) continue;
            linkedList.add(defaultComboBoxModel.getElementAt(i));
        }
        Iterator iterator = linkedList.iterator();
        while (iterator.hasNext()) {
            Object e = iterator.next();
            defaultComboBoxModel.removeElement(e);
            iterator.remove();
        }
    }

    private void fileMRUPopupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
        if (!(this.fileMRU.getSelectedItem() instanceof ComboListElement)) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                ((ComboListElement)DirectorySelectorCombo.this.fileMRU.getSelectedItem()).select();
            }
        });
    }

    private void fileMRUKeyPressed(KeyEvent keyEvent) {
        switch (keyEvent.getKeyCode()) {
            case 38: {
                this.lastKeypress = 1;
                break;
            }
            case 40: {
                this.lastKeypress = 2;
                break;
            }
            default: {
                this.lastKeypress = 0;
            }
        }
    }

    private void fileMRUActionPerformed(ActionEvent actionEvent) {
        if (this.fileMRU.getSelectedItem() == null) {
            return;
        }
        if (this.fileMRU.getSelectedItem() instanceof JSeparator) {
            int n = this.fileMRU.getSelectedIndex();
            if (this.lastKeypress == 1) {
                --n;
            } else if (this.lastKeypress == 2) {
                ++n;
            }
            if (n < 0) {
                n = this.fileMRU.getItemCount() - 1;
            } else if (n >= this.fileMRU.getItemCount()) {
                n = 0;
            }
            this.fileMRU.setSelectedIndex(n);
        }
    }

    private void initCustom() {
        this.showWelcome = true;
        this.welcomeText = SELECT_ACTION_STRING;
        this.noneText = NONE_STRING;
        this.actionText = ACTION_STRING;
        this.itemCountLimit = 2;
        this.supportedExtensions = new HashSet<String>();
    }

    private void changeModel() {
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.fileMRU.getModel();
        defaultComboBoxModel.removeAllElements();
        if (this.isShowWelcome()) {
            defaultComboBoxModel.addElement(new StringComboListElement(this.getWelcomeText(), true));
        }
        defaultComboBoxModel.addElement(new ComboListElement(this.getNoneText()){

            public void onSelection() {
                DirectorySelectorCombo.this.validSelection = false;
            }
        });
        JSeparator jSeparator = new JSeparator();
        defaultComboBoxModel.addElement(jSeparator);
        defaultComboBoxModel.addElement(new ComboListElement(this.getActionText()){

            public void onSelection() {
                DirectorySelectorCombo.this.validSelection = false;
                DirectorySelectorCombo.this.browseFiles();
            }
        });
    }

    private void browseFiles() {
        JFileChooser jFileChooser = new JFileChooser();
        jFileChooser.setFileSelectionMode(0);
        jFileChooser.setDialogType(0);
        jFileChooser.setDialogTitle(DIALOG_CAPTION);
        jFileChooser.setSelectedFile(new File(this.lastSelectedPath));
        jFileChooser.setFileFilter(new FileFilter(){

            public boolean accept(File file) {
                if (file.isDirectory()) {
                    return true;
                }
                String string = file.getAbsolutePath();
                String string2 = string.substring(string.lastIndexOf(46) + 1);
                return DirectorySelectorCombo.this.supportedExtensions.contains(string2);
            }

            public String getDescription() {
                return DIALOG_FILTER;
            }
        });
        int n = jFileChooser.showOpenDialog(this);
        if (n == 0) {
            File file = jFileChooser.getSelectedFile();
            ComboListElement comboListElement = this.addPath(file.getAbsolutePath());
            this.fileMRU.setSelectedItem(comboListElement);
            comboListElement.select();
        } else if (n == 1) {
            this.fileMRU.setSelectedItem(this.lastSelectedObject);
        }
    }

    private ComboListElement addPath(String string) {
        StringComboListElement stringComboListElement;
        DefaultComboBoxModel defaultComboBoxModel = (DefaultComboBoxModel)this.fileMRU.getModel();
        int n = defaultComboBoxModel.getIndexOf(stringComboListElement = new StringComboListElement(string));
        if (n == -1) {
            defaultComboBoxModel.insertElementAt(stringComboListElement, 1);
        }
        if (defaultComboBoxModel.getSize() > this.itemCountLimit + 3) {
            defaultComboBoxModel.removeElementAt(defaultComboBoxModel.getSize() - 3);
        }
        return stringComboListElement;
    }

    public String getActionText() {
        return this.actionText;
    }

    public void setActionText(String string) {
        this.actionText = string;
        this.changeModel();
    }

    public String getWelcomeText() {
        return this.welcomeText;
    }

    public void setWelcomeText(String string) {
        this.welcomeText = string;
        this.changeModel();
    }

    public String getNoneText() {
        return this.noneText;
    }

    public void setNoneText(String string) {
        this.noneText = string;
        this.changeModel();
    }

    public int getItemCountLimit() {
        return this.itemCountLimit;
    }

    public void setItemCountLimit(int n) {
        if (n < 2) {
            n = 2;
        }
        this.itemCountLimit = n;
    }

    public boolean isShowWelcome() {
        return this.showWelcome;
    }

    public void setShowWelcome(boolean bl) {
        this.showWelcome = bl;
    }

    public boolean isEditable() {
        return this.fileMRU.isEditable();
    }

    public void setEditable(boolean bl) {
        this.fileMRU.setEditable(bl);
    }

    public boolean isValidSelection() {
        return this.validSelection;
    }

    public void setSupportedExtensions(Set<String> set) {
        this.supportedExtensions.clear();
        this.supportedExtensions.addAll(set);
    }

    public Set<String> getSupportedExtensions() {
        return this.supportedExtensions;
    }

    public String getSelectedPath() {
        if (this.isValidSelection()) {
            this.lastSelectedPath = this.fileMRU.getSelectedItem().toString();
            return this.fileMRU.getSelectedItem().toString();
        }
        return "";
    }

    public void setStartDir(String string) {
        this.lastSelectedPath = string;
    }

    public String getStartDir() {
        return this.lastSelectedPath;
    }

    private class StringComboListElement
    extends ComboListElement {
        public StringComboListElement(Object object) {
            super(object, false);
        }

        public StringComboListElement(Object object, boolean bl) {
            super(object, bl);
        }

        public void onSelection() {
            DirectorySelectorCombo.this.lastSelectedObject = this;
            DirectorySelectorCombo.this.validSelection = true;
            if (DirectorySelectorCombo.this.lastSelectedObject != null) {
                DirectorySelectorCombo.this.fileMRU.setToolTipText(DirectorySelectorCombo.this.lastSelectedObject.toString());
            }
        }
    }

    private abstract class ComboListElement {
        private Object value;
        private boolean asVolatile;

        public abstract void onSelection();

        public ComboListElement(Object object) {
            this(object, false);
        }

        public ComboListElement(Object object, boolean bl) {
            this.value = object;
            this.asVolatile = bl;
        }

        public void select() {
            String string;
            this.onSelection();
            String string2 = string = DirectorySelectorCombo.this.propertyChangeTracker != null ? DirectorySelectorCombo.this.propertyChangeTracker.toString() : "";
            String string3 = DirectorySelectorCombo.this.isValidSelection() ? (DirectorySelectorCombo.this.lastSelectedObject != null ? DirectorySelectorCombo.this.lastSelectedObject.toString() : "") : null;
            DirectorySelectorCombo.this.firePropertyChange(DirectorySelectorCombo.PROPERTY_SELECTEDPATH, string, string3);
            DirectorySelectorCombo.this.propertyChangeTracker = string3;
        }

        public Object getValue() {
            return this.value;
        }

        public boolean isVolatile() {
            return this.asVolatile;
        }

        public String toString() {
            return this.value != null ? this.value.toString() : "";
        }

        public boolean equals(Object object) {
            if (!(object instanceof ComboListElement)) {
                return false;
            }
            if (this.value == null || object == null || ((ComboListElement)object).getValue() == null) {
                return false;
            }
            return this.value.equals(((ComboListElement)object).getValue());
        }
    }

    private class SeparatedListCellRenderer
    implements ListCellRenderer {
        private ListCellRenderer delegate = new DefaultListCellRenderer();

        public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
            if (object instanceof JSeparator) {
                return (Component)object;
            }
            return this.delegate.getListCellRendererComponent(jList, object, n, bl, bl2);
        }
    }
}

