/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.text.BadLocationException;
import javax.swing.text.Position;
import org.netbeans.editor.BaseDocument;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.JSFConfigDataObject;
import org.netbeans.modules.web.jsf.api.ConfigurationUtils;
import org.netbeans.modules.web.jsf.api.facesmodel.Converter;
import org.netbeans.modules.web.jsf.api.facesmodel.FacesConfig;
import org.netbeans.modules.web.jsf.api.facesmodel.ManagedBean;
import org.netbeans.modules.web.jsf.editor.JSFEditorUtilities;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.CloneableEditorSupport;
import org.openide.text.PositionBounds;
import org.openide.text.PositionRef;
import org.openide.util.NbBundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Occurrences {
    private static final Logger LOGGER = Logger.getLogger(Occurrences.class.getName());

    public static List<OccurrenceItem> getAllOccurrences(WebModule webModule, String string, String string2) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        LOGGER.fine("getAllOccurences(" + webModule.getDocumentBase().getPath() + ", " + string + ", " + string2 + ")");
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObjectArray[i], true).getRootComponent();
                List<Converter> list = facesConfig.getConverters();
                for (Converter converter : list) {
                    if (string.equals(converter.getConverterClass())) {
                        arrayList.add(new ConverterClassItem(fileObjectArray[i], converter, string2));
                        continue;
                    }
                    if (!string.equals(converter.getConverterForClass())) continue;
                    arrayList.add(new ConverterForClassItem(fileObjectArray[i], converter, string2));
                }
                List<ManagedBean> list2 = facesConfig.getManagedBeans();
                Iterator object2 = list2.iterator();
                while (object2.hasNext()) {
                    ManagedBean managedBean = (ManagedBean)object2.next();
                    if (!string.equals(managedBean.getManagedBeanClass())) continue;
                    arrayList.add(new ManagedBeanClassItem(fileObjectArray[i], managedBean, string2));
                }
            }
        }
        return arrayList;
    }

    public static List<OccurrenceItem> getPackageOccurrences(WebModule webModule, String string, String string2, boolean bl) {
        FileObject[] fileObjectArray;
        ArrayList<OccurrenceItem> arrayList = new ArrayList<OccurrenceItem>();
        assert (webModule != null);
        assert (string != null);
        if (webModule != null && (fileObjectArray = ConfigurationUtils.getFacesConfigFiles(webModule)) != null) {
            for (int i = 0; i < fileObjectArray.length; ++i) {
                FacesConfig facesConfig = ConfigurationUtils.getConfigModel(fileObjectArray[i], true).getRootComponent();
                List<Converter> list = facesConfig.getConverters();
                for (Converter converter : list) {
                    if (JSFRefactoringUtils.containsRenamingPackage(converter.getConverterClass(), string, bl)) {
                        arrayList.add(new ConverterClassItem(fileObjectArray[i], converter, Occurrences.getNewFQCN(string2, string, converter.getConverterClass())));
                    }
                    if (!JSFRefactoringUtils.containsRenamingPackage(converter.getConverterForClass(), string, bl)) continue;
                    arrayList.add(new ConverterForClassItem(fileObjectArray[i], converter, Occurrences.getNewFQCN(string2, string, converter.getConverterForClass())));
                }
                List<ManagedBean> list2 = facesConfig.getManagedBeans();
                Iterator object2 = list2.iterator();
                while (object2.hasNext()) {
                    ManagedBean managedBean = (ManagedBean)object2.next();
                    if (!JSFRefactoringUtils.containsRenamingPackage(managedBean.getManagedBeanClass(), string, bl)) continue;
                    arrayList.add(new ManagedBeanClassItem(fileObjectArray[i], managedBean, Occurrences.getNewFQCN(string2, string, managedBean.getManagedBeanClass())));
                }
            }
        }
        return arrayList;
    }

    public static String getNewFQCN(String string, String string2, String string3) {
        String string4 = string3;
        if (string2.length() == 0) {
            string4 = string + '.' + string3;
        } else if (string3.startsWith(string2)) {
            string4 = string4.substring(string2.length());
            if (string.length() > 0) {
                string4 = string + string4;
            }
            if (string4.charAt(0) == '.') {
                string4 = string4.substring(1);
            }
        }
        return string4;
    }

    public static class ConverterForClassItem
    extends OccurrenceItem {
        private final Converter converter;
        private final Converter copy;

        public ConverterForClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, string, converter.getConverterForClass());
            this.converter = converter;
            this.copy = (Converter)converter.copy(converter.getParent());
        }

        protected String getXMLElementName() {
            return "converter-for-class";
        }

        public void performChange() {
            this.changeConverterForClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterForClass(this.newValue, this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_WhereUsed", (Object)this.getElementText());
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterForClass_Rename", (Object)this.getElementText());
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<Converter> list = facesConfig.getConverters();
            for (Converter converter : list) {
                if (!this.oldValue.equals(converter.getConverterClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter(this.copy);
            facesConfig.getModel().endTransaction();
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.getElementText()});
        }

        private void changeConverterForClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<Converter> list = facesConfig.getConverters();
            for (Converter converter : list) {
                if (!string.equals(converter.getConverterForClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterForClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public PositionBounds getChangePosition() {
            PositionBounds positionBounds = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                BaseDocument baseDocument = JSFEditorUtilities.getBaseDocument(dataObject);
                int[] nArray = JSFEditorUtilities.getConverterDefinition(baseDocument, "converter-for-class", this.converter.getConverterForClass());
                String string = baseDocument.getText(nArray);
                int n = nArray[0] + string.indexOf(this.oldValue);
                positionBounds = this.createPosition(n, n + this.oldValue.length());
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return positionBounds;
        }
    }

    public static class ConverterClassItem
    extends OccurrenceItem {
        private final Converter converter;
        private final Converter copy;

        public ConverterClassItem(FileObject fileObject, Converter converter, String string) {
            super(fileObject, string, converter.getConverterClass());
            this.converter = converter;
            this.copy = (Converter)converter.copy(converter.getParent());
        }

        protected String getXMLElementName() {
            return "converter-class";
        }

        public void performChange() {
            this.changeConverterClass(this.oldValue, this.newValue);
        }

        public void undoChange() {
            this.changeConverterClass(this.newValue, this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_WhereUsed", (Object)this.getElementText());
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ConverterClass_Rename", (Object)this.getElementText());
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<Converter> list = facesConfig.getConverters();
            for (Converter converter : list) {
                if (!this.oldValue.equals(converter.getConverterClass())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeConverter(converter);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addConverter(this.copy);
            facesConfig.getModel().endTransaction();
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Converter_SafeDelete", (Object[])new Object[]{this.getElementText()});
        }

        private void changeConverterClass(String string, String string2) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<Converter> list = facesConfig.getConverters();
            for (Converter converter : list) {
                if (!string.equals(converter.getConverterClass())) continue;
                converter.getModel().startTransaction();
                converter.setConverterClass(string2);
                converter.getModel().endTransaction();
                break;
            }
        }

        public PositionBounds getChangePosition() {
            PositionBounds positionBounds = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                BaseDocument baseDocument = JSFEditorUtilities.getBaseDocument(dataObject);
                int[] nArray = JSFEditorUtilities.getConverterDefinition(baseDocument, "converter-class", this.converter.getConverterClass());
                String string = baseDocument.getText(nArray);
                int n = nArray[0] + string.indexOf(this.oldValue);
                positionBounds = this.createPosition(n, n + this.oldValue.length());
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return positionBounds;
        }
    }

    public static class ManagedBeanClassItem
    extends OccurrenceItem {
        private final ManagedBean bean;
        private final ManagedBean copy;

        public ManagedBeanClassItem(FileObject fileObject, ManagedBean managedBean, String string) {
            super(fileObject, string, managedBean.getManagedBeanClass());
            this.bean = managedBean;
            this.copy = (ManagedBean)managedBean.copy(managedBean.getParent());
        }

        protected String getXMLElementName() {
            return "managed-bean-class";
        }

        public void performChange() {
            this.changeBeanClass(this.newValue);
        }

        public void undoChange() {
            this.changeBeanClass(this.oldValue);
        }

        public String getWhereUsedMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_WhereUsed", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        public String getChangeMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_Rename", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        public void performSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<ManagedBean> list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!this.bean.getManagedBeanName().equals(managedBean.getManagedBeanName())) continue;
                facesConfig.getModel().startTransaction();
                facesConfig.removeManagedBean(managedBean);
                facesConfig.getModel().endTransaction();
                break;
            }
        }

        public void undoSafeDelete() {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            facesConfig.getModel().startTransaction();
            facesConfig.addManagedBean(this.copy);
            facesConfig.getModel().endTransaction();
        }

        public String getSafeDeleteMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_ManagedBeanClass_SafeDelete", (Object[])new Object[]{this.bean.getManagedBeanName(), this.getElementText()});
        }

        private void changeBeanClass(String string) {
            FacesConfig facesConfig = ConfigurationUtils.getConfigModel(this.config, true).getRootComponent();
            List<ManagedBean> list = facesConfig.getManagedBeans();
            for (ManagedBean managedBean : list) {
                if (!this.bean.getManagedBeanName().equals(managedBean.getManagedBeanName())) continue;
                facesConfig.getModel().startTransaction();
                managedBean.setManagedBeanClass(string);
                facesConfig.getModel().endTransaction();
            }
        }

        public PositionBounds getChangePosition() {
            PositionBounds positionBounds = null;
            try {
                DataObject dataObject = DataObject.find((FileObject)this.config);
                BaseDocument baseDocument = JSFEditorUtilities.getBaseDocument(dataObject);
                int[] nArray = JSFEditorUtilities.getManagedBeanDefinition(baseDocument, this.bean.getManagedBeanName());
                String string = baseDocument.getText(nArray);
                int n = nArray[0] + string.indexOf(this.oldValue);
                positionBounds = this.createPosition(n, n + this.oldValue.length());
            }
            catch (BadLocationException badLocationException) {
                LOGGER.log(Level.SEVERE, badLocationException.getMessage(), badLocationException);
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return positionBounds;
        }
    }

    public static abstract class OccurrenceItem {
        protected FileObject config;
        protected String oldValue;
        protected String newValue;

        public OccurrenceItem(FileObject fileObject, String string, String string2) {
            this.config = fileObject;
            this.newValue = string;
            this.oldValue = string2;
        }

        public String getNewValue() {
            return this.newValue;
        }

        public String getOldValue() {
            return this.oldValue;
        }

        public FileObject getFacesConfig() {
            return this.config;
        }

        public String getElementText() {
            StringBuffer stringBuffer = new StringBuffer();
            stringBuffer.append("<font color=\"#0000FF\">");
            stringBuffer.append("&lt;").append(this.getXMLElementName()).append("&gt;</font><b>");
            stringBuffer.append(this.oldValue).append("</b><font color=\"#0000FF\">&lt;/").append(this.getXMLElementName());
            stringBuffer.append("&gt;</font>");
            return stringBuffer.toString();
        }

        protected abstract String getXMLElementName();

        public abstract void performChange();

        public abstract void undoChange();

        public abstract String getChangeMessage();

        public String getRenamePackageMessage() {
            return NbBundle.getMessage(Occurrences.class, (String)"MSG_Package_Rename", (Object[])new Object[]{this.getElementText()});
        }

        public abstract void performSafeDelete();

        public abstract void undoSafeDelete();

        public abstract String getSafeDeleteMessage();

        public abstract String getWhereUsedMessage();

        protected PositionBounds createPosition(int n, int n2) {
            try {
                CloneableEditorSupport cloneableEditorSupport;
                DataObject dataObject = DataObject.find((FileObject)this.config);
                if (dataObject instanceof JSFConfigDataObject && (cloneableEditorSupport = JSFEditorUtilities.findCloneableEditorSupport((DataObject)((JSFConfigDataObject)dataObject))) != null) {
                    PositionRef positionRef = cloneableEditorSupport.createPositionRef(n, Position.Bias.Forward);
                    PositionRef positionRef2 = cloneableEditorSupport.createPositionRef(n2, Position.Bias.Backward);
                    return new PositionBounds(positionRef, positionRef2);
                }
            }
            catch (DataObjectNotFoundException dataObjectNotFoundException) {
                LOGGER.log(Level.SEVERE, dataObjectNotFoundException.getMessage(), dataObjectNotFoundException);
            }
            return null;
        }

        public abstract PositionBounds getChangePosition();
    }
}

