/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsf.refactoring;

import com.sun.source.tree.Tree;
import java.util.Collection;
import java.util.List;
import java.util.logging.Logger;
import javax.lang.model.element.Element;
import javax.lang.model.element.TypeElement;
import org.netbeans.api.java.source.CompilationInfo;
import org.netbeans.api.java.source.TreePathHandle;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.SafeDeleteRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.refactoring.spi.SimpleRefactoringElementImplementation;
import org.netbeans.modules.web.api.webmodule.WebModule;
import org.netbeans.modules.web.jsf.refactoring.JSFRefactoringUtils;
import org.netbeans.modules.web.jsf.refactoring.Occurrences;
import org.openide.filesystems.FileObject;
import org.openide.text.PositionBounds;
import org.openide.util.Lookup;
import org.openide.util.lookup.Lookups;

public class JSFSafeDeletePlugin
implements RefactoringPlugin {
    private static ThreadLocal semafor = new ThreadLocal();
    private static final Logger LOGGER = Logger.getLogger(JSFSafeDeletePlugin.class.getName());
    private final SafeDeleteRefactoring refactoring;

    public JSFSafeDeletePlugin(SafeDeleteRefactoring safeDeleteRefactoring) {
        this.refactoring = safeDeleteRefactoring;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public void cancelRequest() {
    }

    public Problem prepare(RefactoringElementsBag refactoringElementsBag) {
        if (semafor.get() == null) {
            semafor.set(new Object());
            Collection collection = this.refactoring.getRefactoringSource().lookupAll(TreePathHandle.class);
            if (collection != null) {
                for (TreePathHandle treePathHandle : collection) {
                    CompilationInfo compilationInfo;
                    WebModule webModule;
                    if (treePathHandle.getKind() != Tree.Kind.CLASS || (webModule = WebModule.getWebModule((FileObject)treePathHandle.getFileObject())) == null || (compilationInfo = JSFRefactoringUtils.getCompilationInfo((AbstractRefactoring)this.refactoring, treePathHandle.getFileObject())) == null) continue;
                    Element element = treePathHandle.resolveElement(compilationInfo);
                    TypeElement typeElement = (TypeElement)element;
                    String string = typeElement.getQualifiedName().toString();
                    List<Occurrences.OccurrenceItem> list = Occurrences.getAllOccurrences(webModule, string, null);
                    for (Occurrences.OccurrenceItem occurrenceItem : list) {
                        refactoringElementsBag.add((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new JSFSafeDeleteClassElement(occurrenceItem));
                    }
                }
            }
            semafor.set(null);
        }
        return null;
    }

    public static class JSFSafeDeleteClassElement
    extends SimpleRefactoringElementImplementation {
        private final Occurrences.OccurrenceItem item;

        JSFSafeDeleteClassElement(Occurrences.OccurrenceItem occurrenceItem) {
            this.item = occurrenceItem;
        }

        public String getText() {
            return this.getDisplayText();
        }

        public String getDisplayText() {
            return this.item.getSafeDeleteMessage();
        }

        public void performChange() {
            this.item.performSafeDelete();
        }

        public Lookup getLookup() {
            return Lookups.singleton((Object)this.item.getFacesConfig());
        }

        public FileObject getParentFile() {
            return this.item.getFacesConfig();
        }

        public PositionBounds getPosition() {
            return this.item.getChangePosition();
        }

        public void undoChange() {
            this.item.undoSafeDelete();
        }
    }
}

