/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.wsdl;

import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.xmlbeans.GDate;
import org.apache.xmlbeans.GDateBuilder;
import org.apache.xmlbeans.GDateSpecification;
import org.apache.xmlbeans.GDuration;
import org.apache.xmlbeans.GDurationBuilder;
import org.apache.xmlbeans.SchemaLocalElement;
import org.apache.xmlbeans.SchemaParticle;
import org.apache.xmlbeans.SchemaProperty;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SimpleValue;
import org.apache.xmlbeans.XmlAnySimpleType;
import org.apache.xmlbeans.XmlCalendar;
import org.apache.xmlbeans.XmlCursor;
import org.apache.xmlbeans.XmlDate;
import org.apache.xmlbeans.XmlDateTime;
import org.apache.xmlbeans.XmlDecimal;
import org.apache.xmlbeans.XmlDuration;
import org.apache.xmlbeans.XmlGDay;
import org.apache.xmlbeans.XmlGMonth;
import org.apache.xmlbeans.XmlGMonthDay;
import org.apache.xmlbeans.XmlGYear;
import org.apache.xmlbeans.XmlGYearMonth;
import org.apache.xmlbeans.XmlInteger;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.XmlTime;
import org.apache.xmlbeans.impl.util.Base64;
import org.apache.xmlbeans.impl.util.HexBin;
import org.apache.xmlbeans.soap.SchemaWSDLArrayType;
import org.openide.util.NbBundle;

public class SampleXmlUtil {
    private boolean _soapEnc;
    Random _picker = new Random(1L);
    private boolean ignoreOptional;
    public static final String[] WORDS = new String[]{"ipsa", "iovis", "rapidum", "iaculata", "e", "nubibus", "ignem", "disiecitque", "rates", "evertitque", "aequora", "ventis", "illum", "exspirantem", "transfixo", "pectore", "flammas", "turbine", "corripuit", "scopuloque", "infixit", "acuto", "ast", "ego", "quae", "divum", "incedo", "regina", "iovisque", "et", "soror", "et", "coniunx", "una", "cum", "gente", "tot", "annos", "bella", "gero", "et", "quisquam", "numen", "iunonis", "adorat", "praeterea", "aut", "supplex", "aris", "imponet", "honorem", "talia", "flammato", "secum", "dea", "corde", "volutans", "nimborum", "in", "patriam", "loca", "feta", "furentibus", "austris", "aeoliam", "venit", "hic", "vasto", "rex", "aeolus", "antro", "luctantis", "ventos", "tempestatesque", "sonoras", "imperio", "premit", "ac", "vinclis", "et", "carcere", "frenat", "illi", "indignantes", "magno", "cum", "murmure", "montis", "circum", "claustra", "fremunt", "celsa", "sedet", "aeolus", "arce", "sceptra", "tenens", "mollitque", "animos", "et", "temperat", "iras", "ni", "faciat", "maria", "ac", "terras", "caelumque", "profundum", "quippe", "ferant", "rapidi", "secum", "verrantque", "per", "auras", "sed", "pater", "omnipotens", "speluncis", "abdidit", "atris", "hoc", "metuens", "molemque", "et", "montis", "insuper", "altos", "imposuit", "regemque", "dedit", "qui", "foedere", "certo", "et", "premere", "et", "laxas", "sciret", "dare", "iussus", "habenas"};
    private static final String[] DNS1 = new String[]{"corp", "your", "my", "sample", "company", "test", "any"};
    private static final String[] DNS2 = new String[]{"com", "org", "com", "gov", "org", "com", "org", "com", "edu"};
    private static final QName HREF = new QName("href");
    private static final QName ID = new QName("id");
    public static final QName XSI_TYPE = new QName("http://www.w3.org/2001/XMLSchema-instance", "type");
    private static final QName ENC_ARRAYTYPE = new QName("http://schemas.xmlsoap.org/soap/encoding/", "arrayType");
    private static final QName ENC_OFFSET = new QName("http://schemas.xmlsoap.org/soap/encoding/", "offset");
    private static final Set SKIPPED_SOAP_ATTRS = new HashSet<QName>(Arrays.asList(HREF, ID, ENC_OFFSET));
    private ArrayList _typeStack = new ArrayList();

    public SampleXmlUtil(boolean bl) {
        this._soapEnc = bl;
    }

    public boolean isSoapEnc() {
        return this._soapEnc;
    }

    public static String createSampleForType(SchemaType schemaType) {
        XmlObject xmlObject = XmlObject.Factory.newInstance();
        XmlCursor xmlCursor = xmlObject.newCursor();
        xmlCursor.toNextToken();
        new SampleXmlUtil(false).createSampleForType(schemaType, xmlCursor);
        XmlOptions xmlOptions = new XmlOptions();
        xmlOptions.put((Object)"SAVE_PRETTY_PRINT");
        xmlOptions.put((Object)"SAVE_PRETTY_PRINT_INDENT", 2);
        xmlOptions.put((Object)"SAVE_AGGRESSIVE_NAMESPACES");
        String string = xmlObject.xmlText(xmlOptions);
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void createSampleForType(SchemaType schemaType, XmlCursor xmlCursor) {
        if (this._typeStack.contains(schemaType)) {
            return;
        }
        this._typeStack.add(schemaType);
        try {
            if (schemaType.isSimpleType() || schemaType.isURType()) {
                this.processSimpleType(schemaType, xmlCursor);
                return;
            }
            this.processAttributes(schemaType, xmlCursor);
            switch (schemaType.getContentType()) {
                case 0: 
                case 1: {
                    return;
                }
                case 2: {
                    this.processSimpleType(schemaType, xmlCursor);
                    return;
                }
                case 4: {
                    xmlCursor.insertChars(this.pick(WORDS) + " ");
                    if (schemaType.getContentModel() != null) {
                        this.processParticle(schemaType.getContentModel(), xmlCursor, true);
                    }
                    xmlCursor.insertChars(this.pick(WORDS));
                    return;
                }
                case 3: {
                    if (schemaType.getContentModel() == null) return;
                    this.processParticle(schemaType.getContentModel(), xmlCursor, false);
                    return;
                }
            }
            return;
        }
        finally {
            this._typeStack.remove(this._typeStack.size() - 1);
        }
    }

    private void processSimpleType(SchemaType schemaType, XmlCursor xmlCursor) {
        Object object;
        if (this._soapEnc && (object = schemaType.getName()) != null) {
            xmlCursor.insertAttributeWithValue(XSI_TYPE, SampleXmlUtil.formatQName(xmlCursor, (QName)object));
        }
        object = this.sampleDataForSimpleType(schemaType);
        xmlCursor.insertChars((String)object);
    }

    private String sampleDataForSimpleType(SchemaType schemaType) {
        return "?" + this._sampleDataForSimpleType(schemaType) + "?";
    }

    private String _sampleDataForSimpleType(SchemaType schemaType) {
        if (XmlObject.type.equals(schemaType)) {
            return "anyType";
        }
        if (XmlAnySimpleType.type.equals(schemaType)) {
            return "anySimpleType";
        }
        if (schemaType.getSimpleVariety() == 3) {
            SchemaType schemaType2 = schemaType.getListItemType();
            StringBuffer stringBuffer = new StringBuffer();
            int n = this.pickLength(schemaType);
            if (n > 0) {
                stringBuffer.append(this.sampleDataForSimpleType(schemaType2));
            }
            for (int i = 1; i < n; ++i) {
                stringBuffer.append(' ');
                stringBuffer.append(this.sampleDataForSimpleType(schemaType2));
            }
            return stringBuffer.toString();
        }
        if (schemaType.getSimpleVariety() == 2) {
            SchemaType[] schemaTypeArray = schemaType.getUnionConstituentTypes();
            if (schemaTypeArray.length == 0) {
                return "";
            }
            return this.sampleDataForSimpleType(schemaTypeArray[this.pick(schemaTypeArray.length)]);
        }
        XmlAnySimpleType[] xmlAnySimpleTypeArray = schemaType.getEnumerationValues();
        if (xmlAnySimpleTypeArray != null && xmlAnySimpleTypeArray.length > 0) {
            return xmlAnySimpleTypeArray[this.pick(xmlAnySimpleTypeArray.length)].getStringValue();
        }
        switch (schemaType.getPrimitiveType().getBuiltinTypeCode()) {
            default: {
                return "";
            }
            case 1: 
            case 2: {
                return "anything";
            }
            case 3: {
                return this.pick(2) == 0 ? "true" : "false";
            }
            case 4: {
                String string = null;
                try {
                    string = new String(Base64.encode((byte[])this.formatToLength(this.pick(WORDS), schemaType).getBytes("utf-8")));
                }
                catch (UnsupportedEncodingException unsupportedEncodingException) {
                    // empty catch block
                }
                return string;
            }
            case 5: {
                return HexBin.encode((String)this.formatToLength(this.pick(WORDS), schemaType));
            }
            case 6: {
                return this.formatToLength("http://www." + this.pick(DNS1) + "." + this.pick(DNS2) + "/" + this.pick(WORDS) + "/" + this.pick(WORDS), schemaType);
            }
            case 7: {
                return this.formatToLength("qname", schemaType);
            }
            case 8: {
                return this.formatToLength("notation", schemaType);
            }
            case 9: {
                return "1.5E2";
            }
            case 10: {
                return "1.051732E7";
            }
            case 11: {
                switch (this.closestBuiltin(schemaType).getBuiltinTypeCode()) {
                    case 25: {
                        return this.formatDecimal("1", schemaType);
                    }
                    case 33: {
                        return this.formatDecimal("5", schemaType);
                    }
                    case 26: {
                        return this.formatDecimal("2", schemaType);
                    }
                    case 34: {
                        return this.formatDecimal("6", schemaType);
                    }
                    case 24: {
                        return this.formatDecimal("3", schemaType);
                    }
                    case 32: {
                        return this.formatDecimal("7", schemaType);
                    }
                    case 23: {
                        return this.formatDecimal("10", schemaType);
                    }
                    case 31: {
                        return this.formatDecimal("11", schemaType);
                    }
                    case 22: {
                        return this.formatDecimal("100", schemaType);
                    }
                    case 27: {
                        return this.formatDecimal("-200", schemaType);
                    }
                    case 28: {
                        return this.formatDecimal("-201", schemaType);
                    }
                    case 29: {
                        return this.formatDecimal("200", schemaType);
                    }
                    case 30: {
                        return this.formatDecimal("201", schemaType);
                    }
                }
                return this.formatDecimal("1000.00", schemaType);
            }
            case 12: {
                String string;
                switch (this.closestBuiltin(schemaType).getBuiltinTypeCode()) {
                    case 12: 
                    case 35: {
                        string = "string";
                        break;
                    }
                    case 36: {
                        string = "token";
                        break;
                    }
                    default: {
                        string = "string";
                    }
                }
                return this.formatToLength(string, schemaType);
            }
            case 13: {
                return this.formatDuration(schemaType);
            }
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: 
            case 19: 
            case 20: 
            case 21: 
        }
        return this.formatDate(schemaType);
    }

    private int pick(int n) {
        return this._picker.nextInt(n);
    }

    private String pick(String[] stringArray) {
        return stringArray[this.pick(stringArray.length)];
    }

    private String pick(String[] stringArray, int n) {
        if (n <= 0) {
            return "";
        }
        int n2 = this.pick(stringArray.length);
        StringBuffer stringBuffer = new StringBuffer(stringArray[n2]);
        while (n-- > 0) {
            if (++n2 >= stringArray.length) {
                n2 = 0;
            }
            stringBuffer.append(' ');
            stringBuffer.append(stringArray[n2]);
        }
        return stringBuffer.toString();
    }

    private String pickDigits(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        while (n-- > 0) {
            stringBuffer.append(Integer.toString(this.pick(10)));
        }
        return stringBuffer.toString();
    }

    private int pickLength(SchemaType schemaType) {
        XmlInteger xmlInteger = (XmlInteger)schemaType.getFacet(0);
        if (xmlInteger != null) {
            return xmlInteger.getBigIntegerValue().intValue();
        }
        XmlInteger xmlInteger2 = (XmlInteger)schemaType.getFacet(1);
        XmlInteger xmlInteger3 = (XmlInteger)schemaType.getFacet(2);
        int n = xmlInteger2 == null ? 0 : xmlInteger2.getBigIntegerValue().intValue();
        int n2 = xmlInteger3 == null ? Integer.MAX_VALUE : xmlInteger3.getBigIntegerValue().intValue();
        if (n == 0 && n2 >= 1) {
            n = 1;
        }
        if (n2 > n + 2) {
            n2 = n + 2;
        }
        if (n2 < n) {
            n2 = n;
        }
        return n + this.pick(n2 - n);
    }

    private String formatToLength(String string, SchemaType schemaType) {
        String string2 = string;
        try {
            SimpleValue simpleValue;
            SimpleValue simpleValue2 = (SimpleValue)schemaType.getFacet(0);
            if (simpleValue2 == null) {
                simpleValue2 = (SimpleValue)schemaType.getFacet(1);
            }
            if (simpleValue2 != null) {
                int n = simpleValue2.getIntValue();
                while (string2.length() < n) {
                    string2 = string2 + string2;
                }
            }
            if ((simpleValue = (SimpleValue)schemaType.getFacet(0)) == null) {
                simpleValue = (SimpleValue)schemaType.getFacet(2);
            }
            if (simpleValue != null) {
                int n = simpleValue.getIntValue();
                if (string2.length() > n) {
                    string2 = string2.substring(0, n);
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return string2;
    }

    private String formatDecimal(String string, SchemaType schemaType) {
        BigDecimal bigDecimal;
        BigDecimal bigDecimal2;
        BigDecimal bigDecimal3 = new BigDecimal(string);
        XmlDecimal xmlDecimal = (XmlDecimal)schemaType.getFacet(4);
        BigDecimal bigDecimal4 = xmlDecimal != null ? xmlDecimal.getBigDecimalValue() : null;
        xmlDecimal = (XmlDecimal)schemaType.getFacet(5);
        BigDecimal bigDecimal5 = xmlDecimal != null ? xmlDecimal.getBigDecimalValue() : null;
        boolean bl = true;
        boolean bl2 = true;
        xmlDecimal = (XmlDecimal)schemaType.getFacet(3);
        if (xmlDecimal != null) {
            bigDecimal2 = xmlDecimal.getBigDecimalValue();
            if (bigDecimal4 == null || bigDecimal4.compareTo(bigDecimal2) < 0) {
                bigDecimal4 = bigDecimal2;
                bl = false;
            }
        }
        if ((xmlDecimal = (XmlDecimal)schemaType.getFacet(6)) != null) {
            bigDecimal2 = xmlDecimal.getBigDecimalValue();
            if (bigDecimal5 == null || bigDecimal5.compareTo(bigDecimal2) > 0) {
                bigDecimal5 = bigDecimal2;
                bl2 = false;
            }
        }
        xmlDecimal = (XmlDecimal)schemaType.getFacet(7);
        int n = -1;
        if (xmlDecimal != null) {
            n = xmlDecimal.getBigDecimalValue().intValue();
            StringBuffer stringBuffer = new StringBuffer(n);
            for (int i = 0; i < n; ++i) {
                stringBuffer.append('9');
            }
            BigDecimal bigDecimal6 = new BigDecimal(stringBuffer.toString());
            if (bigDecimal5 != null && bigDecimal5.compareTo(bigDecimal6) > 0) {
                bigDecimal5 = bigDecimal6;
                bl2 = true;
            }
            bigDecimal6 = bigDecimal6.negate();
            if (bigDecimal4 != null && bigDecimal4.compareTo(bigDecimal6) < 0) {
                bigDecimal4 = bigDecimal6;
                bl = true;
            }
        }
        int n2 = bigDecimal4 == null ? 1 : bigDecimal3.compareTo(bigDecimal4);
        int n3 = bigDecimal5 == null ? -1 : bigDecimal3.compareTo(bigDecimal5);
        boolean bl3 = n2 > 0 || n2 == 0 && bl;
        boolean bl4 = n3 < 0 || n3 == 0 && bl2;
        xmlDecimal = (XmlDecimal)schemaType.getFacet(8);
        int n4 = -1;
        if (xmlDecimal == null) {
            bigDecimal = new BigDecimal(1);
        } else {
            n4 = xmlDecimal.getBigDecimalValue().intValue();
            if (n4 > 0) {
                StringBuffer stringBuffer = new StringBuffer("0.");
                for (int i = 1; i < n4; ++i) {
                    stringBuffer.append('0');
                }
                stringBuffer.append('1');
                bigDecimal = new BigDecimal(stringBuffer.toString());
            } else {
                bigDecimal = new BigDecimal(1);
            }
        }
        if (!bl3 || !bl4) {
            if (bl3 && !bl4) {
                bigDecimal3 = bl2 ? bigDecimal5 : bigDecimal5.subtract(bigDecimal);
            } else if (!bl3 && bl4) {
                bigDecimal3 = bl ? bigDecimal4 : bigDecimal4.add(bigDecimal);
            }
        }
        int n5 = 0;
        BigDecimal bigDecimal7 = new BigDecimal(BigInteger.ONE);
        BigDecimal bigDecimal8 = bigDecimal3;
        while (bigDecimal8.abs().compareTo(bigDecimal7) >= 0) {
            bigDecimal8 = bigDecimal8.movePointLeft(1);
            ++n5;
        }
        if (n4 > 0) {
            if (n >= 0) {
                bigDecimal3.setScale(Math.max(n4, n - n5));
            } else {
                bigDecimal3.setScale(n4);
            }
        } else if (n4 == 0) {
            bigDecimal3.setScale(0);
        }
        return bigDecimal3.toString();
    }

    private String formatDuration(SchemaType schemaType) {
        XmlDuration xmlDuration = (XmlDuration)schemaType.getFacet(4);
        GDuration gDuration = null;
        if (xmlDuration != null) {
            gDuration = xmlDuration.getGDurationValue();
        }
        xmlDuration = (XmlDuration)schemaType.getFacet(5);
        GDuration gDuration2 = null;
        if (xmlDuration != null) {
            gDuration2 = xmlDuration.getGDurationValue();
        }
        xmlDuration = (XmlDuration)schemaType.getFacet(3);
        GDuration gDuration3 = null;
        if (xmlDuration != null) {
            gDuration3 = xmlDuration.getGDurationValue();
        }
        xmlDuration = (XmlDuration)schemaType.getFacet(6);
        GDuration gDuration4 = null;
        if (xmlDuration != null) {
            gDuration4 = xmlDuration.getGDurationValue();
        }
        GDurationBuilder gDurationBuilder = new GDurationBuilder();
        gDurationBuilder.setSecond(this.pick(800000));
        gDurationBuilder.setMonth(this.pick(20));
        if (gDuration != null) {
            if (gDurationBuilder.getYear() < gDuration.getYear()) {
                gDurationBuilder.setYear(gDuration.getYear());
            }
            if (gDurationBuilder.getMonth() < gDuration.getMonth()) {
                gDurationBuilder.setMonth(gDuration.getMonth());
            }
            if (gDurationBuilder.getDay() < gDuration.getDay()) {
                gDurationBuilder.setDay(gDuration.getDay());
            }
            if (gDurationBuilder.getHour() < gDuration.getHour()) {
                gDurationBuilder.setHour(gDuration.getHour());
            }
            if (gDurationBuilder.getMinute() < gDuration.getMinute()) {
                gDurationBuilder.setMinute(gDuration.getMinute());
            }
            if (gDurationBuilder.getSecond() < gDuration.getSecond()) {
                gDurationBuilder.setSecond(gDuration.getSecond());
            }
            if (gDurationBuilder.getFraction().compareTo(gDuration.getFraction()) < 0) {
                gDurationBuilder.setFraction(gDuration.getFraction());
            }
        }
        if (gDuration2 != null) {
            if (gDurationBuilder.getYear() > gDuration2.getYear()) {
                gDurationBuilder.setYear(gDuration2.getYear());
            }
            if (gDurationBuilder.getMonth() > gDuration2.getMonth()) {
                gDurationBuilder.setMonth(gDuration2.getMonth());
            }
            if (gDurationBuilder.getDay() > gDuration2.getDay()) {
                gDurationBuilder.setDay(gDuration2.getDay());
            }
            if (gDurationBuilder.getHour() > gDuration2.getHour()) {
                gDurationBuilder.setHour(gDuration2.getHour());
            }
            if (gDurationBuilder.getMinute() > gDuration2.getMinute()) {
                gDurationBuilder.setMinute(gDuration2.getMinute());
            }
            if (gDurationBuilder.getSecond() > gDuration2.getSecond()) {
                gDurationBuilder.setSecond(gDuration2.getSecond());
            }
            if (gDurationBuilder.getFraction().compareTo(gDuration2.getFraction()) > 0) {
                gDurationBuilder.setFraction(gDuration2.getFraction());
            }
        }
        if (gDuration3 != null) {
            if (gDurationBuilder.getYear() <= gDuration3.getYear()) {
                gDurationBuilder.setYear(gDuration3.getYear() + 1);
            }
            if (gDurationBuilder.getMonth() <= gDuration3.getMonth()) {
                gDurationBuilder.setMonth(gDuration3.getMonth() + 1);
            }
            if (gDurationBuilder.getDay() <= gDuration3.getDay()) {
                gDurationBuilder.setDay(gDuration3.getDay() + 1);
            }
            if (gDurationBuilder.getHour() <= gDuration3.getHour()) {
                gDurationBuilder.setHour(gDuration3.getHour() + 1);
            }
            if (gDurationBuilder.getMinute() <= gDuration3.getMinute()) {
                gDurationBuilder.setMinute(gDuration3.getMinute() + 1);
            }
            if (gDurationBuilder.getSecond() <= gDuration3.getSecond()) {
                gDurationBuilder.setSecond(gDuration3.getSecond() + 1);
            }
            if (gDurationBuilder.getFraction().compareTo(gDuration3.getFraction()) <= 0) {
                gDurationBuilder.setFraction(gDuration3.getFraction().add(new BigDecimal(0.001)));
            }
        }
        if (gDuration4 != null) {
            if (gDurationBuilder.getYear() > gDuration4.getYear()) {
                gDurationBuilder.setYear(gDuration4.getYear());
            }
            if (gDurationBuilder.getMonth() > gDuration4.getMonth()) {
                gDurationBuilder.setMonth(gDuration4.getMonth());
            }
            if (gDurationBuilder.getDay() > gDuration4.getDay()) {
                gDurationBuilder.setDay(gDuration4.getDay());
            }
            if (gDurationBuilder.getHour() > gDuration4.getHour()) {
                gDurationBuilder.setHour(gDuration4.getHour());
            }
            if (gDurationBuilder.getMinute() > gDuration4.getMinute()) {
                gDurationBuilder.setMinute(gDuration4.getMinute());
            }
            if (gDurationBuilder.getSecond() > gDuration4.getSecond()) {
                gDurationBuilder.setSecond(gDuration4.getSecond());
            }
            if (gDurationBuilder.getFraction().compareTo(gDuration4.getFraction()) > 0) {
                gDurationBuilder.setFraction(gDuration4.getFraction());
            }
        }
        gDurationBuilder.normalize();
        return gDurationBuilder.toString();
    }

    private String formatDate(SchemaType schemaType) {
        XmlDateTime xmlDateTime;
        GDateBuilder gDateBuilder = new GDateBuilder(new Date(1000L * (long)this.pick(31536000) + (30L + (long)this.pick(20)) * 365L * 24L * 60L * 60L * 1000L));
        GDate gDate = null;
        GDate gDate2 = null;
        switch (schemaType.getPrimitiveType().getBuiltinTypeCode()) {
            case 14: {
                xmlDateTime = (XmlDateTime)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDateTime)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDateTime)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDateTime)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 15: {
                xmlDateTime = (XmlTime)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlTime)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlTime)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlTime)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 16: {
                xmlDateTime = (XmlDate)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDate)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDate)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlDate)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 17: {
                xmlDateTime = (XmlGYearMonth)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYearMonth)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYearMonth)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYearMonth)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 18: {
                xmlDateTime = (XmlGYear)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYear)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYear)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGYear)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 19: {
                xmlDateTime = (XmlGMonthDay)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonthDay)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonthDay)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonthDay)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 20: {
                xmlDateTime = (XmlGDay)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGDay)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGDay)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGDay)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
            case 21: {
                xmlDateTime = (XmlGMonth)schemaType.getFacet(4);
                if (xmlDateTime != null) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonth)schemaType.getFacet(3)) != null && (gDate == null || gDate.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) <= 0)) {
                    gDate = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonth)schemaType.getFacet(5)) != null) {
                    gDate2 = xmlDateTime.getGDateValue();
                }
                if ((xmlDateTime = (XmlGMonth)schemaType.getFacet(6)) == null || gDate2 != null && gDate2.compareToGDate((GDateSpecification)xmlDateTime.getGDateValue()) < 0) break;
                gDate2 = xmlDateTime.getGDateValue();
                break;
            }
        }
        if (gDate != null && gDate2 == null) {
            if (gDate.compareToGDate((GDateSpecification)gDateBuilder) >= 0) {
                xmlDateTime = gDateBuilder.getCalendar();
                xmlDateTime.add(11, this.pick(8));
                gDateBuilder = new GDateBuilder((Calendar)xmlDateTime);
            }
        } else if (gDate == null && gDate2 != null) {
            if (gDate2.compareToGDate((GDateSpecification)gDateBuilder) <= 0) {
                xmlDateTime = gDateBuilder.getCalendar();
                xmlDateTime.add(11, 0 - this.pick(8));
                gDateBuilder = new GDateBuilder((Calendar)xmlDateTime);
            }
        } else if (gDate != null && gDate2 != null && (gDate.compareToGDate((GDateSpecification)gDateBuilder) >= 0 || gDate2.compareToGDate((GDateSpecification)gDateBuilder) <= 0)) {
            xmlDateTime = gDate.getCalendar();
            XmlCalendar xmlCalendar = gDate2.getCalendar();
            xmlDateTime.add(11, 1);
            if (xmlDateTime.after(xmlCalendar)) {
                xmlDateTime.add(11, -1);
                xmlDateTime.add(12, 1);
                if (xmlDateTime.after(xmlCalendar)) {
                    xmlDateTime.add(12, -1);
                    xmlDateTime.add(13, 1);
                    if (xmlDateTime.after(xmlCalendar)) {
                        xmlDateTime.add(13, -1);
                        xmlDateTime.add(14, 1);
                        if (xmlDateTime.after(xmlCalendar)) {
                            xmlDateTime.add(14, -1);
                        }
                    }
                }
            }
            gDateBuilder = new GDateBuilder((Calendar)xmlDateTime);
        }
        gDateBuilder.setBuiltinTypeCode(schemaType.getPrimitiveType().getBuiltinTypeCode());
        if (this.pick(2) == 0) {
            gDateBuilder.clearTimeZone();
        }
        return gDateBuilder.toString();
    }

    private SchemaType closestBuiltin(SchemaType schemaType) {
        while (!schemaType.isBuiltinType()) {
            schemaType = schemaType.getBaseType();
        }
        return schemaType;
    }

    public static QName crackQName(String string) {
        String string2;
        String string3;
        int n = string.lastIndexOf(58);
        if (n >= 0) {
            string3 = string.substring(0, n);
            string2 = string.substring(n + 1);
        } else {
            string3 = "";
            string2 = string;
        }
        return new QName(string3, string2);
    }

    private void processParticle(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        int n = this.determineMinMaxForSample(schemaParticle, xmlCursor);
        block7: while (n-- > 0) {
            switch (schemaParticle.getParticleType()) {
                case 4: {
                    this.processElement(schemaParticle, xmlCursor, bl);
                    continue block7;
                }
                case 3: {
                    this.processSequence(schemaParticle, xmlCursor, bl);
                    continue block7;
                }
                case 2: {
                    this.processChoice(schemaParticle, xmlCursor, bl);
                    continue block7;
                }
                case 1: {
                    this.processAll(schemaParticle, xmlCursor, bl);
                    continue block7;
                }
                case 5: {
                    this.processWildCard(schemaParticle, xmlCursor, bl);
                    continue block7;
                }
            }
        }
    }

    private int determineMinMaxForSample(SchemaParticle schemaParticle, XmlCursor xmlCursor) {
        int n;
        int n2 = schemaParticle.getIntMinOccurs();
        if (n2 == (n = schemaParticle.getIntMaxOccurs())) {
            return n2;
        }
        if (n2 == 0 && this.ignoreOptional) {
            return 0;
        }
        int n3 = n2;
        if (n3 == 0) {
            n3 = 1;
        }
        if (schemaParticle.getParticleType() != 4) {
            return n3;
        }
        if (schemaParticle.getMaxOccurs() == null) {
            if (n2 == 0) {
                xmlCursor.insertComment(NbBundle.getMessage(SampleXmlUtil.class, (String)"LBL_Zero_or_more_repetitions"));
            } else {
                xmlCursor.insertComment(NbBundle.getMessage(SampleXmlUtil.class, (String)"LBL_N_or_more_repetitions", (Object)("" + n2)));
            }
        } else if (schemaParticle.getIntMaxOccurs() > 1) {
            xmlCursor.insertComment(NbBundle.getMessage(SampleXmlUtil.class, (String)"LBL_N_to_M_repetitions", (Object)("" + n2), (Object)String.valueOf(schemaParticle.getMaxOccurs())));
        } else {
            xmlCursor.insertComment(NbBundle.getMessage(SampleXmlUtil.class, (String)"LBL_Optional"));
        }
        return n3;
    }

    private String getItemNameOrType(SchemaParticle schemaParticle, XmlCursor xmlCursor) {
        String string = null;
        string = schemaParticle.getParticleType() == 4 ? "Element (" + schemaParticle.getName().getLocalPart() + ")" : this.printParticleType(schemaParticle.getParticleType());
        return string;
    }

    private void processElement(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        SchemaLocalElement schemaLocalElement = (SchemaLocalElement)schemaParticle;
        if (this._soapEnc) {
            xmlCursor.insertElement(schemaLocalElement.getName().getLocalPart());
        } else {
            xmlCursor.insertElement(schemaLocalElement.getName().getLocalPart(), schemaLocalElement.getName().getNamespaceURI());
        }
        xmlCursor.toPrevToken();
        this.createSampleForType(schemaLocalElement.getType(), xmlCursor);
        xmlCursor.toNextToken();
    }

    private void moveToken(int n, XmlCursor xmlCursor) {
        for (int i = 0; i < Math.abs(n); ++i) {
            if (n < 0) {
                xmlCursor.toPrevToken();
                continue;
            }
            xmlCursor.toNextToken();
        }
    }

    private static final String formatQName(XmlCursor xmlCursor, QName qName) {
        XmlCursor xmlCursor2 = xmlCursor.newCursor();
        xmlCursor2.toParent();
        String string = xmlCursor2.prefixForNamespace(qName.getNamespaceURI());
        xmlCursor2.dispose();
        String string2 = string == null || string.length() == 0 ? qName.getLocalPart() : string + ":" + qName.getLocalPart();
        return string2;
    }

    private void processAttributes(SchemaType schemaType, XmlCursor xmlCursor) {
        SchemaProperty[] schemaPropertyArray;
        if (this._soapEnc && (schemaPropertyArray = schemaType.getName()) != null) {
            xmlCursor.insertAttributeWithValue(XSI_TYPE, SampleXmlUtil.formatQName(xmlCursor, (QName)schemaPropertyArray));
        }
        schemaPropertyArray = schemaType.getAttributeProperties();
        for (int i = 0; i < schemaPropertyArray.length; ++i) {
            String string;
            SchemaProperty schemaProperty = schemaPropertyArray[i];
            if (this._soapEnc) {
                if (SKIPPED_SOAP_ATTRS.contains(schemaProperty.getName())) continue;
                if (ENC_ARRAYTYPE.equals(schemaProperty.getName())) {
                    string = ((SchemaWSDLArrayType)schemaType.getAttributeModel().getAttribute(schemaProperty.getName())).getWSDLArrayType();
                    if (string == null) continue;
                    xmlCursor.insertAttributeWithValue(schemaProperty.getName(), SampleXmlUtil.formatQName(xmlCursor, string.getQName()) + string.soap11DimensionString());
                    continue;
                }
            }
            string = schemaProperty.getDefaultText();
            xmlCursor.insertAttributeWithValue(schemaProperty.getName(), string == null ? this.sampleDataForSimpleType(schemaProperty.getType()) : string);
        }
    }

    private void processSequence(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        SchemaParticle[] schemaParticleArray = schemaParticle.getParticleChildren();
        for (int i = 0; i < schemaParticleArray.length; ++i) {
            this.processParticle(schemaParticleArray[i], xmlCursor, bl);
            if (!bl || i >= schemaParticleArray.length - 1) continue;
            xmlCursor.insertChars(this.pick(WORDS));
        }
    }

    private void processChoice(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        SchemaParticle[] schemaParticleArray = schemaParticle.getParticleChildren();
        xmlCursor.insertComment("You have a CHOICE of the next " + String.valueOf(schemaParticleArray.length) + " items at this level");
        for (int i = 0; i < schemaParticleArray.length; ++i) {
            this.processParticle(schemaParticleArray[i], xmlCursor, bl);
        }
    }

    private void processAll(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        SchemaParticle[] schemaParticleArray = schemaParticle.getParticleChildren();
        for (int i = 0; i < schemaParticleArray.length; ++i) {
            this.processParticle(schemaParticleArray[i], xmlCursor, bl);
            if (!bl || i >= schemaParticleArray.length - 1) continue;
            xmlCursor.insertChars(this.pick(WORDS));
        }
    }

    private void processWildCard(SchemaParticle schemaParticle, XmlCursor xmlCursor, boolean bl) {
        xmlCursor.insertComment("You may enter ANY elements at this point");
        xmlCursor.insertElement("AnyElement");
    }

    private static QName getClosestName(SchemaType schemaType) {
        while (schemaType.getName() == null) {
            schemaType = schemaType.getBaseType();
        }
        return schemaType.getName();
    }

    private String printParticleType(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append("Schema Particle Type: ");
        switch (n) {
            case 1: {
                stringBuffer.append("ALL\n");
                break;
            }
            case 2: {
                stringBuffer.append("CHOICE\n");
                break;
            }
            case 4: {
                stringBuffer.append("ELEMENT\n");
                break;
            }
            case 3: {
                stringBuffer.append("SEQUENCE\n");
                break;
            }
            case 5: {
                stringBuffer.append("WILDCARD\n");
                break;
            }
            default: {
                stringBuffer.append("Schema Particle Type Unknown");
            }
        }
        return stringBuffer.toString();
    }

    public boolean isIgnoreOptional() {
        return this.ignoreOptional;
    }

    public void setIgnoreOptional(boolean bl) {
        this.ignoreOptional = bl;
    }
}

