/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui.wizards;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import javax.swing.Action;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathFactory;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.api.queries.VisibilityQuery;
import org.openide.cookies.OpenCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.loaders.DataFolder;
import org.openide.loaders.DataObject;
import org.openide.nodes.Children;
import org.openide.nodes.CookieSet;
import org.openide.nodes.FilterNode;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.WeakListeners;
import org.openide.util.lookup.ProxyLookup;
import org.w3c.dom.Document;
import org.w3c.dom.NodeList;

public class WsdlViewNodes {
    private static boolean isAcceptableFolder(FileObject fileObject) {
        FileObject fileObject2;
        if (!fileObject.isFolder()) {
            return false;
        }
        boolean bl = false;
        Enumeration enumeration = fileObject.getData(bl);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!WsdlViewNodes.isAcceptableFile(fileObject2)) continue;
            return true;
        }
        enumeration = fileObject.getFolders(bl);
        while (enumeration.hasMoreElements()) {
            fileObject2 = (FileObject)enumeration.nextElement();
            if (!WsdlViewNodes.isAcceptableFolder(fileObject2)) continue;
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isAcceptableFile(FileObject fileObject) {
        if (fileObject.getExt().equalsIgnoreCase("wsdl")) {
            InputStream inputStream = null;
            try {
                inputStream = fileObject.getInputStream();
                DocumentBuilder documentBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = documentBuilder.parse(inputStream);
                XPath xPath = XPathFactory.newInstance().newXPath();
                String string = "/definitions/service/port";
                NodeList nodeList = (NodeList)xPath.evaluate(string, document, XPathConstants.NODESET);
                if (nodeList.getLength() > 0) {
                    boolean bl = true;
                    return bl;
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        return false;
    }

    public static final class FileObjectCookie
    implements Node.Cookie {
        private FileObject fileObject;

        public FileObjectCookie(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public FileObject getFileObject() {
            return this.fileObject;
        }
    }

    static final class DepedentProjectFileNode
    extends FilterNode {
        private FileObject fileObject;
        private SourceGroup ownerGroup;
        private SourceGroup[] allGroups;
        private CookieSet set;

        public DepedentProjectFileNode(Node node, FileObject fileObject, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray) {
            super(node, FilterNode.Children.LEAF);
            this.fileObject = fileObject;
            this.ownerGroup = sourceGroup;
            this.allGroups = sourceGroupArray;
            this.set = new CookieSet();
            this.set.add((Node.Cookie)new FileObjectCookie(this.fileObject));
        }

        public Node.Cookie getCookie(Class clazz) {
            if (DataObject.class.isAssignableFrom(clazz) || OpenCookie.class.isAssignableFrom(clazz)) {
                return null;
            }
            Node.Cookie cookie = this.set.getCookie(clazz);
            if (cookie != null) {
                return cookie;
            }
            return super.getCookie(clazz);
        }

        public boolean canRename() {
            return false;
        }
    }

    public static final class SourceGroupsChildren
    extends Children.Keys {
        private Project ownerProject;
        private SourceGroup[] allGroups;
        private SourceGroup ownerGroup;
        private FileObject fo;

        public SourceGroupsChildren(FileObject fileObject, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray, Project project) {
            this.fo = fileObject;
            this.ownerGroup = sourceGroup;
            this.allGroups = sourceGroupArray;
            this.ownerProject = project;
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            if (object instanceof Key) {
                fileObject = ((Key)object).folder;
                Node node = null;
                if (fileObject.isFolder()) {
                    node = DataFolder.findFolder((FileObject)fileObject).getNodeDelegate();
                    if (node != null) {
                        FilterNode filterNode = new FilterNode(node, (Children)new SourceGroupsChildren(fileObject, this.ownerGroup, this.allGroups, this.ownerProject));
                        return new Node[]{filterNode};
                    }
                } else {
                    try {
                        node = DataFolder.find((FileObject)fileObject).getNodeDelegate();
                        if (node != null) {
                            DepedentProjectFileNode depedentProjectFileNode = new DepedentProjectFileNode(node, fileObject, this.ownerGroup, this.allGroups);
                            return new Node[]{depedentProjectFileNode};
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
            }
            return new Node[0];
        }

        private Collection getKeys() {
            FileObject[] fileObjectArray = this.fo.getChildren();
            ArrayList<Key> arrayList = new ArrayList<Key>(fileObjectArray.length);
            for (int i = 0; i < fileObjectArray.length; ++i) {
                if (!fileObjectArray[i].isFolder()) {
                    if (!VisibilityQuery.getDefault().isVisible(fileObjectArray[i]) || !WsdlViewNodes.isAcceptableFile(fileObjectArray[i])) continue;
                    arrayList.add(new Key(fileObjectArray[i]));
                    continue;
                }
                if (!WsdlViewNodes.isAcceptableFolder(fileObjectArray[i])) continue;
                arrayList.add(new Key(fileObjectArray[i]));
            }
            Collections.sort(arrayList, new KeyComparator());
            return arrayList;
        }

        private class KeyComparator
        implements Comparator {
            private KeyComparator() {
            }

            public int compare(Object object, Object object2) {
                FileObject fileObject = ((Key)object).getFileObject();
                FileObject fileObject2 = ((Key)object2).getFileObject();
                return fileObject.getNameExt().compareToIgnoreCase(fileObject2.getNameExt());
            }
        }

        private class Key {
            private FileObject folder;

            private Key(FileObject fileObject) {
                this.folder = fileObject;
            }

            FileObject getFileObject() {
                return this.folder;
            }
        }
    }

    public static final class SourceGroups
    extends Children.Keys {
        private Project ownerProject;
        private SourceGroup[] allGroups;

        public SourceGroups(Project project, SourceGroup[] sourceGroupArray, SourceGroup[] sourceGroupArray2) {
            this.ownerProject = project;
            this.allGroups = new SourceGroup[sourceGroupArray.length + sourceGroupArray2.length];
            System.arraycopy(sourceGroupArray, 0, this.allGroups, 0, sourceGroupArray.length);
            System.arraycopy(sourceGroupArray2, 0, this.allGroups, sourceGroupArray.length, sourceGroupArray2.length);
        }

        protected void addNotify() {
            super.addNotify();
            this.setKeys(this.getKeys());
        }

        protected void removeNotify() {
            this.setKeys(Collections.EMPTY_SET);
            super.removeNotify();
        }

        protected Node[] createNodes(Object object) {
            FileObject fileObject = null;
            SourceGroup sourceGroup = null;
            if (object instanceof SourceGroup) {
                sourceGroup = (SourceGroup)object;
                fileObject = sourceGroup.getRootFolder();
                Project project = FileOwnerQuery.getOwner((FileObject)fileObject);
                DataFolder dataFolder = DataFolder.findFolder((FileObject)fileObject);
                GroupNode groupNode = new GroupNode(this.ownerProject, project, sourceGroup, this.allGroups, DataFolder.findFolder((FileObject)fileObject));
                return new Node[]{groupNode};
            }
            return new Node[0];
        }

        private Collection getKeys() {
            return Arrays.asList(this.allGroups);
        }
    }

    static final class GroupNode
    extends FilterNode
    implements PropertyChangeListener {
        final String GROUP_NAME_PATTERN = NbBundle.getMessage(WsdlViewNodes.class, (String)"FMT_WsdlViewNodes_GroupName");
        private Project project;
        private ProjectInformation pi;
        private SourceGroup group;

        public GroupNode(Project project, Project project2, SourceGroup sourceGroup, SourceGroup[] sourceGroupArray, DataFolder dataFolder) {
            super(dataFolder.getNodeDelegate(), (Children)new SourceGroupsChildren(dataFolder.getPrimaryFile(), sourceGroup, sourceGroupArray, project), GroupNode.createLookup(project2, sourceGroup, dataFolder));
            this.project = project2;
            this.pi = ProjectUtils.getInformation((Project)this.project);
            this.group = sourceGroup;
            this.pi.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.pi));
            sourceGroup.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)sourceGroup));
        }

        public String getName() {
            return this.group.getName();
        }

        public String getDisplayName() {
            return MessageFormat.format(this.GROUP_NAME_PATTERN, this.group.getDisplayName(), this.pi.getDisplayName(), this.getOriginal().getDisplayName());
        }

        public String getShortDescription() {
            FileObject fileObject = this.group.getRootFolder();
            String string = FileUtil.getFileDisplayName((FileObject)fileObject);
            return NbBundle.getMessage(WsdlViewNodes.class, (String)"HINT_group", (Object)string);
        }

        public boolean canRename() {
            return false;
        }

        public boolean canCut() {
            return false;
        }

        public boolean canCopy() {
            return false;
        }

        public boolean canDestroy() {
            return false;
        }

        public Action[] getActions(boolean bl) {
            if (bl) {
                return super.getActions(true);
            }
            Action[] actionArray = super.getActions(false);
            return actionArray;
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("displayName".equals(string)) {
                this.fireDisplayNameChange(null, null);
            } else if ("name".equals(string)) {
                this.fireNameChange(null, null);
            } else if (!"icon".equals(string)) {
                if ("name".equals(string)) {
                    this.fireNameChange(null, null);
                } else if ("displayName".equals(string)) {
                    this.fireDisplayNameChange(null, null);
                } else if (!"icon".equals(string)) {
                    if ("rootFolder".equals(string)) {
                        this.fireNameChange(null, null);
                        this.fireDisplayNameChange(null, null);
                        this.fireShortDescriptionChange(null, null);
                    } else assert (false) : "Attempt to fire an unsupported property change event from " + this.pi.getClass().getName() + ": " + string;
                }
            }
        }

        private static Lookup createLookup(Project project, SourceGroup sourceGroup, DataFolder dataFolder) {
            return new ProxyLookup(new Lookup[]{dataFolder.getNodeDelegate().getLookup(), project.getLookup()});
        }
    }
}

