/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.test.ui.wizards;

import java.awt.Component;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.JComponent;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.api.project.Project;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseConstants;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseNameVisualPanel;
import org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseWsdlVisualPanel;
import org.netbeans.modules.compapp.test.wsdl.WsdlSupport;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.WizardDescriptor;
import org.openide.WizardValidationException;
import org.openide.filesystems.FileObject;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;

public class NewTestcaseWsdlWizardPanel
implements WizardDescriptor.ValidatingPanel,
NewTestcaseConstants {
    private static final Logger mLog = Logger.getLogger("org.netbeans.modules.compapp.test.ui.wizards.NewTestcaseWsdlWizardPanel");
    private NewTestcaseWsdlVisualPanel mComponent;
    private Project mProject;
    private FileObject mWsdlFile;
    private WsdlSupport mWsdlSupport;
    private WizardDescriptor wiz;
    private final Set<ChangeListener> listeners = new HashSet<ChangeListener>(1);

    public NewTestcaseWsdlWizardPanel(Project project) {
        this.mProject = project;
    }

    public Component getComponent() {
        if (this.mComponent == null) {
            this.mComponent = new NewTestcaseWsdlVisualPanel(this.mProject, this);
        }
        return this.mComponent;
    }

    public HelpCtx getHelp() {
        return HelpCtx.DEFAULT_HELP;
    }

    public boolean isValid() {
        if (this.mComponent.getSelectedWsdlFile() == null) {
            this.wiz.putProperty("WizardPanel_errorMessage", (Object)NbBundle.getMessage(NewTestcaseNameVisualPanel.class, (String)"LBL_One_WSDL_document_must_be_selected"));
            return false;
        }
        this.wiz.putProperty("WizardPanel_errorMessage", (Object)"");
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeChangeListener(ChangeListener changeListener) {
        Set<ChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(changeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void fireChangeEvent() {
        Iterator<ChangeListener> iterator;
        Object object = this.listeners;
        synchronized (object) {
            iterator = new HashSet<ChangeListener>(this.listeners).iterator();
        }
        object = new ChangeEvent(this);
        while (iterator.hasNext()) {
            iterator.next().stateChanged((ChangeEvent)object);
        }
    }

    public void readSettings(Object object) {
        this.wiz = (WizardDescriptor)object;
    }

    public void storeSettings(Object object) {
        try {
            FileObject fileObject = this.mComponent.getSelectedWsdlFile();
            if (fileObject == this.mWsdlFile) {
                return;
            }
            this.mWsdlFile = fileObject;
            WsdlSupport wsdlSupport = null;
            if (fileObject != null) {
                wsdlSupport = new WsdlSupport(fileObject);
            }
            this.mWsdlSupport = wsdlSupport;
            this.wiz = (WizardDescriptor)object;
            this.wiz.putProperty("WsdlSupport", (Object)wsdlSupport);
            mLog.info("Writing WsdlSupport to WizardDescriptor");
        }
        catch (Exception exception) {
            ErrorManager.getDefault().notify((Throwable)exception);
        }
    }

    public void validate() throws WizardValidationException {
        if (this.mWsdlSupport != null) {
            if (this.mWsdlSupport.getWsdlSupportError().length() != 0) {
                String string = this.mWsdlSupport.getWsdlSupportError();
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string, 0);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
                String string2 = NbBundle.getMessage(NewTestcaseWsdlWizardPanel.class, (String)"MSG_Error_Load_WSDL");
                throw new WizardValidationException((JComponent)this.mComponent.getWsdlTreeView(), string2, string2);
            }
            this.mWsdlSupport.setWsdlSupportError("");
        }
    }
}

