/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.nio.charset.UnsupportedCharsetException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.SwingUtilities;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.api.project.ant.AntArtifact;
import org.netbeans.api.queries.FileEncodingQuery;
import org.netbeans.modules.compapp.projects.jbi.CasaHelper;
import org.netbeans.modules.compapp.projects.jbi.ComponentInfoGenerator;
import org.netbeans.modules.compapp.projects.jbi.JbiActionProvider;
import org.netbeans.modules.compapp.projects.jbi.JbiProjectOperations;
import org.netbeans.modules.compapp.projects.jbi.JbiSubprojectProvider;
import org.netbeans.modules.compapp.projects.jbi.MigrationHelper;
import org.netbeans.modules.compapp.projects.jbi.ProjectPropertyProvider;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.netbeans.modules.compapp.projects.jbi.api.JbiProjectHelper;
import org.netbeans.modules.compapp.projects.jbi.queries.JbiProjectEncodingQueryImpl;
import org.netbeans.modules.compapp.projects.jbi.ui.JbiCustomizerProvider;
import org.netbeans.modules.compapp.projects.jbi.ui.JbiLogicalViewProvider;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.modules.sun.manager.jbi.management.model.ComponentInformationParser;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.netbeans.spi.java.project.support.ui.BrokenReferencesSupport;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.ant.AntArtifactProvider;
import org.netbeans.spi.project.support.ant.AntBasedProjectType;
import org.netbeans.spi.project.support.ant.AntProjectEvent;
import org.netbeans.spi.project.support.ant.AntProjectHelper;
import org.netbeans.spi.project.support.ant.AntProjectListener;
import org.netbeans.spi.project.support.ant.EditableProperties;
import org.netbeans.spi.project.support.ant.GeneratedFilesHelper;
import org.netbeans.spi.project.support.ant.ProjectXmlSavedHook;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.netbeans.spi.project.support.ant.ReferenceHelper;
import org.netbeans.spi.project.support.ant.SourcesHelper;
import org.netbeans.spi.project.ui.PrivilegedTemplates;
import org.netbeans.spi.project.ui.ProjectOpenedHook;
import org.netbeans.spi.project.ui.RecommendedTemplates;
import org.netbeans.spi.queries.FileBuiltQueryImplementation;
import org.openide.ErrorManager;
import org.openide.filesystems.FileChangeAdapter;
import org.openide.filesystems.FileChangeListener;
import org.openide.filesystems.FileEvent;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.InstalledFileLocator;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;
import org.openide.util.lookup.Lookups;
import org.openide.windows.TopComponent;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public final class JbiProject
implements Project,
AntProjectListener,
ProjectPropertyProvider {
    private static final Icon PROJECT_ICON = new ImageIcon(Utilities.loadImage((String)"org/netbeans/modules/compapp/projects/jbi/ui/resources/composite_application_project.png"));
    public static final String SOURCES_TYPE_JBI = "JBI";
    public static final String JAVA_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-junit.jar";
    public static final String ENTERPRISE_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-j2ee-sun-appsrv.jar";
    public static final String XML_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-xml-wsdl-extensions.jar";
    public static final String IDE_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-xml-wsdl-model.jar";
    public static final String SOA_MODULE_INSTALL_NAME = "modules/org-netbeans-modules-compapp-projects-jbi.jar";
    public static final String JAVA_MODULE_INSTALL_CBN = "org.netbeans.modules.junit";
    public static final String ENTERPRISE_MODULE_INSTALL_CBN = "org.netbeans.modules.j2ee.sun.api";
    public static final String XML_MODULE_INSTALL_CBN = "org.netbeans.modules.xml.wsdl.model.extensions";
    public static final String IDE_MODULE_INSTALL_CBN = "org.netbeans.modules.xml.wsdl.model";
    public static final String SOA_MODULE_INSTALL_CBN = "org.netbeans.modules.compapp.projects.jbi";
    public static final String JAVA_MODULE_INSTALL_DIR = "java.module.install.dir";
    public static final String ENTERPRISE_MODULE_INSTALL_DIR = "enterprise.module.install.dir";
    public static final String XML_MODULE_INSTALL_DIR = "xml.module.install.dir";
    public static final String IDE_MODULE_INSTALL_DIR = "ide.module.install.dir";
    public static final String SOA_MODULE_INSTALL_DIR = "soa.module.install.dir";
    public static final String COMPONENT_INFO_FILE_NAME = "ComponentInformation.xml";
    public static final String BINDING_COMPONENT_INFO_FILE_NAME = "BindingComponentInformation.xml";
    public static final String ASSEMBLY_INFO_FILE_NAME = "AssemblyInformation.xml";
    private final AntProjectHelper helper;
    private final PropertyEvaluator eval;
    private final ReferenceHelper refHelper;
    private final GeneratedFilesHelper genFilesHelper;
    private final Lookup lookup;
    private AntBasedProjectType abpt;
    private JbiLogicalViewProvider lvp;
    private FileChangeListener casaFileListener;
    private static final Logger LOG = Logger.getLogger(JbiProject.class.getName());

    public JbiProject(AntProjectHelper antProjectHelper, AntBasedProjectType antBasedProjectType) throws IOException {
        this.helper = antProjectHelper;
        this.abpt = antBasedProjectType;
        this.eval = this.createEvaluator();
        AuxiliaryConfiguration auxiliaryConfiguration = antProjectHelper.createAuxiliaryConfiguration();
        this.refHelper = new ReferenceHelper(antProjectHelper, auxiliaryConfiguration, antProjectHelper.getStandardPropertyEvaluator());
        this.genFilesHelper = new GeneratedFilesHelper(antProjectHelper);
        this.lookup = this.createLookup(auxiliaryConfiguration);
        antProjectHelper.addAntProjectListener((AntProjectListener)this);
    }

    public AntBasedProjectType getAntBasedProjectType() {
        return this.abpt;
    }

    public FileObject getProjectDirectory() {
        return this.helper.getProjectDirectory();
    }

    public String toString() {
        return "JbiProject[" + this.getProjectDirectory() + "]";
    }

    private PropertyEvaluator createEvaluator() {
        return this.helper.getStandardPropertyEvaluator();
    }

    public PropertyEvaluator evaluator() {
        return this.eval;
    }

    public ReferenceHelper getReferenceHelper() {
        return this.refHelper;
    }

    public Lookup getLookup() {
        return this.lookup;
    }

    public AntProjectHelper getAntProjectHelper() {
        return this.helper;
    }

    private Lookup createLookup(AuxiliaryConfiguration auxiliaryConfiguration) {
        JbiSubprojectProvider jbiSubprojectProvider = new JbiSubprojectProvider(this.refHelper.createSubprojectProvider());
        FileBuiltQueryImplementation fileBuiltQueryImplementation = this.helper.createGlobFileBuiltQuery(this.helper.getStandardPropertyEvaluator(), new String[]{"${src.dir}/*.java"}, new String[]{"${build.classes.dir}/*.class"});
        final SourcesHelper sourcesHelper = new SourcesHelper(this.helper, this.evaluator());
        String string = NbBundle.getMessage(JbiCustomizerProvider.class, (String)"LBL_Node_EJBModule");
        String string2 = NbBundle.getMessage(JbiCustomizerProvider.class, (String)"LBL_Node_Sources");
        sourcesHelper.addPrincipalSourceRoot("${source.root}", string, null, null);
        sourcesHelper.addPrincipalSourceRoot("${src.dir}", string2, null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", SOURCES_TYPE_JBI, string2, null, null);
        sourcesHelper.addTypedSourceRoot("${src.dir}", "java", string2, null, null);
        ProjectManager.mutex().postWriteRequest(new Runnable(){

            public void run() {
                sourcesHelper.registerExternalRoots(0);
            }
        });
        this.casaFileListener = new FileChangeAdapter(){

            public void fileChanged(FileEvent fileEvent) {
                this.refreshRootNode();
            }

            public void fileDeleted(FileEvent fileEvent) {
                this.refreshRootNode();
            }

            private void refreshRootNode() {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        JbiProject.this.lvp.refreshRootNode();
                    }
                });
            }
        };
        Object[] objectArray = new Object[21];
        objectArray[0] = this;
        objectArray[1] = new Info();
        objectArray[2] = auxiliaryConfiguration;
        objectArray[3] = this.helper.createCacheDirectoryProvider();
        objectArray[4] = this.helper;
        objectArray[5] = jbiSubprojectProvider;
        objectArray[6] = new JbiActionProvider(this, this.helper, this.refHelper);
        this.lvp = new JbiLogicalViewProvider(this, this.helper, this.evaluator(), jbiSubprojectProvider, this.refHelper);
        objectArray[7] = this.lvp;
        objectArray[8] = new JbiCustomizerProvider(this, this.helper, this.refHelper);
        objectArray[9] = new AntArtifactProviderImpl();
        objectArray[10] = new ProjectXmlSavedHookImpl();
        objectArray[11] = new ProjectOpenedHookImpl();
        objectArray[12] = new JbiProjectOperations(this);
        objectArray[13] = new HashSet();
        objectArray[14] = fileBuiltQueryImplementation;
        objectArray[15] = new RecommendedTemplatesImpl();
        objectArray[16] = new JbiProjectEncodingQueryImpl(this.evaluator());
        objectArray[17] = this.refHelper;
        objectArray[18] = sourcesHelper.createSources();
        objectArray[19] = this.casaFileListener;
        objectArray[20] = this.helper.createSharabilityQuery(this.evaluator(), new String[]{"${source.root}"}, new String[]{"${build.dir}", "${dist.dir}", "${test.results.dir}", "${src.build.dir}"});
        return Lookups.fixed((Object[])objectArray);
    }

    public void configurationXmlChanged(AntProjectEvent antProjectEvent) {
        if (antProjectEvent.getPath().equals("nbproject/project.xml")) {
            Info info = (Info)this.getLookup().lookup(ProjectInformation.class);
            info.firePropertyChange("name");
            info.firePropertyChange("displayName");
        }
    }

    public void propertiesChanged(AntProjectEvent antProjectEvent) {
        if (this.lvp != null) {
            this.lvp.refreshRootNode();
        }
    }

    public String getBuildXmlName() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("buildfile");
        return string == null ? "build.xml" : string;
    }

    public FileObject getTestDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("test.dir");
        try {
            return this.helper.resolveFileObject(string);
        }
        catch (Exception exception) {
            return null;
        }
    }

    public FileObject createTestDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("test.dir");
        if (this.helper.resolveFileObject(string) == null) {
            try {
                this.getProjectDirectory().createFolder(string);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        return this.helper.resolveFileObject(string);
    }

    public FileObject getTestResultsDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("test.results.dir");
        return this.helper.resolveFileObject(string);
    }

    FileObject getSourceDirectory() {
        String string = this.helper.getStandardPropertyEvaluator().getProperty("src.dir");
        return string == null ? null : this.helper.resolveFileObject(string);
    }

    public String getName() {
        return (String)ProjectManager.mutex().readAccess(new Mutex.Action(){

            public Object run() {
                Element element = JbiProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-jbi/1", "name");
                if (nodeList.getLength() == 1 && (nodeList = nodeList.item(0).getChildNodes()).getLength() == 1 && nodeList.item(0).getNodeType() == 3) {
                    return ((Text)nodeList.item(0)).getNodeValue();
                }
                return "???";
            }
        });
    }

    public void setName(final String string) {
        ProjectManager.mutex().writeAccess(new Mutex.Action(){

            public Object run() {
                Element element;
                Element element2 = JbiProject.this.helper.getPrimaryConfigurationData(true);
                NodeList nodeList = element2.getElementsByTagNameNS("http://www.netbeans.org/ns/j2ee-jbi/1", "name");
                if (nodeList.getLength() == 1) {
                    element = (Element)nodeList.item(0);
                    NodeList nodeList2 = element.getChildNodes();
                    while (nodeList2.getLength() > 0) {
                        element.removeChild(nodeList2.item(0));
                    }
                } else {
                    element = element2.getOwnerDocument().createElementNS("http://www.netbeans.org/ns/j2ee-jbi/1", "name");
                    element2.insertBefore(element, element2.getChildNodes().item(0));
                }
                element.appendChild(element2.getOwnerDocument().createTextNode(string));
                JbiProject.this.helper.putPrimaryConfigurationData(element2, true);
                return null;
            }
        });
    }

    public JbiProjectProperties getProjectProperties() {
        return new JbiProjectProperties(this, this.helper, this.refHelper);
    }

    private static final class RecommendedTemplatesImpl
    implements RecommendedTemplates,
    PrivilegedTemplates {
        private static final String[] TYPES = new String[]{"XML", "simple-files"};
        private static final String[] PRIVILEGED_NAMES = new String[]{"Templates/XML/WSDL.wsdl", "Templates/XML/XmlSchema.xsd", "Templates/XML/retrieveSchemaResource", "Templates/XML/retrieveWSDLResource"};

        private RecommendedTemplatesImpl() {
        }

        public String[] getRecommendedTypes() {
            return TYPES;
        }

        public String[] getPrivilegedTemplates() {
            return PRIVILEGED_NAMES;
        }
    }

    private final class AntArtifactProviderImpl
    implements AntArtifactProvider {
        private AntArtifactProviderImpl() {
        }

        public AntArtifact[] getBuildArtifacts() {
            return new AntArtifact[]{JbiProject.this.helper.createSimpleAntArtifact("CAPS.au", "dist.jar", JbiProject.this.helper.getStandardPropertyEvaluator(), "dist", "clean")};
        }
    }

    private final class ProjectOpenedHookImpl
    extends ProjectOpenedHook {
        ProjectOpenedHookImpl() {
        }

        protected void projectOpened() {
            String string;
            try {
                JbiProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", JbiProject.class.getResource("resources/build-impl.xsl"), true);
                JbiProject.this.genFilesHelper.refreshBuildScript(JbiProject.this.getBuildXmlName(), JbiProject.class.getResource("resources/build.xsl"), true);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify(1, (Throwable)iOException);
            }
            ProjectManager.mutex().writeAccess(new Mutex.Action(){

                public Object run() {
                    String string = JbiProject.this.getName();
                    FileObject fileObject = JbiProject.this.getProjectDirectory();
                    String string2 = FileUtil.toFile((FileObject)fileObject).getAbsolutePath() + File.separator + "src" + File.separator + "conf";
                    ProjectOpenedHookImpl.this.updateComponentDocuments(string2);
                    JbiProjectProperties jbiProjectProperties = JbiProject.this.getProjectProperties();
                    try {
                        jbiProjectProperties.fixComponentTargetList();
                    }
                    catch (Exception exception) {
                        return null;
                    }
                    String string3 = JbiProject.this.getProjectDirectory().getPath();
                    String string4 = string3 + File.separator + JbiProject.this.helper.getStandardPropertyEvaluator().getProperty("source.root");
                    String string5 = JbiProjectHelper.getJbiProjectName(JbiProject.this);
                    MigrationHelper.migrateCasaWSDL(string4, string5);
                    EditableProperties editableProperties = JbiProject.this.helper.getProperties("nbproject/project.properties");
                    MigrationHelper.migrateCompAppProperties(string3, editableProperties);
                    if (editableProperties.getProperty("source.encoding") == null) {
                        editableProperties.setProperty("source.encoding", FileEncodingQuery.getDefaultEncoding().name());
                    }
                    JbiProject.this.helper.putProperties("nbproject/project.properties", editableProperties);
                    EditableProperties editableProperties2 = JbiProject.this.helper.getProperties("nbproject/private/private.properties");
                    editableProperties2.setProperty("netbeans.user", System.getProperty("netbeans.user"));
                    InstalledFileLocator installedFileLocator = InstalledFileLocator.getDefault();
                    File file = installedFileLocator.locate(JbiProject.SOA_MODULE_INSTALL_NAME, JbiProject.SOA_MODULE_INSTALL_CBN, false);
                    if (file != null) {
                        editableProperties2.setProperty(JbiProject.SOA_MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    if ((file = installedFileLocator.locate(JbiProject.JAVA_MODULE_INSTALL_NAME, JbiProject.JAVA_MODULE_INSTALL_CBN, false)) != null) {
                        editableProperties2.setProperty(JbiProject.JAVA_MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    if ((file = installedFileLocator.locate(JbiProject.XML_MODULE_INSTALL_NAME, JbiProject.XML_MODULE_INSTALL_CBN, false)) != null) {
                        editableProperties2.setProperty(JbiProject.XML_MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    if ((file = installedFileLocator.locate(JbiProject.IDE_MODULE_INSTALL_NAME, JbiProject.IDE_MODULE_INSTALL_CBN, false)) != null) {
                        editableProperties2.setProperty(JbiProject.IDE_MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    if ((file = installedFileLocator.locate(JbiProject.ENTERPRISE_MODULE_INSTALL_NAME, JbiProject.ENTERPRISE_MODULE_INSTALL_CBN, false)) != null) {
                        editableProperties2.setProperty(JbiProject.ENTERPRISE_MODULE_INSTALL_DIR, file.getParentFile().getPath());
                    }
                    JbiProject.this.helper.putProperties("nbproject/private/private.properties", editableProperties2);
                    try {
                        ProjectManager.getDefault().saveProject((Project)JbiProject.this);
                    }
                    catch (IOException iOException) {
                        ErrorManager.getDefault().notify((Throwable)iOException);
                    }
                    CasaHelper.getCasaFileObject(JbiProject.this, true);
                    JbiProject.this.getProjectProperties().saveAssemblyInfo();
                    CasaHelper.cleanupLocks(JbiProject.this);
                    return null;
                }
            });
            if (JbiLogicalViewProvider.hasBrokenLinks(JbiProject.this.helper, JbiProject.this.refHelper)) {
                BrokenReferencesSupport.showAlert();
            }
            if ((string = JbiProject.this.eval.getProperty("source.encoding")) != null) {
                try {
                    Charset charset = Charset.forName(string);
                }
                catch (IllegalCharsetNameException illegalCharsetNameException) {
                    LOG.warning("Illegal charset: " + string + " in project: " + FileUtil.getFileDisplayName((FileObject)JbiProject.this.getProjectDirectory()));
                }
                catch (UnsupportedCharsetException unsupportedCharsetException) {
                    LOG.warning("Unsupported charset: " + string + " in project: " + FileUtil.getFileDisplayName((FileObject)JbiProject.this.getProjectDirectory()));
                }
            }
        }

        private void updateComponentDocuments(String string) {
            try {
                Object object;
                Object object22;
                File file = new File(string + File.separator + JbiProject.COMPONENT_INFO_FILE_NAME);
                List list = ComponentInformationParser.parse((File)file);
                File file2 = new File(string + File.separator + JbiProject.BINDING_COMPONENT_INFO_FILE_NAME);
                List list2 = ComponentInformationParser.parse((File)file2);
                block2: for (Object object22 : list2) {
                    object = object22.getName();
                    List list3 = object22.getNamespaces();
                    for (Object object3 : list) {
                        if (!object3.getName().equals(object)) continue;
                        object3.setNamespaces(list3);
                        continue block2;
                    }
                }
                JbiDefaultComponentInfo jbiDefaultComponentInfo = JbiDefaultComponentInfo.getJbiDefaultComponentInfo();
                object22 = jbiDefaultComponentInfo.getComponentHash();
                object = new ArrayList();
                boolean bl = false;
                for (Object object3 : object22.keySet()) {
                    JBIComponentStatus jBIComponentStatus = (JBIComponentStatus)object22.get(object3);
                    boolean bl2 = false;
                    for (JBIComponentStatus jBIComponentStatus2 : list) {
                        if (!jBIComponentStatus2.getName().equals(object3)) continue;
                        for (String string2 : jBIComponentStatus.getNamespaces()) {
                            if (!jBIComponentStatus2.addNamespace(string2)) continue;
                            bl = true;
                        }
                        bl2 = true;
                        break;
                    }
                    if (bl2) continue;
                    object.add(jBIComponentStatus);
                }
                if (object != null && object.size() > 0 || bl) {
                    ArrayList arrayList = new ArrayList();
                    arrayList.addAll(list);
                    arrayList.addAll(object);
                    new ComponentInfoGenerator(string, arrayList).doIt();
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        }

        protected void projectClosed() {
            Set set = (Set)JbiProject.this.getLookup().lookup(HashSet.class);
            if (set != null) {
                for (Object e : set) {
                    if (!(e instanceof TopComponent)) continue;
                    ((TopComponent)e).close();
                }
            }
            try {
                ProjectManager.getDefault().saveProject((Project)JbiProject.this);
            }
            catch (IOException iOException) {
                ErrorManager.getDefault().notify((Throwable)iOException);
            }
        }
    }

    private final class ProjectXmlSavedHookImpl
    extends ProjectXmlSavedHook {
        ProjectXmlSavedHookImpl() {
        }

        protected void projectXmlSaved() throws IOException {
            JbiProject.this.genFilesHelper.refreshBuildScript("nbproject/build-impl.xml", JbiProject.class.getResource("resources/build-impl.xsl"), false);
            JbiProject.this.genFilesHelper.refreshBuildScript(JbiProject.this.getBuildXmlName(), JbiProject.class.getResource("resources/build.xsl"), false);
        }
    }

    private final class Info
    implements ProjectInformation {
        private final PropertyChangeSupport pcs = new PropertyChangeSupport(this);

        Info() {
        }

        void firePropertyChange(String string) {
            this.pcs.firePropertyChange(string, null, null);
        }

        public String getName() {
            return JbiProject.this.getName();
        }

        public String getDisplayName() {
            return JbiProject.this.getName();
        }

        public Icon getIcon() {
            return PROJECT_ICON;
        }

        public Project getProject() {
            return JbiProject.this;
        }

        public void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.addPropertyChangeListener(propertyChangeListener);
        }

        public void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
            this.pcs.removePropertyChangeListener(propertyChangeListener);
        }
    }
}

