/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.projects.jbi;

import java.io.File;
import java.io.Serializable;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import org.netbeans.modules.compapp.projects.jbi.api.JbiDefaultComponentInfo;
import org.netbeans.modules.compapp.projects.jbi.descriptor.XmlUtil;
import org.netbeans.modules.sun.manager.jbi.management.model.JBIComponentStatus;
import org.w3c.dom.DOMException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ComponentInfoGenerator
implements Serializable {
    private String confDir;
    private List<JBIComponentStatus> compList;

    public ComponentInfoGenerator(String string) {
        this(string, JbiDefaultComponentInfo.getJbiDefaultComponentInfo().getComponentList());
    }

    public ComponentInfoGenerator(String string, List<JBIComponentStatus> list) {
        this.confDir = string;
        this.compList = list;
    }

    public void doIt() {
        try {
            Document document = this.buildComponentDOMTree();
            this.writeTo(this.confDir, "ComponentInformation.xml", document);
            Document document2 = this.buildBindingComponentDOMTree();
            this.writeTo(this.confDir, "BindingComponentInformation.xml", document2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private Document buildComponentDOMTree() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component-info-list");
        document.appendChild(element);
        for (JBIComponentStatus jBIComponentStatus : this.compList) {
            String string = jBIComponentStatus.getType();
            if (!string.equalsIgnoreCase("Binding") && !string.equalsIgnoreCase("Engine") || jBIComponentStatus.getName().startsWith("com.sun.")) continue;
            Element element2 = this.createComponentInfoNode(document, jBIComponentStatus);
            element.appendChild(element2);
        }
        return document;
    }

    private Document buildBindingComponentDOMTree() throws ParserConfigurationException {
        DocumentBuilderFactory documentBuilderFactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder documentBuilder = documentBuilderFactory.newDocumentBuilder();
        Document document = documentBuilder.newDocument();
        Element element = document.createElement("component-info-list");
        document.appendChild(element);
        for (JBIComponentStatus jBIComponentStatus : this.compList) {
            String string = jBIComponentStatus.getType();
            List list = jBIComponentStatus.getNamespaces();
            if (string == null || !string.equalsIgnoreCase("Binding") || list == null || list.size() <= 0 || jBIComponentStatus.getName().startsWith("com.sun.")) continue;
            Element element2 = this.createComponentInfoNode(document, jBIComponentStatus);
            for (int i = 0; i < list.size(); ++i) {
                String string2 = (String)list.get(i);
                if (string2 == null || string2.trim().equals("")) continue;
                Element element3 = document.createElement("xmlns");
                Text text = document.createTextNode(string2);
                element3.appendChild(text);
                element2.appendChild(element3);
            }
            element.appendChild(element2);
        }
        return document;
    }

    private Element createComponentInfoNode(Document document, JBIComponentStatus jBIComponentStatus) throws DOMException {
        String string = jBIComponentStatus.getName();
        Element element = document.createElement("component-info");
        Element element2 = document.createElement("description");
        Text text = document.createTextNode(jBIComponentStatus.getDescription());
        element2.appendChild(text);
        element.appendChild(element2);
        Element element3 = document.createElement("name");
        Text text2 = document.createTextNode(string);
        element3.appendChild(text2);
        element.appendChild(element3);
        Element element4 = document.createElement("state");
        Text text3 = document.createTextNode(jBIComponentStatus.getState());
        element4.appendChild(text3);
        element.appendChild(element4);
        Element element5 = document.createElement("type");
        Text text4 = document.createTextNode(jBIComponentStatus.getType());
        element5.appendChild(text4);
        element.appendChild(element5);
        return element;
    }

    private void writeTo(String string, String string2, Document document) throws TransformerConfigurationException, TransformerException, Exception {
        File file = new File(string);
        if (!file.isDirectory() || !file.exists()) {
            throw new Exception("Directory Path: " + string + " is invalid.");
        }
        String string3 = file.getAbsolutePath() + File.separator + string2;
        XmlUtil.writeToFile(string3, document);
    }
}

