/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.logging.Logger;
import java.util.zip.ZipFile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectInformation;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.compapp.javaee.codegen.model.EndpointCfg;
import org.netbeans.modules.compapp.javaee.codegen.model.JavaEEProject;
import org.netbeans.modules.compapp.javaee.util.EndpointCfgReaderWriter;
import org.netbeans.modules.compapp.javaee.util.JavaEEProjectFactory;
import org.netbeans.modules.compapp.projects.jbi.JbiProject;
import org.netbeans.modules.compapp.projects.jbi.ui.customizer.JbiProjectProperties;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ProjectUtil {
    public static final String DEPLOY_THRU_CA = ".deployThruCa";
    private static final String CONFIG_DIR = "src/conf/";
    private static final String PROJECT_PROP_FILE = "nbproject/project.properties";
    private static final String JAVA_EE_CONFIG_FILE = "javaee_config.properties";
    private static final String PROP_JAR_NAME = "jar.name";
    private static final String PROP_WAR_NAME = "war.name";
    private static final String PROP_DIST_DIR = "dist.dir";
    private static final String ENT_PROJ = "earproject";
    private static final String EJB_PROJ = "ejbjarproject";
    private static final String WEB_PROJ = "web.project";
    private static final Logger log = Logger.getLogger(ProjectUtil.class.getName());

    private ProjectUtil() {
    }

    public static Project getProject(String string) throws IOException {
        Project project = null;
        File file = new File(string);
        FileObject fileObject = FileUtil.toFileObject((File)FileUtil.normalizeFile((File)file));
        try {
            project = ProjectManager.getDefault().findProject(fileObject);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return project;
    }

    public static String getProjectBaseDir(Project project) {
        File file = FileUtil.toFile((FileObject)project.getProjectDirectory());
        return file.getPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectJarName(Project project) throws IOException, FileNotFoundException {
        String string = null;
        String string2 = project.getProjectDirectory().getPath() + File.separator + PROJECT_PROP_FILE;
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string2);
        try {
            properties.load(fileInputStream);
            string = properties.getProperty(PROP_JAR_NAME);
            if (string == null) {
                string = properties.getProperty(PROP_WAR_NAME);
            }
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getProjectJarPath(Project project) throws IOException, FileNotFoundException {
        String string = null;
        String string2 = null;
        String string3 = project.getProjectDirectory().getPath();
        String string4 = string3 + File.separator + PROJECT_PROP_FILE;
        Properties properties = new Properties();
        FileInputStream fileInputStream = new FileInputStream(string4);
        try {
            properties.load(fileInputStream);
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        string = properties.getProperty(PROP_JAR_NAME);
        if (string == null) {
            string = properties.getProperty(PROP_WAR_NAME);
        }
        string2 = properties.getProperty(PROP_DIST_DIR);
        StringBuffer stringBuffer = new StringBuffer(string3);
        stringBuffer.append(File.separator);
        stringBuffer.append(string2);
        stringBuffer.append(File.separator);
        stringBuffer.append(string);
        return stringBuffer.toString();
    }

    public static Set getSubprojects(Project project) {
        HashSet hashSet = null;
        SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
        hashSet = subprojectProvider != null ? subprojectProvider.getSubprojects() : new HashSet();
        return hashSet;
    }

    public static Set getSubprojects(String string) throws IOException {
        Set set = null;
        Project project = null;
        project = ProjectUtil.getProject(string);
        if (project != null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (subprojectProvider != null) {
                set = subprojectProvider.getSubprojects();
            }
        } else {
            set = new HashSet();
        }
        return set;
    }

    public static List<String> getSubprojectsBaseDir(String string) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Project project = null;
        Set set = null;
        SubprojectProvider subprojectProvider = null;
        project = ProjectUtil.getProject(string);
        if (project != null && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            set = subprojectProvider.getSubprojects();
            for (Project project2 : set) {
                if (!ProjectUtil.isJavaEEProject(project2)) continue;
                String string2 = project2.getProjectDirectory().getPath();
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static List<JavaEEProject> getSubJavaEEProjects(String string) throws IOException {
        ArrayList<JavaEEProject> arrayList = new ArrayList<JavaEEProject>();
        Set set = null;
        Set set2 = null;
        Iterator iterator = null;
        Iterator iterator2 = null;
        Project project = null;
        Project project22 = null;
        ProjectInformation projectInformation = null;
        String string2 = null;
        String string3 = null;
        Project project32 = null;
        JavaEEProject javaEEProject = null;
        JavaEEProject javaEEProject2 = null;
        String string4 = null;
        boolean bl = true;
        SubprojectProvider subprojectProvider = null;
        SubprojectProvider subprojectProvider2 = null;
        project = ProjectUtil.getProject(string);
        if (project != null) {
            subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            JbiProject jbiProject = (JbiProject)project;
            Properties properties = ProjectUtil.getJavaEECustomProperty(jbiProject);
            if (subprojectProvider != null) {
                set = subprojectProvider.getSubprojects();
                for (Project project22 : set) {
                    if (!ProjectUtil.isJavaEEProject(project22)) continue;
                    bl = true;
                    projectInformation = (ProjectInformation)project22.getLookup().lookup(ProjectInformation.class);
                    if (projectInformation != null && (string3 = properties.getProperty(string2 = projectInformation.getName())) != null) {
                        bl = Boolean.valueOf(string3);
                    }
                    string4 = ProjectUtil.getProjectJarPath(project22);
                    javaEEProject = JavaEEProjectFactory.getProject(string4);
                    javaEEProject.isDeployThruCA(bl);
                    arrayList.add(javaEEProject);
                    subprojectProvider2 = (SubprojectProvider)project22.getLookup().lookup(SubprojectProvider.class);
                    if (subprojectProvider2 == null) continue;
                    set2 = subprojectProvider2.getSubprojects();
                    for (Project project32 : set2) {
                        javaEEProject2 = JavaEEProjectFactory.getProject(ProjectUtil.getProjectJarPath(project32));
                        javaEEProject.addSubproject(javaEEProject2);
                    }
                }
            }
        }
        return arrayList;
    }

    public static JavaEEProject getJavaEEProject(String string, String string2, String string3, String string4) {
        JavaEEProject javaEEProject = JavaEEProjectFactory.getProject(string2);
        Properties properties = ProjectUtil.readProperties(string3 + JAVA_EE_CONFIG_FILE);
        String string5 = properties.getProperty(string + DEPLOY_THRU_CA);
        boolean bl = true;
        if (string5 != null) {
            bl = Boolean.valueOf(string5);
        }
        javaEEProject.isDeployThruCA(bl);
        javaEEProject.setResourceFolder(string4);
        return javaEEProject;
    }

    public static String normalizePath(String string) {
        String string2 = null;
        if (string == null) {
            return string;
        }
        string2 = string.replaceAll("\\\\", "/");
        return string2;
    }

    public static List<String> getSubJavaEEJarPath(String string, boolean bl) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        Set set = null;
        Iterator iterator = null;
        Project project = null;
        Project project22 = null;
        String string2 = null;
        SubprojectProvider subprojectProvider = null;
        project = ProjectUtil.getProject(string);
        if (project != null && (subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class)) != null) {
            set = subprojectProvider.getSubprojects();
            for (Project project22 : set) {
                if (!ProjectUtil.isJavaEEProject(project22)) continue;
                string2 = ProjectUtil.getProjectJarPath(project22);
                if (bl) {
                    string2 = ProjectUtil.normalizePath(string2);
                }
                arrayList.add(string2);
            }
        }
        return arrayList;
    }

    public static boolean isJavaEEProject(Project project) {
        boolean bl = false;
        String string = project.getClass().getName();
        if (string.toLowerCase().indexOf(ENT_PROJ) > -1) {
            bl = true;
        } else if (string.toLowerCase().indexOf(EJB_PROJ) > -1) {
            bl = true;
        } else if (string.toLowerCase().indexOf(WEB_PROJ) > -1) {
            bl = true;
        }
        return bl;
    }

    private static String getJavaEEConfigFile(JbiProjectProperties jbiProjectProperties, FileObject fileObject) {
        String string = null;
        List list = (List)jbiProjectProperties.get("meta.inf");
        if (list == null || list.size() < 1) {
            return string;
        }
        File file = FileUtil.toFile((FileObject)fileObject);
        String string2 = file.getPath() + File.separator;
        string = string2 + list.get(0).toString() + File.separator + JAVA_EE_CONFIG_FILE;
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Properties readProperties(String string) {
        Properties properties = new Properties();
        FileInputStream fileInputStream = null;
        File file = new File(string);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            fileInputStream = new FileInputStream(file);
            properties.load(fileInputStream);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (fileInputStream != null) {
                try {
                    fileInputStream.close();
                }
                catch (Exception exception) {}
            }
        }
        return properties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void storeProperties(String string, Properties properties) {
        OutputStream outputStream = null;
        File file = new File(string);
        try {
            if (!file.exists()) {
                file.createNewFile();
            }
            outputStream = new FileOutputStream(file);
            Date date = new Date();
            properties.store(outputStream, date.toString());
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
        }
    }

    public static synchronized void setJavaEECustomProperty(JbiProject jbiProject, String string, String string2) {
        JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
        String string3 = ProjectUtil.getJavaEEConfigFile(jbiProjectProperties, jbiProject.getProjectDirectory());
        Properties properties = ProjectUtil.readProperties(string3);
        properties.setProperty(string, string2);
        ProjectUtil.storeProperties(string3, properties);
    }

    public static synchronized Properties getJavaEECustomProperty(JbiProject jbiProject) {
        JbiProjectProperties jbiProjectProperties = jbiProject.getProjectProperties();
        String string = ProjectUtil.getJavaEEConfigFile(jbiProjectProperties, jbiProject.getProjectDirectory());
        Properties properties = ProjectUtil.readProperties(string);
        return properties;
    }

    public static List<EndpointCfg> getEndpointCfgs(JbiProject jbiProject, String string) {
        FileObject fileObject = jbiProject.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = new File(file, CONFIG_DIR);
        List<EndpointCfg> list = EndpointCfgReaderWriter.readConfigs(file2, string);
        return list;
    }

    public static List<EndpointCfg> getEndpointCfgs(File file, String string) {
        List<EndpointCfg> list = EndpointCfgReaderWriter.readConfigs(file, string);
        return list;
    }

    public static void saveEndpointCfgs(JbiProject jbiProject, String string, List<EndpointCfg> list) {
        FileObject fileObject = jbiProject.getProjectDirectory();
        File file = FileUtil.toFile((FileObject)fileObject);
        File file2 = new File(file, CONFIG_DIR);
        EndpointCfgReaderWriter.writeConfigs(file2, string, list);
    }

    public static void saveEndpointCfgs(File file, String string, List<EndpointCfg> list) {
        EndpointCfgReaderWriter.writeConfigs(file, string, list);
    }

    public static void close(Closeable closeable) {
        if (closeable != null) {
            try {
                closeable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static void close(ZipFile zipFile) {
        if (zipFile != null) {
            try {
                zipFile.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

