/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.ui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableColumn;
import org.netbeans.modules.compapp.javaee.sunresources.tool.JavaEETool;
import org.netbeans.modules.compapp.javaee.sunresources.ui.BeanNodeFactory;
import org.netbeans.modules.compapp.javaee.sunresources.ui.ResourceUsagePanel;
import org.netbeans.modules.compapp.javaee.sunresources.ui.ResourcesTableModel;
import org.openide.DialogDescriptor;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.explorer.propertysheet.PropertySheet;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.nodes.Node;
import org.openide.util.NbBundle;

public class ResourcesPanel
extends JPanel {
    private JDialog parent;
    private JavaEETool javaEETool;
    private ResourcesTableModel tableModel;
    private JTable table;
    private JButton editButton;
    private JButton deleteButton;
    private JButton usageButton;
    private JButton closeButton;

    public ResourcesPanel(JDialog jDialog, JavaEETool javaEETool) {
        super(new BorderLayout());
        this.parent = jDialog;
        this.javaEETool = javaEETool;
        this.initComponents();
    }

    private void initComponents() {
        Object object;
        this.setPreferredSize(new Dimension(600, 400));
        JTabbedPane jTabbedPane = new JTabbedPane();
        this.tableModel = new ResourcesTableModel(this.javaEETool.getResourceAggregator());
        this.table = new ResourcesTable(this.tableModel);
        this.table.setSelectionMode(0);
        CustomTableCellRenderer customTableCellRenderer = new CustomTableCellRenderer();
        this.table.setDefaultRenderer(Object.class, customTableCellRenderer);
        for (int i = 0; i < 4; ++i) {
            object = this.table.getColumnModel().getColumn(i);
            if (i == 0 || i == 1) {
                ((TableColumn)object).setPreferredWidth(((TableColumn)object).getPreferredWidth() + 40);
                continue;
            }
            ((TableColumn)object).setPreferredWidth(((TableColumn)object).getPreferredWidth() - 40);
        }
        JScrollPane jScrollPane = new JScrollPane(this.table);
        object = new PopupListener();
        this.table.addMouseListener((MouseListener)object);
        jScrollPane.addMouseListener((MouseListener)object);
        jTabbedPane.addTab(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_table"), jScrollPane);
        JPanel jPanel = new JPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.editButton = new JButton(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_edit"));
        this.editButton.setEnabled(false);
        this.editButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.editButton_actionPerformed(actionEvent);
            }
        });
        this.deleteButton = new JButton(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_delete"));
        this.deleteButton.setEnabled(false);
        this.deleteButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.deleteButton_actionPerformed(actionEvent);
            }
        });
        this.usageButton = new JButton(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_view_usage"));
        this.usageButton.setEnabled(false);
        this.usageButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.usageButton_actionPerformed(actionEvent);
            }
        });
        this.closeButton = new JButton(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_close"));
        this.closeButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ResourcesPanel.this.closeButton_actionPerformed(actionEvent);
            }
        });
        jPanel.add((Component)this.editButton, "East");
        jPanel.add((Component)this.deleteButton, "East");
        jPanel.add((Component)this.usageButton, "East");
        jPanel.add((Component)this.closeButton, "East");
        this.add((Component)jTabbedPane, "Center");
        this.add((Component)jPanel, "South");
    }

    private void editButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            if (this.tableModel.isEditButton(n)) {
                Object object = this.tableModel.getBean(this.table.getSelectedRow());
                FileObject fileObject = this.tableModel.getBeanFileObject(this.table.getSelectedRow());
                PropertySheet propertySheet = new PropertySheet();
                propertySheet.setNodes(new Node[]{BeanNodeFactory.getBeanNode(object, fileObject, this.tableModel)});
                String string = NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_properties");
                String string2 = NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_close");
                Object[] objectArray = new Object[]{string2};
                DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)propertySheet, string, true, objectArray, (Object)string2, 0, null, null);
                Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
                dialog.setVisible(true);
                this.tableModel.writeToFile(n);
            } else {
                FileObject fileObject = this.javaEETool.getResourceDir();
                Object object = this.tableModel.getBean(this.table.getSelectedRow());
                String string = BeanNodeFactory.generateResourceFileName(object) + ".sun-resource";
                int n2 = 1;
                while (fileObject.getFileObject(string + ".sun-resource") != null) {
                    string = string + Integer.toString(n2);
                    ++n2;
                }
                File file = new File(FileUtil.toFile((FileObject)fileObject), string);
                this.tableModel.writeToFile(this.table.getSelectedRow(), file);
                NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResourcesPanel.class, (String)"MSG_res_created", (Object)file.getName()), 1);
                DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        this.tableModel.fireTableDataChanged();
    }

    private void deleteButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            this.tableModel.deleteResourceFile(n);
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResourcesPanel.class, (String)"MSG_res_deleted"), 1);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        catch (Exception exception) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(ResourcesPanel.class, (String)"MSG_res_cannot_delete"), 2);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
        }
        this.tableModel.fireTableDataChanged();
    }

    private void usageButton_actionPerformed(ActionEvent actionEvent) {
        try {
            int n = this.table.getSelectedRow();
            if (n == -1) {
                return;
            }
            String string = NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_res_usage");
            String string2 = NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_close");
            Object[] objectArray = new Object[]{string2};
            ResourceUsagePanel resourceUsagePanel = new ResourceUsagePanel(this.tableModel.getProject(), this.tableModel.getBeanUsages(n));
            DialogDescriptor dialogDescriptor = new DialogDescriptor((Object)resourceUsagePanel, string, true, objectArray, (Object)string2, 0, null, null);
            Dialog dialog = DialogDisplayer.getDefault().createDialog(dialogDescriptor);
            resourceUsagePanel.setRootDialog(this.parent);
            resourceUsagePanel.setParentDialog(dialog);
            dialog.setVisible(true);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.parent.setVisible(false);
        this.parent.dispose();
    }

    public static void main(String[] stringArray) {
    }

    class PopupListener
    extends MouseAdapter {
        PopupListener() {
        }

        public void mousePressed(MouseEvent mouseEvent) {
            this.createPopup(mouseEvent);
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            this.createPopup(mouseEvent);
        }

        private void createPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                JPopupMenu jPopupMenu = new JPopupMenu();
                JMenuItem jMenuItem = new JMenuItem(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_edit"));
                jMenuItem.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourcesPanel.this.editButton_actionPerformed(actionEvent);
                    }
                });
                JMenuItem jMenuItem2 = new JMenuItem(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_delete"));
                jMenuItem2.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourcesPanel.this.deleteButton_actionPerformed(actionEvent);
                    }
                });
                JMenuItem jMenuItem3 = new JMenuItem(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_view_usage"));
                jMenuItem3.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        ResourcesPanel.this.usageButton_actionPerformed(actionEvent);
                    }
                });
                if (ResourcesPanel.this.table.getSelectedRow() == -1) {
                    jMenuItem.setEnabled(false);
                    jMenuItem2.setEnabled(false);
                    jMenuItem3.setEnabled(false);
                } else {
                    if (ResourcesPanel.this.tableModel.isEditButton(ResourcesPanel.this.table.getSelectedRow())) {
                        jMenuItem.setText(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_edit"));
                    } else {
                        jMenuItem.setText(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_create"));
                    }
                    if (ResourcesPanel.this.tableModel.canDelete(ResourcesPanel.this.table.getSelectedRow())) {
                        jMenuItem2.setEnabled(true);
                    } else {
                        jMenuItem2.setEnabled(false);
                    }
                }
                jPopupMenu.add(jMenuItem);
                jPopupMenu.addSeparator();
                jPopupMenu.add(jMenuItem2);
                jPopupMenu.addSeparator();
                jPopupMenu.add(jMenuItem3);
                jPopupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }
    }

    class CustomTableCellRenderer
    extends DefaultTableCellRenderer {
        CustomTableCellRenderer() {
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
            this.setHorizontalAlignment(2);
            return this;
        }
    }

    class ResourcesTable
    extends JTable {
        ResourcesTable(ResourcesTableModel resourcesTableModel) {
            super(resourcesTableModel);
        }

        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            super.valueChanged(listSelectionEvent);
            if (this.getSelectedRow() == -1) {
                ResourcesPanel.this.editButton.setEnabled(false);
                ResourcesPanel.this.deleteButton.setEnabled(false);
                ResourcesPanel.this.usageButton.setEnabled(false);
            } else {
                ResourcesPanel.this.editButton.setEnabled(true);
                if (ResourcesPanel.this.tableModel.isEditButton(this.getSelectedRow())) {
                    ResourcesPanel.this.editButton.setText(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_edit"));
                } else {
                    ResourcesPanel.this.editButton.setText(NbBundle.getMessage(ResourcesPanel.class, (String)"LBL_create"));
                }
                if (ResourcesPanel.this.tableModel.canDelete(this.getSelectedRow())) {
                    ResourcesPanel.this.deleteButton.setEnabled(true);
                } else {
                    ResourcesPanel.this.deleteButton.setEnabled(false);
                }
                ResourcesPanel.this.usageButton.setEnabled(true);
            }
        }
    }
}

