/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.archive;

import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.classfile.ClassFile;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.netbeans.modules.compapp.javaee.sunresources.tool.annotation.JavaEEAnnotationProcessor;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.Archive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.EjbDDJaxbHandler;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.FileUtil;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.SunEjbDDJaxbHandler;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.WebservicesDDJaxbHandler;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMap;
import org.netbeans.modules.compapp.javaee.sunresources.tool.graph.JAXBHandler;
import org.netbeans.modules.compapp.projects.jbi.jeese.actions.ServerResourcesAction;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class EJBArchive
extends Archive {
    private Project p;
    private JavaEEAnnotationProcessor annoProcessor;
    private CMap cmap;
    private String name;
    private ResourceAggregator resAggregator;
    private WebservicesDDJaxbHandler webservicesDD;
    private SunEjbDDJaxbHandler sunEjbDD;
    private EjbDDJaxbHandler ejbDD;
    private FileObject resourceDirFO;

    public EJBArchive(Project project, CMap cMap, JavaEEAnnotationProcessor javaEEAnnotationProcessor) throws Exception {
        this.p = project;
        this.name = ProjectUtils.getInformation((Project)project).getName();
        this.cmap = cMap;
        this.annoProcessor = javaEEAnnotationProcessor;
        this.resAggregator = new ResourceAggregator(project);
        this.distJarPropName = "dist.jar";
    }

    public EJBArchive(Project project) throws Exception {
        this.p = project;
        this.name = ProjectUtils.getInformation((Project)project).getName();
        this.cmap = new CMap(this.name);
        this.resAggregator = new ResourceAggregator(project);
        this.annoProcessor = new JavaEEAnnotationProcessor(this.cmap, this.resAggregator);
        this.distJarPropName = "dist.jar";
    }

    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void open() throws Exception {
        Object object;
        this.resourceDirFO = SunResourcesUtil.getResourceDir(this.p);
        FileObject[] fileObjectArray = this.resourceDirFO.getChildren();
        for (int i = 0; i < fileObjectArray.length; ++i) {
            object = fileObjectArray[i];
            if (object.isFolder() || !object.getExt().equalsIgnoreCase("sun-resource")) continue;
            this.resAggregator.addResource((FileObject)object);
        }
        FileObject fileObject = SunResourcesUtil.getProjectDistJar(this.p, this.distJarPropName);
        if (fileObject == null) {
            throw new ServerResourcesAction.ProjectNotBuiltException(NbBundle.getMessage(EJBArchive.class, (String)"EXC_project_not_build", (Object)this.name));
        }
        object = null;
        try {
            object = new JarFile(org.openide.filesystems.FileUtil.toFile((FileObject)fileObject));
            Enumeration<JarEntry> enumeration = ((JarFile)object).entries();
            while (enumeration.hasMoreElements()) {
                JarEntry jarEntry = enumeration.nextElement();
                if (!jarEntry.getName().endsWith(".class")) continue;
                ClassFile classFile = new ClassFile(((JarFile)object).getInputStream(jarEntry));
                this.annoProcessor.process(classFile);
            }
        }
        finally {
            FileUtil.safecloseJar((JarFile)object);
        }
        this.annoProcessor.postProcess();
    }

    public JAXBHandler getJAXBHandler() {
        return null;
    }

    public void close() throws Exception {
    }

    public ResourceAggregator getResourceAggregator() {
        return this.resAggregator;
    }

    public CMap getCMap() {
        return this.cmap;
    }

    public FileObject getResourceDir() {
        return this.resourceDirFO;
    }
}

