/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.compapp.javaee.sunresources.tool.archive;

import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.compapp.javaee.sunresources.ResourceAggregator;
import org.netbeans.modules.compapp.javaee.sunresources.SunResourcesUtil;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.Archive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.ArchiveConstants;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.EJBArchive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.SunResourcesDDJaxbHandler;
import org.netbeans.modules.compapp.javaee.sunresources.tool.archive.WebArchive;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMap;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.CMapNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.cmap.EJBNode;
import org.netbeans.modules.compapp.javaee.sunresources.tool.graph.JAXBHandler;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;

public class ApplicationArchive
extends Archive {
    private Project p;
    private String name;
    private ResourceAggregator resAggregator;
    private CMap cmap;
    private SunResourcesDDJaxbHandler sunResourcesDD;
    private JAXBHandler jaxbHandler;
    private List<Archive> subProjects = new ArrayList<Archive>();
    private URLClassLoader appClassLoader;

    public ApplicationArchive(Project project) throws Exception {
        this.p = project;
        this.name = ProjectUtils.getInformation((Project)project).getName();
        this.resAggregator = new ResourceAggregator(project);
        this.cmap = new CMap(this.name);
        List<Project> list = SunResourcesUtil.getSubProjects(project);
        for (int i = 0; i < list.size(); ++i) {
            EJBArchive eJBArchive;
            Project project2 = list.get(i);
            ArchiveConstants.ArchiveType archiveType = SunResourcesUtil.getJavaEEProjectType(project2);
            if (archiveType == ArchiveConstants.ArchiveType.EJB) {
                eJBArchive = new EJBArchive(project2);
                this.subProjects.add(eJBArchive);
                continue;
            }
            if (archiveType == ArchiveConstants.ArchiveType.WAR) {
                eJBArchive = new WebArchive(project2);
                this.subProjects.add(eJBArchive);
                continue;
            }
            throw new Exception(NbBundle.getMessage(ApplicationArchive.class, (String)"EXC_bad_project_type", (Object)((Object)archiveType)));
        }
    }

    public String getName() {
        return this.name;
    }

    public void open() throws Exception {
        Object object;
        int n;
        FileObject fileObject = SunResourcesUtil.getResourceDir(this.p);
        FileObject[] fileObjectArray = fileObject.getChildren();
        for (n = 0; n < fileObjectArray.length; ++n) {
            object = fileObjectArray[n];
            if (object.isFolder() || !object.getExt().equalsIgnoreCase("sun-resource")) continue;
            this.resAggregator.addResource((FileObject)object);
        }
        for (n = 0; n < this.subProjects.size(); ++n) {
            object = this.subProjects.get(n);
            ((Archive)object).open();
        }
    }

    private EJBNode findEJBNodeImplIntf(String string) {
        Iterator<CMapNode> iterator = this.cmap.getNodes();
        while (iterator.hasNext()) {
            EJBNode eJBNode;
            CMapNode cMapNode = iterator.next();
            if (!(cMapNode instanceof EJBNode) || !(eJBNode = (EJBNode)cMapNode).implementsInterface(string)) continue;
            return eJBNode;
        }
        return null;
    }

    public void close() throws Exception {
        this.appClassLoader = null;
        this.resAggregator.close();
        this.resAggregator = null;
    }

    public String toString() {
        return this.name;
    }

    public CMap getCMap() {
        return this.cmap;
    }

    public JAXBHandler getJAXBHandler() {
        return this.jaxbHandler;
    }

    public ResourceAggregator getResourceAggregator() {
        return this.resAggregator;
    }

    public FileObject getResourceDir() {
        return null;
    }
}

