/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.models;

import com.sun.jdi.ArrayReference;
import com.sun.jdi.BooleanType;
import com.sun.jdi.ByteType;
import com.sun.jdi.ByteValue;
import com.sun.jdi.CharType;
import com.sun.jdi.CharValue;
import com.sun.jdi.ClassNotLoadedException;
import com.sun.jdi.ClassObjectReference;
import com.sun.jdi.ClassType;
import com.sun.jdi.DoubleType;
import com.sun.jdi.DoubleValue;
import com.sun.jdi.Field;
import com.sun.jdi.FloatType;
import com.sun.jdi.FloatValue;
import com.sun.jdi.IncompatibleThreadStateException;
import com.sun.jdi.IntegerType;
import com.sun.jdi.IntegerValue;
import com.sun.jdi.InvalidTypeException;
import com.sun.jdi.InvocationException;
import com.sun.jdi.LongType;
import com.sun.jdi.LongValue;
import com.sun.jdi.ObjectCollectedException;
import com.sun.jdi.ObjectReference;
import com.sun.jdi.PrimitiveType;
import com.sun.jdi.PrimitiveValue;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.ShortType;
import com.sun.jdi.ShortValue;
import com.sun.jdi.StringReference;
import com.sun.jdi.Type;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.Value;
import com.sun.jdi.VoidValue;
import java.beans.Customizer;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.Set;
import org.netbeans.api.debugger.jpda.InvalidExpressionException;
import org.netbeans.api.debugger.jpda.JPDAClassType;
import org.netbeans.api.debugger.jpda.Variable;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.expr.EvaluatorVisitor;
import org.netbeans.modules.debugger.jpda.expr.JDIVariable;
import org.netbeans.modules.debugger.jpda.models.JPDAClassTypeImpl;
import org.netbeans.modules.debugger.jpda.models.JPDAThreadImpl;
import org.openide.util.NbBundle;

class AbstractVariable
implements JDIVariable,
Customizer,
Cloneable {
    private Value value;
    private JPDADebuggerImpl debugger;
    private String id;
    private Set<PropertyChangeListener> listeners = new HashSet<PropertyChangeListener>();
    private int cloneNumber = 1;

    AbstractVariable(JPDADebuggerImpl jPDADebuggerImpl, Value value, String string) {
        this.debugger = jPDADebuggerImpl;
        this.value = value;
        this.id = string;
        if (this.id == null) {
            this.id = Integer.toString(super.hashCode());
        }
    }

    public String getValue() {
        Value value = this.getInnerValue();
        return AbstractVariable.getValue(value);
    }

    static String getValue(Value value) {
        if (value == null) {
            return "null";
        }
        if (value instanceof VoidValue) {
            return "void";
        }
        if (value instanceof CharValue) {
            return "'" + value.toString() + "'";
        }
        if (value instanceof PrimitiveValue) {
            return value.toString();
        }
        if (value instanceof StringReference) {
            return "\"" + ((StringReference)value).value() + "\"";
        }
        if (value instanceof ClassObjectReference) {
            return "class " + ((ClassObjectReference)value).reflectedType().name();
        }
        if (value instanceof ArrayReference) {
            return "#" + ((ArrayReference)value).uniqueID() + "(length=" + ((ArrayReference)value).length() + ")";
        }
        return "#" + ((ObjectReference)value).uniqueID();
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setValue(String string) throws InvalidExpressionException {
        void var3_9;
        String string2 = this.getValue();
        if (string.equals(string2)) {
            return;
        }
        Value value = this.getInnerValue();
        if (value instanceof CharValue && string.startsWith("'") && string.endsWith("'") && string.length() > 1) {
            CharValue charValue = value.virtualMachine().mirrorOf(string.charAt(1));
        } else if ((value instanceof StringReference || value == null) && string.startsWith("\"") && string.endsWith("\"") && string.length() > 1) {
            StringReference stringReference = this.debugger.getVirtualMachine().mirrorOf(string.substring(1, string.length() - 1));
        } else if (value instanceof ObjectReference && ((ObjectReference)value).referenceType() instanceof ClassType && ((ClassType)((ObjectReference)value).referenceType()).isEnum()) {
            ClassType classType = (ClassType)((ObjectReference)value).referenceType();
            Field field = classType.fieldByName(string);
            if (field == null) throw new InvalidExpressionException(string);
            Value value2 = classType.getValue(field);
        } else if ("null".equals(string)) {
            Object var3_7 = null;
        } else {
            Type type;
            Value value3 = this.debugger.evaluateIn(string);
            if (value != null && value3 != null && !(type = value.type()).equals(value3.type())) {
                value3 = this.convertValue(value3, type);
            }
            Value value4 = value3;
        }
        this.setValue((Value)var3_9);
        this.setInnerValue((Value)var3_9);
    }

    private Value convertValue(Value value, Type type) {
        Object object;
        if (type instanceof PrimitiveType) {
            if (value instanceof ObjectReference) {
                object = this.getDebugger().getCurrentThread();
                if (object != null) {
                    try {
                        value = EvaluatorVisitor.unbox((ObjectReference)value, (PrimitiveType)type, ((JPDAThreadImpl)object).getThreadReference());
                    }
                    catch (InvalidTypeException invalidTypeException) {
                    }
                    catch (ClassNotLoadedException classNotLoadedException) {
                    }
                    catch (IncompatibleThreadStateException incompatibleThreadStateException) {
                    }
                    catch (InvocationException invocationException) {
                        // empty catch block
                    }
                }
                if (value.type().equals(type)) {
                    return value;
                }
            }
            if (value instanceof PrimitiveValue) {
                object = (PrimitiveValue)value;
                if (type instanceof BooleanType) {
                    return object.virtualMachine().mirrorOf(object.booleanValue());
                }
                if (type instanceof ByteType) {
                    return object.virtualMachine().mirrorOf(object.byteValue());
                }
                if (type instanceof CharType) {
                    return object.virtualMachine().mirrorOf(object.charValue());
                }
                if (type instanceof ShortType) {
                    return object.virtualMachine().mirrorOf(object.shortValue());
                }
                if (type instanceof IntegerType) {
                    return object.virtualMachine().mirrorOf(object.intValue());
                }
                if (type instanceof LongType) {
                    return object.virtualMachine().mirrorOf(object.longValue());
                }
                if (type instanceof FloatType) {
                    return object.virtualMachine().mirrorOf(object.floatValue());
                }
                if (type instanceof DoubleType) {
                    return object.virtualMachine().mirrorOf(object.doubleValue());
                }
            }
        }
        if (type instanceof ClassType && value instanceof PrimitiveValue && (object = this.getDebugger().getCurrentThread()) != null) {
            PrimitiveValue primitiveValue = (PrimitiveValue)value;
            String string = type.name();
            if (string.equals("java.lang.Byte") && !(primitiveValue instanceof ByteValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.byteValue());
            }
            if (string.equals("java.lang.Character") && !(primitiveValue instanceof CharValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.charValue());
            }
            if (string.equals("java.lang.Short") && !(primitiveValue instanceof ShortValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.shortValue());
            }
            if (string.equals("java.lang.Integer") && !(primitiveValue instanceof IntegerValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.intValue());
            }
            if (string.equals("java.lang.Long") && !(primitiveValue instanceof LongValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.longValue());
            }
            if (string.equals("java.lang.Float") && !(primitiveValue instanceof FloatValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.floatValue());
            }
            if (string.equals("java.lang.Double") && !(primitiveValue instanceof DoubleValue)) {
                primitiveValue = primitiveValue.virtualMachine().mirrorOf(primitiveValue.doubleValue());
            }
            try {
                value = EvaluatorVisitor.box(primitiveValue, (ReferenceType)type, ((JPDAThreadImpl)object).getThreadReference());
            }
            catch (InvalidTypeException invalidTypeException) {
            }
            catch (ClassNotLoadedException classNotLoadedException) {
            }
            catch (IncompatibleThreadStateException incompatibleThreadStateException) {
            }
            catch (InvocationException invocationException) {
                // empty catch block
            }
        }
        return value;
    }

    protected void setValue(Value value) throws InvalidExpressionException {
        throw new InternalError();
    }

    public void setObject(Object object) {
        try {
            if (!(object instanceof String)) {
                throw new IllegalArgumentException("" + object);
            }
            this.setValue((String)object);
        }
        catch (InvalidExpressionException invalidExpressionException) {
            IllegalArgumentException illegalArgumentException = new IllegalArgumentException(invalidExpressionException.getLocalizedMessage());
            illegalArgumentException.initCause(invalidExpressionException);
            throw illegalArgumentException;
        }
    }

    public String getType() {
        if (this.getInnerValue() == null) {
            return "";
        }
        try {
            return this.getInnerValue().type().name();
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_Disconnected");
        }
        catch (ObjectCollectedException objectCollectedException) {
            return NbBundle.getMessage(AbstractVariable.class, (String)"MSG_ObjCollected");
        }
    }

    public JPDAClassType getClassType() {
        Value value = this.getInnerValue();
        if (value == null) {
            return null;
        }
        Type type = value.type();
        if (type instanceof ReferenceType) {
            return new JPDAClassTypeImpl(this.debugger, (ReferenceType)type);
        }
        return null;
    }

    public boolean equals(Object object) {
        return object instanceof AbstractVariable && this.id.equals(((AbstractVariable)object).id);
    }

    public int hashCode() {
        return this.id.hashCode();
    }

    protected Value getInnerValue() {
        return this.value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setInnerValue(Value value) {
        Object[] objectArray;
        this.value = value;
        PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, "value", null, value);
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            objectArray = this.listeners.toArray();
        }
        for (int i = 0; i < objectArray.length; ++i) {
            ((PropertyChangeListener)objectArray[i]).propertyChange(propertyChangeEvent);
        }
        this.debugger.varChangeSupport.firePropertyChange(propertyChangeEvent);
    }

    public Value getJDIValue() {
        return this.value;
    }

    protected final JPDADebuggerImpl getDebugger() {
        return this.debugger;
    }

    protected final String getID() {
        return this.id;
    }

    public Variable clone() {
        AbstractVariable abstractVariable = new AbstractVariable(this.debugger, this.value, this.id + "_clone" + this.cloneNumber++);
        return abstractVariable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addPropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.add(propertyChangeListener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removePropertyChangeListener(PropertyChangeListener propertyChangeListener) {
        Set<PropertyChangeListener> set = this.listeners;
        synchronized (set) {
            this.listeners.remove(propertyChangeListener);
        }
    }

    public String toString() {
        return "Variable ";
    }
}

