/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.breakpoints;

import com.sun.jdi.Mirror;
import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.event.Event;
import com.sun.jdi.event.ThreadDeathEvent;
import com.sun.jdi.event.ThreadStartEvent;
import com.sun.jdi.request.EventRequest;
import com.sun.jdi.request.ThreadDeathRequest;
import com.sun.jdi.request.ThreadStartRequest;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.JPDABreakpoint;
import org.netbeans.api.debugger.jpda.ThreadBreakpoint;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.breakpoints.BreakpointImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;

public class ThreadBreakpointImpl
extends BreakpointImpl
implements Executor {
    private ThreadBreakpoint breakpoint;

    public ThreadBreakpointImpl(ThreadBreakpoint threadBreakpoint, JPDADebuggerImpl jPDADebuggerImpl, Session session) {
        super((JPDABreakpoint)threadBreakpoint, null, jPDADebuggerImpl, session);
        this.breakpoint = threadBreakpoint;
        this.set();
    }

    protected void setRequests() {
        try {
            Mirror mirror;
            if ((this.breakpoint.getBreakpointType() & 1) != 0) {
                mirror = this.getEventRequestManager().createThreadStartRequest();
                this.addEventRequest((EventRequest)mirror);
            }
            if ((this.breakpoint.getBreakpointType() & 2) != 0 && (mirror = this.getVirtualMachine()) != null) {
                ThreadDeathRequest threadDeathRequest = mirror.eventRequestManager().createThreadDeathRequest();
                this.addEventRequest(threadDeathRequest);
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
            // empty catch block
        }
    }

    protected EventRequest createEventRequest(EventRequest eventRequest) {
        if (eventRequest instanceof ThreadStartRequest) {
            return this.getEventRequestManager().createThreadStartRequest();
        }
        if (eventRequest instanceof ThreadDeathRequest) {
            return this.getEventRequestManager().createThreadDeathRequest();
        }
        return null;
    }

    public boolean exec(Event event) {
        ThreadReference threadReference = null;
        if (event instanceof ThreadStartEvent) {
            threadReference = ((ThreadStartEvent)event).thread();
        } else if (event instanceof ThreadDeathEvent) {
            threadReference = ((ThreadDeathEvent)event).thread();
        }
        return this.perform(event, null, threadReference, null, threadReference);
    }

    public void removed(EventRequest eventRequest) {
    }
}

