/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.AbsentInformationException;
import com.sun.jdi.Location;
import com.sun.jdi.ReferenceType;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.event.Event;
import com.sun.jdi.request.BreakpointRequest;
import com.sun.jdi.request.EventRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import org.netbeans.api.debugger.ActionsManager;
import org.netbeans.api.debugger.ActionsManagerListener;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.jpda.ClassLoadUnloadBreakpoint;
import org.netbeans.api.debugger.jpda.JPDADebugger;
import org.netbeans.api.debugger.jpda.JPDAStep;
import org.netbeans.api.debugger.jpda.JPDAThread;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointEvent;
import org.netbeans.api.debugger.jpda.event.JPDABreakpointListener;
import org.netbeans.modules.debugger.jpda.EditorContextBridge;
import org.netbeans.modules.debugger.jpda.ExpressionPool;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.SourcePath;
import org.netbeans.modules.debugger.jpda.models.CallStackFrameImpl;
import org.netbeans.modules.debugger.jpda.util.Executor;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.debugger.jpda.EditorContext;
import org.openide.DialogDisplayer;
import org.openide.ErrorManager;
import org.openide.NotifyDescriptor;
import org.openide.util.NbBundle;

public class RunIntoMethodActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener,
ActionsManagerListener {
    private JPDADebuggerImpl debugger;
    private Session session;
    private ActionsManager lastActionsManager;
    private SourcePath sourcePath;

    public RunIntoMethodActionProvider(ContextProvider contextProvider) {
        this.debugger = (JPDADebuggerImpl)((Object)contextProvider.lookupFirst(null, JPDADebugger.class));
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.sourcePath = (SourcePath)contextProvider.lookupFirst(null, SourcePath.class);
        this.debugger.addPropertyChangeListener("state", this);
        EditorContextBridge.getContext().addPropertyChangeListener((PropertyChangeListener)this);
    }

    private void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        EditorContextBridge.getContext().removePropertyChangeListener((PropertyChangeListener)this);
    }

    static ActionsManager getCurrentActionsManager() {
        return DebuggerManager.getDebuggerManager().getCurrentEngine() == null ? DebuggerManager.getDebuggerManager().getActionsManager() : DebuggerManager.getDebuggerManager().getCurrentEngine().getActionsManager();
    }

    private ActionsManager getActionsManager() {
        ActionsManager actionsManager = RunIntoMethodActionProvider.getCurrentActionsManager();
        if (actionsManager != this.lastActionsManager) {
            if (this.lastActionsManager != null) {
                this.lastActionsManager.removeActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            }
            actionsManager.addActionsManagerListener("actionStateChanged", (ActionsManagerListener)this);
            this.lastActionsManager = actionsManager;
        }
        return actionsManager;
    }

    /*
     * Unable to fully structure code
     */
    public void propertyChange(PropertyChangeEvent var1_1) {
        if (!this.getActionsManager().isEnabled(ActionsManager.ACTION_CONTINUE)) ** GOTO lbl-1000
        if (this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java")) {
            v0 = true;
        } else lbl-1000:
        // 2 sources

        {
            v0 = false;
        }
        this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        if (this.debugger.getState() == 4) {
            this.destroy();
        }
    }

    public Set getActions() {
        return Collections.singleton(ActionsManager.ACTION_RUN_INTO_METHOD);
    }

    public void doAction(Object object) {
        final String[] stringArray = new String[1];
        final String[] stringArray2 = new String[1];
        final String[] stringArray3 = new String[1];
        final int[] nArray = new int[1];
        final int[] nArray2 = new int[1];
        try {
            SwingUtilities.invokeAndWait(new Runnable(){

                public void run() {
                    stringArray[0] = EditorContextBridge.getContext().getSelectedMethodName();
                    if (stringArray[0].length() < 1) {
                        return;
                    }
                    nArray[0] = EditorContextBridge.getContext().getCurrentLineNumber();
                    nArray2[0] = EditorContextBridge.getCurrentOffset();
                    stringArray2[0] = EditorContextBridge.getContext().getCurrentURL();
                    stringArray3[0] = EditorContextBridge.getContext().getCurrentClassName();
                }
            });
        }
        catch (InvocationTargetException invocationTargetException) {
            ErrorManager.getDefault().notify(invocationTargetException.getTargetException());
            return;
        }
        catch (InterruptedException interruptedException) {
            ErrorManager.getDefault().notify((Throwable)interruptedException);
            return;
        }
        final String string = stringArray[0];
        if (string.length() < 1) {
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_Put_cursor_on_some_method_call"));
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        final int n = nArray[0];
        final int n2 = nArray2[0];
        final String string2 = stringArray2[0];
        String string3 = stringArray3[0];
        VirtualMachine virtualMachine = this.debugger.getVirtualMachine();
        if (virtualMachine == null) {
            return;
        }
        List<ReferenceType> list = virtualMachine.classesByName(string3);
        if (!list.isEmpty()) {
            this.doAction(string2, list.get(0), n, n2, string);
        } else {
            final ClassLoadUnloadBreakpoint classLoadUnloadBreakpoint = ClassLoadUnloadBreakpoint.create((String)string3, (boolean)false, (int)1);
            classLoadUnloadBreakpoint.setHidden(true);
            classLoadUnloadBreakpoint.setSuspend(0);
            classLoadUnloadBreakpoint.addJPDABreakpointListener(new JPDABreakpointListener(){

                public void breakpointReached(JPDABreakpointEvent jPDABreakpointEvent) {
                    DebuggerManager.getDebuggerManager().removeBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
                    RunIntoMethodActionProvider.this.doAction(string2, jPDABreakpointEvent.getReferenceType(), n, n2, string);
                }
            });
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)classLoadUnloadBreakpoint);
            this.resume();
        }
    }

    private void resume() {
        if (this.debugger.getSuspend() == 1) {
            this.debugger.getCurrentThread().resume();
        } else {
            this.session.getEngineForLanguage("Java").getActionsManager().doAction(ActionsManager.ACTION_CONTINUE);
        }
    }

    private void doAction(String string, ReferenceType referenceType, int n, int n2, final String string2) {
        Object object;
        int n3;
        Object object2;
        List<Object> list = Collections.emptyList();
        try {
            while (n > 0 && (list = referenceType.locationsOfLine(n)).isEmpty()) {
                --n;
            }
        }
        catch (AbsentInformationException absentInformationException) {
            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
        }
        Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("doAction(" + string + ", " + referenceType + ", " + n + ", " + string2 + ") locations = " + list);
        if (list.isEmpty()) {
            String string3 = NbBundle.getMessage(RunIntoMethodActionProvider.class, (String)"MSG_RunIntoMeth_absentInfo", (Object)referenceType.name());
            NotifyDescriptor.Message message = new NotifyDescriptor.Message((Object)string3);
            DialogDisplayer.getDefault().notify((NotifyDescriptor)message);
            return;
        }
        ExpressionPool.Expression expression = this.debugger.getExpressionPool().getExpressionAt((Location)list.get(0), string);
        Location location = null;
        if (expression != null) {
            object2 = expression.getOperations();
            for (n3 = 0; n3 < ((EditorContext.Operation[])object2).length; ++n3) {
                object = object2[n3];
                if (object.getMethodStartPosition().getOffset() > n2 || n2 > object.getMethodEndPosition().getOffset()) continue;
                location = expression.getLocations()[n3];
                break;
            }
        }
        if (location == null) {
            location = (Location)list.get(0);
        }
        if ((object2 = this.debugger.getVirtualMachine()) == null) {
            return;
        }
        n3 = location.lineNumber("Java");
        object = (CallStackFrameImpl)this.debugger.getCurrentCallStackFrame();
        if (object != null && ((Object)((CallStackFrameImpl)object).getStackFrame().location()).equals(location)) {
            this.traceLineForMethod(string2, n3);
        } else {
            BreakpointRequest breakpointRequest = object2.eventRequestManager().createBreakpointRequest(location);
            this.debugger.getOperator().register(breakpointRequest, new Executor((VirtualMachine)object2, breakpointRequest, n3){
                final /* synthetic */ VirtualMachine val$vm;
                final /* synthetic */ BreakpointRequest val$brReq;
                final /* synthetic */ int val$line;
                {
                    this.val$vm = virtualMachine;
                    this.val$brReq = breakpointRequest;
                    this.val$line = n;
                }

                public boolean exec(Event event) {
                    Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("Calling location reached, tracing for " + string2 + "()");
                    this.val$vm.eventRequestManager().deleteEventRequest(this.val$brReq);
                    RunIntoMethodActionProvider.this.debugger.getOperator().unregister(this.val$brReq);
                    RunIntoMethodActionProvider.this.traceLineForMethod(string2, this.val$line);
                    return true;
                }

                public void removed(EventRequest eventRequest) {
                }
            });
            breakpointRequest.setSuspendPolicy(this.debugger.getSuspend());
            breakpointRequest.enable();
        }
        this.resume();
    }

    private void traceLineForMethod(final String string, final int n) {
        final int n2 = this.debugger.getCurrentThread().getStackDepth();
        final JPDAStep jPDAStep = this.debugger.createJPDAStep(-2, 1);
        jPDAStep.setHidden(true);
        jPDAStep.addPropertyChangeListener("exec", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                block10: {
                    if (Logger.getLogger(RunIntoMethodActionProvider.class.getName()).isLoggable(Level.FINE)) {
                        Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("traceLineForMethod(" + string + ") step is at " + RunIntoMethodActionProvider.this.debugger.getCurrentThread().getClassName() + ":" + RunIntoMethodActionProvider.this.debugger.getCurrentThread().getMethodName());
                    }
                    JPDAThread jPDAThread = RunIntoMethodActionProvider.this.debugger.getCurrentThread();
                    int n3 = jPDAThread.getStackDepth();
                    Logger.getLogger(RunIntoMethodActionProvider.class.getName()).fine("  depth = " + n3 + ", target = " + n2);
                    if (n3 == n2) {
                        try {
                            if (jPDAThread.getCallStack()[0].getLineNumber("Java") != n) {
                                jPDAStep.setHidden(false);
                                break block10;
                            }
                            jPDAStep.setDepth(1);
                            jPDAStep.addStep(RunIntoMethodActionProvider.this.debugger.getCurrentThread());
                        }
                        catch (AbsentInformationException absentInformationException) {
                            ErrorManager.getDefault().notify(1, (Throwable)absentInformationException);
                            jPDAStep.setHidden(false);
                        }
                    } else if (jPDAThread.getMethodName().equals(string)) {
                        jPDAStep.setHidden(false);
                    } else if (jPDAThread.getMethodName().equals("<init>") && (jPDAThread.getClassName().endsWith("." + string) || jPDAThread.getClassName().equals(string))) {
                        jPDAStep.setHidden(false);
                    } else {
                        jPDAStep.setDepth(3);
                        jPDAStep.addStep(RunIntoMethodActionProvider.this.debugger.getCurrentThread());
                    }
                }
            }
        });
        jPDAStep.addStep(this.debugger.getCurrentThread());
    }

    public void actionPerformed(Object object) {
    }

    /*
     * Unable to fully structure code
     */
    public void actionStateChanged(Object var1_1, boolean var2_2) {
        block2: {
            if (ActionsManager.ACTION_CONTINUE != var1_1) break block2;
            if (!var2_2) ** GOTO lbl-1000
            if (this.debugger.getState() == 3 && EditorContextBridge.getContext().getCurrentLineNumber() >= 0 && EditorContextBridge.getContext().getCurrentURL().endsWith(".java")) {
                v0 = true;
            } else lbl-1000:
            // 2 sources

            {
                v0 = false;
            }
            this.setEnabled(ActionsManager.ACTION_RUN_INTO_METHOD, v0);
        }
    }
}

