/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.debugger.jpda.actions;

import com.sun.jdi.ThreadReference;
import com.sun.jdi.VMDisconnectedException;
import com.sun.jdi.VirtualMachine;
import com.sun.jdi.request.EventRequestManager;
import com.sun.jdi.request.InvalidRequestStateException;
import com.sun.jdi.request.StepRequest;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.debugger.jpda.JPDADebuggerImpl;
import org.netbeans.modules.debugger.jpda.JPDAStepImpl;
import org.netbeans.spi.debugger.ActionsProviderSupport;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

abstract class JPDADebuggerActionProvider
extends ActionsProviderSupport
implements PropertyChangeListener {
    private JPDADebuggerImpl debugger;
    private static RequestProcessor actionsRequestProcessor;
    private static Set<JPDADebuggerActionProvider> providersToDisableOnLazyActions;
    private volatile boolean disabled;

    JPDADebuggerActionProvider(JPDADebuggerImpl jPDADebuggerImpl) {
        this.debugger = jPDADebuggerImpl;
        jPDADebuggerImpl.addPropertyChangeListener("state", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (this.debugger.getState() == 4) {
            Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
            // MONITORENTER : org.netbeans.modules.debugger.jpda.actions.JPDADebuggerActionProvider.class
            if (actionsRequestProcessor != null) {
                actionsRequestProcessor.stop();
                actionsRequestProcessor = null;
            }
            // MONITOREXIT : clazz
        }
        this.checkEnabled(this.debugger.getState());
    }

    protected abstract void checkEnabled(int var1);

    public boolean isEnabled(Object object) {
        if (!this.disabled) {
            this.checkEnabled(this.debugger.getState());
        }
        return super.isEnabled(object);
    }

    JPDADebuggerImpl getDebuggerImpl() {
        return this.debugger;
    }

    protected void removeStepRequests(ThreadReference threadReference) {
        try {
            VirtualMachine virtualMachine = this.getDebuggerImpl().getVirtualMachine();
            if (virtualMachine == null) {
                return;
            }
            EventRequestManager eventRequestManager = virtualMachine.eventRequestManager();
            List<StepRequest> list = eventRequestManager.stepRequests();
            for (StepRequest stepRequest : list) {
                if (!stepRequest.thread().equals(threadReference)) continue;
                eventRequestManager.deleteEventRequest(stepRequest);
                JPDAStepImpl.SingleThreadedStepWatch.stepRequestDeleted(stepRequest);
                this.getDebuggerImpl().getOperator().unregister(stepRequest);
                break;
            }
        }
        catch (VMDisconnectedException vMDisconnectedException) {
        }
        catch (IllegalThreadStateException illegalThreadStateException) {
            illegalThreadStateException.printStackTrace();
        }
        catch (InvalidRequestStateException invalidRequestStateException) {
            invalidRequestStateException.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setProviderToDisableOnLazyAction(JPDADebuggerActionProvider jPDADebuggerActionProvider) {
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            providersToDisableOnLazyActions.add(jPDADebuggerActionProvider);
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void doLazyAction(final Runnable runnable) {
        Class<JPDADebuggerActionProvider> clazz = JPDADebuggerActionProvider.class;
        synchronized (JPDADebuggerActionProvider.class) {
            if (actionsRequestProcessor == null) {
                actionsRequestProcessor = new RequestProcessor("JPDA Processor", 1);
            }
            final HashSet<JPDADebuggerActionProvider> hashSet = new HashSet<JPDADebuggerActionProvider>(providersToDisableOnLazyActions);
            // ** MonitorExit[var3_2] (shouldn't be in output)
            for (JPDADebuggerActionProvider jPDADebuggerActionProvider : hashSet) {
                Set set = jPDADebuggerActionProvider.getActions();
                jPDADebuggerActionProvider.disabled = true;
                for (Object e : set) {
                    jPDADebuggerActionProvider.setEnabled(e, false);
                }
            }
            actionsRequestProcessor.post(new Runnable(){

                public void run() {
                    try {
                        runnable.run();
                        for (JPDADebuggerActionProvider jPDADebuggerActionProvider : hashSet) {
                            Set set = jPDADebuggerActionProvider.getActions();
                            jPDADebuggerActionProvider.disabled = false;
                            jPDADebuggerActionProvider.checkEnabled(JPDADebuggerActionProvider.this.debugger.getState());
                        }
                    }
                    catch (VMDisconnectedException vMDisconnectedException) {
                        // empty catch block
                    }
                }
            });
            return;
        }
    }

    static {
        providersToDisableOnLazyActions = new WeakSet();
    }
}

