/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.persistence.OneToMany;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.ClassAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.CollectionAccessor;
import oracle.toplink.essentials.internal.ejb.cmp3.metadata.accessors.objects.MetadataAccessibleObject;
import oracle.toplink.essentials.internal.helper.DatabaseField;
import oracle.toplink.essentials.mappings.ManyToManyMapping;
import oracle.toplink.essentials.mappings.OneToManyMapping;
import oracle.toplink.essentials.mappings.OneToOneMapping;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OneToManyAccessor
extends CollectionAccessor {
    private OneToMany m_oneToMany = (OneToMany)this.getAnnotation(OneToMany.class);

    public OneToManyAccessor(MetadataAccessibleObject accessibleObject, ClassAccessor classAccessor) {
        super(accessibleObject, classAccessor);
    }

    @Override
    public List<String> getCascadeTypes() {
        if (this.m_oneToMany == null) {
            return new ArrayList<String>();
        }
        return this.getCascadeTypes(this.m_oneToMany.cascade());
    }

    @Override
    public String getFetchType() {
        return this.m_oneToMany == null ? "LAZY" : this.m_oneToMany.fetch().name();
    }

    @Override
    protected String getLoggingContext() {
        return "metadata_default_one_to_many_reference_class";
    }

    @Override
    public String getMappedBy() {
        return this.m_oneToMany == null ? "" : this.m_oneToMany.mappedBy();
    }

    @Override
    public Class getTargetEntity() {
        return this.m_oneToMany == null ? Void.TYPE : this.m_oneToMany.targetEntity();
    }

    @Override
    public boolean isOneToMany() {
        return true;
    }

    @Override
    public void process() {
        String mappedBy = this.getMappedBy();
        if (mappedBy.equals("")) {
            if (this.hasJoinColumn() || this.hasJoinColumns()) {
                this.getValidator().throwUniDirectionalOneToManyHasJoinColumnSpecified(this.getAttributeName(), this.getJavaClass());
            }
            ManyToManyMapping mapping = new ManyToManyMapping();
            this.process(mapping);
            this.processJoinTable(this.getJoinTable(), mapping);
            this.m_descriptor.addMapping(mapping);
        } else {
            OneToManyMapping mapping = new OneToManyMapping();
            this.process(mapping);
            OneToOneMapping ownerMapping = null;
            if (this.getOwningMapping().isOneToOneMapping()) {
                ownerMapping = (OneToOneMapping)this.getOwningMapping();
            } else {
                this.getValidator().throwInvalidMappingEncountered(this.getJavaClass(), this.getReferenceClass());
            }
            Map<DatabaseField, DatabaseField> keys = ownerMapping.getSourceToTargetKeyFields();
            for (DatabaseField fkField : keys.keySet()) {
                mapping.addTargetForeignKeyField(fkField, keys.get(fkField));
            }
            this.m_descriptor.addMapping(mapping);
        }
    }
}

