/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler.nbmodule;

import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.JavaPlatformManager;
import org.netbeans.api.java.platform.Specification;
import org.netbeans.api.project.Project;
import org.netbeans.lib.profiler.ProfilerLogger;
import org.netbeans.lib.profiler.marker.CompositeMarker;
import org.netbeans.lib.profiler.marker.Marker;
import org.netbeans.lib.profiler.marker.MethodMarker;
import org.netbeans.lib.profiler.results.cpu.marking.HierarchicalMark;
import org.netbeans.lib.profiler.results.cpu.marking.Mark;
import org.netbeans.modules.profiler.AbstractProjectTypeProfiler;
import org.netbeans.modules.profiler.projectsupport.utilities.SourceUtils;
import org.netbeans.spi.project.AuxiliaryConfiguration;
import org.netbeans.spi.project.SubprojectProvider;
import org.openide.filesystems.FileObject;
import org.openide.util.NbBundle;
import org.w3c.dom.Element;

public final class NbModuleProjectTypeProfiler
extends AbstractProjectTypeProfiler {
    private static final String NBMODULE_PROJECT_NAMESPACE_2 = "http://www.netbeans.org/ns/nb-module-project/2";
    private static final String NBMODULE_PROJECT_NAMESPACE_3 = "http://www.netbeans.org/ns/nb-module-project/3";
    private static final String NBMODULE_SUITE_PROJECT_NAMESPACE = "http://www.netbeans.org/ns/nb-module-suite-project/1";
    private static final String PROJECT_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_ProjectCategory");
    private static final String LISTENERS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_ListenersCategory");
    private static final String PAINTERS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_PaintersCategory");
    private static final String IO_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_IoCategory");
    private static final String FILES_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_FilesCategory");
    private static final String SOCKETS_CATEGORY = NbBundle.getMessage(NbModuleProjectTypeProfiler.class, (String)"NbModuleProjectTypeProfiler_SocketsCategory");
    private HierarchicalMark projectRoot;
    private Marker marker;

    public boolean isFileObjectSupported(Project project, FileObject fileObject) {
        return SourceUtils.isTest((FileObject)fileObject);
    }

    public HierarchicalMark getMarkHierarchyRoot() {
        if (this.projectRoot == null) {
            this.projectRoot = new HierarchicalMark("SELF", PROJECT_CATEGORY, null);
        }
        return this.projectRoot;
    }

    public Marker getMethodMarker(Project project) {
        this.setupMarks(project);
        return this.marker;
    }

    public String getProfilerTargetName(Project project, FileObject fileObject, int n, FileObject fileObject2) {
        switch (n) {
            case 1: {
                return "profile";
            }
            case 4: {
                return "profile-test-single-nb";
            }
        }
        return null;
    }

    public boolean isProfilingSupported(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        if (auxiliaryConfiguration == null) {
            ProfilerLogger.severe((String)("Auxiliary Configuration is null for Project: " + project));
            return false;
        }
        Element element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_PROJECT_NAMESPACE_2, true);
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_PROJECT_NAMESPACE_3, true);
        }
        if (element == null) {
            element = auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_SUITE_PROJECT_NAMESPACE, true);
        }
        return element != null;
    }

    public FileObject getProjectBuildScript(Project project) {
        return project.getProjectDirectory().getFileObject("build.xml");
    }

    public JavaPlatform getProjectJavaPlatform(Project project) {
        AuxiliaryConfiguration auxiliaryConfiguration = (AuxiliaryConfiguration)project.getLookup().lookup(AuxiliaryConfiguration.class);
        FileObject fileObject = project.getProjectDirectory();
        if (auxiliaryConfiguration.getConfigurationFragment("data", NBMODULE_SUITE_PROJECT_NAMESPACE, true) != null) {
            SubprojectProvider subprojectProvider = (SubprojectProvider)project.getLookup().lookup(SubprojectProvider.class);
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("NB Suite " + fileObject.getPath()));
            }
            if (subprojectProvider == null) {
                return null;
            }
            Set set = subprojectProvider.getSubprojects();
            if (set.isEmpty()) {
                return null;
            }
            return this.getProjectJavaPlatform((Project)set.iterator().next());
        }
        ClassPath classPath = ClassPath.getClassPath((FileObject)fileObject, (String)"classpath/boot");
        List list = classPath.entries();
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("Boot CP " + classPath));
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)("File " + fileObject.getPath()));
        }
        JavaPlatform[] javaPlatformArray = JavaPlatformManager.getDefault().getPlatforms(null, new Specification("j2se", null));
        for (int i = 0; i < javaPlatformArray.length; ++i) {
            JavaPlatform javaPlatform = javaPlatformArray[i];
            if (!((Object)list).equals(javaPlatform.getBootstrapLibraries().entries())) continue;
            if (ProfilerLogger.isDebug()) {
                ProfilerLogger.debug((String)("Platform " + javaPlatform.getDisplayName()));
            }
            return javaPlatform;
        }
        if (ProfilerLogger.isDebug()) {
            ProfilerLogger.debug((String)"Platform null");
        }
        return null;
    }

    public boolean checkProjectCanBeProfiled(Project project, FileObject fileObject) {
        return true;
    }

    public boolean checkProjectIsModifiedForProfiler(Project project) {
        return true;
    }

    public void configurePropertiesForProfiling(Properties properties, Project project, FileObject fileObject) {
        if (fileObject != null) {
            String string = SourceUtils.getToplevelClassName((FileObject)fileObject);
            properties.setProperty("profile.class", string);
        }
    }

    private void setupMarks(Project project) {
        MethodMarker methodMarker = new MethodMarker();
        HierarchicalMark hierarchicalMark = new HierarchicalMark("UI", "Generic UI", this.getMarkHierarchyRoot());
        HierarchicalMark hierarchicalMark2 = new HierarchicalMark("UI/LISTENER", LISTENERS_CATEGORY, hierarchicalMark);
        HierarchicalMark hierarchicalMark3 = new HierarchicalMark("UI/PAINTER", PAINTERS_CATEGORY, hierarchicalMark);
        HierarchicalMark hierarchicalMark4 = new HierarchicalMark("IO", IO_CATEGORY, this.getMarkHierarchyRoot());
        HierarchicalMark hierarchicalMark5 = new HierarchicalMark("IO/FILE", FILES_CATEGORY, hierarchicalMark4);
        HierarchicalMark hierarchicalMark6 = new HierarchicalMark("IO/SOCKET", SOCKETS_CATEGORY, hierarchicalMark4);
        String[] stringArray = new String[]{"java.awt.event.ActionListener", "java.awt.event.AdjustmentListener", "java.awt.event.AWTEventListener", "java.awt.event.ComponentListener", "java.awt.event.ContainerListener", "java.awt.event.FocusListener", "java.awt.event.HierarchyBoundsListener", "java.awt.event.HierarchyListener", "java.awt.event.InputMethodListener", "java.awt.event.InputMethodListener", "java.awt.event.ItemListener", "java.awt.event.KeyListener", "java.awt.event.MouseListener", "java.awt.event.MouseMotionListener", "java.awt.event.MouseWheelListener", "java.awt.event.WindowFocusListener", "java.awt.event.WindowListener", "java.awt.event.WindowStateListener", "java.awt.event.TextListener", "javax.swing.event.AncestorListener", "javax.swing.event.CaretListener", "javax.swing.event.CellEditorListener", "javax.swing.event.ChangeListener", "javax.swing.event.DocumentListener", "javax.swing.event.HyperlinkListener", "javax.swing.event.InternalFrameListener", "javax.swing.event.ListDataListener", "javax.swing.event.ListSelectionListener", "javax.swing.event.MenuDragMouseListener", "javax.swing.event.MenuKeyListener", "javax.swing.event.MenuListener", "javax.swing.event.MouseInputListener", "javax.swing.event.PopupMenuListener", "javax.swing.event.TableColumnModelListener", "javax.swing.event.TableModelListener", "javax.swing.event.TreeExpansionListener", "javax.swing.event.TreeModelListener", "javax.swing.event.TreeSelectionListener", "javax.swing.event.TreeWillExpandListener", "javax.swing.event.UndoableEditListener"};
        this.addInterfaceMarkers(methodMarker, stringArray, (Mark)hierarchicalMark2, project);
        this.addInterfaceMarker(methodMarker, "java.awt.LightweightDispatcher", new String[]{"dispatchEvent"}, true, (Mark)hierarchicalMark2, project);
        this.addInterfaceMarker(methodMarker, "javax.swing.JComponent", new String[]{"repaint", "paint", "paintBorder", "paintChildren", "paintComponent", "paintImmediately", "print", "printAll", "printBorder", "printChildren", "printComponent"}, true, (Mark)hierarchicalMark3, project);
        this.addInterfaceMarker(methodMarker, "java.awt.Component", new String[]{"paint", "paintAll", "print", "printAll"}, true, (Mark)hierarchicalMark3, project);
        String[] stringArray2 = new String[]{"java.io.FileInputStream", "java.io.FileOuptutStream", "java.io.FileReader", "java.io.FileWriter"};
        String[] stringArray3 = new String[]{"java.nio.SocketChannel"};
        String[] stringArray4 = new String[]{"read", "write", "reset", "skip", "flush"};
        String[] stringArray5 = new String[]{"open", "read", "write"};
        this.addInterfaceMarkers(methodMarker, new String[]{"java.io.InputStreamReader", "java.io.OutputStreamWriter", "java.io.InputStream", "java.io.OutputStream"}, stringArray4, true, (Mark)hierarchicalMark4, project);
        this.addInterfaceMarkers(methodMarker, stringArray2, stringArray4, true, (Mark)hierarchicalMark5, project);
        this.addInterfaceMarkers(methodMarker, stringArray3, stringArray5, true, (Mark)hierarchicalMark6, project);
        this.marker = new CompositeMarker();
        ((CompositeMarker)this.marker).addMarker((Marker)methodMarker);
    }
}

