/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features.refactoring;

import javax.swing.JEditorPane;
import javax.swing.text.Document;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.ParserManagerImpl;
import org.netbeans.modules.languages.features.refactoring.RenameRefactoringUI;
import org.netbeans.modules.languages.features.refactoring.WhereUsedQueryUI;
import org.netbeans.modules.refactoring.spi.ui.ActionsImplementationProvider;
import org.netbeans.modules.refactoring.spi.ui.RefactoringUI;
import org.netbeans.modules.refactoring.spi.ui.UI;
import org.openide.cookies.EditorCookie;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.nodes.Node;
import org.openide.util.Lookup;
import org.openide.windows.TopComponent;

public class RefactoringActionsProvider
extends ActionsImplementationProvider {
    private static final String JS_MIME_TYPE = "text/javascript";

    public boolean canFindUsages(Lookup lookup) {
        return RefactoringActionsProvider.canRefactor(lookup);
    }

    public boolean canRename(Lookup lookup) {
        return RefactoringActionsProvider.canRefactor(lookup);
    }

    public void doFindUsages(Lookup lookup) {
        FileObject fileObject = RefactoringActionsProvider.getFileObject(lookup);
        Object[] objectArray = RefactoringActionsProvider.getASTPathAndDocument(lookup);
        ASTPath aSTPath = (ASTPath)objectArray[0];
        Document document = (Document)objectArray[1];
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        WhereUsedQueryUI whereUsedQueryUI = new WhereUsedQueryUI(aSTPath, fileObject, document);
        UI.openRefactoringUI((RefactoringUI)whereUsedQueryUI, (TopComponent)topComponent);
    }

    public void doRename(Lookup lookup) {
        FileObject fileObject = RefactoringActionsProvider.getFileObject(lookup);
        Object[] objectArray = RefactoringActionsProvider.getASTPathAndDocument(lookup);
        ASTPath aSTPath = (ASTPath)objectArray[0];
        Document document = (Document)objectArray[1];
        TopComponent topComponent = TopComponent.getRegistry().getActivated();
        RenameRefactoringUI renameRefactoringUI = new RenameRefactoringUI(aSTPath, fileObject, document);
        UI.openRefactoringUI((RefactoringUI)renameRefactoringUI, (TopComponent)topComponent);
    }

    private static FileObject getFileObject(Lookup lookup) {
        Node node = (Node)lookup.lookup(Node.class);
        DataObject dataObject = (DataObject)node.getCookie(DataObject.class);
        return dataObject.getPrimaryFile();
    }

    private static Object[] getASTPathAndDocument(Lookup lookup) {
        EditorCookie editorCookie = (EditorCookie)lookup.lookup(EditorCookie.class);
        JEditorPane jEditorPane = editorCookie.getOpenedPanes()[0];
        NbEditorDocument nbEditorDocument = (NbEditorDocument)jEditorPane.getDocument();
        String string = jEditorPane.getSelectedText();
        ASTNode aSTNode = ParserManagerImpl.getImpl((Document)nbEditorDocument).getAST();
        int n = 0;
        if (string != null) {
            n = jEditorPane.getSelectionStart();
            for (int i = 0; i < string.length() && Character.isWhitespace(string.charAt(i)); ++i) {
                ++n;
            }
        } else {
            n = jEditorPane.getCaretPosition();
        }
        return new Object[]{aSTNode.findPath(n), nbEditorDocument};
    }

    private static boolean canRefactor(Lookup lookup) {
        return false;
    }
}

