/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.languages.features;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.SwingUtilities;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Position;
import org.netbeans.api.languages.ASTEvaluator;
import org.netbeans.api.languages.ASTItem;
import org.netbeans.api.languages.ASTNode;
import org.netbeans.api.languages.ASTPath;
import org.netbeans.api.languages.ParserManager;
import org.netbeans.api.languages.SyntaxContext;
import org.netbeans.api.lexer.Token;
import org.netbeans.api.lexer.TokenHierarchy;
import org.netbeans.api.lexer.TokenSequence;
import org.netbeans.modules.editor.NbEditorDocument;
import org.netbeans.modules.languages.Feature;
import org.netbeans.modules.languages.Language;
import org.netbeans.modules.languages.features.LocalizationSupport;
import org.openide.ErrorManager;
import org.openide.text.Annotation;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AnnotationManager
extends ASTEvaluator {
    private NbEditorDocument doc;
    private ParserManager parser;
    private List<ASTItem> items;
    private List<Feature> marks;
    private List<LanguagesAnnotation> annotations = new ArrayList<LanguagesAnnotation>();

    public AnnotationManager(Document document) {
        this.doc = (NbEditorDocument)document;
        if (document == null) {
            throw new NullPointerException();
        }
        this.parser = ParserManager.get(document);
        this.parser.addASTEvaluator(this);
    }

    @Override
    public String getFeatureName() {
        return "MARK";
    }

    @Override
    public void beforeEvaluation(ParserManager.State state, ASTNode aSTNode) {
        this.items = new ArrayList<ASTItem>();
        this.marks = new ArrayList<Feature>();
    }

    @Override
    public void afterEvaluation(ParserManager.State state, ASTNode aSTNode) {
        this.refresh(this.items, this.marks);
    }

    @Override
    public void evaluate(ParserManager.State state, List<ASTItem> list, Feature feature) {
        if (feature.getBoolean("condition", SyntaxContext.create((Document)this.doc, ASTPath.create(list)), true)) {
            this.items.add(list.get(list.size() - 1));
            this.marks.add(feature);
        }
    }

    public void remove() {
        this.removeAnnotations();
        this.parser.removeASTEvaluator(this);
    }

    private void removeAnnotations() {
        Iterator<LanguagesAnnotation> iterator = this.annotations.iterator();
        while (iterator.hasNext()) {
            this.doc.removeAnnotation((Annotation)iterator.next());
        }
    }

    private void refresh(final List<ASTItem> list, final List<Feature> list2) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                try {
                    ArrayList<LanguagesAnnotation> arrayList = new ArrayList<LanguagesAnnotation>();
                    Iterator iterator = AnnotationManager.this.annotations.iterator();
                    LanguagesAnnotation languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                    Iterator iterator2 = list.iterator();
                    Iterator iterator3 = list2.iterator();
                    int n = 0;
                    while (iterator2.hasNext() && n < 100) {
                        Object object;
                        ASTItem aSTItem = (ASTItem)iterator2.next();
                        Feature feature = (Feature)iterator3.next();
                        String string = (String)feature.getValue("message");
                        Language language = (Language)aSTItem.getLanguage();
                        string = LocalizationSupport.localize(language, string);
                        String string2 = (String)feature.getValue("type");
                        while (languagesAnnotation != null && languagesAnnotation.getPosition().getOffset() < aSTItem.getOffset()) {
                            AnnotationManager.this.doc.removeAnnotation((Annotation)languagesAnnotation);
                            languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                        }
                        ++n;
                        if (languagesAnnotation != null && languagesAnnotation.getPosition().getOffset() == aSTItem.getOffset() && languagesAnnotation.getAnnotationType().equals(string2) && languagesAnnotation.getShortDescription().equals(string)) {
                            arrayList.add(languagesAnnotation);
                            languagesAnnotation = iterator.hasNext() ? (LanguagesAnnotation)((Object)iterator.next()) : null;
                            continue;
                        }
                        LanguagesAnnotation languagesAnnotation2 = new LanguagesAnnotation(string2, string);
                        if (aSTItem.getLength() == 0) {
                            object = TokenHierarchy.get((Document)AnnotationManager.this.doc);
                            TokenSequence tokenSequence = object.tokenSequence();
                            tokenSequence.move(aSTItem.getOffset());
                            if (!(tokenSequence.moveNext() && AnnotationManager.this.testCreateAnnotation(object, tokenSequence, aSTItem, languagesAnnotation2) || tokenSequence.movePrevious() && AnnotationManager.this.testCreateAnnotation(object, tokenSequence, aSTItem, languagesAnnotation2))) {
                                Position position = AnnotationManager.this.doc.createPosition(aSTItem.getOffset());
                                languagesAnnotation2.setPosition(position);
                                AnnotationManager.this.doc.addAnnotation(AnnotationManager.this.doc.createPosition(aSTItem.getOffset()), aSTItem.getLength(), (Annotation)languagesAnnotation2);
                            }
                        } else {
                            object = AnnotationManager.this.doc.createPosition(aSTItem.getOffset());
                            languagesAnnotation2.setPosition((Position)object);
                            AnnotationManager.this.doc.addAnnotation(AnnotationManager.this.doc.createPosition(aSTItem.getOffset()), aSTItem.getLength(), (Annotation)languagesAnnotation2);
                        }
                        arrayList.add(languagesAnnotation2);
                    }
                    if (languagesAnnotation != null) {
                        AnnotationManager.this.doc.removeAnnotation((Annotation)languagesAnnotation);
                    }
                    while (iterator.hasNext()) {
                        AnnotationManager.this.doc.removeAnnotation((Annotation)iterator.next());
                    }
                    AnnotationManager.this.annotations = arrayList;
                }
                catch (BadLocationException badLocationException) {
                    ErrorManager.getDefault().notify((Throwable)badLocationException);
                }
            }
        });
    }

    private boolean testCreateAnnotation(TokenHierarchy tokenHierarchy, TokenSequence tokenSequence, ASTItem aSTItem, LanguagesAnnotation languagesAnnotation) throws BadLocationException {
        if (tokenSequence.language() == null) {
            throw new NullPointerException("ts.language()==null");
        }
        if (tokenSequence.language().mimeType() == null) {
            throw new NullPointerException("TokenSequence.mimeType==null");
        }
        if (tokenSequence.language().mimeType().equals(aSTItem.getMimeType())) {
            Token token = tokenSequence.token();
            if (token == null) {
                throw new NullPointerException();
            }
            Position position = this.doc.createPosition(token.offset(tokenHierarchy));
            languagesAnnotation.setPosition(position);
            this.doc.addAnnotation(position, token.length(), (Annotation)languagesAnnotation);
            return true;
        }
        if ((tokenSequence = tokenSequence.embedded()) == null) {
            return false;
        }
        return tokenSequence.moveNext() ? this.testCreateAnnotation(tokenHierarchy, tokenSequence, aSTItem, languagesAnnotation) : false;
    }

    static class LanguagesAnnotation
    extends Annotation {
        private String type;
        private String description;
        private Position position;

        LanguagesAnnotation(String string, String string2) {
            this.type = string;
            this.description = string2;
            if (string == null) {
                throw new NullPointerException();
            }
            if (string2 == null) {
                throw new NullPointerException();
            }
        }

        public String getAnnotationType() {
            return this.type;
        }

        public String getShortDescription() {
            return this.description;
        }

        void setPosition(Position position) {
            this.position = position;
        }

        Position getPosition() {
            return this.position;
        }
    }
}

