/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.proxy;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.netbeans.modules.cnd.api.utils.Path;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.ExternalTerminal;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbLogger;
import org.netbeans.modules.cnd.debugger.gdb.proxy.GdbProxy;
import org.netbeans.modules.cnd.debugger.gdb.utils.CommandBuffer;
import org.openide.util.RequestProcessor;
import org.openide.util.Utilities;

public class GdbProxyEngine {
    private static final int MIN_TOKEN = 100;
    private PrintStream toGdb;
    private GdbDebugger debugger;
    private GdbProxy gdbProxy;
    private LinkedList<CommandInfo> tokenList;
    private int nextToken = 100;
    private int currentToken = 100;
    private boolean active;
    private boolean timerOn = Boolean.getBoolean("gdb.proxy.timer");
    private Logger log = Logger.getLogger("gdb.gdbproxy.logger");

    public GdbProxyEngine(GdbDebugger gdbDebugger, GdbProxy gdbProxy, List list, String[] stringArray, String string, String string2, String string3) throws IOException {
        Object object;
        Object object2;
        if (Utilities.isUnix() && string2 != null && (object2 = ((ExternalTerminal)(object = new ExternalTerminal(gdbDebugger, string2, stringArray))).getTty()) != null) {
            list.add("-tty");
            list.add(object2);
        }
        this.debugger = gdbDebugger;
        this.gdbProxy = gdbProxy;
        this.tokenList = new LinkedList();
        this.active = true;
        object = new ProcessBuilder(list);
        this.getLogger().logMessage("Debugger Command: " + list);
        this.getLogger().logMessage("Env[" + stringArray.length + "]: " + Arrays.asList(stringArray));
        this.getLogger().logMessage("workingDirectory: " + string);
        this.getLogger().logMessage("================================================");
        object2 = ((ProcessBuilder)object).environment();
        Process process = null;
        String string4 = Path.getPathName();
        for (String string5 : stringArray) {
            int n = string5.indexOf(61);
            if (n == -1) continue;
            String string6 = string5.substring(0, n);
            String string7 = string5.substring(n + 1);
            if (string6.equals(string4)) {
                object2.put(string6, string7 + File.pathSeparator + string3);
                continue;
            }
            object2.put(string6, string7);
        }
        if (!object2.containsKey(string4)) {
            object2.put(string4, Path.getPathAsString() + File.pathSeparator + string3);
        }
        ((ProcessBuilder)object).directory(new File(string));
        ((ProcessBuilder)object).redirectErrorStream(true);
        process = ((ProcessBuilder)object).start();
        final BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(process.getInputStream()));
        new RequestProcessor("GdbReaderRP").post(new Runnable(){

            public void run() {
                try {
                    String string;
                    while ((string = bufferedReader.readLine()) != null) {
                        if ((string = string.trim()).length() <= 0) continue;
                        GdbProxyEngine.this.processMessage(string);
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        });
        this.toGdb = new PrintStream(process.getOutputStream(), true);
        final Process process2 = process;
        final GdbDebugger gdbDebugger2 = gdbDebugger;
        new RequestProcessor("GdbReaperThread").post(new Runnable(){

            public void run() {
                try {
                    int n = process2.waitFor();
                    if (n == 0) {
                        gdbDebugger2.finish(false);
                    } else {
                        gdbDebugger2.unexpectedGdbExit(n);
                    }
                    return;
                }
                catch (InterruptedException interruptedException) {
                    interruptedException.printStackTrace();
                    return;
                }
            }
        });
    }

    private int nextToken() {
        return this.nextToken++;
    }

    int sendCommand(String string) {
        return this.sendCommand(null, string, false);
    }

    int sendCommand(CommandBuffer commandBuffer, String string) {
        return this.sendCommand(commandBuffer, string, false);
    }

    int sendCommand(CommandBuffer commandBuffer, String string, boolean bl) {
        if (this.active) {
            String string2 = this.timerOn ? Long.toString(System.currentTimeMillis()) + ':' : "";
            int n = this.nextToken();
            if (commandBuffer != null) {
                commandBuffer.setID(n);
            }
            if (bl) {
                n += 10000;
            } else if (string.charAt(0) != '-') {
                this.tokenList.add(new CommandInfo(n, string));
            }
            StringBuilder stringBuilder = new StringBuilder(String.valueOf(n));
            stringBuilder.append(string);
            stringBuilder.append('\n');
            this.gdbProxy.getLogger().logMessage(string2 + stringBuilder.toString());
            this.toGdb.print(stringBuilder.toString());
            return n;
        }
        return -1;
    }

    int sendConsoleCommand(String string) {
        return this.sendCommand(null, string, true);
    }

    void stopSending() {
        this.active = false;
    }

    private void processMessage(String string) {
        String string2 = this.timerOn ? Long.toString(System.currentTimeMillis()) + ':' : "";
        if (string.equals("(gdb)")) {
            return;
        }
        int n = this.getToken(string);
        if (n < 0) {
            n = this.getCurrentToken(string);
            if (n != -1) {
                this.gdbProxy.getLogger().logMessage(string2 + n + string);
            } else {
                this.gdbProxy.getLogger().logMessage(string2 + string);
            }
        } else {
            this.gdbProxy.getLogger().logMessage(string2 + string);
        }
        string = this.stripToken(string);
        if (string.length() == 0) {
            this.log.warning("Empty message received from gdb");
            return;
        }
        switch (string.charAt(0)) {
            case '^': {
                if (n == this.currentToken && string.equals("^done")) {
                    this.currentToken = -1;
                }
                this.debugger.resultRecord(n, string);
                break;
            }
            case '*': {
                this.debugger.execAsyncOutput(n, string);
                break;
            }
            case '+': {
                this.debugger.statusAsyncOutput(n, string);
                break;
            }
            case '=': {
                this.debugger.notifyAsyncOutput(n, string);
                break;
            }
            case '~': {
                this.debugger.consoleStreamOutput(n, string.substring(2, string.length() - 1));
                break;
            }
            case '@': {
                this.debugger.targetStreamOutput(string);
                break;
            }
            case '&': {
                this.debugger.logStreamOutput(string);
                break;
            }
            default: {
                this.debugger.output(string);
            }
        }
    }

    private int getCurrentToken(String string) {
        CommandInfo commandInfo;
        char c = string.charAt(0);
        if (c == '&' && (commandInfo = this.getCommandInfo(string)) != null) {
            this.tokenList.remove(commandInfo);
            this.currentToken = commandInfo.getToken();
        }
        return this.currentToken;
    }

    private CommandInfo getCommandInfo(String string) {
        string = string.substring(2, string.length() - 1).replace("\\n", "");
        for (CommandInfo commandInfo : this.tokenList) {
            if (!commandInfo.getCommand().equals(string)) continue;
            return commandInfo;
        }
        return null;
    }

    private int getToken(String string) {
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        if (n > 0) {
            return Integer.parseInt(string.substring(0, n));
        }
        return -1;
    }

    private String stripToken(String string) {
        char c;
        int n;
        for (n = 0; n < string.length() && Character.isDigit(string.charAt(n)); ++n) {
        }
        char c2 = c = n < string.length() ? string.charAt(n) : (char)'\u0000';
        if ((c == '^' || c == '*' || c == '+' || c == '=') && c != '\u0000') {
            return string.substring(n);
        }
        return string;
    }

    private GdbLogger getLogger() {
        return this.gdbProxy.getLogger();
    }

    private static class CommandInfo {
        private int token;
        private String cmd;

        public CommandInfo(int n, String string) {
            this.token = n;
            this.cmd = string;
        }

        private String getCommand() {
            return this.cmd;
        }

        public int getToken() {
            return this.token;
        }

        public boolean equals(Object object) {
            if (object instanceof CommandInfo) {
                CommandInfo commandInfo = (CommandInfo)object;
                return this.cmd.equals(commandInfo.getCommand());
            }
            if (object instanceof String) {
                return this.cmd.equals(object.toString());
            }
            return false;
        }

        public int hashCode() {
            return this.token;
        }
    }
}

