/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerAdapter;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.models.AbstractVariable;
import org.netbeans.modules.cnd.debugger.gdb.models.GdbWatchVariable;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeExpansionModel;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakSet;

public class WatchesTreeModel
implements TreeModel,
TreeExpansionModel,
PropertyChangeListener {
    private GdbDebugger debugger;
    private ContextProvider lookupProvider;
    private static WatchesTreeModel watchesTreeModel;
    private Listener listener;
    private Vector<ModelListener> listeners = new Vector();
    private Map<Watch, AbstractVariable> watchToVariable = new WeakHashMap<Watch, AbstractVariable>();
    private Set<Object> expandedNodes = new WeakSet();
    private Set<Object> collapsedNodes = new WeakSet();
    private Logger log = Logger.getLogger("gdb.logger");

    public WatchesTreeModel(ContextProvider contextProvider) {
        this.lookupProvider = contextProvider;
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.debugger.addPropertyChangeListener(this);
        watchesTreeModel = this;
    }

    public static WatchesTreeModel getWatchesTreeModel() {
        return watchesTreeModel;
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getPropertyName().equals("state") && this.debugger.getState().equals("state_stopped")) {
            this.fireTreeChanged();
        }
    }

    public Object getRoot() {
        return "Root";
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object == "Root") {
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            n2 = Math.min(watchArray.length, n2);
            n = Math.min(watchArray.length, n);
            Watch[] watchArray2 = new Watch[n2 - n];
            System.arraycopy(watchArray, n, watchArray2, 0, n2 - n);
            int n3 = watchArray2.length;
            Object[] objectArray = new AbstractVariable[n3];
            for (int i = 0; i < n3; ++i) {
                AbstractVariable abstractVariable = this.watchToVariable.get(watchArray2[i]);
                if (abstractVariable == null) {
                    abstractVariable = new GdbWatchVariable(this, watchArray2[i]);
                    this.watchToVariable.put(watchArray2[i], abstractVariable);
                }
                objectArray[i] = abstractVariable;
            }
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
            return objectArray;
        }
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getFields(n, n2);
        }
        throw new UnknownTypeException(object);
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return false;
        }
        if (object instanceof Watch) {
            return true;
        }
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getFieldsCount() == 0;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object == "Root") {
            return DebuggerManager.getDebuggerManager().getWatches().length;
        }
        if (object instanceof AbstractVariable) {
            return ((AbstractVariable)object).getFieldsCount();
        }
        throw new UnknownTypeException(object);
    }

    public void addModelListener(ModelListener modelListener) {
        this.listeners.add(modelListener);
    }

    public void removeModelListener(ModelListener modelListener) {
        this.listeners.remove(modelListener);
    }

    protected void fireTreeChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        this.log.fine("WTM.fireTreeChanged[" + Thread.currentThread().getName() + "]:");
        ModelEvent.TreeChanged treeChanged = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)treeChanged);
        }
    }

    private void fireWatchesChanged() {
        Vector vector = (Vector)this.listeners.clone();
        int n = vector.size();
        ModelEvent.NodeChanged nodeChanged = new ModelEvent.NodeChanged((Object)this, (Object)"Root", 8);
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)nodeChanged);
        }
    }

    void fireTableValueChanged(Object object, String string) {
        Vector vector = (Vector)this.listeners.clone();
        this.log.fine("WTM.fireTableValueChanged[" + Thread.currentThread().getName() + "]:");
        int n = vector.size();
        for (int i = 0; i < n; ++i) {
            ((ModelListener)vector.get(i)).modelChanged((ModelEvent)new ModelEvent.TableValueChanged((Object)this, object, string));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isExpanded(Object object) throws UnknownTypeException {
        WatchesTreeModel watchesTreeModel = this;
        synchronized (watchesTreeModel) {
            if (this.expandedNodes.contains(object)) {
                return true;
            }
            if (this.collapsedNodes.contains(object)) {
                return false;
            }
        }
        if (object instanceof AbstractVariable) {
            return false;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeExpanded(Object object) {
        PropertyChangeListener propertyChangeListener;
        if (object instanceof AbstractVariable && ((AbstractVariable)(propertyChangeListener = (AbstractVariable)object)).expandChildren()) {
            this.fireTreeChanged();
        }
        propertyChangeListener = this;
        synchronized (propertyChangeListener) {
            this.expandedNodes.add(object);
            this.collapsedNodes.remove(object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void nodeCollapsed(Object object) {
        WatchesTreeModel watchesTreeModel = this;
        synchronized (watchesTreeModel) {
            this.collapsedNodes.add(object);
            this.expandedNodes.remove(object);
        }
    }

    private static class Listener
    extends DebuggerManagerAdapter
    implements PropertyChangeListener {
        private WeakReference model;
        private WeakReference debugger;
        private RequestProcessor.Task task;

        private Listener(WatchesTreeModel watchesTreeModel, GdbDebugger gdbDebugger) {
            this.model = new WeakReference<WatchesTreeModel>(watchesTreeModel);
            this.debugger = new WeakReference<GdbDebugger>(gdbDebugger);
            DebuggerManager.getDebuggerManager().addDebuggerListener("watches", (DebuggerManagerListener)this);
            gdbDebugger.addPropertyChangeListener(this);
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].addPropertyChangeListener((PropertyChangeListener)this);
            }
        }

        private WatchesTreeModel getModel() {
            WatchesTreeModel watchesTreeModel = (WatchesTreeModel)this.model.get();
            if (watchesTreeModel == null) {
                this.destroy();
            }
            return watchesTreeModel;
        }

        public void watchAdded(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            watch.addPropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireWatchesChanged();
        }

        public void watchRemoved(Watch watch) {
            WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            Object v = watchesTreeModel.watchToVariable.remove(watch);
            watch.removePropertyChangeListener((PropertyChangeListener)this);
            watchesTreeModel.fireWatchesChanged();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if ("watches".equals(string)) {
                return;
            }
            final WatchesTreeModel watchesTreeModel = this.getModel();
            if (watchesTreeModel == null) {
                return;
            }
            if (watchesTreeModel.debugger.getState().equals("state_exited")) {
                this.destroy();
                return;
            }
            if (watchesTreeModel.debugger.getState().equals("state_running")) {
                return;
            }
            if (propertyChangeEvent.getSource() instanceof Watch) {
                Object v;
                Map map = watchesTreeModel.watchToVariable;
                synchronized (map) {
                    v = watchesTreeModel.watchToVariable.get(propertyChangeEvent.getSource());
                }
                if (v != null) {
                    if (v instanceof AbstractVariable && ((AbstractVariable)v).getFieldsCount() > 0) {
                        watchesTreeModel.fireTreeChanged();
                    } else {
                        watchesTreeModel.fireTableValueChanged(v, null);
                    }
                    return;
                }
            }
            if (this.task == null) {
                this.task = RequestProcessor.getDefault().create(new Runnable(){

                    public void run() {
                        watchesTreeModel.fireTreeChanged();
                    }
                });
            }
            this.task.schedule(100);
        }

        private void destroy() {
            DebuggerManager.getDebuggerManager().removeDebuggerListener("watches", (DebuggerManagerListener)this);
            GdbDebugger gdbDebugger = (GdbDebugger)this.debugger.get();
            if (gdbDebugger != null) {
                gdbDebugger.removePropertyChangeListener(this);
            }
            Watch[] watchArray = DebuggerManager.getDebuggerManager().getWatches();
            int n = watchArray.length;
            for (int i = 0; i < n; ++i) {
                watchArray[i].removePropertyChangeListener((PropertyChangeListener)this);
            }
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }
    }
}

