/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.models;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.HashSet;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.spi.debugger.ContextProvider;
import org.netbeans.spi.viewmodel.ModelEvent;
import org.netbeans.spi.viewmodel.ModelListener;
import org.netbeans.spi.viewmodel.TreeModel;
import org.netbeans.spi.viewmodel.UnknownTypeException;
import org.openide.util.RequestProcessor;

public class ThreadsTreeModel
implements TreeModel {
    private GdbDebugger debugger;
    private Collection listeners = new HashSet();
    private Listener listener;

    public ThreadsTreeModel(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
    }

    public Object[] getChildren(Object object, int n, int n2) throws UnknownTypeException {
        if (object.equals("Root")) {
            Object[] objectArray = this.debugger.getThreadsList();
            return objectArray;
        }
        throw new UnknownTypeException(object);
    }

    public int getChildrenCount(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return this.debugger.getThreadCount();
        }
        throw new UnknownTypeException(object);
    }

    public Object getRoot() {
        return "Root";
    }

    public boolean isLeaf(Object object) throws UnknownTypeException {
        if (object.equals("Root")) {
            return false;
        }
        if (object instanceof String) {
            return true;
        }
        throw new UnknownTypeException(object);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addModelListener(ModelListener modelListener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.add(modelListener);
            if (this.listener == null) {
                this.listener = new Listener(this, this.debugger);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeModelListener(ModelListener modelListener) {
        Collection collection = this.listeners;
        synchronized (collection) {
            this.listeners.remove(modelListener);
            if (this.listeners.size() == 0) {
                this.listener.destroy();
                this.listener = null;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void fireTreeChanged() {
        Object[] objectArray;
        Collection collection = this.listeners;
        synchronized (collection) {
            objectArray = this.listeners.toArray();
        }
        collection = new ModelEvent.TreeChanged((Object)this);
        for (int i = 0; i < objectArray.length; ++i) {
            ((ModelListener)objectArray[i]).modelChanged((ModelEvent)collection);
        }
    }

    private static class Listener
    implements PropertyChangeListener {
        private GdbDebugger debugger;
        private WeakReference model;
        private RequestProcessor.Task task;

        public Listener(ThreadsTreeModel threadsTreeModel, GdbDebugger gdbDebugger) {
            this.debugger = gdbDebugger;
            this.model = new WeakReference<ThreadsTreeModel>(threadsTreeModel);
            gdbDebugger.addPropertyChangeListener(this);
        }

        private ThreadsTreeModel getModel() {
            ThreadsTreeModel threadsTreeModel = (ThreadsTreeModel)this.model.get();
            if (threadsTreeModel == null) {
                this.destroy();
            }
            return threadsTreeModel;
        }

        void destroy() {
            this.debugger.removePropertyChangeListener(this);
            if (this.task != null) {
                this.task.cancel();
                this.task = null;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            String string = propertyChangeEvent.getPropertyName();
            if (string.equals("state") && this.debugger.getState().equals("state_stopped") || string.equals("currentThread")) {
                Listener listener = this;
                synchronized (listener) {
                    if (this.task == null) {
                        this.task = RequestProcessor.getDefault().create((Runnable)new Refresher());
                    }
                    this.task.schedule(200);
                }
            }
        }

        private class Refresher
        implements Runnable {
            private Refresher() {
            }

            public void run() {
                ThreadsTreeModel threadsTreeModel;
                if (Listener.this.debugger.getState().equals("state_stopped") && (threadsTreeModel = Listener.this.getModel()) != null) {
                    threadsTreeModel.fireTreeChanged();
                }
            }
        }
    }
}

