/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Line;
import org.openide.util.WeakListeners;

class LineTranslations {
    private static LineTranslations translations;
    private ChangeListener changedFilesListener;
    private Map<Object, Registry> timeStampToRegistry = new WeakHashMap<Object, Registry>();
    private Map<LineBreakpoint, BreakpointLineUpdater> lineUpdaters = new HashMap<LineBreakpoint, BreakpointLineUpdater>();
    private Map<Object, Map<LineBreakpoint, Integer>> originalBreakpointLines = new WeakHashMap<Object, Map<LineBreakpoint, Integer>>();
    private Map<Object, PropertyChangeListener> breakpointListeners = new WeakHashMap<Object, PropertyChangeListener>();

    private LineTranslations() {
    }

    static synchronized LineTranslations getTranslations() {
        if (translations == null) {
            translations = new LineTranslations();
        }
        return translations;
    }

    synchronized void createTimeStamp(Object object) {
        Set set = DataObject.getRegistry().getModifiedSet();
        Registry registry = new Registry();
        this.timeStampToRegistry.put(object, registry);
        for (DataObject dataObject : set) {
            registry.register(dataObject);
        }
        if (this.changedFilesListener == null) {
            this.changedFilesListener = new ChangedFilesListener();
            DataObject.getRegistry().addChangeListener(this.changedFilesListener);
        }
    }

    synchronized void disposeTimeStamp(Object object) {
        this.timeStampToRegistry.remove(object);
        if (this.timeStampToRegistry.isEmpty()) {
            DataObject.getRegistry().removeChangeListener(this.changedFilesListener);
            this.changedFilesListener = null;
        }
        this.originalBreakpointLines.remove(object);
        this.breakpointListeners.remove(object);
    }

    synchronized int getOriginalLineNumber(LineBreakpoint lineBreakpoint, final Object object) {
        Map<LineBreakpoint, Integer> map = this.originalBreakpointLines.get(object);
        if (map != null) {
            Integer n = map.get((Object)lineBreakpoint);
            if (n != null) {
                return n;
            }
        } else {
            map = new WeakHashMap<LineBreakpoint, Integer>();
            this.originalBreakpointLines.put(object, map);
        }
        int n = this.getOriginalLineNumber(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
        map.put(lineBreakpoint, n);
        PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if ("lineNumber".equals(propertyChangeEvent.getPropertyName())) {
                    LineTranslations lineTranslations = LineTranslations.this;
                    synchronized (lineTranslations) {
                        Map map = (Map)LineTranslations.this.originalBreakpointLines.get(object);
                        if (map != null) {
                            LineBreakpoint lineBreakpoint = (LineBreakpoint)((Object)propertyChangeEvent.getSource());
                            int n = LineTranslations.this.getOriginalLineNumber(lineBreakpoint.getURL(), lineBreakpoint.getLineNumber(), object);
                            map.put(lineBreakpoint, n);
                        }
                    }
                }
            }
        };
        this.breakpointListeners.put(object, propertyChangeListener);
        lineBreakpoint.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)propertyChangeListener, (Object)((Object)lineBreakpoint)));
        return n;
    }

    int getOriginalLineNumber(String string, int n, Object object) {
        if (object == null) {
            return n;
        }
        Line.Set set = this.getLineSet(string, object);
        if (set == null) {
            return n;
        }
        try {
            return set.getOriginalLineNumber(set.getCurrent(n));
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return n;
        }
    }

    synchronized void updateTimeStamp(Object object, String string) {
        Registry registry = this.timeStampToRegistry.get(object);
        registry.register(LineTranslations.getDataObject(string));
        Map<LineBreakpoint, Integer> map = this.originalBreakpointLines.get(object);
        if (map != null) {
            HashSet<LineBreakpoint> hashSet = new HashSet<LineBreakpoint>(map.keySet());
            for (LineBreakpoint lineBreakpoint : hashSet) {
                if (!string.equals(lineBreakpoint.getURL())) continue;
                map.remove((Object)lineBreakpoint);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    Line.Set getLineSet(String string, Object object) {
        LineTranslations lineTranslations;
        DataObject dataObject = LineTranslations.getDataObject(string);
        if (dataObject == null) {
            return null;
        }
        if (object != null) {
            lineTranslations = this;
            synchronized (lineTranslations) {
                Line.Set set;
                Registry registry = this.timeStampToRegistry.get(object);
                if (registry != null && (set = registry.getLineSet(dataObject)) != null) {
                    return set;
                }
            }
        }
        if ((lineTranslations = (LineCookie)dataObject.getCookie(LineCookie.class)) == null) {
            return null;
        }
        return lineTranslations.getLineSet();
    }

    Line getLine(String string, int n, Object object) {
        Line.Set set = this.getLineSet(string, object);
        if (set == null) {
            return null;
        }
        try {
            if (object == null) {
                return set.getCurrent(n - 1);
            }
            return set.getOriginal(n - 1);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return null;
    }

    synchronized void registerForLineUpdates(LineBreakpoint lineBreakpoint) {
        DataObject dataObject = LineTranslations.getDataObject(lineBreakpoint.getURL());
        if (dataObject != null) {
            BreakpointLineUpdater breakpointLineUpdater = new BreakpointLineUpdater(lineBreakpoint, dataObject);
            try {
                breakpointLineUpdater.attach();
                this.lineUpdaters.put(lineBreakpoint, breakpointLineUpdater);
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    synchronized void unregisterFromLineUpdates(LineBreakpoint lineBreakpoint) {
        BreakpointLineUpdater breakpointLineUpdater = this.lineUpdaters.remove((Object)lineBreakpoint);
        if (breakpointLineUpdater != null) {
            breakpointLineUpdater.detach();
        }
    }

    private static DataObject getDataObject(String string) {
        FileObject fileObject;
        try {
            fileObject = URLMapper.findFileObject((URL)new URL(string));
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
        if (fileObject == null) {
            return null;
        }
        try {
            return DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            return null;
        }
    }

    private class BreakpointLineUpdater
    implements PropertyChangeListener {
        private LineBreakpoint lb;
        private DataObject dataObject;
        private LineCookie lc;
        private Line line;
        private boolean updatingLine = false;

        public BreakpointLineUpdater(LineBreakpoint lineBreakpoint, DataObject dataObject) {
            this.lb = lineBreakpoint;
            this.dataObject = dataObject;
        }

        public synchronized void attach() throws IOException {
            this.lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
            if (this.lc == null) {
                return;
            }
            this.lb.addPropertyChangeListener(this);
            try {
                this.line = this.lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                this.line.addPropertyChangeListener((PropertyChangeListener)this);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                // empty catch block
            }
        }

        public synchronized void detach() {
            this.lb.removePropertyChangeListener(this);
            if (this.line != null) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private synchronized void update() {
            this.updatingLine = true;
            try {
                this.lb.setLineNumber(this.line.getLineNumber() + 1);
            }
            finally {
                this.updatingLine = false;
            }
        }

        public synchronized void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            block8: {
                if ("lineNumber".equals(propertyChangeEvent.getPropertyName()) && this.line == propertyChangeEvent.getSource()) {
                    this.update();
                    return;
                }
                if (!this.updatingLine && "lineNumber".equals(propertyChangeEvent.getPropertyName())) {
                    boolean bl = this.line != null;
                    try {
                        this.line = this.lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                        if (!bl) {
                            this.line.addPropertyChangeListener((PropertyChangeListener)this);
                        }
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        if (!bl) break block8;
                        this.line.removePropertyChangeListener((PropertyChangeListener)this);
                        this.line = null;
                    }
                }
            }
            if ("url".equals(propertyChangeEvent.getPropertyName())) {
                this.line.removePropertyChangeListener((PropertyChangeListener)this);
                this.dataObject = LineTranslations.getDataObject(this.lb.getURL());
                this.lc = (LineCookie)this.dataObject.getCookie(LineCookie.class);
                try {
                    this.line = this.lc.getLineSet().getCurrent(this.lb.getLineNumber() - 1);
                    this.line.addPropertyChangeListener((PropertyChangeListener)this);
                }
                catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                    this.line = null;
                }
            }
        }
    }

    private class ChangedFilesListener
    implements ChangeListener {
        private ChangedFilesListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void stateChanged(ChangeEvent changeEvent) {
            HashSet hashSet = new HashSet(DataObject.getRegistry().getModifiedSet());
            LineTranslations lineTranslations = LineTranslations.this;
            synchronized (lineTranslations) {
                for (Registry registry : LineTranslations.this.timeStampToRegistry.values()) {
                    for (DataObject dataObject : hashSet) {
                        registry.registerIfNotThere(dataObject);
                    }
                }
            }
        }
    }

    private static class Registry {
        private Map<DataObject, Line.Set> dataObjectToLineSet = new HashMap<DataObject, Line.Set>();

        private Registry() {
        }

        synchronized void register(DataObject dataObject) {
            LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
            if (lineCookie == null) {
                return;
            }
            this.dataObjectToLineSet.put(dataObject, lineCookie.getLineSet());
        }

        synchronized void registerIfNotThere(DataObject dataObject) {
            if (!this.dataObjectToLineSet.containsKey(dataObject)) {
                this.register(dataObject);
            }
        }

        synchronized Line.Set getLineSet(DataObject dataObject) {
            return this.dataObjectToLineSet.get(dataObject);
        }
    }
}

