/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.project.ui.OpenProjects;
import org.netbeans.modules.cnd.debugger.gdb.EditorContextBridge;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.ActionsPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.ConditionsPanel;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.spi.debugger.ui.Controller;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.filesystems.URLMapper;
import org.openide.util.HelpCtx;
import org.openide.util.NbBundle;
import org.openide.util.Utilities;

public class LineBreakpointPanel
extends JPanel
implements Controller,
HelpCtx.Provider {
    private ConditionsPanel conditionsPanel;
    private ActionsPanel actionsPanel;
    private LineBreakpoint breakpoint;
    private boolean createBreakpoint = false;
    private JLabel lFileName;
    private JLabel lLineNumber;
    private JPanel pActions;
    private JPanel pConditions;
    private JPanel pSettings;
    private JTextField tfFileName;
    private JTextField tfLineNumber;

    public LineBreakpointPanel() {
        this(LineBreakpointPanel.createBreakpoint());
        this.createBreakpoint = true;
    }

    public LineBreakpointPanel(LineBreakpoint lineBreakpoint) {
        Object object;
        String string = null;
        String string2 = lineBreakpoint.getURL();
        this.breakpoint = lineBreakpoint;
        this.initComponents();
        try {
            object = URLMapper.findFileObject((URL)new URL(string2));
            if (object != null) {
                string = object.getMIMEType();
            }
        }
        catch (MalformedURLException malformedURLException) {
            // empty catch block
        }
        if (string2.length() > 0 && string != null && (string.equals("text/x-c++") || string.equals("text/x-c") || string.equals("text/x-fortran"))) {
            try {
                object = new URI(string2);
                String string3 = ((URI)object).getPath();
                if (Utilities.isWindows() && string3.charAt(0) == '/') {
                    string3 = string3.substring(1);
                }
                this.tfFileName.setText(string3);
            }
            catch (Exception exception) {
                this.tfFileName.setText(string2);
            }
        } else {
            this.tfFileName.setEditable(true);
        }
        if (lineBreakpoint.getLineNumber() > 0) {
            this.tfLineNumber.setText(Integer.toString(lineBreakpoint.getLineNumber()));
        }
        this.conditionsPanel = new ConditionsPanel(lineBreakpoint);
        this.pConditions.add((Component)this.conditionsPanel, "Center");
        this.actionsPanel = new ActionsPanel(lineBreakpoint);
        this.pActions.add((Component)this.actionsPanel, "Center");
    }

    private static LineBreakpoint createBreakpoint() {
        String string = EditorContextBridge.getMostRecentURL();
        int n = EditorContextBridge.getMostRecentLineNumber();
        LineBreakpoint lineBreakpoint = LineBreakpoint.create(string, n);
        lineBreakpoint.setPrintText(NbBundle.getBundle(LineBreakpointPanel.class).getString("CTL_Line_Breakpoint_Print_Text"));
        return lineBreakpoint;
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("NetbeansDebuggerBreakpointLineGDB");
    }

    private void initComponents() {
        this.pSettings = new JPanel();
        this.lFileName = new JLabel();
        this.tfFileName = new JTextField();
        this.lLineNumber = new JLabel();
        this.tfLineNumber = new JTextField();
        this.pConditions = new JPanel();
        this.pActions = new JPanel();
        this.setLayout(new GridBagLayout());
        ResourceBundle resourceBundle = ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle");
        this.pSettings.setBorder(BorderFactory.createTitledBorder(resourceBundle.getString("L_Line_Breakpoint_BorderTitle")));
        this.pSettings.setMinimumSize(new Dimension(249, 105));
        this.pSettings.setPreferredSize(new Dimension(144, 105));
        this.pSettings.setLayout(new GridBagLayout());
        this.lFileName.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_File_Name").charAt(0));
        this.lFileName.setLabelFor(this.tfFileName);
        this.lFileName.setText(resourceBundle.getString("L_Line_Breakpoint_File_Name"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lFileName, gridBagConstraints);
        this.lFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_File_Name"));
        this.tfFileName.setEditable(false);
        this.tfFileName.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_File_Name"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfFileName, gridBagConstraints);
        this.tfFileName.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.tfFileName.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_File_Name"));
        this.lLineNumber.setDisplayedMnemonic(ResourceBundle.getBundle("org/netbeans/modules/cnd/debugger/gdb/breakpoints/Bundle").getString("MN_L_Line_Breakpoint_Line_Number").charAt(0));
        this.lLineNumber.setLabelFor(this.tfLineNumber);
        this.lLineNumber.setText(resourceBundle.getString("L_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.lLineNumber, gridBagConstraints);
        this.lLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_L_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.setToolTipText(resourceBundle.getString("TTT_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(3, 3, 3, 3);
        this.pSettings.add((Component)this.tfLineNumber, gridBagConstraints);
        this.tfLineNumber.getAccessibleContext().setAccessibleName(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        this.tfLineNumber.getAccessibleContext().setAccessibleDescription(resourceBundle.getString("ACSD_TF_Line_Breakpoint_Line_Number"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pSettings, gridBagConstraints);
        this.pConditions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pConditions, gridBagConstraints);
        this.pActions.setLayout(new BorderLayout());
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.pActions, gridBagConstraints);
    }

    public boolean ok() {
        String string = this.validateBreakpoint();
        if (string != null) {
            DialogDisplayer.getDefault().notify((NotifyDescriptor)new NotifyDescriptor.Message((Object)string));
            return false;
        }
        String string2 = this.tfLineNumber.getText().trim();
        if (string2.length() > 0) {
            this.breakpoint.setLineNumber(Integer.parseInt(string2));
        }
        this.conditionsPanel.ok();
        this.actionsPanel.ok();
        DebuggerManager debuggerManager = DebuggerManager.getDebuggerManager();
        Breakpoint[] breakpointArray = debuggerManager.getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            String string3;
            String string4;
            if (!(breakpointArray[i] instanceof LineBreakpoint)) continue;
            LineBreakpoint lineBreakpoint = (LineBreakpoint)breakpointArray[i];
            if (this.breakpoint.getLineNumber() != lineBreakpoint.getLineNumber() || !(string4 = this.breakpoint.getURL()).equals(lineBreakpoint.getURL()) || ((string3 = this.breakpoint.getCondition()) == null ? lineBreakpoint.getCondition() != null : !string3.equals(lineBreakpoint.getCondition()))) continue;
            if (!lineBreakpoint.isEnabled()) {
                breakpointArray[i].enable();
            }
            return true;
        }
        if (this.createBreakpoint) {
            DebuggerManager.getDebuggerManager().addBreakpoint((Breakpoint)this.breakpoint);
        }
        return true;
    }

    public boolean cancel() {
        return true;
    }

    public boolean isValid() {
        return true;
    }

    private String validateBreakpoint() {
        String string = this.tfFileName.getText();
        if (string == null || string.length() == 0) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_No_File_Name_Spec");
        }
        File file = new File(string);
        if (!file.isAbsolute()) {
            file = new File(this.getRunDirectory(), string);
        }
        if (!file.exists()) {
            return NbBundle.getMessage(LineBreakpointPanel.class, (String)"MSG_File_Name_Does_Not_Exist");
        }
        this.breakpoint.setURL(file.getAbsolutePath());
        return null;
    }

    private String getRunDirectory() {
        try {
            return FileUtil.toFile((FileObject)OpenProjects.getDefault().getMainProject().getProjectDirectory()).getAbsolutePath();
        }
        catch (Exception exception) {
            return ".";
        }
    }
}

