/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;

public class FunctionBreakpoint
extends GdbBreakpoint {
    public static final String PROP_FUNCTION_NAME = "functionName";
    public static final String PROP_BREAKPOINT_TYPE = "breakpointType";
    public static final int TYPE_FUNCTION_ENTRY = 1;
    public static final int TYPE_FUNCTION_EXIT = 2;
    private String function = "";
    private int type;

    private FunctionBreakpoint() {
    }

    public static FunctionBreakpoint create(String string) {
        FunctionBreakpointComparable functionBreakpointComparable = new FunctionBreakpointComparable();
        functionBreakpointComparable.setFunctionName(string);
        return functionBreakpointComparable;
    }

    public String getFunctionName() {
        return this.function;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setFunctionName(String string) {
        String string2 = this.function;
        FunctionBreakpoint functionBreakpoint = this;
        synchronized (functionBreakpoint) {
            int n;
            if (string == null) {
                string = "";
            }
            if ((n = string.indexOf(32)) > 0) {
                string = string.replaceAll(" ", "");
            }
            if ((n = string.indexOf("(void)")) > 0) {
                string = string.substring(0, n + 1) + string.substring(n + 5);
            }
            if (string.equals(this.function)) {
                return;
            }
            this.function = string;
            this.firePropertyChange(PROP_FUNCTION_NAME, string2, string);
        }
    }

    public void setBreakpointType(int n) {
        this.type = n;
    }

    public int getBreakpointType() {
        return this.type;
    }

    public String toString() {
        return "FunctionBreakpoint " + this.function;
    }

    private static class FunctionBreakpointComparable
    extends FunctionBreakpoint
    implements Comparable {
        public int compareTo(Object object) {
            if (object instanceof FunctionBreakpointComparable) {
                FunctionBreakpointComparable functionBreakpointComparable = this;
                FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)((Object)object);
                return ((FunctionBreakpoint)functionBreakpointComparable).function.compareTo(functionBreakpoint.function);
            }
            return -1;
        }
    }
}

