/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.HashMap;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.LazyActionsManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.GdbDebugger;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.BreakpointsReader;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpointImpl;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.PersistenceManager;
import org.netbeans.spi.debugger.ContextProvider;

public class BreakpointsEngineListener
extends LazyActionsManagerListener
implements PropertyChangeListener,
DebuggerManagerListener {
    private GdbDebugger debugger;
    private Session session;
    private BreakpointsReader breakpointsReader;
    private HashMap<Breakpoint, BreakpointImpl> breakpointToImpl = new HashMap();

    public BreakpointsEngineListener(ContextProvider contextProvider) {
        this.debugger = (GdbDebugger)contextProvider.lookupFirst(null, GdbDebugger.class);
        this.session = (Session)contextProvider.lookupFirst(null, Session.class);
        this.debugger.addPropertyChangeListener(this);
        this.breakpointsReader = PersistenceManager.findBreakpointsReader();
    }

    protected void destroy() {
        this.debugger.removePropertyChangeListener("state", this);
        DebuggerManager.getDebuggerManager().removeDebuggerListener("breakpoints", (DebuggerManagerListener)this);
        this.removeBreakpointImpls();
    }

    public String[] getProperties() {
        return new String[]{"asd"};
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string.equals("state")) {
            if (propertyChangeEvent.getNewValue() == "state_loading") {
                int n = this.createBreakpointImpls();
                DebuggerManager.getDebuggerManager().addDebuggerListener("breakpoints", (DebuggerManagerListener)this);
                if (n == 0) {
                    this.debugger.setReady();
                }
            }
        } else if (string.equals("sharedLibLoaded")) {
            assert (!Thread.currentThread().getName().equals("GdbReaderRP"));
            this.sharedLibLoaded();
        }
    }

    public void breakpointAdded(Breakpoint breakpoint) {
        this.createBreakpointImpl(breakpoint);
    }

    public void breakpointRemoved(Breakpoint breakpoint) {
        this.removeBreakpointImpl(breakpoint);
    }

    private int createBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        int n2 = 0;
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                if (!(breakpointArray[i] instanceof GdbBreakpoint)) continue;
                this.createBreakpointImpl(breakpointArray[i]);
                ++n2;
            }
        }
        return n2;
    }

    private void createBreakpointImpl(Breakpoint breakpoint) {
        if (this.breakpointToImpl.containsKey(breakpoint)) {
            return;
        }
        if (breakpoint instanceof LineBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new LineBreakpointImpl((LineBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session));
        } else if (breakpoint instanceof FunctionBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new FunctionBreakpointImpl((FunctionBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session));
        } else if (breakpoint instanceof AddressBreakpoint) {
            this.breakpointToImpl.put(breakpoint, new AddressBreakpointImpl((AddressBreakpoint)breakpoint, this.breakpointsReader, this.debugger, this.session));
        }
    }

    private void removeBreakpointImpls() {
        Breakpoint[] breakpointArray = DebuggerManager.getDebuggerManager().getBreakpoints();
        int n = breakpointArray.length;
        for (int i = 0; i < n; ++i) {
            if (!(breakpointArray[i] instanceof GdbBreakpoint)) continue;
            this.removeBreakpointImpl(breakpointArray[i]);
        }
    }

    private void removeBreakpointImpl(Breakpoint breakpoint) {
        BreakpointImpl breakpointImpl = this.breakpointToImpl.get(breakpoint);
        if (breakpointImpl != null) {
            breakpointImpl.remove();
            this.breakpointToImpl.remove(breakpoint);
        }
    }

    private void sharedLibLoaded() {
        for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
            BreakpointImpl breakpointImpl;
            if (breakpoint.getValidity() != Breakpoint.VALIDITY.INVALID || (breakpointImpl = this.breakpointToImpl.get(breakpoint)) == null) continue;
            breakpointImpl.setState("BpState_Revalidate");
            breakpointImpl.update();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }
}

