/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb.breakpoints;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.debugger.Breakpoint;
import org.netbeans.api.debugger.DebuggerEngine;
import org.netbeans.api.debugger.DebuggerManager;
import org.netbeans.api.debugger.DebuggerManagerListener;
import org.netbeans.api.debugger.Session;
import org.netbeans.api.debugger.Watch;
import org.netbeans.modules.cnd.debugger.gdb.EditorContext;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.AddressBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.DebuggerBreakpointAnnotation;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.FunctionBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.GdbBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineBreakpoint;
import org.netbeans.modules.cnd.debugger.gdb.breakpoints.LineTranslations;
import org.netbeans.modules.cnd.debugger.gdb.disassembly.Disassembly;
import org.openide.cookies.LineCookie;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;
import org.openide.text.Annotation;
import org.openide.text.AnnotationProvider;
import org.openide.text.Line;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public class BreakpointAnnotationProvider
implements AnnotationProvider,
DebuggerManagerListener {
    private Map<GdbBreakpoint, Annotation[]> breakpointToAnnotations;
    private Set<FileObject> annotatedFiles;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void annotate(Line.Set set, Lookup lookup) {
        FileObject fileObject = (FileObject)lookup.lookup(FileObject.class);
        if (fileObject == null) {
            return;
        }
        boolean bl = false;
        Object object = this;
        synchronized (object) {
            if (this.breakpointToAnnotations == null) {
                this.breakpointToAnnotations = new HashMap<GdbBreakpoint, Annotation[]>();
                this.annotatedFiles = new WeakSet();
                bl = true;
            }
        }
        object = this.breakpointToAnnotations;
        synchronized (object) {
            if (this.annotatedFiles.contains(fileObject)) {
                return;
            }
            Set<GdbBreakpoint> set2 = this.breakpointToAnnotations.keySet();
            for (Breakpoint breakpoint : DebuggerManager.getDebuggerManager().getBreakpoints()) {
                if (!BreakpointAnnotationProvider.isAnnotatable(breakpoint)) continue;
                GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
                if (!set2.contains((Object)gdbBreakpoint)) {
                    gdbBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                    this.breakpointToAnnotations.put(gdbBreakpoint, new Annotation[0]);
                    if (gdbBreakpoint instanceof LineBreakpoint) {
                        LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
                        LineTranslations.getTranslations().registerForLineUpdates(lineBreakpoint);
                    }
                }
                this.addAnnotationTo(gdbBreakpoint, fileObject);
            }
            this.annotatedFiles.add(fileObject);
        }
        if (bl) {
            DebuggerManager.getDebuggerManager().addDebuggerListener((DebuggerManagerListener)WeakListeners.create(DebuggerManagerListener.class, (EventListener)((Object)this), (Object)DebuggerManager.getDebuggerManager()));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointAdded(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            Object object = this.breakpointToAnnotations;
            synchronized (object) {
                gdbBreakpoint.addPropertyChangeListener((PropertyChangeListener)((Object)this));
                this.breakpointToAnnotations.put(gdbBreakpoint, new Annotation[0]);
                for (FileObject fileObject : this.annotatedFiles) {
                    this.addAnnotationTo(gdbBreakpoint, fileObject);
                }
            }
            if (gdbBreakpoint instanceof LineBreakpoint) {
                object = (LineBreakpoint)gdbBreakpoint;
                LineTranslations.getTranslations().registerForLineUpdates((LineBreakpoint)((Object)object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void breakpointRemoved(Breakpoint breakpoint) {
        if (BreakpointAnnotationProvider.isAnnotatable(breakpoint)) {
            GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)breakpoint;
            Object object = this.breakpointToAnnotations;
            synchronized (object) {
                gdbBreakpoint.removePropertyChangeListener((PropertyChangeListener)((Object)this));
                this.removeAnnotations(gdbBreakpoint);
                this.breakpointToAnnotations.remove((Object)gdbBreakpoint);
            }
            if (gdbBreakpoint instanceof LineBreakpoint) {
                object = (LineBreakpoint)gdbBreakpoint;
                LineTranslations.getTranslations().unregisterFromLineUpdates((LineBreakpoint)((Object)object));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        String string = propertyChangeEvent.getPropertyName();
        if (string == null) {
            return;
        }
        if (!("enabled".equals(string) || "validity".equals(string) || "condition".equals(string) || "skipCount".equals(string) || "url".equals(string) || "functionName".equals(string) || "lineNumber".equals(string) || "address".equals(string) || "refresh".equals(string))) {
            return;
        }
        GdbBreakpoint gdbBreakpoint = (GdbBreakpoint)((Object)propertyChangeEvent.getSource());
        Map<GdbBreakpoint, Annotation[]> map = this.breakpointToAnnotations;
        synchronized (map) {
            this.removeAnnotations(gdbBreakpoint);
            this.breakpointToAnnotations.put(gdbBreakpoint, new Annotation[0]);
            for (FileObject fileObject : this.annotatedFiles) {
                this.addAnnotationTo(gdbBreakpoint, fileObject);
            }
        }
    }

    private static boolean isAnnotatable(Breakpoint breakpoint) {
        return (breakpoint instanceof LineBreakpoint || breakpoint instanceof FunctionBreakpoint || breakpoint instanceof AddressBreakpoint) && !((GdbBreakpoint)breakpoint).isHidden();
    }

    private static String getAnnotationType(GdbBreakpoint gdbBreakpoint, boolean bl) {
        String string;
        boolean bl2;
        boolean bl3 = bl2 = gdbBreakpoint.getValidity() == Breakpoint.VALIDITY.INVALID;
        if (gdbBreakpoint instanceof LineBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? (bl ? EditorContext.CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.BREAKPOINT_ANNOTATION_TYPE) : (bl ? EditorContext.DISABLED_CONDITIONAL_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_BREAKPOINT_ANNOTATION_TYPE);
        } else if (gdbBreakpoint instanceof FunctionBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? EditorContext.FUNCTION_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_FUNCTION_BREAKPOINT_ANNOTATION_TYPE;
        } else if (gdbBreakpoint instanceof AddressBreakpoint) {
            string = gdbBreakpoint.isEnabled() ? EditorContext.ADDRESS_BREAKPOINT_ANNOTATION_TYPE : EditorContext.DISABLED_ADDRESS_BREAKPOINT_ANNOTATION_TYPE;
        } else {
            throw new IllegalStateException(((Object)((Object)gdbBreakpoint)).toString());
        }
        if (bl2 && gdbBreakpoint.isEnabled()) {
            string = string + "_broken";
        }
        return string;
    }

    private static int[] getAnnotationLines(GdbBreakpoint gdbBreakpoint, FileObject fileObject) {
        if (gdbBreakpoint instanceof LineBreakpoint) {
            LineBreakpoint lineBreakpoint = (LineBreakpoint)gdbBreakpoint;
            try {
                if (fileObject.getURL().equals(new URL(lineBreakpoint.getURL()))) {
                    return new int[]{lineBreakpoint.getLineNumber()};
                }
            }
            catch (MalformedURLException malformedURLException) {
                Exceptions.printStackTrace((Throwable)malformedURLException);
            }
            catch (FileStateInvalidException fileStateInvalidException) {
                Exceptions.printStackTrace((Throwable)fileStateInvalidException);
            }
            return null;
        }
        if (gdbBreakpoint instanceof FunctionBreakpoint) {
            FunctionBreakpoint functionBreakpoint = (FunctionBreakpoint)gdbBreakpoint;
            String string = functionBreakpoint.getURL();
            if (string.length() > 0) {
                try {
                    if (fileObject.getURL().equals(new URL(string))) {
                        return new int[]{functionBreakpoint.getLineNumber()};
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    Exceptions.printStackTrace((Throwable)malformedURLException);
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    Exceptions.printStackTrace((Throwable)fileStateInvalidException);
                }
            }
            return null;
        }
        if (gdbBreakpoint instanceof AddressBreakpoint) {
            if (fileObject != Disassembly.getFileObject()) {
                return null;
            }
            Disassembly disassembly = Disassembly.getCurrent();
            if (disassembly != null) {
                AddressBreakpoint addressBreakpoint = (AddressBreakpoint)gdbBreakpoint;
                return new int[]{disassembly.getAddressLine(addressBreakpoint.getAddress())};
            }
            return null;
        }
        throw new IllegalStateException(((Object)((Object)gdbBreakpoint)).toString());
    }

    private void addAnnotationTo(GdbBreakpoint gdbBreakpoint, FileObject fileObject) {
        int n;
        DataObject dataObject;
        String string;
        int[] nArray = BreakpointAnnotationProvider.getAnnotationLines(gdbBreakpoint, fileObject);
        if (nArray == null || nArray.length == 0) {
            return;
        }
        if (gdbBreakpoint instanceof LineBreakpoint) {
            string = ((LineBreakpoint)gdbBreakpoint).getCondition();
        } else if (gdbBreakpoint instanceof FunctionBreakpoint) {
            string = ((FunctionBreakpoint)gdbBreakpoint).getCondition();
        } else if (gdbBreakpoint instanceof AddressBreakpoint) {
            string = ((AddressBreakpoint)gdbBreakpoint).getCondition();
        } else {
            throw new IllegalStateException(((Object)((Object)gdbBreakpoint)).toString());
        }
        boolean bl = string != null && string.trim().length() > 0;
        String string2 = BreakpointAnnotationProvider.getAnnotationType(gdbBreakpoint, bl);
        try {
            dataObject = DataObject.find((FileObject)fileObject);
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            dataObjectNotFoundException.printStackTrace();
            return;
        }
        LineCookie lineCookie = (LineCookie)dataObject.getCookie(LineCookie.class);
        if (lineCookie == null) {
            return;
        }
        ArrayList<DebuggerBreakpointAnnotation> arrayList = new ArrayList<DebuggerBreakpointAnnotation>();
        int[] objectArray = nArray;
        int annotationArray = objectArray.length;
        for (n = 0; n < annotationArray; ++n) {
            int n2 = objectArray[n];
            try {
                Line indexOutOfBoundsException = lineCookie.getLineSet().getCurrent(n2 - 1);
                DebuggerBreakpointAnnotation debuggerBreakpointAnnotation = new DebuggerBreakpointAnnotation(string2, indexOutOfBoundsException, gdbBreakpoint);
                arrayList.add(debuggerBreakpointAnnotation);
                continue;
            }
            catch (IndexOutOfBoundsException illegalArgumentException) {
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        if (arrayList.size() == 0) {
            return;
        }
        Object[] objectArray2 = this.breakpointToAnnotations.get((Object)gdbBreakpoint);
        if (objectArray2 == null || objectArray2.length == 0) {
            this.breakpointToAnnotations.put(gdbBreakpoint, arrayList.toArray(new Annotation[0]));
        } else {
            Annotation[] annotationArray2 = new Annotation[objectArray2.length + arrayList.size()];
            System.arraycopy(objectArray2, 0, annotationArray2, 0, objectArray2.length);
            for (n = 0; n < arrayList.size(); ++n) {
                annotationArray2[n + objectArray2.length] = (Annotation)arrayList.get(n);
            }
            this.breakpointToAnnotations.put(gdbBreakpoint, annotationArray2);
        }
    }

    private void removeAnnotations(GdbBreakpoint gdbBreakpoint) {
        Annotation[] annotationArray = this.breakpointToAnnotations.remove((Object)gdbBreakpoint);
        if (annotationArray == null) {
            return;
        }
        for (Annotation annotation : annotationArray) {
            annotation.detach();
        }
    }

    public Breakpoint[] initBreakpoints() {
        return new Breakpoint[0];
    }

    public void initWatches() {
    }

    public void watchAdded(Watch watch) {
    }

    public void watchRemoved(Watch watch) {
    }

    public void sessionAdded(Session session) {
    }

    public void sessionRemoved(Session session) {
    }

    public void engineAdded(DebuggerEngine debuggerEngine) {
    }

    public void engineRemoved(DebuggerEngine debuggerEngine) {
    }
}

