/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.identity.profile.ui.support;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.netbeans.modules.identity.profile.ui.support.WsdlData;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class WsdlParser {
    public static final String TNS = "targetNamespace";
    public static final String ADDRESS = "soapAddress";
    public static final String PORT = "port";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static WsdlData parseWSDLFile(File file, String string) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        InputSource inputSource = new InputSource(bufferedReader);
        try {
            WsdlData wsdlData = WsdlParser.parseWSDLFile(inputSource, string);
            return wsdlData;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static WsdlData parseWSDLFile(InputSource inputSource, String string) throws IOException {
        WsdlData wsdlData = null;
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            WsdlHandler wsdlHandler = new WsdlHandler(string);
            sAXParser.parse(inputSource, (DefaultHandler)wsdlHandler);
            wsdlData = wsdlHandler.getWsdlData();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            iOException.initCause(sAXException);
            throw iOException;
        }
        return wsdlData;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ArrayList getWsdlSvcNames(File file) throws IOException {
        BufferedReader bufferedReader = new BufferedReader(new FileReader(file));
        InputSource inputSource = new InputSource(bufferedReader);
        try {
            ArrayList arrayList = WsdlParser.getWsdlSvcNames(inputSource);
            return arrayList;
        }
        finally {
            bufferedReader.close();
        }
    }

    public static ArrayList getWsdlSvcNames(InputSource inputSource) throws IOException {
        try {
            SAXParserFactory sAXParserFactory = SAXParserFactory.newInstance();
            sAXParserFactory.setNamespaceAware(true);
            SAXParser sAXParser = sAXParserFactory.newSAXParser();
            SvcNameHandler svcNameHandler = new SvcNameHandler();
            sAXParser.parse(inputSource, (DefaultHandler)svcNameHandler);
            return svcNameHandler.getWsdlSvcNames();
        }
        catch (ParserConfigurationException parserConfigurationException) {
            IOException iOException = new IOException();
            iOException.initCause(parserConfigurationException);
            throw iOException;
        }
        catch (SAXException sAXException) {
            IOException iOException = new IOException();
            iOException.initCause(sAXException);
            throw iOException;
        }
    }

    private static class SvcNameHandler
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        ArrayList wsdlSvcNames = new ArrayList();

        public ArrayList getWsdlSvcNames() {
            return this.wsdlSvcNames;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if ((W3C_WSDL_SCHEMA.equals(string) || W3C_WSDL_SCHEMA_SLASH.equals(string)) && string2.equals("service")) {
                String string4 = attributes.getValue("name");
                this.wsdlSvcNames.add(string4);
            }
        }

        public void endElement(String string, String string2, String string3) {
        }
    }

    private static class WsdlHandler
    extends DefaultHandler {
        private static final String W3C_WSDL_SCHEMA = "http://schemas.xmlsoap.org/wsdl";
        private static final String W3C_WSDL_SCHEMA_SLASH = "http://schemas.xmlsoap.org/wsdl/";
        private String svcName;
        WsdlData wsdlData = new WsdlData();
        boolean found = false;

        public WsdlHandler(String string) {
            this.svcName = string;
        }

        public WsdlData getWsdlData() {
            return this.wsdlData;
        }

        public void startDocument() {
        }

        public void endDocument() {
        }

        public void startElement(String string, String string2, String string3, Attributes attributes) {
            if (W3C_WSDL_SCHEMA.equals(string) || W3C_WSDL_SCHEMA_SLASH.equals(string)) {
                if (string2.equals("definitions")) {
                    this.wsdlData.setTargetNameSpace(attributes.getValue(WsdlParser.TNS));
                }
                if (string2.equals("service") && this.svcName.equalsIgnoreCase(attributes.getValue("name"))) {
                    this.found = true;
                }
                if (this.found && string2.equals(WsdlParser.PORT)) {
                    this.wsdlData.setPort(attributes.getValue("name"));
                }
            }
            if (this.found && string2.equals("address")) {
                this.wsdlData.setAddress(attributes.getValue("location"));
                this.found = false;
            }
        }

        public void endElement(String string, String string2, String string3) {
        }
    }
}

