/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.util;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import org.netbeans.modules.soa.ui.util.DurationUtil;
import org.netbeans.modules.soa.ui.util.UI;
import org.openide.util.Utilities;

public final class DurationDialog
extends JDialog {
    private JTextField myYear;
    private JTextField myMonth;
    private JTextField myDay;
    private JTextField myHour;
    private JTextField myMinute;
    private JTextField mySecond;
    private String myDuration;
    private static final int TEXT_WIDTH = 60;
    private static final String DEFAULT_VALUE = "0";

    public DurationDialog() {
        super((Frame)null, UI.i18n(DurationDialog.class, "LBL_Duration"), true);
        UI.a11y(this, UI.i18n(DurationDialog.class, "ACS_Duration"));
        this.setLayout(new BorderLayout());
        this.add((Component)UI.getResizable(this.createPanel()), "Center");
        this.add((Component)this.createButtonPanel(), "South");
        String string = "cancel";
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.getRootPane().getInputMap(1).put(keyStroke, string);
        AbstractAction abstractAction = new AbstractAction(){

            public void actionPerformed(ActionEvent actionEvent) {
                DurationDialog.this.dispose();
            }
        };
        this.getRootPane().getActionMap().put(string, abstractAction);
        this.pack();
        Rectangle rectangle = Utilities.getUsableScreenBounds();
        int n = rectangle.width * 9 / 10;
        int n2 = rectangle.height * 9 / 10;
        Dimension dimension = this.getPreferredSize();
        dimension.width = Math.min(dimension.width, n);
        dimension.height = Math.min(dimension.height, n2);
        this.setBounds(Utilities.findCenterBounds((Dimension)dimension));
    }

    private JPanel createButtonPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new FlowLayout(2));
        JButton jButton = this.createButton("LBL_OK", "ACS_OK");
        this.getRootPane().setDefaultButton(jButton);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (DurationDialog.this.check()) {
                    DurationDialog.this.dispose();
                }
            }
        });
        jPanel.add(jButton);
        jButton = this.createButton("LBL_Cancel", "ACS_Cancel");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DurationDialog.this.dispose();
            }
        });
        jPanel.add(jButton);
        return jPanel;
    }

    private JButton createButton(String string, String string2) {
        JButton jButton = new JButton(UI.i18n(DurationDialog.class, string));
        UI.a11y(jButton, UI.i18n(DurationDialog.class, string2));
        return jButton;
    }

    private JPanel createPanel() {
        JPanel jPanel = new JPanel(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        this.myYear = this.createField("LBL_Year", "ACS_Year", gridBagConstraints, jPanel);
        this.myMonth = this.createField("LBL_Month", "ACS_Month", gridBagConstraints, jPanel);
        this.myDay = this.createField("LBL_Day", "ACS_Day", gridBagConstraints, jPanel);
        ++gridBagConstraints.gridy;
        this.myHour = this.createField("LBL_Hour", "ACS_Hour", gridBagConstraints, jPanel);
        this.myMinute = this.createField("LBL_Minute", "ACS_Minute", gridBagConstraints, jPanel);
        this.mySecond = this.createField("LBL_Second", "ACS_Second", gridBagConstraints, jPanel);
        return jPanel;
    }

    private JTextField createField(String string, String string2, GridBagConstraints gridBagConstraints, JPanel jPanel) {
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 13;
        JLabel jLabel = UI.createLabel(UI.i18n(DurationDialog.class, string));
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 0, 0);
        gridBagConstraints.anchor = 17;
        JTextField jTextField = new JTextField(DEFAULT_VALUE);
        UI.a11y(jTextField, UI.i18n(DurationDialog.class, string2));
        UI.setWidth(jTextField, 60);
        jPanel.add((Component)jTextField, gridBagConstraints);
        jLabel.setLabelFor(jTextField);
        return jTextField;
    }

    public String getDuration() {
        return this.myDuration;
    }

    private boolean check() {
        int n = UI.getInt(this.myYear.getText());
        int n2 = UI.getInt(this.myMonth.getText());
        int n3 = UI.getInt(this.myDay.getText());
        int n4 = UI.getInt(this.myHour.getText());
        int n5 = UI.getInt(this.myMinute.getText());
        double d = UI.getDouble(this.mySecond.getText());
        if (this.check(n, "ERR_invalid_year", this.myYear) && this.check(n2, "ERR_invalid_month", this.myMonth) && this.check(n3, "ERR_invalid_day", this.myDay) && this.check(n4, "ERR_invalid_hour", this.myHour) && this.check(n5, "ERR_invalid_minute", this.myMinute) && this.check(d, "ERR_invalid_second", this.mySecond)) {
            this.myDuration = DurationUtil.getContent(true, n, n2, n3, n4, n5, d);
            return true;
        }
        this.myDuration = null;
        return false;
    }

    private boolean check(int n, String string, JTextField jTextField) {
        return this.check(n >= 0, string, jTextField);
    }

    private boolean check(double d, String string, JTextField jTextField) {
        return this.check(d >= 0.0, string, jTextField);
    }

    private boolean check(boolean bl, String string, JTextField jTextField) {
        if (bl) {
            return true;
        }
        UI.printError(UI.i18n(DurationDialog.class, string, jTextField.getText()));
        jTextField.requestFocus();
        jTextField.selectAll();
        return false;
    }
}

