/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.soa.ui.tnv.impl;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import javax.swing.BorderFactory;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import javax.swing.Timer;
import org.netbeans.modules.soa.ui.tnv.api.ThumbnailPaintable;
import org.netbeans.modules.soa.ui.tnv.api.ThumbnailView;
import org.netbeans.modules.soa.ui.tnv.impl.ComponentChangeTracker;
import org.netbeans.modules.soa.ui.tnv.impl.DndProcessor;
import org.netbeans.modules.soa.ui.tnv.impl.ThumbnailGraphics;
import org.netbeans.modules.soa.ui.tnv.impl.ThumbnailPositionState;
import org.openide.util.NbBundle;

public class ThumbnailViewImpl
extends JPanel
implements ThumbnailView {
    protected JScrollPane myScrollPane;
    protected JComponent myContent;
    protected MyContainerListener myContListener;
    protected double myZoom = 0.0;
    protected double relativeZoom = 3.5;
    protected Rectangle2D.Double myTnvVisibleRect;
    protected Rectangle2D.Double myMainVisibleRect;
    private DndProcessor yDndProcessor = new DndProcessor();
    private DndProcessor xDndProcessor = new DndProcessor();
    private ComponentChangeTracker compChangeTracker = null;
    protected boolean repaintMainViewRightAway = true;
    protected boolean repaintThumbnailViewRightAway = true;
    protected boolean dndMode = false;
    protected transient Dimension prevMainVisibleDimension;
    protected transient Dimension prevMainDimension;
    protected transient Dimension prevTnvDimension;
    private Timer changeUpdateDelayTimer = new Timer(100, new ActionListener(){

        public void actionPerformed(ActionEvent actionEvent) {
            ThumbnailViewImpl.this.processObservableChange();
        }
    });

    public ThumbnailViewImpl() {
        this.changeUpdateDelayTimer.setRepeats(false);
        this.setBorder(BorderFactory.createLineBorder(Color.GRAY, 1));
        this.addMouseMotionListener(new MouseMotionAdapter(){

            public void mouseDragged(MouseEvent mouseEvent) {
                if (ThumbnailViewImpl.this.myContent == null) {
                    return;
                }
                if ((mouseEvent.getModifiers() & 0x10) != 0) {
                    ThumbnailViewImpl.this.dndMode = true;
                    ThumbnailViewImpl.this.processDrag(mouseEvent);
                    ThumbnailViewImpl.this.repaint();
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent mouseEvent) {
                if (ThumbnailViewImpl.this.myContent == null) {
                    return;
                }
                if (mouseEvent.getButton() == 1) {
                    ThumbnailViewImpl.this.processClick(mouseEvent);
                    ThumbnailViewImpl.this.scrollMainView();
                    ThumbnailViewImpl.this.repaint();
                }
            }

            public void mousePressed(MouseEvent mouseEvent) {
                if (ThumbnailViewImpl.this.myContent == null) {
                    return;
                }
                if (mouseEvent.getButton() == 1) {
                    ThumbnailViewImpl.this.dndMode = false;
                    double d = ThumbnailViewImpl.this.getZoom();
                    ThumbnailPositionState thumbnailPositionState = new ThumbnailPositionState();
                    ThumbnailPositionState thumbnailPositionState2 = new ThumbnailPositionState();
                    ThumbnailViewImpl.this.recalculateTnPositionStates(thumbnailPositionState, thumbnailPositionState2);
                    ThumbnailViewImpl.this.xDndProcessor.startDnd(mouseEvent.getX(), thumbnailPositionState, d);
                    ThumbnailViewImpl.this.yDndProcessor.startDnd(mouseEvent.getY(), thumbnailPositionState2, d);
                }
                if (mouseEvent.isPopupTrigger()) {
                    ThumbnailViewImpl.this.constructPopupMenu().show(ThumbnailViewImpl.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                if (ThumbnailViewImpl.this.myContent == null) {
                    return;
                }
                if (mouseEvent.getButton() == 1) {
                    ThumbnailViewImpl.this.xDndProcessor.stopDnd();
                    ThumbnailViewImpl.this.yDndProcessor.stopDnd();
                    if (ThumbnailViewImpl.this.dndMode && !ThumbnailViewImpl.this.repaintMainViewRightAway) {
                        ThumbnailViewImpl.this.scrollMainView();
                    }
                    ThumbnailViewImpl.this.dndMode = false;
                }
                if (mouseEvent.isPopupTrigger()) {
                    ThumbnailViewImpl.this.constructPopupMenu().show(ThumbnailViewImpl.this, mouseEvent.getX(), mouseEvent.getY());
                }
            }
        });
    }

    private JPopupMenu constructPopupMenu() {
        JPopupMenu jPopupMenu = new JPopupMenu();
        String string = NbBundle.getMessage(ThumbnailView.class, (String)"REPAINT_MAIN_VIEW_RIGHT_AWAY");
        JCheckBoxMenuItem jCheckBoxMenuItem = new JCheckBoxMenuItem(string, this.isRepaintMainViewRightAway());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThumbnailViewImpl.this.repaintMainViewRightAway(!ThumbnailViewImpl.this.isRepaintMainViewRightAway());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        string = NbBundle.getMessage(ThumbnailView.class, (String)"REPAINT_THUMBNAIL_VIEW_RIGHT_AWAY");
        jCheckBoxMenuItem = new JCheckBoxMenuItem(string, this.isRepaintThumbnailViewRightAway());
        jCheckBoxMenuItem.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ThumbnailViewImpl.this.repaintThumbnailViewRightAway(!ThumbnailViewImpl.this.isRepaintThumbnailViewRightAway());
            }
        });
        jPopupMenu.add(jCheckBoxMenuItem);
        return jPopupMenu;
    }

    public void repaintMainViewRightAway(boolean bl) {
        this.repaintMainViewRightAway = bl;
    }

    public boolean isRepaintMainViewRightAway() {
        return this.repaintMainViewRightAway;
    }

    public void repaintThumbnailViewRightAway(boolean bl) {
        this.repaintThumbnailViewRightAway = bl;
    }

    public boolean isRepaintThumbnailViewRightAway() {
        return this.repaintThumbnailViewRightAway;
    }

    private void recalculateTnPositionStates(ThumbnailPositionState thumbnailPositionState, ThumbnailPositionState thumbnailPositionState2) {
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        Rectangle rectangle = this.myContent.getVisibleRect();
        thumbnailPositionState.mvSize = this.myContent.getWidth();
        thumbnailPositionState.tnvPosition = double_.x;
        thumbnailPositionState.tnvSize = double_.width;
        thumbnailPositionState.vaPosition = rectangle.x;
        thumbnailPositionState.vaHalfSize = (double)rectangle.width / 2.0;
        thumbnailPositionState2.mvSize = this.myContent.getHeight();
        thumbnailPositionState2.tnvPosition = double_.y;
        thumbnailPositionState2.tnvSize = double_.height;
        thumbnailPositionState2.vaPosition = rectangle.y;
        thumbnailPositionState2.vaHalfSize = (double)rectangle.height / 2.0;
    }

    private void applyTnPositionStates(ThumbnailPositionState thumbnailPositionState, ThumbnailPositionState thumbnailPositionState2) {
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        double_.x = thumbnailPositionState.tnvPosition;
        double_.y = thumbnailPositionState2.tnvPosition;
        double_.width = thumbnailPositionState.tnvSize;
        double_.height = thumbnailPositionState2.tnvSize;
        Rectangle2D.Double double_2 = new Rectangle2D.Double(thumbnailPositionState.vaPosition, thumbnailPositionState2.vaPosition, thumbnailPositionState.vaHalfSize * 2.0, thumbnailPositionState2.vaHalfSize * 2.0);
        this.setVisiblePart(double_2);
    }

    public void doLayout() {
        super.doLayout();
        this.processTnvResize();
    }

    public JScrollPane getScrollPane() {
        return this.myScrollPane;
    }

    public JComponent getContent() {
        return this.myContent;
    }

    public void setScrollPane(JScrollPane jScrollPane) {
        if (this.myScrollPane != null && this.compChangeTracker != null) {
            this.compChangeTracker.removeUpdateListener(this);
            this.compChangeTracker.dispose();
            this.compChangeTracker = null;
        }
        this.myScrollPane = jScrollPane;
        if (this.myScrollPane != null) {
            this.myScrollPane.getContainerListeners();
            this.startListenContainer(this.myScrollPane);
            this.compChangeTracker = new ComponentChangeTracker(this.myScrollPane);
            this.compChangeTracker.addUpdateListener(this);
        }
        this.updateContent();
    }

    private void startListenContainer(Container container) {
        if (this.myContListener == null) {
            this.myContListener = new MyContainerListener();
            container.addContainerListener(this.myContListener);
        } else {
            ContainerListener[] containerListenerArray = container.getContainerListeners();
            boolean bl = false;
            for (ContainerListener containerListener : containerListenerArray) {
                if (containerListener != this.myContListener) continue;
                bl = true;
                break;
            }
            if (!bl) {
                container.addContainerListener(this.myContListener);
            }
        }
    }

    private void updateContent() {
        Component component;
        JViewport jViewport;
        JComponent jComponent = null;
        if (this.myScrollPane != null && (jViewport = this.myScrollPane.getViewport()) != null && (component = jViewport.getView()) != null && component instanceof JComponent) {
            jComponent = (JComponent)component;
        }
        if (!(jComponent instanceof ThumbnailPaintable)) {
            jComponent = null;
        }
        if (this.myContent == null && jComponent == null) {
            return;
        }
        if (this.myContent == null || !this.myContent.equals(jComponent)) {
            this.myContent = jComponent;
            this.recalculateZoomAndTnv();
            this.centerSmallView();
            this.revalidate();
            this.repaint();
        }
    }

    private Rectangle2D.Double getTnvVisibleRect() {
        if (this.myTnvVisibleRect == null) {
            this.recalculateZoomAndTnv();
        }
        return this.myTnvVisibleRect;
    }

    public void setVisiblePart(Rectangle2D.Double double_) {
        if (this.myContent == null) {
            return;
        }
        this.myMainVisibleRect = double_;
        if (this.repaintMainViewRightAway) {
            this.scrollMainView();
        }
    }

    protected void scrollMainView() {
        this.myContent.scrollRectToVisible(this.myMainVisibleRect.getBounds());
    }

    public Rectangle2D.Double getVisiblePart() {
        if (this.myContent == null) {
            return null;
        }
        if (this.myMainVisibleRect == null) {
            Rectangle rectangle = this.myContent.getVisibleRect();
            this.myMainVisibleRect = new Rectangle2D.Double(rectangle.getX(), rectangle.getY(), rectangle.getWidth(), rectangle.getHeight());
            this.accommodateTnvTo(this.myMainVisibleRect);
        }
        return this.myMainVisibleRect;
    }

    public void observableChanged() {
        if (this.repaintThumbnailViewRightAway) {
            this.processObservableChange();
        } else {
            this.changeUpdateDelayTimer.restart();
        }
    }

    private void processObservableChange() {
        if (this.myContent != null) {
            this.recalculateZoomAndTnv();
            this.centerSmallView();
            Rectangle2D rectangle2D = this.myContent.getVisibleRect().getBounds2D();
            this.myMainVisibleRect = new Rectangle2D.Double(rectangle2D.getX(), rectangle2D.getY(), rectangle2D.getWidth(), rectangle2D.getHeight());
            this.accommodateTnvTo(rectangle2D);
            this.repaint();
        }
    }

    public JComponent getUIComponent() {
        return this;
    }

    public double getZoom() {
        if (this.myZoom == 0.0) {
            this.recalculateZoomAndTnv();
        }
        return this.myZoom;
    }

    public void setZoom(double d) {
        if (this.myZoom != d) {
            this.myZoom = d;
            this.repaint();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        if (this.myContent != null) {
            ThumbnailGraphics thumbnailGraphics = new ThumbnailGraphics((Graphics2D)graphics.create());
            try {
                double d = this.getZoom();
                thumbnailGraphics.scale(d, d);
                Rectangle2D.Double double_ = this.getTnvVisibleRect();
                thumbnailGraphics.translate(-double_.x, -double_.y);
                assert (this.myContent instanceof ThumbnailPaintable) : "The observable component has to implement the ThumbnailPaintable interface";
                ((ThumbnailPaintable)((Object)this.myContent)).paintThumbnail(thumbnailGraphics);
                Rectangle2D.Double double_2 = this.getVisiblePart();
                thumbnailGraphics.setColor(new Color(200, 200, 200, 128));
                thumbnailGraphics.fill(double_2);
                thumbnailGraphics.setColor(Color.BLACK);
                thumbnailGraphics.draw(double_2);
            }
            finally {
                thumbnailGraphics.dispose();
            }
        }
    }

    protected Point2D.Double fromTnvToMain(Point2D point2D, Point2D.Double double_) {
        double d = this.getZoom();
        double d2 = point2D.getX() / d + double_.x;
        double d3 = point2D.getY() / d + double_.y;
        Point2D.Double double_2 = new Point2D.Double(d2, d3);
        return double_2;
    }

    protected Point2D.Double fromTnvToMain(Point2D point2D) {
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        return this.fromTnvToMain(point2D, new Point2D.Double(double_.x, double_.y));
    }

    protected Point2D.Double fromMainToTnv(Point2D point2D) {
        double d = this.getZoom();
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        double d2 = (point2D.getX() - double_.x) * d;
        double d3 = (point2D.getY() - double_.y) * d;
        Point2D.Double double_2 = new Point2D.Double(d2, d3);
        return double_2;
    }

    protected void processDrag(MouseEvent mouseEvent) {
        double d = this.getZoom();
        ThumbnailPositionState thumbnailPositionState = new ThumbnailPositionState();
        ThumbnailPositionState thumbnailPositionState2 = new ThumbnailPositionState();
        this.recalculateTnPositionStates(thumbnailPositionState, thumbnailPositionState2);
        thumbnailPositionState = this.xDndProcessor.processDnD(mouseEvent.getX(), thumbnailPositionState, d);
        thumbnailPositionState2 = this.yDndProcessor.processDnD(mouseEvent.getY(), thumbnailPositionState2, d);
        this.applyTnPositionStates(thumbnailPositionState, thumbnailPositionState2);
    }

    protected void processClick(MouseEvent mouseEvent) {
        double d = this.getZoom();
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        double d2 = (double)mouseEvent.getX() / d + double_.x;
        double d3 = (double)mouseEvent.getY() / d + double_.y;
        Point2D.Double double_2 = new Point2D.Double(d2, d3);
        Rectangle2D rectangle2D = this.myContent.getVisibleRect().getBounds2D();
        Dimension dimension = this.myContent.getSize();
        double d4 = rectangle2D.getWidth() / 2.0;
        double d5 = rectangle2D.getHeight() / 2.0;
        double d6 = double_2.x;
        double d7 = double_2.y;
        double d8 = d4;
        double d9 = dimension.getWidth() - d4;
        double d10 = d5;
        double d11 = dimension.getHeight() - d5;
        if (d6 < d8) {
            d6 = d8;
        }
        if (d6 > d9) {
            d6 = d9;
        }
        if (d7 < d10) {
            d7 = d10;
        }
        if (d7 > d11) {
            d7 = d11;
        }
        Rectangle2D.Double double_3 = new Rectangle2D.Double(d6 - d4, d7 - d5, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.setVisiblePart(double_3);
    }

    protected void accommodateTnvTo(Rectangle2D rectangle2D) {
        double d;
        Rectangle2D.Double double_ = this.getTnvVisibleRect();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = rectangle2D.getX();
        d2 = d4 - (d = double_.x);
        if (d2 >= 0.0 && (d2 = d4 + rectangle2D.getWidth() - (d + double_.width)) <= 0.0) {
            d2 = 0.0;
        }
        if ((d3 = (d4 = rectangle2D.getY()) - (d = double_.y)) >= 0.0 && (d3 = d4 + rectangle2D.getHeight() - (d + double_.height)) <= 0.0) {
            d3 = 0.0;
        }
        if (d3 != 0.0 || d2 != 0.0) {
            double_.x += d2;
            double_.y += d3;
        }
    }

    protected double recalculateZoomAndTnv() {
        double d = 0.1;
        if (this.myContent != null) {
            Rectangle rectangle = this.myContent.getVisibleRect();
            Dimension dimension = rectangle.getSize();
            Dimension dimension2 = this.myContent.getSize();
            Dimension dimension3 = this.getSize();
            if (dimension3.width == 0 || dimension3.height == 0) {
                dimension3 = this.getPreferredSize();
            }
            boolean bl = false;
            if (this.prevMainDimension == null || !this.prevMainDimension.equals(dimension2)) {
                bl = true;
                this.prevMainDimension = dimension2;
            }
            if (this.prevMainVisibleDimension == null || !this.prevMainVisibleDimension.equals(dimension)) {
                bl = true;
                this.prevMainVisibleDimension = dimension;
            }
            if (bl) {
                Cloneable cloneable;
                double d2 = (double)dimension3.width / ((double)rectangle.width * this.relativeZoom);
                double d3 = (double)dimension3.height / ((double)rectangle.height * this.relativeZoom);
                d = Math.min(d2, d3);
                Dimension dimension4 = this.myContent.getSize();
                if (dimension4.width == 0 || dimension4.height == 0) {
                    dimension4 = this.myContent.getPreferredSize();
                }
                if ((double)dimension3.width / d > (double)dimension4.width * 1.001) {
                    d2 = (double)dimension3.width / (double)dimension4.width;
                }
                if ((double)dimension3.height / d > (double)dimension4.height * 1.001) {
                    d3 = (double)dimension3.height / (double)dimension4.height;
                }
                if (this.myZoom != (d = Math.min(d2, d3))) {
                    Point2D.Double double_;
                    cloneable = ThumbnailViewImpl.getCenter(rectangle);
                    if (this.myTnvVisibleRect != null) {
                        double_ = this.fromMainToTnv((Point2D)cloneable);
                    } else {
                        Rectangle rectangle2 = new Rectangle(0, 0, dimension3.width, dimension3.height);
                        double_ = ThumbnailViewImpl.getCenter(rectangle2);
                        this.myTnvVisibleRect = new Rectangle2D.Double();
                    }
                    this.myZoom = d;
                    this.myTnvVisibleRect.x = cloneable.x - double_.x / d;
                    this.myTnvVisibleRect.y = cloneable.y - double_.y / d;
                    this.myTnvVisibleRect.width = (double)dimension3.width / d;
                    this.myTnvVisibleRect.height = (double)dimension3.height / d;
                }
                cloneable = this.myContent.getBounds();
                if (this.myTnvVisibleRect.x < 0.0) {
                    this.myTnvVisibleRect.x = 0.0;
                } else if (this.myTnvVisibleRect.x + this.myTnvVisibleRect.width > (double)((Rectangle)cloneable).width) {
                    this.myTnvVisibleRect.x = (double)((Rectangle)cloneable).width - this.myTnvVisibleRect.width;
                }
                if (this.myTnvVisibleRect.y < 0.0) {
                    this.myTnvVisibleRect.y = 0.0;
                } else if (this.myTnvVisibleRect.y + this.myTnvVisibleRect.height > (double)((Rectangle)cloneable).height) {
                    this.myTnvVisibleRect.y = (double)((Rectangle)cloneable).height - this.myTnvVisibleRect.height;
                }
            }
        }
        return d;
    }

    protected double processTnvResize() {
        double d = 0.1;
        if (this.myContent != null) {
            Rectangle rectangle = this.myContent.getVisibleRect();
            Dimension dimension = this.getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                dimension = this.getPreferredSize();
            }
            boolean bl = false;
            if (this.prevTnvDimension == null || !this.prevTnvDimension.equals(dimension)) {
                bl = true;
                this.prevTnvDimension = dimension;
            }
            if (bl) {
                double d2 = (double)dimension.width / ((double)rectangle.width * this.relativeZoom);
                double d3 = (double)dimension.height / ((double)rectangle.height * this.relativeZoom);
                d = Math.min(d2, d3);
                Dimension dimension2 = this.myContent.getSize();
                if (dimension2.width == 0 || dimension2.height == 0) {
                    dimension2 = this.myContent.getPreferredSize();
                }
                if ((double)dimension.width / d > (double)dimension2.width * 1.001) {
                    d2 = (double)dimension.width / (double)dimension2.width;
                }
                if ((double)dimension.height / d > (double)dimension2.height * 1.001) {
                    d3 = (double)dimension.height / (double)dimension2.height;
                }
                if (this.myZoom != (d = Math.min(d2, d3))) {
                    this.myZoom = d;
                }
                Point2D.Double double_ = ThumbnailViewImpl.getCenter(rectangle);
                this.myTnvVisibleRect.x = double_.x - (double)dimension.width / d / 2.0;
                this.myTnvVisibleRect.y = double_.y - (double)dimension.height / d / 2.0;
                this.myTnvVisibleRect.width = (double)dimension.width / d;
                this.myTnvVisibleRect.height = (double)dimension.height / d;
                Rectangle rectangle2 = this.myContent.getBounds();
                if (this.myTnvVisibleRect.x < 0.0) {
                    this.myTnvVisibleRect.x = 0.0;
                }
                if (this.myTnvVisibleRect.x + this.myTnvVisibleRect.width > (double)rectangle2.width) {
                    this.myTnvVisibleRect.x = (double)rectangle2.width - this.myTnvVisibleRect.width;
                }
                if (this.myTnvVisibleRect.y < 0.0) {
                    this.myTnvVisibleRect.y = 0.0;
                }
                if (this.myTnvVisibleRect.y + this.myTnvVisibleRect.height > (double)rectangle2.height) {
                    this.myTnvVisibleRect.y = (double)rectangle2.height - this.myTnvVisibleRect.height;
                }
            }
        }
        this.centerSmallView();
        return d;
    }

    protected void centerSmallView() {
        if (this.myContent != null) {
            Rectangle rectangle = this.myContent.getBounds();
            double d = this.getZoom();
            Dimension dimension = this.getSize();
            double d2 = (double)dimension.width / d;
            double d3 = (double)dimension.height / d;
            Rectangle2D.Double double_ = this.getTnvVisibleRect();
            if (d2 > (double)rectangle.width * 1.001) {
                double_.x = ((double)rectangle.width - d2) / 2.0;
            }
            if (d3 > (double)rectangle.height * 1.001) {
                double_.y = ((double)rectangle.height - d3) / 2.0;
            }
        }
    }

    public static Point2D.Double getCenter(Rectangle2D.Double double_) {
        double d = double_.x + double_.width / 2.0;
        double d2 = double_.y + double_.height / 2.0;
        return new Point2D.Double(d, d2);
    }

    public static Point2D.Double getCenter(Rectangle rectangle) {
        double d = rectangle.x + rectangle.width / 2;
        double d2 = rectangle.y + rectangle.height / 2;
        return new Point2D.Double(d, d2);
    }

    private class MyContainerListener
    implements ContainerListener {
        private MyContainerListener() {
        }

        public void componentAdded(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof JViewport) {
                ThumbnailViewImpl.this.startListenContainer((JViewport)component);
            }
            ThumbnailViewImpl.this.updateContent();
        }

        public void componentRemoved(ContainerEvent containerEvent) {
            Container container = containerEvent.getContainer();
            Component component = containerEvent.getChild();
            if (component instanceof JComponent) {
                ((JComponent)component).removeContainerListener(ThumbnailViewImpl.this.myContListener);
            }
            ThumbnailViewImpl.this.updateContent();
        }
    }
}

